/*
 * Decompiled with CFR 0.152.
 */
package com.viewshine.codec.engine;

import com.viewshine.codec.engine.OptionItem;
import com.viewshine.codec.utils.StringUtils;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Option {
    private static Logger log = LoggerFactory.getLogger(Option.class);
    private static String optionFile = "protocol/Option.xml";
    public static Map<String, Map<String, OptionItem>> optionMap = new HashMap<String, Map<String, OptionItem>>();

    private static void loadOptionFile() throws DocumentException {
        SAXReader reader = new SAXReader();
        InputStream is = Option.class.getResourceAsStream("/" + optionFile);
        Document document = reader.read(is);
        if (document != null) {
            Element root = document.getRootElement();
            Iterator it = root.elementIterator();
            while (it.hasNext()) {
                Element elementOption = (Element)it.next();
                String code = elementOption.attribute("code").getValue();
                if (StringUtils.isEmpty(code)) continue;
                optionMap.put(code, Option.loadOptionItems(elementOption));
            }
        }
    }

    public static Map<String, OptionItem> loadOptionItems(Element elementOption) {
        Iterator it_optionItems = elementOption.elementIterator();
        HashMap<String, OptionItem> optionItems = new HashMap<String, OptionItem>();
        while (it_optionItems.hasNext()) {
            Element elementOptionItem = (Element)it_optionItems.next();
            OptionItem item = Option.loadOptionItem(elementOptionItem);
            optionItems.put(item.getValue(), Option.loadOptionItem(elementOptionItem));
        }
        return optionItems;
    }

    public static OptionItem loadOptionItem(Element elementOptionItem) {
        String value = elementOptionItem.attribute("value").getValue();
        String text = elementOptionItem.attribute("text").getValue();
        String codecValue = value;
        Attribute codecValueAttr = elementOptionItem.attribute("codecValue");
        if (codecValueAttr != null) {
            codecValue = codecValueAttr.getValue();
        }
        return new OptionItem(codecValue, value, text);
    }

    public static Map<String, Map<String, OptionItem>> getOptionMap() {
        return optionMap;
    }

    public static Map<String, OptionItem> getOptionItems(String code) {
        return optionMap.get(code);
    }

    static {
        try {
            if (!StringUtils.isEmpty(optionFile)) {
                Option.loadOptionFile();
            }
        }
        catch (Exception ex) {
            log.error("error", (Throwable)ex);
        }
    }
}

