/*
 * Decompiled with CFR 0.152.
 */
package com.viewshine.codec.engine;

import com.viewshine.codec.engine.CodecDataItem;
import com.viewshine.codec.engine.CommandItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EncodeUnit {
    public CommandItem commandItem;
    public int status;
    private List<Byte> buf;
    private StringBuilder bitsetSb = new StringBuilder();
    public List<CodecDataItem> params;
    public Map<String, String> dynItems;

    public EncodeUnit() {
        this.buf = new ArrayList<Byte>();
    }

    public void addDynItem(String code, String value) {
        if (this.dynItems == null) {
            this.dynItems = new HashMap<String, String>();
        }
        this.dynItems.put(code, value);
    }

    public byte[] getBytes() {
        if (this.buf == null) {
            return null;
        }
        byte[] bytes = new byte[this.buf.size()];
        for (int i = 0; i < this.buf.size(); ++i) {
            bytes[i] = this.buf.get(i);
        }
        return bytes;
    }

    public void putBitset(String bitsetStr) {
        this.bitsetSb.append(bitsetStr);
        int length = this.bitsetSb.length();
        int byteNum = length / 8;
        if (byteNum > 0) {
            for (int i = 0; i < byteNum; ++i) {
                this.putByte((byte)Integer.parseInt(this.bitsetSb.substring(i * 8, (i + 1) * 8), 2));
            }
            this.bitsetSb.delete(0, byteNum * 8);
        }
    }

    public void putBitsetReserve(int length) {
        String bitsetStr = "0000000000000000".substring(0, length);
        this.putBitset(bitsetStr);
    }

    private void putByte(byte b) {
        this.buf.add(b);
    }

    public void putBytes(byte[] bytes) {
        int length = this.bitsetSb.length();
        if (length > 0) {
            this.putByte((byte)Integer.parseInt(this.bitsetSb.substring(0, length), 2));
            this.bitsetSb.delete(0, length);
        }
        for (byte b : bytes) {
            this.buf.add(b);
        }
    }

    public boolean isSuccess() {
        return this.status == 1;
    }

    public static void main(String[] args) {
        StringBuilder bitsetSb = new StringBuilder();
        bitsetSb.append("12345678");
        System.out.println("1=====" + bitsetSb.length());
        bitsetSb.delete(0, bitsetSb.length());
        System.out.println("1=====" + bitsetSb.length());
        String bitsetStr = "0000000000000000".substring(0, 5);
        System.out.println("2=====" + bitsetStr);
    }
}

