/*
 * Decompiled with CFR 0.152.
 */
package com.viewshine.codec.engine;

import com.viewshine.codec.engine.CodecDataItem;
import com.viewshine.codec.engine.CommandItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DecodeUnit {
    public static final int DECODE_UNCOMPLETE = 0;
    public static final int DECODE_SUCCESS = 1;
    public static final int DECODE_FAILED = 2;
    public CommandItem commandItem;
    public int status;
    public byte[] bytes;
    public int bitPos = 0;
    public int bytePos = 0;
    public Map<String, String> dynItems;
    private List<CodecDataItem> decodeItems;

    public void addDynItem(String code, String value) {
        if (this.dynItems == null) {
            this.dynItems = new HashMap<String, String>();
        }
        this.dynItems.put(code, value);
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public void stepByte() {
        this.stepByte(1);
    }

    public void stepByte(int step) {
        this.bytePos += step;
    }

    public void stepBit() {
        this.stepBit(1);
    }

    public void stepBit(int step) {
        this.bitPos += step;
        if (this.bitPos > 7) {
            this.stepByte((this.bitPos + 1) / 8);
            this.bitPos %= 8;
        }
    }

    public void restBitPos() {
        if (this.bitPos > 0) {
            this.stepByte();
        }
        this.bitPos = 0;
    }

    public boolean hasEnoughRemaing(int length, boolean isBitSet) {
        int remaing = this.remaining(isBitSet);
        return remaing >= length;
    }

    public int remaining(boolean isBitSet) {
        if (isBitSet) {
            return (this.bytes.length - this.bytePos) * 8 - this.bitPos;
        }
        return this.bytes.length - this.bytePos;
    }

    public List<CodecDataItem> getDecodeItems() {
        return this.decodeItems;
    }

    public void addDecodeItem(CodecDataItem decodeItem) {
        if (this.decodeItems == null) {
            this.decodeItems = new ArrayList<CodecDataItem>();
        }
        this.decodeItems.add(decodeItem);
    }

    public CommandItem getCommandItem() {
        return this.commandItem;
    }

    public void setCommandItem(CommandItem commandItem) {
        this.commandItem = commandItem;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getBitPos() {
        return this.bitPos;
    }

    public void setBitPos(int bitPos) {
        this.bitPos = bitPos;
    }

    public int getBytePos() {
        return this.bytePos;
    }

    public void setBytePos(int bytePos) {
        this.bytePos = bytePos;
    }

    public Map<String, String> getDynItems() {
        return this.dynItems;
    }

    public void setDynItems(Map<String, String> dynItems) {
        this.dynItems = dynItems;
    }

    public void setDecodeItems(List<CodecDataItem> decodeItems) {
        this.decodeItems = decodeItems;
    }

    public boolean isSuccess() {
        return this.status == 1;
    }
}

