/*
 * Decompiled with CFR 0.152.
 */
package com.viewshine.codec.engine;

import com.alibaba.fastjson.annotation.JSONField;
import com.viewshine.codec.engine.OptionItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataItem {
    @JSONField(ordinal=1)
    public String code;
    @JSONField(ordinal=2)
    public String name;
    public MarkType mark;
    @JSONField(ordinal=3)
    public String type;
    @JSONField(serialize=false)
    public String params;
    @JSONField(ordinal=4)
    public int length;
    @JSONField(serialize=false)
    public Map<String, List<DataItem>> subItemsGroup;
    @JSONField(ordinal=5)
    public String defaultValue;
    @JSONField(ordinal=6, name="option")
    public Map<String, OptionItem> encodeOptions;
    @JSONField(serialize=false)
    private Map<String, OptionItem> decodeOptions;
    @JSONField(serialize=false)
    public String dynLenCode;
    @JSONField(serialize=false)
    public String refCode;
    @JSONField(serialize=false)
    public Map<String, String> attribute;
    @JSONField(serialize=false)
    boolean isBitSet = false;
    @JSONField(serialize=false)
    boolean isReserve = false;

    public DataItem() {
    }

    public DataItem(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MarkType getMark() {
        return this.mark;
    }

    public void setMark(MarkType mark) {
        this.mark = mark;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public List<DataItem> getSubItemsGroup(String formatCode) {
        if (this.subItemsGroup == null) {
            return null;
        }
        List<DataItem> dis = this.subItemsGroup.get(formatCode);
        if (dis == null) {
            dis = this.subItemsGroup.get("default");
        }
        return dis;
    }

    public void setSubItemsGroup(String formatCode, List<DataItem> dataItems) {
        if (this.subItemsGroup == null) {
            this.subItemsGroup = new HashMap<String, List<DataItem>>();
        }
        this.subItemsGroup.put(formatCode, dataItems);
    }

    public boolean hasSubItemsGroup() {
        return this.subItemsGroup != null && !this.subItemsGroup.isEmpty();
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setEncodeOptions(Map<String, OptionItem> encodeOptions) {
        this.encodeOptions = encodeOptions;
    }

    public Map<String, OptionItem> getEncodeOptions() {
        return this.encodeOptions;
    }

    public void setDecodeOptions(Map<String, OptionItem> decodeOptions) {
        this.decodeOptions = decodeOptions;
    }

    public Map<String, OptionItem> getDecodeOptions() {
        return this.decodeOptions;
    }

    public void addEncodeOption(OptionItem option) {
        if (this.encodeOptions == null) {
            this.encodeOptions = new HashMap<String, OptionItem>();
        }
        this.encodeOptions.put(option.getValue(), option);
    }

    public void addDecodeOption(OptionItem option) {
        if (this.decodeOptions == null) {
            this.decodeOptions = new HashMap<String, OptionItem>();
        }
        this.decodeOptions.put(option.getValue(), option);
    }

    public OptionItem getEncodeOption(String value) {
        if (this.encodeOptions == null) {
            return null;
        }
        OptionItem optionItem = this.encodeOptions.get(value);
        if (optionItem == null) {
            optionItem = this.encodeOptions.get("default");
        }
        return optionItem;
    }

    public OptionItem getDecodeOption(String value) {
        if (this.decodeOptions == null) {
            return null;
        }
        OptionItem optionItem = this.decodeOptions.get(value);
        if (optionItem == null) {
            optionItem = this.decodeOptions.get("default");
        }
        return optionItem;
    }

    public void setAttribute(String key, String value) {
        if (this.attribute == null) {
            this.attribute = new HashMap<String, String>();
        }
        this.attribute.put(key, value);
    }

    public String getAttribute(String key) {
        return this.attribute.get(key);
    }

    public static enum MarkType {
        Timing,
        WhileLoop,
        ValueLoop;

    }
}

