/*
 * Decompiled with CFR 0.152.
 */
package com.viewshine.codec.engine;

import com.viewshine.codec.engine.ConvertItem;
import com.viewshine.codec.utils.StringUtils;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Converter {
    private static Logger log = LoggerFactory.getLogger(Converter.class);
    private static String convertFile = "protocol/Convert.xml";
    private static Map<String, Map<String, ConvertItem>> convertMap = null;

    private static Map<String, Map<String, ConvertItem>> loadConvertFile(String convertFile) throws DocumentException {
        SAXReader reader = new SAXReader();
        InputStream is = Converter.class.getResourceAsStream("/" + convertFile);
        Document document = reader.read(is);
        HashMap<String, Map<String, ConvertItem>> convertMap = null;
        if (document != null) {
            Element root = document.getRootElement();
            Iterator it = root.elementIterator();
            convertMap = new HashMap<String, Map<String, ConvertItem>>();
            while (it.hasNext()) {
                Element elementConvert = (Element)it.next();
                Map<String, ConvertItem> convertItems = Converter.loadConvertItem(elementConvert);
                String code = elementConvert.attribute("code").getValue();
                if (convertItems == null) continue;
                convertMap.put(code, convertItems);
            }
        }
        return convertMap;
    }

    public static Map<String, ConvertItem> loadConvertItem(Element elementConvert) {
        HashMap<String, ConvertItem> convertItems = null;
        String code = elementConvert.attribute("code").getValue();
        if (!StringUtils.isEmpty(code)) {
            Iterator it_convertItems = elementConvert.elementIterator();
            convertItems = new HashMap<String, ConvertItem>();
            while (it_convertItems.hasNext()) {
                Element elementConvertItem = (Element)it_convertItems.next();
                List convertItemsAttrs = elementConvertItem.attributes();
                if (convertItemsAttrs.size() <= 0) continue;
                String value = elementConvertItem.attribute("value").getValue();
                String text = elementConvertItem.attribute("text").getValue();
                convertItems.put(value, new ConvertItem(value, value, text));
            }
        }
        return convertItems;
    }

    public static Map<String, Map<String, ConvertItem>> getConvertMap() {
        return convertMap;
    }

    public static Map<String, ConvertItem> getConvertItems(String code) {
        return convertMap.get(code);
    }

    public static ConvertItem getConvertItem(String code, String value) {
        Map<String, ConvertItem> convertItems = convertMap.get(code);
        if (convertItems != null) {
            return convertItems.get(value);
        }
        return null;
    }

    static {
        try {
            if (!StringUtils.isEmpty(convertFile)) {
                convertMap = Converter.loadConvertFile(convertFile);
            }
        }
        catch (Exception ex) {
            log.error("error", (Throwable)ex);
        }
    }
}

