/*
 * Decompiled with CFR 0.152.
 */
package com.viewshine.codec.engine;

import com.alibaba.fastjson.JSON;
import com.viewshine.codec.engine.CodecDataItem;
import com.viewshine.codec.engine.CommandItem;
import com.viewshine.codec.engine.DataItem;
import com.viewshine.codec.engine.DecodeUnit;
import com.viewshine.codec.engine.EncodeUnit;
import com.viewshine.codec.engine.OptionItem;
import com.viewshine.codec.engine.datatype.DataType;
import com.viewshine.codec.engine.datatype.DataTypeBitSet;
import com.viewshine.codec.utils.ByteUtils;
import com.viewshine.codec.utils.StringUtils;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodecEngineByte {
    private static Logger log = LoggerFactory.getLogger(CodecEngineByte.class);
    private String protocolFile;
    private HashMap<String, CommandItem> decodeCommandItems;
    public HashMap<String, CommandItem> encodeCommandItems;

    public CodecEngineByte(String protocolFile) {
        this.protocolFile = protocolFile;
        this.decodeCommandItems = new HashMap();
        this.encodeCommandItems = new HashMap();
        this.loadConfigFile();
        log.info("\u534f\u8bae\u6587\u6863[{}]\u52a0\u8f7d\u5b8c\u6210", (Object)protocolFile);
    }

    public CommandItem getDecodeCommandItem(String commandCode) {
        return this.decodeCommandItems.get(commandCode);
    }

    public CommandItem getEncodeCommandItems(String commandCode) {
        return this.encodeCommandItems.get(commandCode);
    }

    private void loadConfigFile() {
        try {
            InputStream is;
            SAXReader reader;
            Document document;
            if (!this.protocolFile.isEmpty() && (document = (reader = new SAXReader()).read(is = this.getClass().getResourceAsStream("/" + this.protocolFile))) != null) {
                Element root = document.getRootElement();
                Iterator it = root.elementIterator();
                while (it.hasNext()) {
                    Element elementCmdItem = (Element)it.next();
                    if ("Option".equals(elementCmdItem.getName())) {
                        Attribute attribute = elementCmdItem.attribute("code");
                        continue;
                    }
                    List cmdItemAttrs = elementCmdItem.attributes();
                    String code = null;
                    String name = null;
                    String timeOut = null;
                    HashMap<String, String> cmdItemExtraAttrs = new HashMap<String, String>();
                    block23: for (Object o : cmdItemAttrs) {
                        Attribute attr = (Attribute)o;
                        String value = attr.getValue();
                        switch (attr.getName()) {
                            case "code": {
                                code = value;
                                continue block23;
                            }
                            case "name": {
                                name = value;
                                continue block23;
                            }
                            case "timeOut": {
                                timeOut = value;
                                continue block23;
                            }
                        }
                        cmdItemExtraAttrs.put(attr.getName(), value);
                    }
                    Iterator it_cdt = elementCmdItem.elementIterator();
                    while (it_cdt.hasNext()) {
                        CommandItem cmdItem = new CommandItem(code, name);
                        cmdItem.setGroupCode(code);
                        if (!StringUtils.isEmpty(timeOut)) {
                            cmdItem.setTimeOutSeconds(Integer.valueOf(timeOut));
                        }
                        if (!cmdItemExtraAttrs.isEmpty()) {
                            cmdItem.getAttributes().putAll(cmdItemExtraAttrs);
                        }
                        Element element = (Element)it_cdt.next();
                        String elementName = element.getName();
                        List attrs = element.attributes();
                        block25: for (Object o : attrs) {
                            Attribute attr = (Attribute)o;
                            String value = attr.getValue();
                            switch (attr.getName()) {
                                case "code": {
                                    cmdItem.setCode(value);
                                    continue block25;
                                }
                                case "name": {
                                    cmdItem.setName(value);
                                    continue block25;
                                }
                                case "timeOut": {
                                    cmdItem.setTimeOutSeconds(Integer.valueOf(value));
                                    continue block25;
                                }
                            }
                            cmdItem.setAttribute(attr.getName(), value);
                        }
                        int type = 0;
                        if ("Decode".equals(elementName)) {
                            type = 1;
                            this.decodeCommandItems.put(cmdItem.code, cmdItem);
                        } else if ("Encode".equals(elementName)) {
                            type = 2;
                            this.encodeCommandItems.put(cmdItem.code, cmdItem);
                        }
                        Iterator it_dt = element.elementIterator();
                        ArrayList<String> dynItemCodes = new ArrayList<String>();
                        while (it_dt.hasNext()) {
                            DataItem dataItem = this.loadDataItem((Element)it_dt.next(), dynItemCodes, type);
                            cmdItem.dataItems.add(dataItem);
                        }
                        cmdItem.dynItemCodes = dynItemCodes;
                    }
                }
            }
        }
        catch (Exception ex) {
            log.error("error", (Throwable)ex);
        }
    }

    private DataItem loadDataItem(Element elementDataItem, List<String> dynItemCodes, int type) {
        try {
            String value;
            DataItem dataItem = new DataItem();
            List attrs = elementDataItem.attributes();
            block29: for (Object o : attrs) {
                Attribute attr = (Attribute)o;
                value = attr.getValue();
                switch (attr.getName()) {
                    case "code": {
                        dataItem.setCode(value);
                        continue block29;
                    }
                    case "name": {
                        dataItem.setName(value);
                        continue block29;
                    }
                    case "type": {
                        int indexExtra;
                        if (StringUtils.isEmpty(value)) continue block29;
                        if (value.contains("@")) {
                            String refCode;
                            dataItem.refCode = refCode = value.substring(1);
                            dynItemCodes.add(refCode);
                            continue block29;
                        }
                        if (value.contains("BitSet")) {
                            dataItem.isBitSet = true;
                        }
                        if (value.contains("Reserve")) {
                            dataItem.isReserve = true;
                        }
                        if ((indexExtra = value.indexOf("(")) > -1) {
                            String params = value.substring(indexExtra).replaceAll("\\(", "").replaceAll("\\)", "");
                            dataItem.setParams(params);
                            value = value.substring(0, indexExtra);
                        }
                        dataItem.type = value;
                        continue block29;
                    }
                    case "length": {
                        if (StringUtils.isEmpty(value)) continue block29;
                        if (value.contains("@")) {
                            String dynLenCode;
                            dataItem.dynLenCode = dynLenCode = value.substring(1);
                            dynItemCodes.add(dynLenCode);
                            continue block29;
                        }
                        dataItem.length = Integer.parseInt(value);
                        continue block29;
                    }
                    case "default": {
                        dataItem.setDefaultValue(value);
                        continue block29;
                    }
                    case "option": 
                    case "mark": {
                        if (StringUtils.isEmpty(value)) continue block29;
                        switch (value) {
                            case "Timing": {
                                dataItem.setMark(DataItem.MarkType.Timing);
                                break;
                            }
                            case "WhileLoop": {
                                dataItem.setMark(DataItem.MarkType.WhileLoop);
                                break;
                            }
                            case "ValueLoop": {
                                dataItem.setMark(DataItem.MarkType.ValueLoop);
                            }
                        }
                        continue block29;
                    }
                }
                dataItem.setAttribute(attr.getName(), value);
            }
            Iterator it_sdi = elementDataItem.elementIterator();
            ArrayList<DataItem> defaultSsdis = new ArrayList<DataItem>();
            while (it_sdi.hasNext()) {
                Element sdiElement = (Element)it_sdi.next();
                if ("Option".equals(sdiElement.getName())) {
                    value = sdiElement.attribute("value").getValue();
                    String text = sdiElement.attribute("text").getValue();
                    String codecValue = value;
                    Attribute attr = sdiElement.attribute("codecValue");
                    if (attr != null) {
                        codecValue = attr.getValue();
                    }
                    if (type == 1) {
                        dataItem.addDecodeOption(new OptionItem(codecValue, value, text));
                        continue;
                    }
                    dataItem.addEncodeOption(new OptionItem(codecValue, value, text));
                    continue;
                }
                if ("Group".equals(sdiElement.getName())) {
                    String[] formatCodes = sdiElement.attributeValue("value").split(",");
                    ArrayList<DataItem> ssdis = new ArrayList<DataItem>();
                    Iterator it_ssdi = sdiElement.elementIterator();
                    while (it_ssdi.hasNext()) {
                        ssdis.add(this.loadDataItem((Element)it_ssdi.next(), dynItemCodes, type));
                    }
                    for (String formatCode : formatCodes) {
                        dataItem.setSubItemsGroup(formatCode, ssdis);
                    }
                    continue;
                }
                defaultSsdis.add(this.loadDataItem(sdiElement, dynItemCodes, type));
            }
            if (defaultSsdis.size() > 0) {
                dataItem.setSubItemsGroup("default", defaultSsdis);
            }
            return dataItem;
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
            return null;
        }
    }

    public DecodeUnit decode(String cmdCode, byte[] src) {
        DecodeUnit unit = new DecodeUnit();
        unit.bytes = src;
        CommandItem commandItem = this.decodeCommandItems.get(cmdCode);
        if (commandItem == null) {
            log.error("\u547d\u4ee4\u9879[{}]\u4fe1\u606f\u7f3a\u5931, \u89e3\u7801\u5931\u8d25!", (Object)cmdCode);
            unit.setStatus(2);
        } else {
            unit.commandItem = commandItem;
            if (commandItem.dynItemCodes != null) {
                for (String dynItemCode : commandItem.dynItemCodes) {
                    unit.addDynItem(dynItemCode, null);
                }
            }
            for (DataItem dataItem : commandItem.dataItems) {
                CodecDataItem cdi = this.decodeDataItem(unit, dataItem);
                if (cdi != null) {
                    if (cdi.isReserve()) continue;
                    unit.addDecodeItem(cdi);
                    continue;
                }
                log.error("\u547d\u4ee4\u9879[{}:{}]\u4e2d\u7684\u6570\u636e\u9879[{}:{}]\u89e3\u7801\u5931\u8d25!", new Object[]{cmdCode, commandItem.name, dataItem.code, dataItem.name});
                unit.setStatus(2);
                return unit;
            }
            unit.setStatus(1);
        }
        return unit;
    }

    private CodecDataItem decodeDataItem(DecodeUnit unit, DataItem dataItem) {
        try {
            OptionItem optionItem;
            String code = dataItem.code;
            CodecDataItem cdi = new CodecDataItem(code, dataItem.name);
            cdi.setDataItem(dataItem);
            if (dataItem.refCode != null) {
                String refValue = unit.dynItems.get(dataItem.refCode);
                if (refValue == null) {
                    log.error("\u83b7\u53d6\u5f15\u7528\u9879[{}]\u503c\u5931\u8d25", (Object)dataItem.refCode);
                    return null;
                }
                cdi.setValue(refValue);
            } else {
                String type = dataItem.type;
                if (!StringUtils.isEmpty(type)) {
                    int length = dataItem.length;
                    if (dataItem.dynLenCode != null) {
                        String dynValue = unit.dynItems.get(dataItem.dynLenCode);
                        if (dynValue == null) {
                            log.error("\u83b7\u53d6\u5f15\u7528\u9879[{}]\u503c\u5931\u8d25", (Object)dataItem.refCode);
                            return null;
                        }
                        length = Integer.parseInt(dynValue);
                    }
                    if (!unit.hasEnoughRemaing(length, dataItem.isBitSet)) {
                        log.error("\u62a5\u6587\u957f\u5ea6\u6709\u8bef");
                        return null;
                    }
                    if (dataItem.isReserve) {
                        cdi.isReserve(true);
                    } else {
                        if (!dataItem.isBitSet) {
                            unit.restBitPos();
                        }
                        DataType dt = (DataType)Class.forName(this.getClass().getPackage().getName() + ".datatype.DataType" + type).newInstance();
                        dt.setLength(length);
                        if (!StringUtils.isEmpty(dataItem.getParams())) {
                            dt.setParams(dataItem.getParams());
                        }
                        dt.setBitPos(unit.bitPos);
                        dt.setBytes(unit.bytes, unit.bytePos);
                        String value = dt.getValue();
                        cdi.setCodecValue(value);
                        cdi.setValue(value);
                        cdi.setText(value);
                    }
                    if (dataItem.isBitSet) {
                        unit.stepBit(length);
                    } else {
                        unit.stepByte(length);
                    }
                }
            }
            if (cdi.getValue() == null && dataItem.getDefaultValue() != null) {
                cdi.setCodecValue(dataItem.getDefaultValue());
                cdi.setValue(dataItem.getDefaultValue());
                cdi.setText(dataItem.getDefaultValue());
            }
            if ((optionItem = dataItem.getDecodeOption(cdi.getValue())) != null) {
                cdi.setValue(optionItem.getValue());
                cdi.setText(optionItem.getText());
            }
            if (unit.dynItems != null && unit.dynItems.containsKey(code)) {
                unit.addDynItem(code, cdi.getValue());
            }
            if (dataItem.hasSubItemsGroup()) {
                List<DataItem> dis = dataItem.getSubItemsGroup(cdi.getValue());
                if (dis == null) {
                    log.error("\u672a\u627e\u5230\u6570\u636e\u9879[{}]\u503c[{}]\u5bf9\u5e94\u7684\u52a8\u6001\u5b50\u6570\u636e\u9879\u5217\u8868,\u89e3\u6790\u5931\u8d25", (Object)code, (Object)cdi.getValue());
                    return null;
                }
                int loopValue = 1;
                if (dataItem.mark != null) {
                    if (dataItem.mark == DataItem.MarkType.ValueLoop) {
                        loopValue = Integer.parseInt(cdi.getValue());
                    } else if (dataItem.mark == DataItem.MarkType.WhileLoop) {
                        loopValue = 999;
                    }
                }
                for (int i = 0; i < loopValue; ++i) {
                    ArrayList<CodecDataItem> diGroup = new ArrayList<CodecDataItem>();
                    boolean isComplete = false;
                    for (DataItem di : dis) {
                        if (!unit.hasEnoughRemaing(di.length, di.isBitSet)) {
                            isComplete = false;
                            break;
                        }
                        CodecDataItem subCdi = this.decodeDataItem(unit, di);
                        if (subCdi == null) {
                            log.error("\u547d\u4ee4\u9879[{}:{}]\u4e2d\u7684\u6570\u636e\u9879[{}:{}]\u89e3\u7801\u5931\u8d25!", new Object[]{unit.commandItem.code, unit.commandItem.name, di.code, di.name});
                            return null;
                        }
                        if (!subCdi.isReserve()) {
                            diGroup.add(subCdi);
                        }
                        isComplete = true;
                    }
                    if (!isComplete) break;
                    cdi.addSubItem(diGroup);
                }
                if (cdi.getValue() == null) {
                    cdi.setValue(cdi.subItemsLength() + "");
                    cdi.setValue(cdi.getValue());
                    cdi.setText(cdi.getValue());
                }
            }
            return cdi;
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
            return null;
        }
    }

    public EncodeUnit encode(String cmdCode, List<CodecDataItem> cdis) {
        EncodeUnit unit = new EncodeUnit();
        CommandItem commandItem = this.encodeCommandItems.get(cmdCode);
        if (commandItem == null) {
            log.error("\u547d\u4ee4\u9879[{}]\u4fe1\u606f\u7f3a\u5931, \u7f16\u7801\u5931\u8d25!", (Object)cmdCode);
        } else {
            unit.commandItem = commandItem;
            unit.params = cdis;
            if (commandItem.dynItemCodes != null) {
                for (String dynItemCode : commandItem.dynItemCodes) {
                    unit.addDynItem(dynItemCode, null);
                }
            }
            boolean status = true;
            for (DataItem dataItem : commandItem.dataItems) {
                status = this.encodeDataItem(unit, dataItem, unit.params);
                if (status) continue;
                log.error("\u547d\u4ee4\u9879[{}:{}]\u4e2d\u7684\u6570\u636e\u9879[{}:{}]\u7f16\u7801\u5931\u8d25!", new Object[]{cmdCode, commandItem.name, dataItem.code, dataItem.name});
                break;
            }
            unit.status = status ? 1 : 2;
        }
        return unit;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean encodeDataItem(EncodeUnit unit, DataItem dataItem, List<CodecDataItem> params) {
        try {
            String code = dataItem.code;
            String format = dataItem.type;
            int length = dataItem.length;
            String value = null;
            CodecDataItem cdi = this.findDataItem(code, params);
            if (!StringUtils.isEmpty(format)) {
                if (dataItem.dynLenCode != null) {
                    String dynValue = unit.dynItems.get(dataItem.dynLenCode);
                    if (dynValue == null) {
                        log.error("\u83b7\u53d6\u52a8\u6001\u9879[{}]\u503c\u5931\u8d25", (Object)dataItem.dynLenCode);
                        return false;
                    }
                    length = Integer.parseInt(dynValue);
                }
                if (dataItem.isReserve) {
                    if (dataItem.isBitSet) {
                        unit.putBitsetReserve(length);
                    } else {
                        unit.putBytes(new byte[length]);
                    }
                } else {
                    if (dataItem.mark != null && dataItem.mark == DataItem.MarkType.Timing) {
                        cdi = new CodecDataItem(dataItem.code, this.getTimeStr("yyyyMMddHHmmss"));
                    }
                    if (cdi == null || StringUtils.isEmpty(cdi.getValue())) {
                        if (dataItem.defaultValue == null) {
                            log.error("\u6570\u636e\u9879[{}:{}]\u7f3a\u5931\uff0c\u7f16\u7801\u5931\u8d25\uff01", (Object)code, (Object)dataItem.name);
                            return false;
                        }
                        value = dataItem.defaultValue;
                    } else {
                        value = cdi.getValue();
                    }
                    OptionItem optionItem = dataItem.getEncodeOption(value);
                    if (optionItem != null) {
                        value = optionItem.getCodecValue();
                    }
                    if (unit.dynItems != null && unit.dynItems.containsKey(code)) {
                        unit.addDynItem(code, value);
                    }
                    DataType dt = (DataType)Class.forName(this.getClass().getPackage().getName() + ".datatype.DataType" + format).newInstance();
                    dt.setLength(length);
                    if (!StringUtils.isEmpty(dataItem.getParams())) {
                        dt.setParams(dataItem.getParams());
                    }
                    dt.setValue(value);
                    if (dataItem.isBitSet) {
                        DataTypeBitSet sfb = (DataTypeBitSet)dt;
                        unit.putBitset(sfb.getBitSetStr());
                    } else {
                        unit.putBytes(dt.getBytes());
                    }
                }
            }
            if (cdi == null) return true;
            if (!dataItem.hasSubItemsGroup()) return true;
            List<DataItem> dis = dataItem.getSubItemsGroup(value);
            if (dis == null) {
                dis = dataItem.getSubItemsGroup("default");
            }
            if (dis == null) {
                log.error("\u672a\u627e\u5230\u6570\u636e\u9879[{}]\u503c[{}]\u5bf9\u5e94\u7684\u5b50\u6570\u636e\u9879\u5217\u8868,\u7f16\u7801\u5931\u8d25", (Object)code, (Object)cdi.getValue());
                return false;
            }
            List<List<CodecDataItem>> subItems = cdi.subItems;
            Iterator<List<CodecDataItem>> iterator = subItems.iterator();
            block2: while (true) {
                DataItem di;
                if (!iterator.hasNext()) return true;
                List<CodecDataItem> subItem = iterator.next();
                Iterator<DataItem> iterator2 = dis.iterator();
                do {
                    if (!iterator2.hasNext()) continue block2;
                } while (this.encodeDataItem(unit, di = iterator2.next(), subItem));
                break;
            }
            log.error("\u6570\u636e\u9879[{}:{}]\u7f16\u7801\u5931\u8d25!", (Object)dataItem.code, (Object)dataItem.name);
            return false;
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
            return false;
        }
    }

    private CodecDataItem findDataItem(String code, List<CodecDataItem> params) {
        CodecDataItem findCdi = null;
        if (params != null && params.size() > 0) {
            for (CodecDataItem cdi : params) {
                if (!code.equals(cdi.getCode())) continue;
                findCdi = cdi;
                break;
            }
        }
        return findCdi;
    }

    private String getTimeStr(String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(new Date());
    }

    public static void main(String[] args) throws DocumentException {
        CodecEngineByte engine = new CodecEngineByte("protocol/WaterNB.xml");
        long ct = System.currentTimeMillis();
        String str = "223230313831313239313233313030303132333132333132333132333132333132CA";
        byte[] bytes = ByteUtils.hexStrToBytes(str, false);
        DecodeUnit unit = engine.decode("042003", bytes);
        System.out.println(JSON.toJSONString(unit.getDecodeItems()));
        System.out.println("\u8017\u65f6:" + (System.currentTimeMillis() - ct) + "");
    }
}

