/*
 * Decompiled with CFR 0.152.
 */
package com.viewshine.codec.engine;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.viewshine.codec.engine.DataItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CodecDataItem {
    @JSONField(ordinal=1)
    private String code;
    @JSONField(ordinal=2)
    private String name;
    @JSONField(ordinal=3)
    private String value;
    @JSONField(serialize=false)
    private String codecValue;
    @JSONField(serialize=false)
    private String text;
    @JSONField(serialize=false)
    private DataItem dataItem;
    @JSONField(ordinal=6)
    public List<List<CodecDataItem>> subItems;
    @JSONField(serialize=false)
    private Map<String, String> attribute;
    @JSONField(serialize=false)
    private boolean reserve;

    public CodecDataItem(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public CodecDataItem(String code, String name, String value) {
        this.code = code;
        this.name = name;
        this.value = value;
    }

    public CodecDataItem(String code, String name, String value, String text) {
        this.code = code;
        this.name = name;
        this.value = value;
        this.text = text;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getCodecValue() {
        return this.codecValue;
    }

    public void setCodecValue(String codecValue) {
        this.codecValue = codecValue;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public DataItem getDataItem() {
        return this.dataItem;
    }

    public void setDataItem(DataItem dataItem) {
        this.dataItem = dataItem;
    }

    public void addSubItem(List<CodecDataItem> cdis) {
        if (this.subItems == null) {
            this.subItems = new ArrayList<List<CodecDataItem>>();
        }
        this.subItems.add(cdis);
    }

    public int subItemsLength() {
        if (this.subItems == null) {
            return 0;
        }
        return this.subItems.size();
    }

    public List<List<CodecDataItem>> getSubItems() {
        return this.subItems;
    }

    public void setSubItems(List<List<CodecDataItem>> subItems) {
        this.subItems = subItems;
    }

    public void setAttribute(String key, String value) {
        if (this.attribute == null) {
            this.attribute = new HashMap<String, String>();
        }
        this.attribute.put(key, value);
    }

    public String getAttribute(String key) {
        if (this.attribute == null) {
            return null;
        }
        return this.attribute.get(key);
    }

    public boolean isReserve() {
        return this.reserve;
    }

    public void isReserve(boolean reserve) {
        this.reserve = reserve;
    }

    public static CodecDataItem FindDto(String code, List<CodecDataItem> list, boolean foundRemove) {
        CodecDataItem result = null;
        if (list != null) {
            for (CodecDataItem dto : list) {
                if (!dto.code.equals(code)) continue;
                result = dto;
                break;
            }
            if (result != null && foundRemove) {
                list.remove(result);
            }
        }
        return result;
    }

    public static void main(String[] args) {
        String jsonStr = "{'code':'1','value':'111','subItems':[[{'code':'2','value':'2222'},{'code':'3','value':'3333'}],[{'code':'4','value':'4444','attribute':{'qwe':'adfa'}},{'code':'5','value':'5555'}]]}";
        CodecDataItem cdi1 = (CodecDataItem)JSON.parseObject((String)jsonStr, CodecDataItem.class);
        System.out.println(JSONObject.toJSONString((Object)cdi1));
    }
}

