/*
 * Decompiled with CFR 0.152.
 */
package com.viewshine.codec;

import com.alibaba.fastjson.JSON;
import com.viewshine.codec.Codec;
import com.viewshine.codec.DecodeResult;
import com.viewshine.codec.engine.CodecDataItem;
import com.viewshine.codec.engine.CodecEngineByte;
import com.viewshine.codec.engine.CommandItem;
import com.viewshine.codec.engine.DataItem;
import com.viewshine.codec.engine.DecodeUnit;
import com.viewshine.codec.engine.EncodeUnit;
import com.viewshine.codec.utils.AESUtil;
import com.viewshine.codec.utils.ByteUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Commerce30 {
    private static final Logger log = LoggerFactory.getLogger(Codec.class);
    private static String secretKey = "01020304050607080000000000000000";
    private static CodecEngineByte codecEngine = new CodecEngineByte("CommerceIot30.xml");
    private static SimpleDateFormat sdf1 = new SimpleDateFormat("yyMMddHH");

    private static byte calcCs(byte[] bytes) {
        return Commerce30.calcCs(bytes, 0, bytes.length);
    }

    private static byte calcCs(byte[] bytes, int beginIndex, int len) {
        byte cs = 0;
        for (int i = beginIndex; i < beginIndex + len; ++i) {
            cs = (byte)((cs & 0xFF) + (bytes[i] & 0xFF));
        }
        return cs;
    }

    private static boolean isEmpty(String src) {
        return src == null || "".equals(src);
    }

    public static boolean isNotEmpty(String src) {
        return !Commerce30.isEmpty(src);
    }

    public static DecodeResult Decode(byte[] msg, boolean haveNextCmd) {
        ArrayList<CodecDataItem> rs;
        byte[] data;
        boolean isEncrypted;
        DecodeResult result = new DecodeResult();
        if (msg == null || msg.length < 24) {
            result.setSuccess(false);
            result.setErrCode("0");
            result.setErrMsg("\u62a5\u6587\u957f\u5ea6\u6709\u8bef");
            return result;
        }
        boolean isValid = true;
        int dataLenght = 0;
        if (104 != (msg[0] & 0xFF) || 104 != (msg[7] & 0xFF)) {
            isValid = false;
        } else {
            dataLenght = (int)ByteUtils.bytesToInt(msg, 9, 2, true);
            if (22 != msg[11 + dataLenght + 1]) {
                isValid = false;
            } else if (Commerce30.calcCs(msg, 0, 11 + dataLenght) != msg[11 + dataLenght]) {
                isValid = false;
            }
        }
        if (!isValid) {
            result.setSuccess(false);
            result.setErrCode("1");
            result.setErrMsg("\u62a5\u6587\u683c\u5f0f\u6709\u8bef");
            return result;
        }
        String meterCode = ByteUtils.bytesToHexStr(msg, 1, 6, true);
        String funCode = ByteUtils.byteToHexStr((byte)(msg[8] & 0x7F));
        String time = ByteUtils.bytesToHexStr(msg, 11, 6, false);
        String meterType = ByteUtils.byteToHexStr(msg[17]);
        String cmdCode = ByteUtils.bytesToHexStr(msg, 18, 2, true);
        cmdCode = funCode + cmdCode;
        byte seq = msg[20];
        boolean bl = isEncrypted = (msg[17] & 0x80) == 128;
        if (isEncrypted) {
            data = ByteUtils.copyBytes(msg, 22, dataLenght - 11);
            data = AESUtil.decrypt(data, secretKey);
            int plainLen = (int)ByteUtils.bytesToInt(data, 0, 2, true);
            data = ByteUtils.copyBytes(data, 2, plainLen);
        } else {
            data = ByteUtils.copyBytes(msg, 21, dataLenght - 10);
        }
        if ("05AA00".equals(cmdCode) && data.length < 5) {
            cmdCode = "85AA00";
            rs = new ArrayList<CodecDataItem>();
            rs.add(new CodecDataItem("01", "\u5f00\u901a\u7ed3\u679c", (data[0] & 0xFF) + ""));
        } else {
            DecodeUnit decodeUnit = codecEngine.decode(cmdCode, data);
            if (!decodeUnit.isSuccess()) {
                result.setSuccess(false);
                result.setErrCode("1");
                result.setErrMsg("\u6570\u636e\u9879\u89e3\u6790\u5931\u8d25");
                return result;
            }
            rs = decodeUnit.getDecodeItems();
        }
        result.setSuccess(true);
        result.setMeterCode(meterCode);
        result.setMeterType(meterType);
        result.setCmdCode(cmdCode);
        result.setTime(time);
        result.setDataItems(rs);
        if ("05AA01".equals(cmdCode)) {
            result.setEchoData(Commerce30.Encode(meterCode, cmdCode, meterType, null, haveNextCmd));
        } else if ("01AA08".equals(cmdCode) && seq != 0) {
            ArrayList<CodecDataItem> dataItems = new ArrayList<CodecDataItem>();
            dataItems.add(new CodecDataItem("01", "", "02"));
            result.setEchoData(Commerce30.Encode(meterCode, cmdCode, meterType, dataItems, haveNextCmd));
            result.setCmdable(false);
        } else if ("05AA09".equals(cmdCode)) {
            result.setEchoData(Commerce30.Encode(meterCode, cmdCode, meterType, null, haveNextCmd));
        }
        return result;
    }

    public static byte[] Encode1(String meterCode, String cmdCode, String meterType, List<CodecDataItem> dataItems, boolean haveNextCmd) {
        boolean isEncrypted;
        EncodeUnit encodeUnit = codecEngine.encode(cmdCode, dataItems);
        if (!encodeUnit.isSuccess()) {
            log.info("\u547d\u4ee4[{}]\u7f16\u7801\u5931\u8d25", (Object)cmdCode);
            return null;
        }
        byte[] dataBytes = encodeUnit.getBytes();
        int dataLen = dataBytes.length;
        byte deviceType = ByteUtils.hexStrToByte(meterType);
        boolean bl = isEncrypted = (deviceType & 0x80) == 128;
        if (isEncrypted) {
            if (dataLen > 0) {
                byte[] b = new byte[]{(byte)dataLen, (byte)(dataLen >> 8)};
                dataBytes = ByteUtils.concatBytes(b, new byte[][]{dataBytes});
                dataBytes = AESUtil.encryptPKCS7(dataBytes, secretKey);
            }
            dataLen = dataBytes.length + 1;
        }
        ByteBuf buf = Unpooled.buffer((int)50);
        buf.writeByte(104);
        buf.writeBytes(ByteUtils.hexStrToBytes(meterCode, true));
        buf.writeByte(104);
        buf.writeByte((int)ByteUtils.hexStrToByte(cmdCode.substring(0, 2)));
        buf.writeByte((int)((byte)(dataLen += 10)));
        buf.writeByte((int)((byte)(dataLen >> 8)));
        buf.writeBytes(ByteUtils.dateToBcd(new Date(), "YYMMDDHHMISS"));
        buf.writeByte((int)deviceType);
        buf.writeBytes(ByteUtils.hexStrToBytes(cmdCode.substring(2, 6), true));
        buf.writeByte(haveNextCmd ? 0 : 1);
        if (isEncrypted) {
            buf.writeByte(0);
        }
        buf.writeBytes(dataBytes);
        buf.writeByte((int)Commerce30.calcCs(buf.array()));
        buf.writeByte(22);
        byte[] bytes = Arrays.copyOfRange(buf.array(), 0, buf.readableBytes());
        log.info("\u7f16\u7801\u5b8c\u6210: {}", (Object)ByteUtils.bytesToHexStr(bytes, " "));
        return bytes;
    }

    public static byte[] Encode(String meterCode, String cmdCode, String meterType, List<CodecDataItem> dataItems, boolean haveNextCmd) {
        boolean isEncrypted;
        EncodeUnit encodeUnit = codecEngine.encode(cmdCode, dataItems);
        if (!encodeUnit.isSuccess()) {
            log.info("\u547d\u4ee4[{}]\u7f16\u7801\u5931\u8d25", (Object)cmdCode);
            return null;
        }
        byte[] dataBytes = encodeUnit.getBytes();
        int dataLen = dataBytes.length;
        byte deviceType = ByteUtils.hexStrToByte(meterType);
        boolean bl = isEncrypted = (deviceType & 0x80) == 128;
        if (isEncrypted) {
            if (dataLen > 0) {
                byte[] b = new byte[]{(byte)dataLen, (byte)(dataLen >> 8)};
                dataBytes = ByteUtils.concatBytes(b, new byte[][]{dataBytes});
                dataBytes = AESUtil.encryptPKCS7(dataBytes, secretKey);
            }
            dataLen = dataBytes.length + 1;
        }
        byte[] bytes = new byte[(dataLen += 10) + 13];
        bytes[0] = 104;
        System.arraycopy(ByteUtils.hexStrToBytes(meterCode, true), 0, bytes, 1, 6);
        bytes[7] = 104;
        bytes[8] = ByteUtils.hexStrToByte(cmdCode.substring(0, 2));
        bytes[9] = (byte)dataLen;
        bytes[10] = (byte)(dataLen >> 8);
        System.arraycopy(ByteUtils.dateToBcd(new Date(), "YYMMDDHHMISS"), 0, bytes, 11, 6);
        bytes[17] = deviceType;
        System.arraycopy(ByteUtils.hexStrToBytes(cmdCode.substring(2, 6), true), 0, bytes, 18, 2);
        bytes[20] = (byte)(!haveNextCmd ? 1 : 0);
        int pos = 0;
        if (isEncrypted) {
            bytes[21] = 0;
            pos = 1;
        }
        if (dataBytes.length > 0) {
            System.arraycopy(dataBytes, 0, bytes, pos + 21, dataBytes.length);
        }
        bytes[pos + 21 + dataBytes.length] = Commerce30.calcCs(bytes);
        bytes[pos + 21 + dataBytes.length + 1] = 22;
        log.info("\u7f16\u7801\u5b8c\u6210: {}", (Object)ByteUtils.bytesToHexStr(bytes, " "));
        return bytes;
    }

    private static byte[] Encode2(String meterCode, String cmdCode, String meterType, byte[] dataBytes, boolean haveNextCmd) {
        boolean isEncrypted;
        int dataLen = dataBytes != null ? dataBytes.length : 0;
        byte deviceType = ByteUtils.hexStrToByte(meterType);
        boolean bl = isEncrypted = (deviceType & 0x80) == 128;
        if (isEncrypted) {
            if (dataLen > 0) {
                byte[] b = new byte[]{(byte)dataLen, (byte)(dataLen >> 8)};
                dataBytes = ByteUtils.concatBytes(b, new byte[][]{dataBytes});
                dataBytes = AESUtil.encryptPKCS7(dataBytes, secretKey);
            }
            dataLen = dataBytes.length + 1;
        }
        byte[] bytes = new byte[(dataLen += 10) + 13];
        bytes[0] = 104;
        System.arraycopy(ByteUtils.hexStrToBytes(meterCode, true), 0, bytes, 1, 6);
        bytes[7] = 104;
        bytes[8] = ByteUtils.hexStrToByte(cmdCode.substring(0, 2));
        bytes[9] = (byte)dataLen;
        bytes[10] = (byte)(dataLen >> 8);
        System.arraycopy(ByteUtils.dateToBcd(new Date(), "YYMMDDHHMISS"), 0, bytes, 11, 6);
        bytes[17] = deviceType;
        System.arraycopy(ByteUtils.hexStrToBytes(cmdCode.substring(2, 6), true), 0, bytes, 18, 2);
        bytes[20] = (byte)(!haveNextCmd ? 1 : 0);
        int pos = 0;
        if (isEncrypted) {
            bytes[21] = 0;
            pos = 1;
        }
        if (dataBytes.length > 0) {
            System.arraycopy(dataBytes, 0, bytes, pos + 21, dataBytes.length);
        }
        bytes[pos + 21 + dataBytes.length] = Commerce30.calcCs(bytes);
        bytes[pos + 21 + dataBytes.length + 1] = 22;
        log.info("\u7f16\u7801\u5b8c\u6210: {}", (Object)ByteUtils.bytesToHexStr(bytes, " "));
        return bytes;
    }

    public static byte[] MakeOpenPacket(String meterCode, String meterType, Map<String, String> params) {
        if (params == null || params.size() == 0) {
            log.error("\u53c2\u6570\u4e3a\u7a7a\uff0c\u5f00\u901a\u5305\u7f16\u7801\u5931\u8d25");
            return null;
        }
        String openState = params.get("openState");
        if (openState == null) {
            log.error("\u53c2\u6570\u9879[\u5f00\u901a\u72b6\u6001:openState]\u4e3a\u7a7a\uff0c\u5f00\u901a\u5305\u7f16\u7801\u5931\u8d25");
            return null;
        }
        if (!"1".equals(openState)) {
            log.info("\u547d\u4ee4[\u5f00\u901a\u5305]\u7ec4\u5e27\uff1a\u672a\u5f55\u5165");
            byte[] data = new byte[]{-69};
            return Commerce30.Encode2(meterCode, "05AA00", meterType, data, true);
        }
        String payType = params.get("payType");
        if (payType == null) {
            log.error("\u53c2\u6570\u9879[\u4ed8\u8d39\u7c7b\u578b:payType]\u4e3a\u7a7a\uff0c\u5f00\u901a\u5305\u7f16\u7801\u5931\u8d25");
            return null;
        }
        String price1 = params.get("price1");
        String price2 = params.get("price2");
        String price3 = params.get("price3");
        String price4 = params.get("price4");
        String price5 = params.get("price5");
        String gasVolume1 = params.get("gasVolume1");
        String gasVolume2 = params.get("gasVolume2");
        String gasVolume3 = params.get("gasVolume3");
        String gasVolume4 = params.get("gasVolume4");
        String gasVolume5 = "9999999";
        String prestoreAmount = params.get("prestoreAmount");
        String overdraft = params.get("overdraft");
        String cycleGas = params.get("cycleGas");
        String chargingCycleType = params.get("chargingCycleType");
        String chargingCycleValue = params.get("chargingCycleValue");
        String chargingStartDate = params.get("chargingStartDate");
        if ("1".equals(payType)) {
            if (Commerce30.isEmpty(price1)) {
                log.error("\u8868\u7aef\u9884\u4ed8\u8d39\u6a21\u5f0f\u4e0b\uff0c\u53c2\u6570\u9879[\u9636\u68af\u4ef7\u683c1:price1]\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5f00\u901a\u5305\u7f16\u7801\u5931\u8d25");
                return null;
            }
            if (Commerce30.isEmpty(chargingCycleType)) {
                log.error("\u8868\u7aef\u9884\u4ed8\u8d39\u6a21\u5f0f\u4e0b\uff0c\u53c2\u6570\u9879[\u9636\u68af\u8ba1\u8d39\u65f6\u95f4\u5355\u4f4d:chargingCycleType]\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5f00\u901a\u5305\u7f16\u7801\u5931\u8d25");
                return null;
            }
            if (Commerce30.isEmpty(chargingCycleValue)) {
                log.error("\u8868\u7aef\u9884\u4ed8\u8d39\u6a21\u5f0f\u4e0b\uff0c\u53c2\u6570\u9879[\u9636\u68af\u8ba1\u8d39\u65f6\u95f4:chargingCycleValue]\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5f00\u901a\u5305\u7f16\u7801\u5931\u8d25");
                return null;
            }
            if (Commerce30.isEmpty(chargingStartDate)) {
                log.error("\u8868\u7aef\u9884\u4ed8\u8d39\u6a21\u5f0f\u4e0b\uff0c\u53c2\u6570\u9879[\u9636\u68af\u8ba1\u8d39\u5f00\u59cb\u65e5\u671f:chargingStartDate]\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5f00\u901a\u5305\u7f16\u7801\u5931\u8d25");
                return null;
            }
            String bt1 = ByteUtils.byteToBitSetStr(ByteUtils.hexStrToByte(chargingStartDate.substring(0, 2)), 4, 4, false);
            String bt2 = ByteUtils.byteToBitSetStr(ByteUtils.hexStrToByte(chargingStartDate.substring(2, 4)), 3, 5, false);
            chargingStartDate = ByteUtils.bytesToHexStr(ByteUtils.bitSetStringToBytes("0000000" + bt1 + bt2, false));
        }
        if (Commerce30.isEmpty(price1)) {
            price1 = "1";
        }
        if (Commerce30.isEmpty(price2)) {
            price2 = price1;
        }
        if (Commerce30.isEmpty(price3)) {
            price3 = price2;
        }
        if (Commerce30.isEmpty(price4)) {
            price4 = price3;
        }
        if (Commerce30.isEmpty(price5)) {
            price5 = price4;
        }
        if (Commerce30.isEmpty(gasVolume1)) {
            gasVolume1 = "9999999";
        }
        if (Commerce30.isEmpty(gasVolume2)) {
            gasVolume2 = "9999999";
        }
        if (Commerce30.isEmpty(gasVolume3)) {
            gasVolume3 = "9999999";
        }
        if (Commerce30.isEmpty(gasVolume4)) {
            gasVolume4 = "9999999";
        }
        String upTime = params.get("upTime");
        String upTime1 = params.get("upTime1");
        String upTime2 = params.get("upTime2");
        String upTime3 = params.get("upTime3");
        if (Commerce30.isEmpty(upTime)) {
            upTime = "000200";
        }
        if (Commerce30.isEmpty(upTime1)) {
            upTime1 = upTime;
        }
        if (Commerce30.isEmpty(upTime2)) {
            upTime2 = upTime1;
        }
        if (Commerce30.isEmpty(upTime3)) {
            upTime3 = upTime2;
        }
        ArrayList<CodecDataItem> dataItems = new ArrayList<CodecDataItem>();
        dataItems.add(new CodecDataItem("01", "\u9884\u5b58\u91d1\u989d", prestoreAmount == null ? "0" : prestoreAmount));
        dataItems.add(new CodecDataItem("02", "\u51bb\u7ed3\u65f6\u95f4-\u5355\u4f4d", "2"));
        dataItems.add(new CodecDataItem("03", "\u51bb\u7ed3\u65f6\u95f4-\u503c", "28"));
        dataItems.add(new CodecDataItem("04", "\u5b9a\u65f6\u4e0a\u544a\u65f6\u95f4-\u5355\u4f4d", "2"));
        dataItems.add(new CodecDataItem("05", "\u5b9a\u65f6\u4e0a\u544a\u65f6\u95f4-\u503c", "1"));
        dataItems.add(new CodecDataItem("06", "\u6307\u5b9a\u65f6\u95f4\u70b91", upTime1));
        dataItems.add(new CodecDataItem("07", "\u6307\u5b9a\u65f6\u95f4\u70b92", upTime2));
        dataItems.add(new CodecDataItem("08", "\u6307\u5b9a\u65f6\u95f4\u70b93", upTime3));
        dataItems.add(new CodecDataItem("09", "\u5c11\u989d\u9608\u503c", "0"));
        dataItems.add(new CodecDataItem("10", "\u900f\u652f\u91d1\u989d", overdraft == null ? "0" : overdraft));
        dataItems.add(new CodecDataItem("11", "\u529f\u80fd-\u5c11\u989d", "1"));
        dataItems.add(new CodecDataItem("12", "\u529f\u80fd-\u96f6\u989d", "1"));
        dataItems.add(new CodecDataItem("13", "\u529f\u80fd-\u900f\u652f", "1"));
        dataItems.add(new CodecDataItem("21", "\u529f\u80fd-\u540e\u4ed8\u8d39/\u9884\u4ed8\u8d39", "1".equals(payType) ? "1" : "0"));
        dataItems.add(new CodecDataItem("22", "\u529f\u80fd-\u76f4\u63a5\u5f00\u9600", "0"));
        dataItems.add(new CodecDataItem("23", "\u529f\u80fd-\u5b9a\u65f6\u4e0a\u544a", "0"));
        dataItems.add(new CodecDataItem("24", "\u529f\u80fd-\u6307\u5b9a\u65f6\u95f4\u70b93", "0"));
        dataItems.add(new CodecDataItem("25", "\u529f\u80fd-\u6307\u5b9a\u65f6\u95f4\u70b92", "0"));
        dataItems.add(new CodecDataItem("26", "\u529f\u80fd-\u6307\u5b9a\u65f6\u95f4\u70b91", "1"));
        dataItems.add(new CodecDataItem("75", "\u4ed8\u8d39\u7c7b\u578b(5\u540e\u53f0\u9884\u4ed8\u8d39, 0\u975e\u540e\u53f0\u9884\u4ed8\u8d39)", "2".equals(payType) ? "5" : "0"));
        dataItems.add(new CodecDataItem("28", "\u5c11\u989d\u62a5\u8b66", "1"));
        dataItems.add(new CodecDataItem("29", "\u96f6\u989d\u62a5\u8b66", "1"));
        dataItems.add(new CodecDataItem("30", "\u900f\u652f\u62a5\u8b66", "1"));
        dataItems.add(new CodecDataItem("31", "\u65ad\u7ebf\u62a5\u8b66", "1"));
        dataItems.add(new CodecDataItem("32", "\u5f00\u76d6\u62a5\u8b66", "1"));
        dataItems.add(new CodecDataItem("33", "\u78c1\u653b\u51fb\u62a5\u8b66", "1"));
        dataItems.add(new CodecDataItem("34", "\u6b20\u538b\u62a5\u8b66", "1"));
        dataItems.add(new CodecDataItem("35", "\u8868\u5177\u5f02\u5e38\u62a5\u8b66", "1"));
        dataItems.add(new CodecDataItem("36", "\u62c6\u8868\u62a5\u8b66", "1"));
        dataItems.add(new CodecDataItem("77", "119\u62a5\u8b66", "1"));
        dataItems.add(new CodecDataItem("78", "\u6f0f\u6c14\u62a5\u8b66", "1"));
        dataItems.add(new CodecDataItem("79", "\u53cd\u5411\u8d70\u6c14\u62a5\u8b66", "1"));
        dataItems.add(new CodecDataItem("37", "\u4f4e\u538b\u62a5\u8b66", "1"));
        dataItems.add(new CodecDataItem("38", "\u9600\u95e8\u5f02\u5e38\u62a5\u8b66", "1"));
        dataItems.add(new CodecDataItem("39", "\u8d85\u6d41\u62a5\u8b66", "1"));
        dataItems.add(new CodecDataItem("40", "\u5c0f\u6d41\u62a5\u8b66", "1"));
        dataItems.add(new CodecDataItem("41", "\u5c11\u989d\u5173\u9600", "0"));
        dataItems.add(new CodecDataItem("42", "\u96f6\u989d\u5173\u9600", "0"));
        dataItems.add(new CodecDataItem("74", "\u900f\u652f\u5173\u9600", "1"));
        dataItems.add(new CodecDataItem("43", "\u65ad\u7ebf\u5173\u9600", "0"));
        dataItems.add(new CodecDataItem("44", "\u5f00\u76d6\u5173\u9600", "0"));
        dataItems.add(new CodecDataItem("45", "\u78c1\u653b\u51fb\u5173\u9600", "1"));
        dataItems.add(new CodecDataItem("46", "\u6b20\u538b\u5173\u9600", "1"));
        dataItems.add(new CodecDataItem("47", "\u8868\u5177\u5f02\u5e38\u5173\u9600", "1"));
        dataItems.add(new CodecDataItem("48", "\u62c6\u8868\u5173\u9600", "1"));
        dataItems.add(new CodecDataItem("80", "119\u5173\u9600", "1"));
        dataItems.add(new CodecDataItem("81", "\u6f0f\u6c14\u5173\u9600", "1"));
        dataItems.add(new CodecDataItem("82", "\u53cd\u5411\u8d70\u6c14\u5173\u9600", "0"));
        dataItems.add(new CodecDataItem("49", "\u4f4e\u538b\u5173\u9600", "1"));
        dataItems.add(new CodecDataItem("50", "\u5927\u4e8e\u6392\u7a7a\u91cf\u5173\u9600", "0"));
        dataItems.add(new CodecDataItem("51", "\u8d85\u6d41\u5173\u9600", "0"));
        dataItems.add(new CodecDataItem("52", "\u5c0f\u6d41\u5173\u9600", "0"));
        dataItems.add(new CodecDataItem("53", "\u9636\u68af\u5468\u671f\u7528\u6c14\u91cf", Commerce30.isEmpty(cycleGas) ? "0" : cycleGas));
        dataItems.add(new CodecDataItem("54", "\u6a21\u578b\u7c7b\u522b", "1"));
        dataItems.add(new CodecDataItem("55", "\u66f4\u65b0\u65b9\u5f0f", "1"));
        dataItems.add(new CodecDataItem("56", "\u9636\u68af\u8ba1\u8d39\u65f6\u95f4\u5355\u4f4d", Commerce30.isEmpty(chargingCycleType) ? "0" : chargingCycleType));
        dataItems.add(new CodecDataItem("57", "\u9636\u68af\u4ed8\u8d39\u6a21\u578b", "0"));
        dataItems.add(new CodecDataItem("58", "\u9636\u68af\u5468\u671f\u65f6\u95f4", Commerce30.isEmpty(chargingCycleType) ? "12" : chargingCycleValue));
        dataItems.add(new CodecDataItem("59", "\u6267\u884c\u65f6\u95f4(YYMMDDHH)", "01010100"));
        dataItems.add(new CodecDataItem("60", "\u9636\u68af1\u4ef7\u683c", price1));
        dataItems.add(new CodecDataItem("61", "\u9636\u68af1\u6c14\u91cf", gasVolume1));
        dataItems.add(new CodecDataItem("62", "\u9636\u68af2\u4ef7\u683c", price2));
        dataItems.add(new CodecDataItem("63", "\u9636\u68af2\u6c14\u91cf", gasVolume2));
        dataItems.add(new CodecDataItem("64", "\u9636\u68af3\u4ef7\u683c", price3));
        dataItems.add(new CodecDataItem("65", "\u9636\u68af3\u6c14\u91cf", gasVolume3));
        dataItems.add(new CodecDataItem("66", "\u9636\u68af4\u4ef7\u683c", price4));
        dataItems.add(new CodecDataItem("67", "\u9636\u68af4\u6c14\u91cf", gasVolume4));
        dataItems.add(new CodecDataItem("68", "\u9636\u68af5\u4ef7\u683c", price5));
        dataItems.add(new CodecDataItem("69", "\u9636\u68af5\u6c14\u91cf", gasVolume5));
        dataItems.add(new CodecDataItem("70", "\u9636\u68af\u8d77\u59cb\u65e5\u671f:\u5e74\u6708\u65e5", Commerce30.isEmpty(chargingStartDate) ? "010101" : chargingStartDate));
        dataItems.add(new CodecDataItem("73", "\u8c03\u4ef7\u5e8f\u53f7", "1"));
        return Commerce30.Encode(meterCode, "05AA00", meterType, dataItems, true);
    }

    public static byte[] SetParameter(String meterCode, String meterType, Map<String, String> params, boolean haveNextCmd) {
        ArrayList<CodecDataItem> dataItems = new ArrayList<CodecDataItem>();
        if (params != null && params.size() != 0) {
            String ip = params.get("ip");
            String port = params.get("port");
            String upTime = params.get("upTime");
            String overdraft = params.get("overdraft");
            if (Commerce30.isNotEmpty(ip)) {
                dataItems.add(new CodecDataItem("05", "IP\u662f\u5426\u66f4\u6539", "1"));
                dataItems.add(new CodecDataItem("06", "IP", ip));
                dataItems.add(new CodecDataItem("07", "\u7aef\u53e3", port));
            }
            if (Commerce30.isNotEmpty(upTime)) {
                dataItems.add(new CodecDataItem("14", "\u6307\u5b9a\u65f6\u95f4\u70b91\u662f\u5426\u66f4\u6539", "1"));
                dataItems.add(new CodecDataItem("15", "\u6307\u5b9a\u65f6\u95f4\u70b91", upTime));
                dataItems.add(new CodecDataItem("35", "\u6307\u5b9a\u65f6\u95f4\u70b91\u529f\u80fd\u662f\u5426\u66f4\u6539", "1"));
                dataItems.add(new CodecDataItem("46", "\u6307\u5b9a\u65f6\u95f4\u70b91\u529f\u80fd\u662f\u5426\u5f00\u542f", "1"));
            }
            if (Commerce30.isNotEmpty(overdraft)) {
                dataItems.add(new CodecDataItem("22", "\u900f\u652f\u91d1\u989d\u662f\u5426\u66f4\u6539", "1"));
                dataItems.add(new CodecDataItem("23", "\u900f\u652f\u91d1\u989d", overdraft));
            }
        }
        log.info("\u547d\u4ee4[\u53c2\u6570\u8bbe\u7f6e]\u6570\u636e\u9879\uff1a{}", (Object)JSON.toJSONString(dataItems));
        return Commerce30.Encode(meterCode, "04AA02", meterType, dataItems, haveNextCmd);
    }

    public static byte[] ReadParameter(String meterCode, String meterType, boolean haveNextCmd) {
        log.info("\u547d\u4ee4[\u53c2\u6570\u8bfb\u53d6]\u7f16\u7801");
        return Commerce30.Encode(meterCode, "01AA02", meterType, null, haveNextCmd);
    }

    public static byte[] Recharge(String meterCode, String meterType, Map<String, String> params, boolean haveNextCmd) {
        if (params == null || params.size() == 0) {
            log.error("\u53c2\u6570\u4e3a\u7a7a\uff0c\u5145\u503c\u547d\u4ee4\u7f16\u7801\u5931\u8d25");
            return null;
        }
        ArrayList<CodecDataItem> dataItems = new ArrayList<CodecDataItem>();
        String rechargeAmount = params.get("rechargeAmount");
        String sequence = params.get("sequence");
        String serialNo = params.get("serialNo");
        if (Commerce30.isEmpty(rechargeAmount)) {
            log.error("\u53c2\u6570\u9879[\u5145\u503c\u91d1\u989d:rechargeAmount]\u4e3a\u7a7a\uff0c\u5145\u503c\u547d\u4ee4\u7f16\u7801\u5931\u8d25");
            return null;
        }
        if (Commerce30.isEmpty(sequence)) {
            log.error("\u53c2\u6570\u9879[\u5145\u503c\u5e8f\u53f7:sequence]\u4e3a\u7a7a\uff0c\u5145\u503c\u547d\u4ee4\u7f16\u7801\u5931\u8d25");
            return null;
        }
        if (Commerce30.isEmpty(serialNo)) {
            log.error("\u53c2\u6570\u9879[\u5145\u503c\u6d41\u6c34\u7801:serialNo]\u4e3a\u7a7a\uff0c\u5145\u503c\u547d\u4ee4\u7f16\u7801\u5931\u8d25");
            return null;
        }
        dataItems.add(new CodecDataItem("01", "\u5145\u503c\u91d1\u989d", rechargeAmount));
        dataItems.add(new CodecDataItem("02", "\u5145\u503c\u6b21\u6570", sequence));
        dataItems.add(new CodecDataItem("03", "\u5145\u503c\u6d41\u6c34\u7801", serialNo));
        log.info("\u547d\u4ee4[\u5145\u503c]\u6570\u636e\u9879\uff1a{}", (Object)JSON.toJSONString(dataItems));
        return Commerce30.Encode(meterCode, "04AA05", meterType, dataItems, haveNextCmd);
    }

    public static byte[] ValveControl(String meterCode, String meterType, Map<String, String> params, boolean haveNextCmd) {
        if (params == null || params.size() == 0) {
            log.error("\u53c2\u6570\u4e3a\u7a7a\uff0c\u5145\u503c\u547d\u4ee4\u7f16\u7801\u5931\u8d25");
            return null;
        }
        ArrayList<CodecDataItem> dataItems = new ArrayList<CodecDataItem>();
        String valveState = params.get("valveState");
        if (Commerce30.isEmpty(valveState)) {
            log.error("\u53c2\u6570\u9879[\u9600\u95e8\u72b6\u6001:valveState]\u4e3a\u7a7a\uff0c\u9600\u63a7\u547d\u4ee4\u7f16\u7801\u5931\u8d25");
            return null;
        }
        if ("0C".equals(meterType)) {
            switch (valveState) {
                case "0": {
                    valveState = "DD";
                    break;
                }
                case "1": 
                case "2": {
                    valveState = "EE";
                    break;
                }
                default: {
                    log.error("\u53c2\u6570\u9879[\u9600\u95e8\u72b6\u6001:valveState={}]\u9519\u8bef\uff0c\u65e0\u6cd5\u8bc6\u522b\uff0c\u9600\u63a7\u547d\u4ee4\u7f16\u7801\u5931\u8d25", (Object)valveState);
                    return null;
                }
            }
        } else {
            switch (valveState) {
                case "0": {
                    valveState = "55";
                    break;
                }
                case "1": {
                    valveState = "99";
                    break;
                }
                case "2": {
                    valveState = "AA";
                    break;
                }
                default: {
                    log.error("\u53c2\u6570\u9879[\u9600\u95e8\u72b6\u6001:valveState={}]\u9519\u8bef\uff0c\u65e0\u6cd5\u8bc6\u522b\uff0c\u9600\u63a7\u547d\u4ee4\u7f16\u7801\u5931\u8d25", (Object)valveState);
                    return null;
                }
            }
        }
        dataItems.add(new CodecDataItem("01", "\u9600\u95e8\u72b6\u6001", valveState));
        log.info("\u547d\u4ee4[\u5145\u503c]\u6570\u636e\u9879\uff1a{}", (Object)JSON.toJSONString(dataItems));
        return Commerce30.Encode(meterCode, "04AA06", meterType, dataItems, haveNextCmd);
    }

    public static byte[] ReadPriceModel(String meterCode, String meterType, boolean haveNextCmd) {
        log.info("\u547d\u4ee4[\u8bfb\u53d6\u9636\u68af\u4ed8\u8d39\u6a21\u578b]\u7f16\u7801");
        return Commerce30.Encode(meterCode, "01AA07", meterType, null, haveNextCmd);
    }

    public static byte[] SetPriceModel(String meterCode, String meterType, Map<String, String> params, boolean haveNextCmd) {
        if (params == null || params.size() == 0) {
            log.error("\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bbe\u7f6e\u9636\u68af\u4ed8\u8d39\u6a21\u578b\u547d\u4ee4\u7f16\u7801\u5931\u8d25");
            return null;
        }
        String price1 = params.get("price1");
        String price2 = params.get("price2");
        String price3 = params.get("price3");
        String price4 = params.get("price4");
        String price5 = params.get("price5");
        String GasVolume1 = params.get("GasVolume1");
        String GasVolume2 = params.get("GasVolume2");
        String GasVolume3 = params.get("GasVolume3");
        String GasVolume4 = params.get("GasVolume4");
        String GasVolume5 = "9999999";
        String chargingCycleType = params.get("chargingCycleType");
        String chargingCycleValue = params.get("chargingCycleValue");
        String chargingExecuteDate = params.get("chargingExecuteDate");
        String chargingStartDate = params.get("chargingStartDate");
        String priceModelSeq = params.get("priceModelSeq");
        if (Commerce30.isEmpty(price1)) {
            log.error("\u53c2\u6570\u9879[\u9636\u68af\u4ef7\u683c1:price1]\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bbe\u7f6e\u9636\u68af\u4ed8\u8d39\u6a21\u578b\u547d\u4ee4\u7f16\u7801\u5931\u8d25");
            return null;
        }
        if (Commerce30.isEmpty(chargingCycleType)) {
            log.error("\u53c2\u6570\u9879[\u9636\u68af\u8ba1\u8d39\u65f6\u95f4\u5355\u4f4d:chargingCycleType]\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bbe\u7f6e\u9636\u68af\u4ed8\u8d39\u6a21\u578b\u547d\u4ee4\u7f16\u7801\u5931\u8d25");
            return null;
        }
        if (Commerce30.isEmpty(chargingCycleValue)) {
            log.error("\u53c2\u6570\u9879[\u9636\u68af\u8ba1\u8d39\u65f6\u95f4:chargingCycleValue]\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bbe\u7f6e\u9636\u68af\u4ed8\u8d39\u6a21\u578b\u547d\u4ee4\u7f16\u7801\u5931\u8d25");
            return null;
        }
        if (Commerce30.isEmpty(chargingExecuteDate)) {
            chargingExecuteDate = sdf1.format(new Date());
        }
        if (Commerce30.isEmpty(chargingStartDate)) {
            log.error("\u53c2\u6570\u9879[\u9636\u68af\u8ba1\u8d39\u5f00\u59cb\u65e5\u671f:chargingStartDate]\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bbe\u7f6e\u9636\u68af\u4ed8\u8d39\u6a21\u578b\u547d\u4ee4\u7f16\u7801\u5931\u8d25");
            return null;
        }
        String mm = chargingStartDate.substring(0, 2);
        String dd = chargingStartDate.substring(2, 4);
        log.info("mm=" + mm + ", dd=" + dd);
        String bt0 = "0000000";
        String bt1 = ByteUtils.byteToBitSetStr((byte)Integer.valueOf(mm).intValue(), 4, 4, false);
        String bt2 = ByteUtils.byteToBitSetStr((byte)Integer.valueOf(dd).intValue(), 3, 5, false);
        log.info("bt0=" + bt0 + ", bt1=" + bt1 + ", bt2=" + bt2);
        chargingStartDate = ByteUtils.bytesToHexStr(ByteUtils.bitSetStringToBytes(bt0 + bt1 + bt2, false));
        if (Commerce30.isEmpty(priceModelSeq)) {
            log.error("\u53c2\u6570\u9879[\u4ef7\u683c\u5e8f\u53f7:priceModelSeq]\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bbe\u7f6e\u9636\u68af\u4ed8\u8d39\u6a21\u578b\u547d\u4ee4\u7f16\u7801\u5931\u8d25");
            return null;
        }
        if (Commerce30.isEmpty(price1)) {
            price1 = "1";
        }
        if (Commerce30.isEmpty(price2)) {
            price2 = price1;
        }
        if (Commerce30.isEmpty(price3)) {
            price3 = price2;
        }
        if (Commerce30.isEmpty(price4)) {
            price4 = price3;
        }
        if (Commerce30.isEmpty(price5)) {
            price5 = price4;
        }
        if (Commerce30.isEmpty(GasVolume1)) {
            GasVolume1 = "9999999";
        }
        if (Commerce30.isEmpty(GasVolume2)) {
            GasVolume2 = "9999999";
        }
        if (Commerce30.isEmpty(GasVolume3)) {
            GasVolume3 = "9999999";
        }
        if (Commerce30.isEmpty(GasVolume4)) {
            GasVolume4 = "9999999";
        }
        ArrayList<CodecDataItem> dataItems = new ArrayList<CodecDataItem>();
        dataItems.add(new CodecDataItem("01", "\u6a21\u578b\u7c7b\u522b", "1"));
        dataItems.add(new CodecDataItem("02", "\u66f4\u65b0\u65b9\u5f0f", "1"));
        dataItems.add(new CodecDataItem("03", "\u9636\u68af\u8ba1\u8d39\u65f6\u95f4\u5355\u4f4d", Commerce30.isEmpty(chargingCycleType) ? "0" : chargingCycleType));
        dataItems.add(new CodecDataItem("04", "\u9636\u68af\u4ed8\u8d39\u6a21\u578b", "0"));
        dataItems.add(new CodecDataItem("05", "\u9636\u68af\u5468\u671f\u65f6\u95f4", Commerce30.isEmpty(chargingCycleValue) ? "12" : chargingCycleValue));
        dataItems.add(new CodecDataItem("06", "\u6267\u884c\u65f6\u95f4(YYMMDDHH)", chargingExecuteDate));
        dataItems.add(new CodecDataItem("07", "\u9636\u68af1\u4ef7\u683c", price1));
        dataItems.add(new CodecDataItem("08", "\u9636\u68af1\u6c14\u91cf", GasVolume1));
        dataItems.add(new CodecDataItem("09", "\u9636\u68af2\u4ef7\u683c", price2));
        dataItems.add(new CodecDataItem("10", "\u9636\u68af2\u6c14\u91cf", GasVolume2));
        dataItems.add(new CodecDataItem("11", "\u9636\u68af3\u4ef7\u683c", price3));
        dataItems.add(new CodecDataItem("12", "\u9636\u68af3\u6c14\u91cf", GasVolume3));
        dataItems.add(new CodecDataItem("13", "\u9636\u68af4\u4ef7\u683c", price4));
        dataItems.add(new CodecDataItem("14", "\u9636\u68af4\u6c14\u91cf", GasVolume4));
        dataItems.add(new CodecDataItem("15", "\u9636\u68af5\u4ef7\u683c", price5));
        dataItems.add(new CodecDataItem("16", "\u9636\u68af5\u6c14\u91cf", GasVolume5));
        dataItems.add(new CodecDataItem("17", "\u9636\u68af\u8d77\u59cb\u65e5\u671f:\u5e74\u6708\u65e5", chargingStartDate));
        dataItems.add(new CodecDataItem("18", "\u8c03\u4ef7\u5e8f\u53f7", priceModelSeq));
        log.info("\u547d\u4ee4[\u8bbe\u7f6e\u9636\u68af\u4ed8\u8d39\u6a21\u578b]\u6570\u636e\u9879\uff1a{}", (Object)JSON.toJSONString(dataItems));
        return Commerce30.Encode(meterCode, "04AA07", meterType, dataItems, haveNextCmd);
    }

    public static byte[] ReadLog(String meterCode, String meterType, boolean haveNextCmd) {
        ArrayList<CodecDataItem> dataItems = new ArrayList<CodecDataItem>();
        dataItems.add(new CodecDataItem("01", "\u5f00\u59cb\u8bfb\u53d6", "01"));
        log.info("\u547d\u4ee4[\u8bfb\u65e5\u5fd7]\u6570\u636e\u9879\uff1a{}", (Object)JSON.toJSONString(dataItems));
        return Commerce30.Encode(meterCode, "01AA08", meterType, dataItems, haveNextCmd);
    }

    public static byte[] RestoreMeter(String meterCode, String meterType, boolean haveNextCmd) {
        log.info("\u547d\u4ee4[\u6062\u590d\u51fa\u5382\u8bbe\u7f6e]\u7f16\u7801");
        return Commerce30.Encode(meterCode, "01AA04", meterType, null, haveNextCmd);
    }

    public static byte[] SetGasVolume(String meterCode, String meterType, Map<String, String> params, boolean haveNextCmd) {
        if (params == null || params.size() == 0) {
            log.error("\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bbe\u7f6e\u8868\u5177\u5e95\u7801\u547d\u4ee4\u7f16\u7801\u5931\u8d25");
            return null;
        }
        String setType = params.get("setType");
        String gasVolume = params.get("gasVolume");
        if (Commerce30.isEmpty(setType)) {
            log.error("\u53c2\u6570\u9879[\u8bbe\u7f6e\u7c7b\u578b:setType]\u4e3a\u7a7a\uff0c\u8bbe\u7f6e\u8868\u5177\u5e95\u7801\u547d\u4ee4\u7f16\u7801\u5931\u8d25");
            return null;
        }
        if (Commerce30.isEmpty(gasVolume)) {
            log.error("\u53c2\u6570\u9879[\u6c14\u91cf:gasVolume]\u4e3a\u7a7a\uff0c\u8bbe\u7f6e\u8868\u5177\u5e95\u7801\u547d\u4ee4\u7f16\u7801\u5931\u8d25");
            return null;
        }
        ArrayList<CodecDataItem> dataItems = new ArrayList<CodecDataItem>();
        dataItems.add(new CodecDataItem("01", "\u8bbe\u7f6e\u7c7b\u578b", setType));
        dataItems.add(new CodecDataItem("02", "\u6c14\u91cf", gasVolume));
        log.info("\u547d\u4ee4[\u8bbe\u7f6e\u8868\u5177\u5e95\u7801]\u6570\u636e\u9879\uff1a{}", (Object)JSON.toJSONString(dataItems));
        return Commerce30.Encode(meterCode, "04AA0C", meterType, dataItems, haveNextCmd);
    }

    public static byte[] SetCycleGasVolume(String meterCode, String meterType, Map<String, String> params, boolean haveNextCmd) {
        if (params == null || params.size() == 0) {
            log.error("\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bbe\u7f6e\u5468\u671f\u7528\u6c14\u91cf\u547d\u4ee4\u7f16\u7801\u5931\u8d25");
            return null;
        }
        String cycleGasVolume = params.get("cycleGasVolume");
        if (Commerce30.isEmpty(cycleGasVolume)) {
            log.error("\u53c2\u6570\u9879[\u8bbe\u7f6e\u5468\u671f\u7528\u6c14\u91cf:cycleGasVolume]\u4e3a\u7a7a\uff0c\u8bbe\u7f6e\u5468\u671f\u7528\u6c14\u91cf\u547d\u4ee4\u7f16\u7801\u5931\u8d25");
            return null;
        }
        ArrayList<CodecDataItem> dataItems = new ArrayList<CodecDataItem>();
        dataItems.add(new CodecDataItem("01", "\u5468\u671f\u7528\u6c14\u91cf", cycleGasVolume));
        log.info("\u547d\u4ee4[\u8bbe\u7f6e\u5468\u671f\u7528\u6c14\u91cf]\u6570\u636e\u9879\uff1a{}", (Object)JSON.toJSONString(dataItems));
        return Commerce30.Encode(meterCode, "04AA0D", meterType, dataItems, haveNextCmd);
    }

    public static byte[] ReadCycleGasVolume(String meterCode, String meterType, boolean haveNextCmd) {
        log.info("\u547d\u4ee4[\u8bbe\u7f6e\u5468\u671f\u7528\u6c14\u91cf]");
        return Commerce30.Encode(meterCode, "01AA0D", meterType, null, haveNextCmd);
    }

    public static byte[] RemoteUpgrade(String meterCode, String meterType, Map<String, String> params, boolean haveNextCmd) {
        if (params == null || params.size() == 0) {
            log.error("\u53c2\u6570\u4e3a\u7a7a\uff0c\u8fdc\u7a0b\u5347\u7ea7\u547d\u4ee4\u7f16\u7801\u5931\u8d25");
            return null;
        }
        String ftpUrl = params.get("ftpUrl");
        if (Commerce30.isEmpty(ftpUrl)) {
            log.error("\u53c2\u6570\u9879[ftp\u57df\u540d\u6216IP:ftpUrl]\u4e3a\u7a7a\uff0c\u8fdc\u7a0b\u5347\u7ea7\u547d\u4ee4\u7f16\u7801\u5931\u8d25");
            return null;
        }
        String port = params.get("port");
        if (Commerce30.isEmpty(port)) {
            log.error("\u53c2\u6570\u9879[\u7aef\u53e3:port]\u4e3a\u7a7a\uff0c\u8fdc\u7a0b\u5347\u7ea7\u547d\u4ee4\u7f16\u7801\u5931\u8d25");
            return null;
        }
        String fileUri = params.get("fileUri");
        if (Commerce30.isEmpty(fileUri)) {
            log.error("\u53c2\u6570\u9879[\u6587\u4ef6\u8def\u5f84:fileUri]\u4e3a\u7a7a\uff0c\u8fdc\u7a0b\u5347\u7ea7\u547d\u4ee4\u7f16\u7801\u5931\u8d25");
            return null;
        }
        String fileName = params.get("fileName");
        if (Commerce30.isEmpty(fileName)) {
            log.error("\u53c2\u6570\u9879[\u6587\u4ef6\u540d:fileName]\u4e3a\u7a7a\uff0c\u8fdc\u7a0b\u5347\u7ea7\u547d\u4ee4\u7f16\u7801\u5931\u8d25");
            return null;
        }
        String userName = params.get("userName");
        if (Commerce30.isEmpty(userName)) {
            log.error("\u53c2\u6570\u9879[\u767b\u5f55\u540d:userName]\u4e3a\u7a7a\uff0c\u8fdc\u7a0b\u5347\u7ea7\u547d\u4ee4\u7f16\u7801\u5931\u8d25");
            return null;
        }
        String password = params.get("password");
        if (Commerce30.isEmpty(password)) {
            log.error("\u53c2\u6570\u9879[\u767b\u5f55\u5bc6\u7801:password]\u4e3a\u7a7a\uff0c\u8fdc\u7a0b\u5347\u7ea7\u547d\u4ee4\u7f16\u7801\u5931\u8d25");
            return null;
        }
        ArrayList<CodecDataItem> dataItems = new ArrayList<CodecDataItem>();
        dataItems.add(new CodecDataItem("01", "ftp\u57df\u540d\u6216IP", ftpUrl));
        dataItems.add(new CodecDataItem("02", "\u7aef\u53e3", port));
        dataItems.add(new CodecDataItem("03", "\u6587\u4ef6\u8def\u5f84", fileUri));
        dataItems.add(new CodecDataItem("04", "\u6587\u4ef6\u540d", fileName));
        dataItems.add(new CodecDataItem("05", "\u767b\u5f55\u540d", userName));
        dataItems.add(new CodecDataItem("06", "\u767b\u5f55\u5bc6\u7801", password));
        log.info("\u547d\u4ee4[\u8fdc\u7a0b\u5347\u7ea7]\u6570\u636e\u9879\uff1a{}", (Object)JSON.toJSONString(dataItems));
        return Commerce30.Encode(meterCode, "06AA12", meterType, dataItems, haveNextCmd);
    }

    public static byte[] BalanceSync(String meterCode, String meterType, Map<String, String> params, boolean haveNextCmd) {
        if (params == null || params.size() == 0) {
            log.error("\u53c2\u6570\u4e3a\u7a7a\uff0c\u4f59\u989d\u540c\u6b65\u547d\u4ee4\u7f16\u7801\u5931\u8d25");
            return null;
        }
        ArrayList<CodecDataItem> dataItems = new ArrayList<CodecDataItem>();
        String balanceType = params.get("balanceType");
        String balance = params.get("balance");
        String updataTime = params.get("updataTime");
        String cycleGasVolume = params.get("cycleGasVolume");
        String totalRecharge = params.get("totalRecharge");
        String price = params.get("price");
        String lastRecharge = params.get("lastRecharge");
        String lastRechargeTime = params.get("lastRechargeTime");
        if (Commerce30.isEmpty(balanceType)) {
            log.error("\u53c2\u6570\u9879[\u4f59\u989d\u7c7b\u578b:balanceType]\u4e3a\u7a7a\uff0c\u4f59\u989d\u540c\u6b65\u547d\u4ee4\u7f16\u7801\u5931\u8d25");
            return null;
        }
        if (Commerce30.isEmpty(balance)) {
            log.error("\u53c2\u6570\u9879[\u4f59\u989d:balance]\u4e3a\u7a7a\uff0c\u4f59\u989d\u540c\u6b65\u547d\u4ee4\u7f16\u7801\u5931\u8d25");
            return null;
        }
        if (Commerce30.isEmpty(updataTime)) {
            log.error("\u53c2\u6570\u9879[\u66f4\u65b0\u65f6\u95f4:updataTime]\u4e3a\u7a7a\uff0c\u4f59\u989d\u540c\u6b65\u547d\u4ee4\u7f16\u7801\u5931\u8d25");
            return null;
        }
        if ("1".equals(balanceType)) {
            dataItems.add(new CodecDataItem("01", "\u4f59\u989d\u7c7b\u578b", "05"));
            dataItems.add(new CodecDataItem("10", "\u663e\u793a:\u5269\u4f59\u6c14\u91cf", "1"));
            dataItems.add(new CodecDataItem("15", "\u5269\u4f59\u6c14\u91cf", balance));
        } else {
            dataItems.add(new CodecDataItem("01", "\u4f59\u989d\u7c7b\u578b", "0A"));
            dataItems.add(new CodecDataItem("09", "\u663e\u793a:\u5269\u4f59\u91d1\u989d", "1"));
            dataItems.add(new CodecDataItem("14", "\u5269\u4f59\u91d1\u989d", balance));
        }
        dataItems.add(new CodecDataItem("02", "\u4f59\u989d", balance));
        dataItems.add(new CodecDataItem("03", "\u66f4\u65b0\u65f6\u95f4", updataTime));
        if (Commerce30.isNotEmpty(cycleGasVolume)) {
            dataItems.add(new CodecDataItem("04", "\u663e\u793a:\u9636\u68af\u5468\u671f\u7d2f\u8ba1\u7528\u6c14\u91cf", "1"));
            dataItems.add(new CodecDataItem("21", "\u9636\u68af\u5468\u671f\u7d2f\u8ba1\u7528\u6c14\u91cf", cycleGasVolume));
        }
        if (Commerce30.isNotEmpty(totalRecharge)) {
            if ("1".equals(balanceType)) {
                dataItems.add(new CodecDataItem("05", "\u663e\u793a:\u7d2f\u8ba1\u5145\u503c\u6c14\u91cf", "1"));
                dataItems.add(new CodecDataItem("20", "\u7d2f\u8ba1\u5145\u503c\u6c14\u91cf", totalRecharge));
            } else {
                dataItems.add(new CodecDataItem("06", "\u663e\u793a:\u7d2f\u8ba1\u5145\u503c\u91d1\u989d", "1"));
                dataItems.add(new CodecDataItem("19", "\u7d2f\u8ba1\u5145\u503c\u91d1\u989d", totalRecharge));
            }
        }
        if (Commerce30.isNotEmpty(lastRecharge)) {
            if ("1".equals(balanceType)) {
                dataItems.add(new CodecDataItem("07", "\u663e\u793a:\u6700\u8fd1\u4e00\u6b21\u5145\u503c\u6c14\u91cf", "1"));
                dataItems.add(new CodecDataItem("17", "\u6700\u8fd1\u4e00\u6b21\u5145\u503c\u6c14\u91cf", lastRecharge));
            } else {
                dataItems.add(new CodecDataItem("08", "\u663e\u793a:\u6700\u8fd1\u4e00\u6b21\u5145\u503c\u91d1\u989d", "1"));
                dataItems.add(new CodecDataItem("16", "\u6700\u8fd1\u4e00\u6b21\u5145\u503c\u91d1\u989d", lastRecharge));
            }
        }
        if (Commerce30.isNotEmpty(price)) {
            dataItems.add(new CodecDataItem("11", "\u663e\u793a:\u5355\u4ef7", "1"));
            dataItems.add(new CodecDataItem("13", "\u5355\u4ef7", price));
        }
        if (Commerce30.isNotEmpty(lastRechargeTime)) {
            dataItems.add(new CodecDataItem("18", "\u6700\u8fd1\u4e00\u6b21\u5145\u503c\u65f6\u95f4", lastRechargeTime));
        }
        log.info("\u547d\u4ee4[\u4f59\u989d\u540c\u6b65]\u6570\u636e\u9879\uff1a{}", (Object)JSON.toJSONString(dataItems));
        return Commerce30.Encode(meterCode, "04AA21", meterType, dataItems, haveNextCmd);
    }

    private static boolean checkParam(CommandItem commandItem, String code, Map<String, String> params, String paramName, List<CodecDataItem> dataItems, String defaultValue) {
        String cmdName = commandItem.getName();
        String dataItemName = null;
        for (DataItem di : commandItem.getDataItems()) {
            if (!code.endsWith(di.getCode())) continue;
            dataItemName = di.getName();
            break;
        }
        if (dataItemName == null) {
            log.error("\u547d\u4ee4\u9879[{}]\u4e2d\u672a\u627e\u5230\u6570\u636e\u9879[{}], \u7f16\u7801\u5931\u8d25", (Object)cmdName, (Object)code);
            return false;
        }
        String value = null;
        if (paramName != null) {
            value = params.get(paramName);
        }
        if (Commerce30.isEmpty(value)) {
            if (Commerce30.isEmpty(defaultValue)) {
                log.error("\u53c2\u6570\u9879[{}:{}]\u4e3a\u7a7a\uff0c[{}]\u547d\u4ee4\u7f16\u7801\u5931\u8d25", new Object[]{dataItemName, paramName, cmdName});
                return false;
            }
            value = defaultValue;
        }
        dataItems.add(new CodecDataItem(code, dataItemName, value));
        return true;
    }

    public static void main(String[] args) {
        Commerce30.isEmpty("123123");
        long s = System.currentTimeMillis();
        log.info("\u5f00\u59cb=" + s);
        String ss = "68 56 10 11 03 19 20 68 85 4C 00 19 03 11 13 26 35 12 01 AA 00 14 01 19 03 11 13 26 35 00 00 00 00 00 00 00 00 00 00 A0 0F 02 00 00 00 00 00 00 A0 00 8A 4C 5C 06 64 FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF 00 FF FF 00 FF 2B 16";
        byte[] b = ByteUtils.hexStrToBytes(ss);
        DecodeResult rs = Commerce30.Decode(b, true);
        System.out.println(JSON.toJSON((Object)rs));
        long e = System.currentTimeMillis();
        log.info("\u7ed3\u675f=" + e);
        log.info("\u8017\u65f6=" + (e - s));
    }
}

