/*
 * Decompiled with CFR 0.152.
 */
package com.ld.dataparse;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang.StringUtils;

public class Util {
    private static byte charToByte(char c) {
        return (byte)"0123456789abcdef".indexOf(c);
    }

    public static String bcd2Str(byte[] bytes) {
        StringBuffer temp = new StringBuffer(bytes.length * 2);
        int i = 0;
        while (i < bytes.length) {
            temp.append((byte)((bytes[i] & 0xF0) >>> 4));
            temp.append((byte)(bytes[i] & 0xF));
            ++i;
        }
        return temp.toString().substring(0, 1).equalsIgnoreCase("0") ? temp.toString().substring(1) : temp.toString();
    }

    public static byte[] StrToBCDBytes(String s) {
        if (s.length() % 2 != 0) {
            s = "0" + s;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        char[] cs = s.toCharArray();
        int i = 0;
        while (i < cs.length) {
            int high = cs[i] - 48;
            int low = cs[i + 1] - 48;
            baos.write(high << 4 | low);
            i += 2;
        }
        return baos.toByteArray();
    }

    public static String hexToAscii(String hexStr) {
        StringBuilder output = new StringBuilder("");
        int i = 0;
        while (i < hexStr.length()) {
            String str = hexStr.substring(i, i + 2);
            output.append((char)Integer.parseInt(str, 16));
            i += 2;
        }
        return output.toString();
    }

    public static int convertToDecimal(String binary) {
        return Integer.valueOf(binary, 2);
    }

    public static String stringToAscii(String value) {
        StringBuffer sbu = new StringBuffer();
        char[] chars = value.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (i != chars.length - 1) {
                sbu.append((int)chars[i]).append(",");
            } else {
                sbu.append((int)chars[i]);
            }
            ++i;
        }
        return sbu.toString();
    }

    public static String asciiToString(String value) {
        StringBuffer sbu = new StringBuffer();
        String[] chars = value.split(",");
        int i = 0;
        while (i < chars.length) {
            sbu.append((char)Integer.parseInt(chars[i]));
            ++i;
        }
        return sbu.toString();
    }

    public static String makeChecksum1(String data) {
        if (data == null || data.equals("")) {
            return "";
        }
        int total = 0;
        int len = data.length();
        int num = 0;
        while (num < len) {
            String s = data.substring(num, num + 2);
            total += Integer.parseInt(s, 16);
            num += 2;
        }
        int mod = total % 256;
        String hex = Integer.toHexString(mod);
        len = hex.length();
        if (len < 2) {
            hex = "0" + hex;
        }
        return hex;
    }

    public static String makeChecksum(String hexdata, int len) {
        if (hexdata == null || hexdata.equals("")) {
            return "00";
        }
        hexdata = hexdata.replaceAll(" ", "");
        int total = 0;
        if (len % 2 != 0) {
            return "00";
        }
        int num = 0;
        while (num < len) {
            String s = hexdata.substring(num, num + 2);
            total += Integer.parseInt(s, 16);
            num += 2;
        }
        return Util.hexInt(total);
    }

    private static String hexInt(int total) {
        int a = total / 256;
        int b = total % 256;
        if (a > 255) {
            return String.valueOf(Util.hexInt(a)) + Util.format(b);
        }
        return String.valueOf(Util.format(a)) + Util.format(b);
    }

    private static String format(int hex) {
        String hexa = Integer.toHexString(hex);
        int len = hexa.length();
        if (len < 2) {
            hexa = "0" + hexa;
        }
        return hexa;
    }

    private static String makeCheckSum(String data, int length) {
        int dSum = 0;
        int index = 0;
        while (index < length) {
            String s = data.substring(index, index + 2);
            dSum += Integer.parseInt(s, 16);
            index += 2;
        }
        int mod = dSum % 256;
        String checkSumHex = Integer.toHexString(mod);
        length = checkSumHex.length();
        if (length < 2) {
            checkSumHex = "0" + checkSumHex;
        }
        return checkSumHex;
    }

    public static byte[] intToByteArray(int a) {
        return new byte[]{(byte)(a >> 24 & 0xFF), (byte)(a >> 16 & 0xFF), (byte)(a >> 8 & 0xFF), (byte)(a & 0xFF)};
    }

    public static int byteArrayToInt(byte[] bytes) {
        int value = 0;
        int i = 0;
        while (i < 4) {
            int shift = (3 - i) * 8;
            value += (bytes[i] & 0xFF) << shift;
            ++i;
        }
        return value;
    }

    public static int HexToInt(byte[] Hex, int Count) {
        int Result = 0;
        int i = 0;
        while (i < Count) {
            Result = Result << 8 | Hex[i] & 0xFF;
            ++i;
        }
        return Result;
    }

    public static byte[] str2Bcd(String asc) {
        int len = asc.length();
        int mod = len % 2;
        if (mod != 0) {
            asc = "0" + asc;
            len = asc.length();
        }
        byte[] abt = new byte[len];
        if (len >= 2) {
            len /= 2;
        }
        byte[] bbt = new byte[len];
        abt = asc.getBytes(StandardCharsets.US_ASCII);
        int p = 0;
        while (p < asc.length() / 2) {
            byte b;
            int j = abt[2 * p] >= 48 && abt[2 * p] <= 57 ? abt[2 * p] - 48 : (abt[2 * p] >= 97 && abt[2 * p] <= 122 ? abt[2 * p] - 97 + 10 : abt[2 * p] - 65 + 10);
            int k = abt[2 * p + 1] >= 48 && abt[2 * p + 1] <= 57 ? abt[2 * p + 1] - 48 : (abt[2 * p + 1] >= 97 && abt[2 * p + 1] <= 122 ? abt[2 * p + 1] - 97 + 10 : abt[2 * p + 1] - 65 + 10);
            int a = (j << 4) + k;
            bbt[p] = b = (byte)a;
            ++p;
        }
        return bbt;
    }

    public static final String bytesToHexString(byte[] bArray) {
        StringBuffer sb = new StringBuffer(bArray.length);
        int i = 0;
        while (i < bArray.length) {
            String sTemp = Integer.toHexString(0xFF & bArray[i]);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
            ++i;
        }
        return sb.toString();
    }

    public static final String byteToHexString(byte bArray) {
        StringBuffer sb = new StringBuffer(1);
        String sTemp = Integer.toHexString(0xFF & bArray);
        if (sTemp.length() < 2) {
            sb.append(0);
        }
        sb.append(sTemp.toUpperCase());
        return sb.toString();
    }

    public static String str2HexStr(String str) {
        char[] chars = "0123456789ABCDEF".toCharArray();
        StringBuilder sb = new StringBuilder("");
        byte[] bs = str.getBytes();
        int i = 0;
        while (i < bs.length) {
            int bit = (bs[i] & 0xF0) >> 4;
            sb.append(chars[bit]);
            bit = bs[i] & 0xF;
            sb.append(chars[bit]);
            ++i;
        }
        return sb.toString();
    }

    public static String Int2Hex(int integer) {
        StringBuffer buf = new StringBuffer(2);
        if ((integer & 0xFF) < 16) {
            buf.append("0");
        }
        buf.append(Long.toString(integer & 0xFF, 16));
        return buf.toString();
    }

    public static String byteArrToBinStr(byte[] b) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < b.length) {
            result.append(String.valueOf(Long.toString(b[i] & 0xFF, 2)) + ",");
            ++i;
        }
        return result.toString().substring(0, result.length() - 1);
    }

    public static byte[] toByteArray(String hexString) {
        if (StringUtils.isEmpty((String)hexString)) {
            return null;
        }
        hexString = hexString.toLowerCase();
        byte[] byteArray = new byte[hexString.length() >> 1];
        int index = 0;
        int i = 0;
        while (i < hexString.length()) {
            if (index > hexString.length() - 1) {
                return byteArray;
            }
            byte highDit = (byte)(Character.digit(hexString.charAt(index), 16) & 0xFF);
            byte lowDit = (byte)(Character.digit(hexString.charAt(index + 1), 16) & 0xFF);
            byteArray[i] = (byte)(highDit << 4 | lowDit);
            index += 2;
            ++i;
        }
        return byteArray;
    }

    protected static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new RuntimeException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }

    public static byte[] hexToByteArray(String inHex) {
        byte[] result;
        int hexlen = inHex.length();
        if (hexlen % 2 == 1) {
            result = new byte[++hexlen / 2];
            inHex = "0" + inHex;
        } else {
            result = new byte[hexlen / 2];
        }
        int j = 0;
        int i = 0;
        while (i < hexlen) {
            result[j] = Util.hexToByte(inHex.substring(i, i + 2));
            ++j;
            i += 2;
        }
        return result;
    }

    public static byte hexToByte(String inHex) {
        return (byte)Integer.parseInt(inHex, 16);
    }

    public static byte[] hexStringToByte(String hex) {
        int len = hex.length() / 2;
        byte[] result = new byte[len];
        char[] achar = hex.toCharArray();
        int i = 0;
        while (i < len) {
            int pos = i * 2;
            result[i] = (byte)(Util.charToByte(achar[pos]) << 4 | Util.charToByte(achar[pos + 1]));
            ++i;
        }
        return result;
    }
}

