/*
 * Decompiled with CFR 0.152.
 */
package com.goldcard.resolve.util;

import com.goldcard.protocol.AbstractProtocol;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentHashMap;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class ProtocolUtil {
    private static final ConcurrentHashMap<Class<? extends AbstractProtocol>, AbstractProtocol> protocols = new ConcurrentHashMap(16);

    public static final AbstractProtocol getAbstractProtocol(Class<? extends AbstractProtocol> clazz) {
        ProtocolUtil.initProtocols();
        return protocols.get(clazz);
    }

    public static final ConcurrentHashMap<Class<? extends AbstractProtocol>, AbstractProtocol> getAllProtocols() {
        ProtocolUtil.initProtocols();
        return protocols;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initProtocols() {
        if (protocols.size() != 0) return;
        Class<ProtocolUtil> clazz = ProtocolUtil.class;
        synchronized (ProtocolUtil.class) {
            if (protocols.size() != 0) return;
            Reflections reflections = new Reflections("com.goldcard", new Scanner[0]);
            for (Class<AbstractProtocol> protocol : reflections.getSubTypesOf(AbstractProtocol.class)) {
                if (Modifier.isAbstract(protocol.getModifiers()) || Modifier.isInterface(protocol.getModifiers())) continue;
                try {
                    protocols.put(protocol, protocol.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Exception e) {
                    throw new RuntimeException(String.valueOf(e.getMessage()) + "|" + e.getCause());
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

