/*
 * Decompiled with CFR 0.152.
 */
package com.goldcard.resolve.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DateUtil {
    private static final ConcurrentMap<String, DateTimeFormatter> formatterMap = new ConcurrentHashMap<String, DateTimeFormatter>();
    private static final ConcurrentMap<String, ThreadLocal<SimpleDateFormat>> sdfs = new ConcurrentHashMap<String, ThreadLocal<SimpleDateFormat>>();

    public static final DateTimeFormatter getDateTimeFormatter(String pattern) {
        DateTimeFormatter df = (DateTimeFormatter)formatterMap.get(pattern);
        if (df != null) {
            return df;
        }
        formatterMap.putIfAbsent(pattern, DateTimeFormatter.ofPattern(pattern));
        return (DateTimeFormatter)formatterMap.get(pattern);
    }

    public static final SimpleDateFormat getSimpleDateFormat(final String pattern) {
        sdfs.putIfAbsent(pattern, new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat(pattern);
            }
        });
        return (SimpleDateFormat)((ThreadLocal)sdfs.get(pattern)).get();
    }

    public static final Date string2Date(String date, String pattern) {
        try {
            return DateUtil.getSimpleDateFormat(pattern).parse(date);
        }
        catch (ParseException e) {
            throw new RuntimeException("\u65e5\u671f\u89e3\u6790\u51fa\u73b0\u5f02\u5e38" + date + ":" + pattern);
        }
    }

    public static Date addDay(Date date, int i) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, i);
        return cal.getTime();
    }

    public static Date addMonth(Date date, int i) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, i);
        return cal.getTime();
    }

    public static Date firstDayOfThisMonth(Date date) {
        String str = String.valueOf(DateUtil.getSimpleDateFormat("yyyy-MM").format(date)) + "-01";
        return DateUtil.string2Date(str, "yyyy-MM-dd");
    }

    public static Date formatDate(Date date, String pattern) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sf = DateUtil.getSimpleDateFormat(pattern);
        return DateUtil.string2Date(sf.format(date), pattern);
    }

    public static int compareDate(Date date1, Date date2, String pattern) {
        SimpleDateFormat sf = DateUtil.getSimpleDateFormat(pattern);
        String tmp1 = sf.format(date1);
        String tmp2 = sf.format(date2);
        return tmp1.compareTo(tmp2);
    }
}

