/*
 * Decompiled with CFR 0.152.
 */
package com.goldcard.resolve.util;

import com.goldcard.resolve.util.ByteUtil;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;

public class DESUtil {
    private static final String DES = "DES";

    public static byte[] decrypt(byte[] data, String key, String code) {
        try {
            byte[] keys = ByteUtil.hexString2Bytes(key);
            byte[] datas = ByteUtil.hexString2Bytes(String.valueOf(ByteUtil.bytes2HexString(data)) + code);
            return DESUtil.decrypt(datas, keys);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] encrypt(byte[] data, String key) {
        try {
            byte[] keys = ByteUtil.hexString2Bytes(key);
            if (data.length > 8) {
                byte[] data_jia = DESUtil.encrypt(Arrays.copyOfRange(data, 0, 8), keys);
                byte[] dest = new byte[data.length];
                System.arraycopy(data_jia, 0, dest, 0, 8);
                System.arraycopy(data, 8, dest, 8, data.length - 8);
                return dest;
            }
            byte[] data_jia = DESUtil.encrypt(data, keys);
            byte[] dest = Arrays.copyOfRange(data_jia, 0, 8);
            return dest;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static byte[] decrypt(byte[] data, byte[] key) throws Exception {
        SecureRandom sr = new SecureRandom();
        byte[] b = null;
        DESKeySpec dks = new DESKeySpec(key);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DES);
        SecretKey securekey = keyFactory.generateSecret(dks);
        Cipher cipher = Cipher.getInstance(DES);
        cipher.init(2, (Key)securekey, sr);
        b = cipher.doFinal(data);
        return b;
    }

    private static byte[] encrypt(byte[] data, byte[] key) throws Exception {
        SecureRandom sr = new SecureRandom();
        byte[] b = null;
        DESKeySpec dks = new DESKeySpec(key);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DES);
        SecretKey securekey = keyFactory.generateSecret(dks);
        Cipher cipher = Cipher.getInstance(DES);
        cipher.init(1, (Key)securekey, sr);
        b = cipher.doFinal(data);
        return b;
    }

    public static byte[] encode3DES(byte[] data, byte[] key, boolean isencrypt) {
        try {
            DESedeKeySpec spec = new DESedeKeySpec(key);
            SecretKeyFactory keyfactory = SecretKeyFactory.getInstance("desede");
            SecretKey deskey = keyfactory.generateSecret(spec);
            Cipher cipher = isencrypt ? Cipher.getInstance("DESede/ECB/PKCS5Padding") : Cipher.getInstance("DESede/ECB/NoPadding");
            cipher.init(1, deskey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public static byte[] decode3DES(byte[] data, byte[] key, boolean isencrypt) {
        try {
            DESedeKeySpec spec = new DESedeKeySpec(key);
            SecretKeyFactory keyfactory = SecretKeyFactory.getInstance("desede");
            SecretKey deskey = keyfactory.generateSecret(spec);
            Cipher cipher = isencrypt ? Cipher.getInstance("DESede/ECB/PKCS5Padding") : Cipher.getInstance("DESede/ECB/NoPadding");
            cipher.init(2, deskey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }
}

