/*
 * Decompiled with CFR 0.152.
 */
package com.goldcard.resolve.util;

import java.io.File;
import java.io.FileFilter;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassUtil {
    public static <T> List<Class<T>> getAllClassByInaterface(Class<T> clazz) {
        ArrayList<Class<T>> returnClassList = new ArrayList<Class<T>>();
        if (clazz.isInterface()) {
            String packageName = clazz.getPackage().getName();
            List<Class<?>> allClass = null;
            try {
                allClass = ClassUtil.getClasses(packageName);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            if (allClass != null) {
                for (Class<?> c : allClass) {
                    if (!clazz.isAssignableFrom(c) || c.isInterface()) continue;
                    returnClassList.add(c);
                }
            }
        }
        return returnClassList;
    }

    public static List<Class<?>> getClasses(String packageName) throws Exception {
        ArrayList allClass = new ArrayList();
        String packageDirName = packageName.replace(".", "/");
        Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
        while (dirs.hasMoreElements()) {
            URL url = dirs.nextElement();
            String protocol = url.getProtocol();
            if ("file".equals(protocol)) {
                String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                ClassUtil.findAndAddClassesInPackageByFile(packageName, filePath, allClass);
                continue;
            }
            if (!"jar".equals(protocol)) continue;
            JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                int idx;
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (name.charAt(0) == '/') {
                    name = name.substring(1);
                }
                if (!name.startsWith(packageDirName) || (idx = name.lastIndexOf(47)) == -1 || !name.endsWith(".class") || entry.isDirectory()) continue;
                String className = name.replace("/", ".").substring(0, name.length() - 6);
                allClass.add(Class.forName(className));
            }
        }
        return allClass;
    }

    private static void findAndAddClassesInPackageByFile(String packageName, String filePath, List<Class<?>> allClass) throws ClassNotFoundException {
        File[] dirfiles;
        File dir = new File(filePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] fileArray = dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file1) {
                return file1.isDirectory() || file1.getName().endsWith(".class");
            }
        });
        int n = dirfiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                ClassUtil.findAndAddClassesInPackageByFile(String.valueOf(packageName) + "." + file.getName(), file.getAbsolutePath(), allClass);
            } else {
                String className = file.getName().substring(0, file.getName().length() - 6);
                allClass.add(Class.forName(String.valueOf(packageName) + "." + className));
            }
            ++n2;
        }
    }
}

