/*
 * Decompiled with CFR 0.152.
 */
package com.goldcard.resolve.util;

import com.goldcard.resolve.util.ByteUtil;

public class CRCUtil {
    public static byte[] getCRC(byte[] data) {
        String HI;
        int crc = 0;
        int i = 0;
        while (i < data.length) {
            crc = data[i] << 8 ^ crc;
            int j = 0;
            while (j < 8) {
                if ((crc & 0x8000) != 0) {
                    crc -= 32768;
                    crc = crc << 1 ^ 0x1021;
                } else {
                    crc <<= 1;
                }
                ++j;
            }
            ++i;
        }
        String LO = Integer.toHexString(crc & 0xFF);
        if (LO.length() == 1) {
            LO = "0" + LO;
        }
        if ((HI = Integer.toHexString(crc >> 8 & 0xFF)).length() == 1) {
            HI = "0" + HI;
        }
        return ByteUtil.hexString2Bytes((String.valueOf(HI) + LO).toUpperCase());
    }

    public static byte[] calcCRCCCIT(byte[] data) {
        short s = (short)CRCUtil.calcCRC16(data);
        byte[] bb = new byte[]{(byte)(s >> 8), (byte)(s >> 0)};
        return bb;
    }

    private static int calcCRC16(byte[] data) {
        int wCRC = 65535;
        int k = 0;
        while (k < data.length) {
            wCRC ^= 0xFF & data[k];
            int i = 0;
            while (i < 8) {
                wCRC = (wCRC & 1) > 0 ? wCRC >> 1 ^ 0xA001 : (wCRC >>= 1);
                ++i;
            }
            ++k;
        }
        wCRC = wCRC << 8 | wCRC >> 8 & 0xFF;
        return wCRC;
    }
}

