/*
 * Decompiled with CFR 0.152.
 */
package com.goldcard.resolve.util;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public class ByteUtil {
    public static final String bytes2HexString(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        int i = 0;
        while (i < bytes.length) {
            int v = bytes[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                sb.append("0");
            }
            sb.append(hv);
            ++i;
        }
        return sb.toString().toUpperCase();
    }

    public static final String byte2HexString(byte b) {
        String hex = Integer.toHexString(b & 0xFF);
        if (hex.length() == 1) {
            hex = String.valueOf('0') + hex;
        }
        return hex.toUpperCase();
    }

    public static final byte[] hexString2Bytes(String hexString) {
        if (hexString == null || "".equals(hexString)) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        byte[] d = new byte[length];
        char[] hexChars = hexString.toCharArray();
        int i = 0;
        while (i < length) {
            int pos = i * 2;
            d[i] = (byte)(ByteUtil.char2Byte(hexChars[pos]) << 4 | ByteUtil.char2Byte(hexChars[pos + 1]));
            ++i;
        }
        return d;
    }

    public static final byte hexString2Byte(String hexString) {
        if (hexString.length() != 2) {
            throw new RuntimeException("hexString\u957f\u5ea6\u4e3a2");
        }
        byte[] bytes = ByteUtil.hexString2Bytes(hexString);
        if (bytes.length != 1) {
            throw new RuntimeException("hexString\u8f6cbyte\u89e3\u6790\u5931\u8d25");
        }
        return bytes[0];
    }

    private static final byte char2Byte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static String byte2BinaryString(byte b) {
        String str = Integer.toBinaryString(b & 0xFF);
        return StringUtils.leftPad(str, 8, "0");
    }

    public static String bytes2BinaryString(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            sb.append(ByteUtil.byte2BinaryString(bytes[i]));
            ++i;
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        String str = ByteUtil.bytes2AsciiString(ByteUtil.hexString2Bytes("3839383630374232313131373330323039353634"));
        System.out.println(String.valueOf(str) + ":");
    }

    public static String bytes2AsciiString(byte[] bytes) {
        char[] cs = new char[bytes.length];
        int i = 0;
        while (i < bytes.length) {
            cs[i] = (char)(bytes[i] & 0xFF);
            ++i;
        }
        return new String(cs);
    }

    public static byte[] AsciiString2bytes(String asciiString) {
        char[] cs = asciiString.toCharArray();
        byte[] bytes = new byte[cs.length];
        int i = 0;
        while (i < cs.length) {
            bytes[i] = (byte)(cs[i] & 0xFF);
            ++i;
        }
        return bytes;
    }

    public static byte[] oppositebytes(byte[] bytes) {
        byte[] result = new byte[bytes.length];
        int i = 0;
        while (i < bytes.length) {
            result[i] = bytes[bytes.length - 1 - i];
            ++i;
        }
        return result;
    }

    public static final byte[] copyOfRange(byte[] bytes, int start, int end) {
        if (start < 0) {
            start += bytes.length;
        }
        if (end <= 0) {
            end += bytes.length;
        }
        return Arrays.copyOfRange(bytes, start, end);
    }

    public static final byte[] copyOfRangeOpposite(byte[] bytes, int start, int end) {
        if (start < 0) {
            start += bytes.length;
        }
        if (end <= 0) {
            end += bytes.length;
        }
        byte[] tmp = Arrays.copyOfRange(bytes, start, end);
        byte[] actual = new byte[tmp.length];
        int i = 0;
        while (i < actual.length) {
            actual[i] = tmp[actual.length - 1 - i];
            ++i;
        }
        return actual;
    }

    public static void replaceBytes(byte[] orginalbytes, int start, int end, byte[] replacebytes) {
        if (start < 0) {
            start += orginalbytes.length;
        }
        if (end <= 0) {
            end += orginalbytes.length;
        }
        if (end - start != replacebytes.length) {
            throw new RuntimeException("\u957f\u5ea6\u4e0d\u5408\u6cd5\u5f02\u5e38");
        }
        if (replacebytes.length + start - orginalbytes.length > 0) {
            throw new RuntimeException("\u957f\u5ea6\u4e0d\u5408\u6cd5\u5f02\u5e38");
        }
        int i = 0;
        while (i < replacebytes.length) {
            orginalbytes[i + start] = replacebytes[i];
            ++i;
        }
    }

    public static void replaceBytesOppostie(byte[] orginalbytes, int start, int end, byte[] replacebytes) {
        if (start < 0) {
            start += orginalbytes.length;
        }
        if (end <= 0) {
            end += orginalbytes.length;
        }
        if (end - start != replacebytes.length) {
            throw new RuntimeException("\u957f\u5ea6\u4e0d\u5408\u6cd5\u5f02\u5e38");
        }
        if (replacebytes.length + start - orginalbytes.length > 0) {
            throw new RuntimeException("\u957f\u5ea6\u4e0d\u5408\u6cd5\u5f02\u5e38");
        }
        int i = 0;
        while (i < replacebytes.length) {
            orginalbytes[end - 1 - i] = replacebytes[i];
            ++i;
        }
    }

    public static int bytes2Int(byte[] bytes) {
        int init = 0;
        int i = 0;
        while (i < bytes.length) {
            init |= (bytes[i] & 0xFF) << 8 * i;
            ++i;
        }
        return init;
    }

    public static byte[] connectBytes(byte[] ... bytes) {
        int totalLength = 0;
        byte[][] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] tmp = byArray[n2];
            totalLength = tmp.length + totalLength;
            ++n2;
        }
        byte[] tmpBytes = new byte[totalLength];
        int i = 0;
        byte[][] byArray2 = bytes;
        int n3 = bytes.length;
        int n4 = 0;
        while (n4 < n3) {
            byte[] tmp;
            byte[] byArray3 = tmp = byArray2[n4];
            int n5 = tmp.length;
            int n6 = 0;
            while (n6 < n5) {
                byte tmp_1;
                tmpBytes[i] = tmp_1 = byArray3[n6];
                ++i;
                ++n6;
            }
            ++n4;
        }
        return tmpBytes;
    }
}

