/*
 * Decompiled with CFR 0.152.
 */
package com.goldcard.resolve.util;

import com.goldcard.protocol.Command;
import com.goldcard.resolve.annotation.Identity;
import com.goldcard.resolve.model.ClazzInfo;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalysisUtil {
    public static final ConcurrentMap<Class<?>, ClazzInfo> classInfoMaps = new ConcurrentHashMap();
    public static final ConcurrentMap<String, Class<? extends Command>> classMap = new ConcurrentHashMap<String, Class<? extends Command>>();
    private static Logger logger = LoggerFactory.getLogger(AnalysisUtil.class);

    public static synchronized void initClassInfo() {
        classMap.clear();
        classInfoMaps.clear();
        Reflections reflections = new Reflections("com.goldcard.protocol", new Scanner[0]);
        Set<Class<Command>> classes = reflections.getSubTypesOf(Command.class);
        for (Class<Command> clazz : classes) {
            if (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers()) || !clazz.isAnnotationPresent(Identity.class)) continue;
            try {
                ClazzInfo info = new ClazzInfo(clazz);
                classInfoMaps.put(clazz, info);
                String key = String.valueOf(info.getProtocol().getProtocolName()) + info.getIdentity().value();
                if (!classMap.containsKey(key)) {
                    classMap.put(key, clazz);
                    logger.info(String.format("InwardCommand:%s\u88c5\u8f7d\u6210\u529f,key:%s", clazz.getName(), key));
                } else {
                    logger.error(String.format("\u5b58\u5728\u540c\u540dkey,key\u503c:%s,\u7a0b\u5e8f\u5f3a\u5236\u9000\u51fa", key));
                    System.exit(0);
                }
                logger.info(String.format("\u7c7b:%s\u89e3\u6790\u5b8c\u6210", clazz.getName()));
            }
            catch (Exception e) {
                logger.error(String.format("\u89e3\u6790\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38:%s,\u7a0b\u5e8f\u5f3a\u5236\u9000\u51fa", e.getCause() + e.getMessage()));
                System.exit(0);
            }
        }
    }
}

