/*
 * Decompiled with CFR 0.152.
 */
package com.goldcard.resolve.operation.method.validation;

import com.goldcard.protocol.jk.jrhr.model.Keys;
import com.goldcard.protocol.jk.jrhr.service.JrhrStrategy;
import com.goldcard.resolve.operation.method.ValidationMethod;
import com.goldcard.resolve.util.ByteUtil;
import com.goldcard.resolve.util.ShaUtil;

public class JrhrMacValidationMethod
implements ValidationMethod {
    @Override
    public void inward(byte[] bytes, int start, int end, String[] parameters) {
        Keys keys = JrhrStrategy.getKesyInfo();
        String mac = ByteUtil.bytes2HexString(ByteUtil.copyOfRange(bytes, Integer.valueOf(parameters[0]), Integer.valueOf(parameters[1])));
        byte[] tmp = ByteUtil.connectBytes(keys.getRandomKey(), ByteUtil.copyOfRange(bytes, start, end));
        String calMac = ByteUtil.bytes2HexString(ShaUtil.sha256_Hmac(tmp, keys.getHmacKey()));
        if (!mac.equalsIgnoreCase(calMac)) {
            throw new RuntimeException("mac\u6821\u9a8c\u5931\u8d25");
        }
    }

    @Override
    public void outward(byte[] bytes, int start, int end, String[] parameters) {
        Keys keys = JrhrStrategy.getKesyInfo();
        byte[] calBytes = ByteUtil.connectBytes(keys.getRandomKey(), ByteUtil.copyOfRange(bytes, start, end));
        byte[] tmp = ShaUtil.sha256_Hmac(calBytes, keys.getHmacKey());
        ByteUtil.replaceBytes(bytes, Integer.valueOf(parameters[0]), Integer.valueOf(parameters[1]), tmp);
    }
}

