/*
 * Decompiled with CFR 0.152.
 */
package com.goldcard.resolve.operation.method.validation;

import com.goldcard.resolve.operation.method.ValidationMethod;
import com.goldcard.resolve.util.ByteUtil;
import org.apache.commons.lang3.StringUtils;

public class HexLengthValidationMethod
implements ValidationMethod {
    @Override
    public void inward(byte[] bytes, int start, int end, String[] parameters) {
        byte[] temp_bytes = ByteUtil.copyOfRange(bytes, start, end);
        String hexString = ByteUtil.bytes2HexString(temp_bytes);
        int hex = Integer.parseInt(hexString, 16);
        int addition = 0;
        if (parameters.length == 1) {
            addition = Integer.valueOf(parameters[0]);
        }
        if (bytes.length != hex + addition) {
            throw new RuntimeException("hexLength\u6821\u9a8c\u5931\u8d25");
        }
    }

    @Override
    public void outward(byte[] bytes, int start, int end, String[] parameters) {
        int length = bytes.length;
        int addition = 0;
        if (parameters.length == 1) {
            addition = Integer.valueOf(parameters[0]);
        }
        int num = length - addition;
        byte[] tmp = ByteUtil.hexString2Bytes(StringUtils.leftPad(Integer.toHexString(num), (end - start) * 2, "0"));
        ByteUtil.replaceBytes(bytes, start, end, tmp);
    }
}

