/*
 * Decompiled with CFR 0.152.
 */
package com.goldcard.resolve.operation.method.convert;

import com.goldcard.resolve.operation.method.ConvertMethod;
import com.goldcard.resolve.util.ByteUtil;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;

public class Jk30ToDecimalConvertMethod
implements ConvertMethod<BigDecimal> {
    @Override
    public BigDecimal inward(byte[] bytes, int start, int end, String[] parameters) {
        if ((end - start) % 2 != 0) {
            throw new RuntimeException(String.format("%s\u548c%s\u7684\u5dee\u503c\u5fc5\u987b\u662f\u5076\u6570", start, end));
        }
        int middle = (end + start) / 2;
        int i = ByteUtil.bytes2Int(ByteUtil.copyOfRange(bytes, start, middle));
        int j = ByteUtil.bytes2Int(ByteUtil.copyOfRange(bytes, middle, end));
        int size = end - start;
        return new BigDecimal(String.valueOf(i)).add(new BigDecimal(String.valueOf(j)).divide(new BigDecimal(StringUtils.rightPad("1", size + 1, "0"))));
    }

    @Override
    public void outward(byte[] bytes, int start, int end, String[] parameters, BigDecimal value) {
        if (value == null) {
            return;
        }
        int part1 = value.intValue();
        int part2 = value.subtract(new BigDecimal(String.valueOf(part1))).multiply(new BigDecimal(StringUtils.rightPad("1", end - start + 1, "0"))).intValue();
        byte[] front = ByteUtil.hexString2Bytes(StringUtils.leftPad(Integer.toHexString(part1), end - start, "0"));
        byte[] back = ByteUtil.hexString2Bytes(StringUtils.leftPad(Integer.toHexString(part2), end - start, "0"));
        ByteUtil.replaceBytesOppostie(bytes, start, (end + start) / 2, front);
        ByteUtil.replaceBytesOppostie(bytes, (end + start) / 2, end, back);
    }
}

