/*
 * Decompiled with CFR 0.152.
 */
package com.goldcard.resolve.operation.method.convert;

import com.goldcard.protocol.jk.jk30.model.CloseRecord;
import com.goldcard.resolve.operation.method.ConvertMethod;
import com.goldcard.resolve.util.ByteUtil;
import com.goldcard.resolve.util.DateUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jk30CloseRecordsConvertMethod
implements ConvertMethod<List<CloseRecord>> {
    private static Logger logger = LoggerFactory.getLogger(Jk30CloseRecordsConvertMethod.class);

    @Override
    public List<CloseRecord> inward(byte[] bytes, int start, int end, String[] parameters) {
        if (start < 0) {
            start += bytes.length;
        }
        if (end <= 0) {
            end += bytes.length;
        }
        int size = (end - start) / 7;
        ArrayList<CloseRecord> lists = new ArrayList<CloseRecord>();
        int i = 0;
        while (i < size) {
            try {
                CloseRecord cr = new CloseRecord();
                cr.setCloseType(bytes[7 * i + start] & 0xFF);
                if (cr.getCloseType() != 0) {
                    cr.setCloseTime(DateUtil.getSimpleDateFormat("yyMMddHHmmss").parse(ByteUtil.bytes2HexString(ByteUtil.copyOfRange(bytes, 7 * i + 1 + start, 7 * i + 7 + start))));
                    lists.add(cr);
                }
            }
            catch (Exception e) {
                logger.info("\u89e3\u6790\u8fc7\u7a0b\u51fa\u73b0\u975e\u81f4\u547d\u5f02\u5e38,\u7ee7\u7eed\u89e3\u6790,\u629b\u51fa\u5f02\u5e38:" + e.getMessage() + e.getCause());
            }
            ++i;
        }
        return lists;
    }

    @Override
    public void outward(byte[] bytes, int start, int end, String[] parameters, List<CloseRecord> value) {
    }
}

