/*
 * Decompiled with CFR 0.152.
 */
package com.goldcard.resolve.operation.method.convert;

import com.goldcard.protocol.jk.jk16.model.Info;
import com.goldcard.resolve.operation.method.ConvertMethod;
import com.goldcard.resolve.util.ByteUtil;
import com.goldcard.resolve.util.DateUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jk10InfosConvertMethod
implements ConvertMethod<List<Info>> {
    private static final Logger log = LoggerFactory.getLogger(Jk10InfosConvertMethod.class);

    @Override
    public List<Info> inward(byte[] bytes, int start, int end, String[] parameters) {
        ArrayList<Info> list = new ArrayList<Info>();
        int i = 0;
        while (i < 2) {
            try {
                String str = ByteUtil.bytes2HexString(ByteUtil.copyOfRange(bytes, start + i * 18, start + 18 + i * 18));
                Info info = new Info();
                info.setWorkCondition(new BigDecimal(new StringBuilder(str.substring(0, 10)).insert(8, ".").toString()));
                info.setStandardCondition(new BigDecimal(new StringBuilder(str.substring(10, 20)).insert(8, ".").toString()));
                info.setEventType(Integer.valueOf(str.substring(20, 24), 16));
                info.setEventTime(DateUtil.string2Date(str.substring(24, 36), "yyMMddHHmmss"));
                list.add(info);
            }
            catch (Exception e) {
                log.info("\u7a0b\u5e8f\u53d1\u751f\u975e\u81f4\u547d\u5f02\u5e38,\u7ee7\u7eed\u6267\u884c" + e.getMessage() + e.getCause());
            }
            ++i;
        }
        return list;
    }

    @Override
    public void outward(byte[] bytes, int start, int end, String[] parameters, List<Info> value) {
    }
}

