/*
 * Decompiled with CFR 0.152.
 */
package com.goldcard.resolve.operation.method.convert;

import com.goldcard.protocol.jk.jkcollector.model.GasInfo;
import com.goldcard.resolve.operation.method.ConvertMethod;
import com.goldcard.resolve.operation.method.convert.HexLongDecimalConvertMethod;
import com.goldcard.resolve.util.ByteUtil;
import java.math.BigDecimal;

public class JKCollectorGasInfoConvertMethod
implements ConvertMethod<GasInfo> {
    private static HexLongDecimalConvertMethod hexLong = new HexLongDecimalConvertMethod();

    @Override
    public GasInfo inward(byte[] bytes, int start, int end, String[] parameters) {
        GasInfo gasInfo = new GasInfo();
        gasInfo.setMomentWorkingGas(hexLong.inward(ByteUtil.copyOfRangeOpposite(bytes, start, start + 4), 0, 4, new String[]{"10000"}));
        gasInfo.setMomentStandardGas(hexLong.inward(ByteUtil.copyOfRangeOpposite(bytes, start + 4, start + 8), 0, 4, new String[]{"10000"}));
        gasInfo.setTemperature(BigDecimal.ZERO);
        gasInfo.setPressure(hexLong.inward(ByteUtil.copyOfRangeOpposite(bytes, start + 10, end + 14), 0, 4, new String[]{""}));
        gasInfo.setWorkingGas(this.getGas(ByteUtil.copyOfRange(bytes, start + 14, start + 20)));
        gasInfo.setStandardGas(this.getGas(ByteUtil.copyOfRange(bytes, start + 20, start + 26)));
        return gasInfo;
    }

    @Override
    public void outward(byte[] bytes, int start, int end, String[] parameters, GasInfo value) {
    }

    private BigDecimal getGas(byte[] bytes) {
        BigDecimal part1 = new BigDecimal(ByteUtil.bytes2HexString(ByteUtil.copyOfRangeOpposite(bytes, 0, 4)));
        BigDecimal part2 = hexLong.inward(ByteUtil.copyOfRangeOpposite(bytes, 4, 6), 0, 2, new String[]{"10000"});
        part2 = part2.subtract(new BigDecimal(String.valueOf(part2.intValue())));
        return part1.add(part2);
    }
}

