/*
 * Decompiled with CFR 0.152.
 */
package com.goldcard.resolve.operation.method.convert;

import com.goldcard.resolve.operation.method.ConvertMethod;
import com.goldcard.resolve.util.ByteUtil;
import org.apache.commons.lang3.StringUtils;

public class HexOppositeConvertMethod
implements ConvertMethod<Integer> {
    @Override
    public Integer inward(byte[] bytes, int start, int end, String[] parameters) {
        byte[] tmp_bytes = ByteUtil.copyOfRange(bytes, start, end);
        byte[] actual = new byte[tmp_bytes.length];
        int i = 0;
        while (i < actual.length) {
            actual[i] = tmp_bytes[actual.length - 1 - i];
            ++i;
        }
        return Integer.valueOf(ByteUtil.bytes2HexString(actual), 16);
    }

    @Override
    public void outward(byte[] bytes, int start, int end, String[] parameters, Integer value) {
        if (value == null) {
            value = 0;
        }
        String str = Integer.toHexString(value);
        int size = (end - start) * 2;
        str = str.length() > size ? str.substring(str.length() - size, str.length()) : StringUtils.leftPad(Integer.toHexString(value), (end - start) * 2, "0");
        byte[] orginal = ByteUtil.hexString2Bytes(str);
        byte[] actual = new byte[orginal.length];
        int i = 0;
        while (i < actual.length) {
            actual[i] = orginal[actual.length - 1 - i];
            ++i;
        }
        ByteUtil.replaceBytes(bytes, start, end, actual);
    }
}

