/*
 * Decompiled with CFR 0.152.
 */
package com.goldcard.resolve.operation.method.convert;

import com.goldcard.resolve.operation.method.ConvertMethod;
import com.goldcard.resolve.util.ByteUtil;
import org.apache.commons.lang3.StringUtils;

public class HexConvertMethod
implements ConvertMethod<Integer> {
    @Override
    public Integer inward(byte[] bytes, int start, int end, String[] parameters) {
        String value = ByteUtil.bytes2HexString(ByteUtil.copyOfRange(bytes, start, end));
        return Integer.valueOf(value, 16);
    }

    @Override
    public void outward(byte[] bytes, int start, int end, String[] parameters, Integer value) {
        if (value == null) {
            return;
        }
        String str = StringUtils.leftPad(Integer.toHexString(value), (end - start) * 2, "0");
        ByteUtil.replaceBytes(bytes, start, end, ByteUtil.hexString2Bytes(str));
    }
}

