/*
 * Decompiled with CFR 0.152.
 */
package com.goldcard.resolve.operation.method.convert;

import com.goldcard.resolve.operation.method.ConvertMethod;
import com.goldcard.resolve.util.ByteUtil;

public class BinaryStringConvertMethod
implements ConvertMethod<String> {
    @Override
    public String inward(byte[] bytes, int start, int end, String[] parameters) {
        return ByteUtil.bytes2BinaryString(ByteUtil.copyOfRange(bytes, start, end));
    }

    @Override
    public void outward(byte[] bytes, int start, int end, String[] parameters, String value) {
        if (value == null) {
            return;
        }
        if (value.length() != (end - start) * 8) {
            throw new RuntimeException("\u53c2\u6570\u957f\u5ea6\u4e0d\u5408\u6cd5");
        }
        byte[] replaceBytes = new byte[end - start];
        int i = 0;
        while (i < end - start) {
            String str = value.substring(8 * i, 8 * i + 8);
            replaceBytes[i] = (byte)(Integer.valueOf(str, 2) & 0xFF);
            ++i;
        }
        ByteUtil.replaceBytes(bytes, start, end, replaceBytes);
    }
}

