/*
 * Decompiled with CFR 0.152.
 */
package com.goldcard.resolve.operation.method.convert;

import com.goldcard.resolve.operation.method.ConvertMethod;
import com.goldcard.resolve.util.ByteUtil;
import com.goldcard.resolve.util.DateUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class BcdDateConvertMethod
implements ConvertMethod<Date> {
    @Override
    public Date inward(byte[] bytes, int start, int end, String[] parameters) {
        SimpleDateFormat sf = DateUtil.getSimpleDateFormat(parameters[0]);
        String time = ByteUtil.bytes2HexString(ByteUtil.copyOfRange(bytes, start, end));
        try {
            return sf.parse(time);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.valueOf(time) + " " + parameters[0] + " \u89e3\u6790\u5931\u8d25");
        }
    }

    @Override
    public void outward(byte[] bytes, int start, int end, String[] parameters, Date value) {
        if (value == null) {
            value = new Date();
        }
        SimpleDateFormat sf = DateUtil.getSimpleDateFormat(parameters[0]);
        byte[] tmp = ByteUtil.hexString2Bytes(sf.format(value));
        ByteUtil.replaceBytes(bytes, start, end, tmp);
    }

    public static void main(String[] args) throws Exception {
        String str = "00000000";
        Date date = DateUtil.getSimpleDateFormat("yyMMddHH").parse(str);
        System.out.println(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date));
    }
}

