/*
 * Decompiled with CFR 0.152.
 */
package com.goldcard.resolve.operation.method.convert;

import com.goldcard.resolve.operation.method.ConvertMethod;
import com.goldcard.resolve.util.ByteUtil;
import org.apache.commons.lang3.StringUtils;

public class AsciiStringConvertMethod
implements ConvertMethod<String> {
    @Override
    public String inward(byte[] bytes, int start, int end, String[] parameters) {
        return ByteUtil.bytes2AsciiString(ByteUtil.copyOfRange(bytes, start, end));
    }

    @Override
    public void outward(byte[] bytes, int start, int end, String[] parameters, String value) {
        if (value == null) {
            return;
        }
        if ((value = StringUtils.rightPad(value, end - start, "\u0000")).length() != end - start) {
            throw new RuntimeException("Ascii\u89e3\u6790\u5931\u8d25,String\u4e32\u7684\u957f\u5ea6\u548c\u8981\u586b\u5145\u7684\u6ce8\u89e3\u957f\u5ea6\u4e0d\u4e00\u81f4");
        }
        ByteUtil.replaceBytes(bytes, start, end, ByteUtil.AsciiString2bytes(value));
    }
}

