/*
 * Decompiled with CFR 0.152.
 */
package com.goldcard.resolve.operation;

import com.goldcard.resolve.operation.Operation;
import com.goldcard.resolve.operation.method.ValidationMethod;
import com.goldcard.resolve.util.ThreadContextUtil;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public class ValidationOperation
implements Operation {
    private ValidationMethod validationMethod;
    private String start;
    private String end;
    private String[] parameters;
    private String condition;
    private boolean canDelay;

    public ValidationOperation(ValidationMethod validationMethod, String start, String end, String[] parameters, String condition, boolean canDelay) {
        this.validationMethod = validationMethod;
        this.start = start;
        this.end = end;
        this.parameters = parameters;
        this.condition = condition;
        this.canDelay = canDelay;
    }

    @Override
    public <T> byte[] handle(byte[] bytes, T t, Operation.Direction direction) {
        boolean isContinue;
        if (StringUtils.isNotBlank(this.condition) && !(isContinue = ((Boolean)ThreadContextUtil.getContextValue(this.condition)).booleanValue())) {
            return bytes;
        }
        int realStart = Integer.valueOf(ThreadContextUtil.getContextValue(this.start).toString());
        int realEnd = Integer.valueOf(ThreadContextUtil.getContextValue(this.end).toString());
        if (Operation.Direction.INWARD.equals((Object)direction)) {
            this.validationMethod.inward(bytes, realStart, realEnd, this.parameters);
        } else if (Operation.Direction.OUTWARD.equals((Object)direction)) {
            this.validationMethod.outward(bytes, realStart, realEnd, this.parameters);
        }
        return bytes;
    }

    public boolean isCanDelay() {
        return this.canDelay;
    }

    public String toString() {
        return "ValidationOperation [validationMethod=" + this.validationMethod + ", start=" + this.start + ", end=" + this.end + ", parameters=" + Arrays.toString(this.parameters) + ", condition=" + this.condition + "]";
    }
}

