/*
 * Decompiled with CFR 0.152.
 */
package com.goldcard.resolve.operation;

import com.goldcard.resolve.operation.Operation;
import com.goldcard.resolve.operation.method.ReplaceMethod;
import com.goldcard.resolve.util.ThreadContextUtil;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public class ReplaceOperation
implements Operation {
    private ReplaceMethod replaceMethod;
    private String start;
    private String end;
    private String[] parameters;
    private String condition;

    public ReplaceOperation(ReplaceMethod replaceMethod, String start, String end, String[] parameters, String condition) {
        this.replaceMethod = replaceMethod;
        this.start = start;
        this.end = end;
        this.parameters = parameters;
        this.condition = condition;
    }

    @Override
    public <T> byte[] handle(byte[] bytes, T t, Operation.Direction direction) {
        boolean isContinue;
        if (StringUtils.isNotBlank(this.condition) && !(isContinue = ((Boolean)ThreadContextUtil.getContextValue(this.condition)).booleanValue())) {
            return bytes;
        }
        int realStart = Integer.valueOf(ThreadContextUtil.getContextValue(this.start).toString());
        int realEnd = Integer.valueOf(ThreadContextUtil.getContextValue(this.end).toString());
        if (Operation.Direction.INWARD.equals((Object)direction)) {
            return this.replaceMethod.inward(bytes, realStart, realEnd, this.parameters);
        }
        if (Operation.Direction.OUTWARD.equals((Object)direction)) {
            return this.replaceMethod.outward(bytes, realStart, realEnd, this.parameters);
        }
        return bytes;
    }

    public String toString() {
        return "ReplaceOperation [replaceMethod=" + this.replaceMethod + ", start=" + this.start + ", end=" + this.end + ", parameters=" + Arrays.toString(this.parameters) + ", condition=" + this.condition + "]";
    }
}

