/*
 * Decompiled with CFR 0.152.
 */
package com.goldcard.resolve.operation;

import com.goldcard.resolve.operation.Operation;
import com.goldcard.resolve.operation.method.ConvertMethod;
import com.goldcard.resolve.util.ThreadContextUtil;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class ConvertOperation<E>
implements Operation {
    private ConvertMethod<E> convertMethod;
    private Method inwardMethod2;
    private Method outwardMethod2;
    private String start;
    private String end;
    private String[] parameters;
    private String condition;

    public ConvertOperation(ConvertMethod<E> convertMethod, Method inwardMethod2, Method outwardMethod2, String start, String end, String[] parameters, String condition) {
        this.convertMethod = convertMethod;
        this.inwardMethod2 = inwardMethod2;
        this.outwardMethod2 = outwardMethod2;
        this.start = start;
        this.end = end;
        this.parameters = parameters;
        this.condition = condition;
    }

    @Override
    public <T> byte[] handle(byte[] bytes, T t, Operation.Direction direction) {
        boolean isContinue;
        if (StringUtils.isNotBlank(this.condition) && !(isContinue = ((Boolean)ThreadContextUtil.getContextValue(this.condition)).booleanValue())) {
            return bytes;
        }
        int realStart = Integer.valueOf(ThreadContextUtil.getContextValue(this.start).toString());
        int realEnd = Integer.valueOf(ThreadContextUtil.getContextValue(this.end).toString());
        try {
            try {
                if (Operation.Direction.INWARD.equals((Object)direction)) {
                    E object = this.convertMethod.inward(bytes, realStart, realEnd, this.parameters);
                    this.inwardMethod2.invoke(t, object);
                } else if (Operation.Direction.OUTWARD.equals((Object)direction)) {
                    Object object = this.outwardMethod2.invoke(t, new Object[0]);
                    this.convertMethod.outward(bytes, realStart, realEnd, this.parameters, object);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e.getCause() + this.toString());
            }
        }
        finally {
            StandardEvaluationContext context = ThreadContextUtil.currentInstance.get();
            context.setVariable("lastStart", realStart);
            context.setVariable("lastEnd", realEnd);
        }
        return bytes;
    }

    public String toString() {
        return "ConvertOperation [convertMethod=" + this.convertMethod + ", inwardMethod2=" + this.inwardMethod2 + ", outwardMethod2=" + this.outwardMethod2 + ", start=" + this.start + ", end=" + this.end + ", parameters=" + Arrays.toString(this.parameters) + "]";
    }
}

