/*
 * Decompiled with CFR 0.152.
 */
package com.goldcard.resolve.model;

import com.goldcard.protocol.AbstractProtocol;
import com.goldcard.protocol.Command;
import com.goldcard.resolve.annotation.BasicTemplate;
import com.goldcard.resolve.annotation.Convert;
import com.goldcard.resolve.annotation.Identity;
import com.goldcard.resolve.annotation.Protocol;
import com.goldcard.resolve.annotation.Replace;
import com.goldcard.resolve.annotation.Validation;
import com.goldcard.resolve.annotation.inner.ReplaceContainer;
import com.goldcard.resolve.annotation.inner.ValidationContainer;
import com.goldcard.resolve.operation.ConvertOperation;
import com.goldcard.resolve.operation.Operation;
import com.goldcard.resolve.operation.ReplaceOperation;
import com.goldcard.resolve.operation.ValidationOperation;
import com.goldcard.resolve.operation.method.ConvertMethod;
import com.goldcard.resolve.operation.method.ReplaceMethod;
import com.goldcard.resolve.operation.method.ValidationMethod;
import com.goldcard.resolve.util.ProtocolUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;

public class ClazzInfo {
    private TreeMap<Integer, List<Operation>> operations = new TreeMap();
    private Identity identity;
    private Method deviceNoMethod;
    private AbstractProtocol protocol;
    private BasicTemplate basicTemplate;

    public ClazzInfo(Class<?> clazz) {
        try {
            this.analysisTemplate(clazz);
            this.analysisOperations(clazz);
            this.analysisIdentity(clazz);
            this.analysisProtocol(clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(String.valueOf(clazz.getSimpleName()) + "\u89e3\u6790\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38" + e.getMessage());
        }
    }

    private void analysisProtocol(Class<?> clazz) throws ReflectiveOperationException {
        if (Command.class.isAssignableFrom(clazz)) {
            if (!clazz.isAnnotationPresent(Protocol.class)) {
                throw new RuntimeException(String.valueOf(clazz.getName()) + "\u9700\u8981\u63d0\u4f9b@Protocol\u6ce8\u89e3,\u5426\u5219\u65e0\u6cd5\u6b63\u5e38\u89e3\u6790");
            }
            this.protocol = ProtocolUtil.getAbstractProtocol(clazz.getAnnotation(Protocol.class).value());
        }
    }

    private void analysisTemplate(Class<?> clazz) {
        if (Command.class.isAssignableFrom(clazz)) {
            this.basicTemplate = clazz.isAnnotationPresent(BasicTemplate.class) ? clazz.getAnnotation(BasicTemplate.class) : null;
        }
    }

    private void analysisOperations(Class<?> clazz) throws Exception {
        Operation oper;
        List<Field> fields = this.findAllField(clazz);
        List<Validation> validationsList = this.findAllValidation(clazz);
        List<Replace> replaceList = this.findAllReplace(clazz);
        for (Validation validation : validationsList) {
            ValidationMethod validationMethod = validation.operation().newInstance();
            oper = new ValidationOperation(validationMethod, validation.start(), validation.end(), validation.parameters(), validation.condition(), validation.canDelay());
            this.putIntoMapOperationList(validation.order(), oper);
        }
        for (Replace replace : replaceList) {
            ReplaceMethod replaceMethod = replace.operation().newInstance();
            oper = new ReplaceOperation(replaceMethod, replace.start(), replace.end(), replace.parameters(), replace.condition());
            this.putIntoMapOperationList(replace.order(), oper);
        }
        for (Field field : fields) {
            if (field.isAnnotationPresent(Convert.class)) {
                Convert convert = field.getAnnotation(Convert.class);
                ConvertMethod<?> convertMethod = convert.operation().newInstance();
                Method inwardMethod2 = ClazzInfo.findMethod("set" + field.getName(), clazz);
                Method outwardMethod2 = ClazzInfo.findMethod("get" + field.getName(), clazz);
                ConvertOperation oper2 = new ConvertOperation(convertMethod, inwardMethod2, outwardMethod2, convert.start(), convert.end(), convert.parameters(), convert.condition());
                this.putIntoMapOperationList(convert.order(), oper2);
                continue;
            }
            throw new RuntimeException("\u7c7b\u540d:" + field.getClass().getName() + "\u5b57\u6bb5\u540d:" + field.getName() + "\u9700\u8981\u63d0\u4f9b\u6ce8\u89e3");
        }
    }

    private void analysisIdentity(Class<?> clazz) {
        if (Command.class.isAssignableFrom(clazz)) {
            if (!clazz.isAnnotationPresent(Identity.class)) {
                throw new RuntimeException(String.format("%s\u9700\u8981\u63d0\u4f9b@Identity\u6ce8\u89e3,\u5426\u5219\u65e0\u6cd5\u8fdb\u884c\u89e3\u6790", clazz.getName()));
            }
            this.identity = clazz.getAnnotation(Identity.class);
        }
    }

    private List<Field> findAllField(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        if (clazz == null) {
            return fields;
        }
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        fields.addAll(0, this.findAllField(clazz.getSuperclass()));
        return fields;
    }

    private List<Validation> findAllValidation(Class<?> clazz) {
        ArrayList<Validation> validationsList = new ArrayList<Validation>();
        if (clazz == null) {
            return validationsList;
        }
        if (clazz.isAnnotationPresent(ValidationContainer.class)) {
            Validation[] validations;
            Validation[] validationArray = validations = clazz.getAnnotation(ValidationContainer.class).value();
            int n = validations.length;
            int n2 = 0;
            while (n2 < n) {
                Validation validation = validationArray[n2];
                validationsList.add(validation);
                ++n2;
            }
        }
        if (clazz.isAnnotationPresent(Validation.class)) {
            validationsList.add(clazz.getAnnotation(Validation.class));
        }
        validationsList.addAll(0, this.findAllValidation(clazz.getSuperclass()));
        return validationsList;
    }

    private List<Replace> findAllReplace(Class<?> clazz) {
        ArrayList<Replace> replaceList = new ArrayList<Replace>();
        if (clazz == null) {
            return replaceList;
        }
        if (clazz.isAnnotationPresent(ReplaceContainer.class)) {
            Replace[] replaces;
            Replace[] replaceArray = replaces = clazz.getAnnotation(ReplaceContainer.class).value();
            int n = replaces.length;
            int n2 = 0;
            while (n2 < n) {
                Replace replace = replaceArray[n2];
                replaceList.add(replace);
                ++n2;
            }
        }
        if (clazz.isAnnotationPresent(Replace.class)) {
            replaceList.add(clazz.getAnnotation(Replace.class));
        }
        replaceList.addAll(0, this.findAllReplace(clazz.getSuperclass()));
        return replaceList;
    }

    private static Method findMethod(String methodName, Class<?> clazz) {
        Method[] methods;
        Method[] methodArray = methods = clazz.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equalsIgnoreCase(methodName)) {
                return method;
            }
            ++n2;
        }
        throw new RuntimeException(String.format("\u65e0\u6cd5\u5728\u6307\u5b9a\u7c7b\u4e2d%s\u627e\u5230\u6307\u5b9a\u65b9\u6cd5%s", clazz.getName(), methodName));
    }

    private void putIntoMapOperationList(Integer key, Operation operation) {
        List<Operation> list = this.operations.get(key);
        if (list == null) {
            list = new ArrayList<Operation>();
            this.operations.put(key, list);
        }
        list.add(operation);
    }

    public TreeMap<Integer, List<Operation>> getOperations() {
        return this.operations;
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public Method getDeviceNoMethod() {
        return this.deviceNoMethod;
    }

    public AbstractProtocol getProtocol() {
        return this.protocol;
    }

    public BasicTemplate getBasicTemplate() {
        return this.basicTemplate;
    }
}

