/*
 * Decompiled with CFR 0.152.
 */
package com.goldcard.protocol.ym.ym20;

import com.cqct.MeterMsgTranslate.Md5Helper;
import com.cqct.MeterMsgTranslate.MeterMsg;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.goldcard.protocol.AbstractProtocol;
import com.goldcard.protocol.Command;
import com.goldcard.protocol.ym.ym20.inward.Ym20_Result;
import com.goldcard.protocol.ym.ym20.inward.Ym20_SZ;
import com.goldcard.resolve.util.ByteUtil;
import com.goldcard.resolve.util.JsonUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ym20Protocol
extends AbstractProtocol {
    public static final String SER = "ser";
    public static final String METERNO = "meterEcuId";
    public static final String SIGN = "sign";
    public static final String COMMANDCODE = "commandCode";
    private static final Logger log = LoggerFactory.getLogger(Ym20Protocol.class);

    public static ObjectNode getNewObjectNode() {
        ObjectNode node = new ObjectNode(JsonNodeFactory.instance);
        node.put("factoryCode", "A22");
        node.put("partner", "TEST");
        node.put("companyCode", "FFFFFF");
        node.put("protocolCode", "CQCT2.0");
        node.put("signType", "MD5");
        node.put("version", "1.0.0");
        return node;
    }

    public static String getValue(ObjectNode objectNode) {
        String sign = Md5Helper.getSignValue(objectNode.toString(), "51StGDgAJPhgCrLXWCg4ZPR4V9OL0tBf");
        objectNode.put(SIGN, sign);
        log.debug("\u8f93\u5165\u7684\u89e3\u6790\u53c2\u6570:" + objectNode.toString());
        JsonNode result = JsonUtil.getTreeNode(MeterMsg.buildMsg(objectNode.toString()));
        log.info("\u8f93\u51fa\u7684\u89e3\u6790\u7ed3\u679c:" + result.toString());
        if ("0000".equals(result.get("resultCode").asText())) {
            return result.get("meterMsg").asText();
        }
        throw new RuntimeException(String.format("\u89e3\u6790\u5931\u8d25,\u9519\u8bef\u7801:%s,\u8be6\u7ec6\u4fe1\u606f:%s", result.get("resultCode"), result.get("resultMsg")));
    }

    public static String formatBigDecimal(BigDecimal value) {
        DecimalFormat df = new DecimalFormat("####.00");
        return df.format(value.setScale(2, RoundingMode.HALF_UP));
    }

    @Override
    public String getCommandIdentity(byte[] bytes) {
        throw new UnsupportedOperationException("");
    }

    @Override
    public boolean isMatch(String inIdentity, String outIdentity) {
        return true;
    }

    @Override
    public Command init(byte[] bytes) {
        ObjectNode node = Ym20Protocol.getNewObjectNode();
        node.remove("companyCode");
        node.remove("protocolCode");
        node.put("meterMsg", ByteUtil.bytes2HexString(bytes));
        node.put(SIGN, Md5Helper.getSignValue(node.toString(), "51StGDgAJPhgCrLXWCg4ZPR4V9OL0tBf"));
        System.out.println("\u4f20\u5165\u88d5\u6c11\u89e3\u6790\u6570\u636e:" + node.toString());
        JsonNode result = JsonUtil.getTreeNode(MeterMsg.analyzeMsg(node.toString()));
        System.out.println("\u88d5\u6c11\u89e3\u6790\u7684\u6570\u636e\u5185\u5bb9:" + result);
        if (!"0000".equals(result.get("resultCode").asText())) {
            throw new RuntimeException(String.format("\u89e3\u6790\u5931\u8d25,\u9519\u8bef\u7801:%s,\u8be6\u7ec6\u4fe1\u606f:%s", result.get("resultCode"), result.get("resultMsg")));
        }
        if (result.get(COMMANDCODE) != null && "READ_METER_BASIC_INFO".equals(result.get(COMMANDCODE).asText())) {
            Ym20_SZ instance = JsonUtil.stringToObject(result.get("dataDetail").toString(), Ym20_SZ.class);
            instance.setMeterNo(result.get(METERNO).asText());
            instance.setSerialNo(Integer.valueOf(result.get(SER).asText()));
            System.out.println(instance.toJsonString());
            return instance;
        }
        Ym20_Result instance = new Ym20_Result();
        instance.setResultMsg(result.get("resultMsg").asText());
        if ("0000".equals(result.get("resultCode").asText().trim())) {
            instance.setSuccess(true);
            instance.setMeterNo(result.get(METERNO).asText());
            instance.setSer(result.get(SER).asInt());
            return instance;
        }
        instance.setSuccess(false);
        return instance;
    }
}

