/*
 * Decompiled with CFR 0.152.
 */
package com.goldcard.protocol.jk.jk30.outward;

import com.goldcard.protocol.OutwardCommand;
import com.goldcard.protocol.jk.jk30.AbstractJK30Command;
import com.goldcard.resolve.annotation.BasicTemplate;
import com.goldcard.resolve.annotation.Convert;
import com.goldcard.resolve.annotation.Identity;
import com.goldcard.resolve.annotation.Replace;
import com.goldcard.resolve.annotation.Validation;
import com.goldcard.resolve.annotation.inner.ValidationContainer;
import com.goldcard.resolve.operation.method.convert.BcdConvertMethod;
import com.goldcard.resolve.operation.method.convert.HexConvertMethod;
import com.goldcard.resolve.operation.method.convert.HexOppositeConvertMethod;
import com.goldcard.resolve.operation.method.replace.DESReplaceMethod;
import com.goldcard.resolve.operation.method.validation.CrcOnlyFor30ValidationMethod;
import com.goldcard.resolve.operation.method.validation.Jk30LengthValidationMethod;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@Identity(value="30_System")
@BasicTemplate(length="#root.registerLength+36")
@Replace(start="20", end="28", operation=DESReplaceMethod.class, parameters={"C83E7386FA4DB629", "523593D5B8DC1676"}, order=-8)
@ValidationContainer(value={@Validation(start="8", end="-2", operation=CrcOnlyFor30ValidationMethod.class, parameters={"-2", "0"}, order=-10), @Validation(start="10", end="-4", operation=CrcOnlyFor30ValidationMethod.class, parameters={"-4", "-2"}, order=-6), @Validation(start="10", end="12", operation=Jk30LengthValidationMethod.class, parameters={"14"})})
public class JK30_30_System
extends AbstractJK30Command
implements OutwardCommand {
    @Convert(start="0", end="10", operation=BcdConvertMethod.class)
    private String start = "FEFEFEFEFEEB90000130";
    @Convert(start="10", end="12", operation=HexOppositeConvertMethod.class)
    private int dataLength;
    @Convert(start="12", end="14", operation=BcdConvertMethod.class)
    private String blank = "0000";
    @Convert(start="14", end="20", operation=BcdConvertMethod.class)
    private String deviceNo;
    @Convert(start="20", end="21", operation=HexConvertMethod.class)
    private int type = 0;
    @Convert(start="23", end="28", operation=BcdConvertMethod.class)
    private String dtu;
    @Convert(start="28", end="30", operation=HexOppositeConvertMethod.class)
    private int registerStart;
    @Convert(start="30", end="32", operation=HexOppositeConvertMethod.class)
    private int registerLength;
    @Convert(start="32", end="32+#root.registerLength", operation=BcdConvertMethod.class)
    private String data;

    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(int dataLength) {
        this.dataLength = dataLength;
    }

    public String getBlank() {
        return this.blank;
    }

    public void setBlank(String blank) {
        this.blank = blank;
    }

    public String getDeviceNo() {
        return this.deviceNo;
    }

    public void setDeviceNo(String deviceNo) {
        this.deviceNo = deviceNo;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getDtu() {
        return this.dtu;
    }

    public void setDtu(String dtu) {
        this.dtu = dtu;
    }

    public int getRegisterStart() {
        return this.registerStart;
    }

    public void setRegisterStart(int registerStart) {
        this.registerStart = registerStart;
    }

    public int getRegisterLength() {
        return this.registerLength;
    }

    public void setRegisterLength(int registerLength) {
        this.registerLength = registerLength;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    private void init() {
        this.dtu = this.deviceNo.substring(2, 12);
        this.dataLength = this.registerLength + 22;
    }

    private String oppositeString(String value) {
        StringBuilder oppositeValue = new StringBuilder();
        int i = 0;
        while (i < value.length() / 2) {
            String tmp = value.substring(value.length() - i * 2 - 2, value.length() - i * 2);
            oppositeValue.append(tmp);
            ++i;
        }
        return oppositeValue.toString();
    }

    public static JK30_30_System jk30_cardNo(String meterNo, String cardNo) {
        JK30_30_System jk30 = new JK30_30_System();
        jk30.setDeviceNo(meterNo);
        jk30.setRegisterStart(37);
        jk30.setRegisterLength(8);
        cardNo = cardNo.length() > 16 ? cardNo.substring(0, 16) : StringUtils.rightPad(cardNo, 16, "F");
        jk30.setData(cardNo);
        jk30.init();
        return jk30;
    }

    public static JK30_30_System jk30_noUserDay1(String meterNo, String day1) {
        int tmp = Integer.valueOf(day1);
        if (tmp <= 0 || tmp > 255) {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6307\u4ee4\u8bbe\u7f6e\u65b9\u5f0f:" + meterNo + " " + day1);
        }
        JK30_30_System jk30 = new JK30_30_System();
        jk30.setDeviceNo(meterNo);
        jk30.setRegisterStart(14);
        jk30.setRegisterLength(1);
        jk30.setData(StringUtils.leftPad(Integer.toHexString(tmp), 2, "0"));
        jk30.init();
        return jk30;
    }

    public static JK30_30_System jk30_noUserDay2(String meterNo, String day2) {
        int tmp = Integer.valueOf(day2);
        if (tmp <= 0 || tmp > 255) {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6307\u4ee4\u8bbe\u7f6e\u65b9\u5f0f:" + meterNo + " " + day2);
        }
        JK30_30_System jk30 = new JK30_30_System();
        jk30.setDeviceNo(meterNo);
        jk30.setRegisterStart(15);
        jk30.setRegisterLength(1);
        jk30.setData(StringUtils.leftPad(Integer.toHexString(tmp), 2, "0"));
        jk30.init();
        return jk30;
    }

    public static JK30_30_System jk30_returnCycle(String meterNo, int interval, List<String> times) {
        if (times.size() < 1 || times.size() > 3) {
            throw new RuntimeException("\u65f6\u95f4\u96c6\u54081\u52303\u4e2a");
        }
        JK30_30_System jk30 = new JK30_30_System();
        jk30.setDeviceNo(meterNo);
        jk30.setRegisterStart(120);
        jk30.setRegisterLength(8);
        String data = StringUtils.leftPad(Integer.toHexString(interval & 0xFF), 2, "0");
        data = String.valueOf(data) + StringUtils.leftPad(Integer.toHexString(times.size() & 0xFF), 2, "0");
        for (String time : times) {
            data = String.valueOf(data) + time;
        }
        data = StringUtils.rightPad(data, 16, "0");
        jk30.setData(data);
        jk30.init();
        return jk30;
    }

    public static JK30_30_System jk30_overdraft(String meterNo, int overdraft) {
        JK30_30_System jk30 = new JK30_30_System();
        jk30.setDeviceNo(meterNo);
        jk30.setRegisterStart(45);
        jk30.setRegisterLength(2);
        String value = StringUtils.leftPad(Integer.toHexString(overdraft), 4, "0");
        jk30.setData(jk30.oppositeString(value));
        jk30.init();
        return jk30;
    }

    public static JK30_30_System jk30_alarm1(String meterNo, int alarm1) {
        JK30_30_System jk30 = new JK30_30_System();
        jk30.setDeviceNo(meterNo);
        jk30.setRegisterStart(47);
        jk30.setRegisterLength(2);
        String value = StringUtils.leftPad(Integer.toHexString(alarm1), 4, "0");
        jk30.setData(jk30.oppositeString(value));
        jk30.init();
        return jk30;
    }

    public static JK30_30_System jk30_alarm2(String meterNo, int alarm2) {
        JK30_30_System jk30 = new JK30_30_System();
        jk30.setDeviceNo(meterNo);
        jk30.setRegisterLength(49);
        jk30.setRegisterLength(2);
        String value = StringUtils.leftPad(Integer.toHexString(alarm2), 4, "0");
        jk30.setData(jk30.oppositeString(value));
        jk30.init();
        return jk30;
    }

    public static JK30_30_System jk30_ip(String meterNo, String ip) {
        String[] ips = ip.split("\\.");
        if (ips.length != 4) {
            throw new RuntimeException("ip\u5fc5\u987b\u4e3a4\u4e2a\u6570\u503c");
        }
        JK30_30_System jk30 = new JK30_30_System();
        jk30.setDeviceNo(meterNo);
        jk30.setRegisterStart(61);
        jk30.setRegisterLength(6);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < ips.length) {
            int num = Integer.valueOf(ips[i]);
            if (num < 0 || num > 255) {
                throw new RuntimeException("\u4e0d\u5408\u6cd5\u7684\u503c:" + num);
            }
            sb.append(StringUtils.leftPad(Integer.toHexString(num), 2, "0"));
            ++i;
        }
        jk30.setData(StringUtils.leftPad(sb.toString(), 12, "0"));
        jk30.init();
        return jk30;
    }

    public static JK30_30_System jk30_port(String meterNo, int port) {
        if (port < 0 || port > 65535) {
            throw new RuntimeException("\u7aef\u53e3\u53d6\u503c\u8303\u56f4\u57280\u523065535\u4e4b\u95f4");
        }
        JK30_30_System jk30 = new JK30_30_System();
        jk30.setDeviceNo(meterNo);
        jk30.setRegisterStart(68);
        jk30.setRegisterLength(2);
        String value = StringUtils.leftPad(Integer.toHexString(port), 4, "0");
        value = jk30.oppositeString(value);
        jk30.setData(value);
        jk30.init();
        return jk30;
    }

    public static JK30_30_System jk30_ipAndPort(String meterNo, String ip, int port) {
        JK30_30_System jk30 = new JK30_30_System();
        String[] ips = ip.split("\\.");
        if (ips.length != 4) {
            throw new RuntimeException("ip\u5fc5\u987b\u4e3a4\u4e2a\u6570\u503c");
        }
        if (port < 0 || port > 65535) {
            throw new RuntimeException("\u7aef\u53e3\u53d6\u503c\u8303\u56f4\u57280\u523065535\u4e4b\u95f4");
        }
        jk30.setDeviceNo(meterNo);
        jk30.setRegisterStart(61);
        jk30.setRegisterLength(9);
        StringBuffer nsb = new StringBuffer();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < ips.length) {
            int num = Integer.valueOf(ips[i]);
            if (num < 0 || num > 255) {
                throw new RuntimeException("\u4e0d\u5408\u6cd5\u7684\u503c:" + num);
            }
            sb.append(StringUtils.leftPad(Integer.toHexString(num), 2, "0"));
            ++i;
        }
        nsb.append(StringUtils.leftPad(String.valueOf(sb), 12, "0"));
        nsb.append("00");
        nsb.append(jk30.oppositeString(StringUtils.leftPad(Integer.toHexString(port), 4, "0")));
        jk30.setData(String.valueOf(nsb));
        jk30.init();
        return jk30;
    }
}

