/*
 * Decompiled with CFR 0.152.
 */
package com.goldcard.protocol.jk.jk30.outward;

import com.goldcard.protocol.OutwardCommand;
import com.goldcard.protocol.jk.jk30.AbstractJK30Command;
import com.goldcard.resolve.annotation.BasicTemplate;
import com.goldcard.resolve.annotation.Convert;
import com.goldcard.resolve.annotation.Identity;
import com.goldcard.resolve.annotation.Replace;
import com.goldcard.resolve.annotation.Validation;
import com.goldcard.resolve.annotation.inner.ValidationContainer;
import com.goldcard.resolve.operation.method.convert.BcdConvertMethod;
import com.goldcard.resolve.operation.method.convert.BcdDateConvertMethod;
import com.goldcard.resolve.operation.method.convert.HexConvertMethod;
import com.goldcard.resolve.operation.method.convert.HexOppositeConvertMethod;
import com.goldcard.resolve.operation.method.replace.DESReplaceMethod;
import com.goldcard.resolve.operation.method.validation.CrcOnlyFor30ValidationMethod;
import com.goldcard.resolve.operation.method.validation.Jk30LengthValidationMethod;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

@Identity(value="20_System")
@BasicTemplate(length="38")
@Replace(start="20", end="28", operation=DESReplaceMethod.class, parameters={"C83E7386FA4DB629", "523593D5B8DC1676"}, order=-8)
@ValidationContainer(value={@Validation(start="8", end="-2", operation=CrcOnlyFor30ValidationMethod.class, parameters={"-2", "0"}, order=-10), @Validation(start="10", end="-4", operation=CrcOnlyFor30ValidationMethod.class, parameters={"-4", "-2"}, order=-6), @Validation(start="10", end="12", operation=Jk30LengthValidationMethod.class, parameters={"14"})})
public class JK30_20_System
extends AbstractJK30Command
implements OutwardCommand {
    @Convert(start="0", end="12", operation=BcdConvertMethod.class)
    private String identity = "FEFEFEFEFEEB900001201800";
    @Convert(start="12", end="14", operation=BcdConvertMethod.class)
    private String blank = "0000";
    @Convert(start="14", end="20", operation=BcdConvertMethod.class)
    private String deviceNo;
    @Convert(start="20", end="21", operation=HexConvertMethod.class)
    private int type;
    @Convert(start="21", end="25", operation=HexOppositeConvertMethod.class)
    private int integralPart;
    @Convert(start="25", end="26", operation=HexConvertMethod.class)
    private int fractionalPart;
    @Convert(start="26", end="28", operation=HexOppositeConvertMethod.class)
    private int rechargeNum;
    @Convert(start="28", end="34", operation=BcdDateConvertMethod.class, parameters={"yyMMddHHmmss"})
    private Date time;

    public JK30_20_System() {
    }

    public JK30_20_System(String meterNo, BigDecimal money, int num) {
        money = money.setScale(2, RoundingMode.HALF_UP);
        this.deviceNo = meterNo;
        this.type = 0;
        this.integralPart = money.intValue();
        BigDecimal tmp = money.compareTo(BigDecimal.ZERO) >= 0 ? money.subtract(new BigDecimal(String.valueOf(this.integralPart))) : new BigDecimal(String.valueOf(this.integralPart)).subtract(money);
        this.fractionalPart = tmp.multiply(new BigDecimal("100")).intValue();
        this.rechargeNum = num;
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public String getBlank() {
        return this.blank;
    }

    public void setBlank(String blank) {
        this.blank = blank;
    }

    public String getDeviceNo() {
        return this.deviceNo;
    }

    public void setDeviceNo(String deviceNo) {
        this.deviceNo = deviceNo;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getIntegralPart() {
        return this.integralPart;
    }

    public void setIntegralPart(int integralPart) {
        this.integralPart = integralPart;
    }

    public int getFractionalPart() {
        return this.fractionalPart;
    }

    public void setFractionalPart(int fractionalPart) {
        this.fractionalPart = fractionalPart;
    }

    public int getRechargeNum() {
        return this.rechargeNum;
    }

    public void setRechargeNum(int rechargeNum) {
        this.rechargeNum = rechargeNum;
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }
}

