/*
 * Decompiled with CFR 0.152.
 */
package com.goldcard.protocol.jk.jk30.outward;

import com.goldcard.protocol.OutwardCommand;
import com.goldcard.protocol.jk.jk30.AbstractJK30Command;
import com.goldcard.resolve.annotation.BasicTemplate;
import com.goldcard.resolve.annotation.Convert;
import com.goldcard.resolve.annotation.Identity;
import com.goldcard.resolve.annotation.Validation;
import com.goldcard.resolve.operation.method.convert.BcdConvertMethod;
import com.goldcard.resolve.operation.method.convert.HexConvertMethod;
import com.goldcard.resolve.operation.method.validation.CrcOnlyFor30ValidationMethod;

@Identity(value="03_System")
@BasicTemplate(length="16")
@Validation(start="8", end="-2", operation=CrcOnlyFor30ValidationMethod.class, parameters={"-2", "0"}, order=-10)
public class JK30_03_System
extends AbstractJK30Command
implements OutwardCommand {
    @Convert(start="0", end="10", operation=BcdConvertMethod.class)
    private String start = "FEFEFEFEFEEB90000103";
    @Convert(start="10", end="12", operation=HexConvertMethod.class)
    private int registerStart;
    @Convert(start="12", end="14", operation=HexConvertMethod.class)
    private int registerLength;

    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public int getRegisterStart() {
        return this.registerStart;
    }

    public void setRegisterStart(int registerStart) {
        this.registerStart = registerStart;
    }

    public int getRegisterLength() {
        return this.registerLength;
    }

    public void setRegisterLength(int registerLength) {
        this.registerLength = registerLength;
    }

    public static JK30_03_System jk30_monthGasRecord(int month) {
        if (month < 1 || month > 12) {
            throw new RuntimeException("month\u7684\u53d6\u503c\u57281\u523012\u4e4b\u95f4,\u9519\u8bef\u503c:" + month);
        }
        JK30_03_System jk30 = new JK30_03_System();
        int start = 1024;
        start = 1024 + (month - 1) * 160;
        jk30.setRegisterStart(start);
        jk30.setRegisterLength(80);
        return jk30;
    }

    public static JK30_03_System jk30_simNo() {
        JK30_03_System jk30 = new JK30_03_System();
        jk30.setRegisterStart(3104);
        jk30.setRegisterLength(10);
        return jk30;
    }

    public static JK30_03_System jk30_meterRun() {
        JK30_03_System jk30 = new JK30_03_System();
        jk30.setRegisterStart(0);
        jk30.setRegisterLength(5);
        return jk30;
    }

    public static JK30_03_System jk30_meterParam() {
        JK30_03_System jk30 = new JK30_03_System();
        jk30.setRegisterStart(10);
        jk30.setRegisterLength(25);
        return jk30;
    }

    public static JK30_03_System jk30_gprs() {
        JK30_03_System jk30 = new JK30_03_System();
        jk30.setRegisterStart(61);
        jk30.setRegisterLength(42);
        return jk30;
    }
}

