/*
 * Decompiled with CFR 0.152.
 */
package com.goldcard.protocol.jk.jk16.outward;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.goldcard.protocol.OutwardCommand;
import com.goldcard.protocol.jk.jk16.AbstractJK16Command;
import com.goldcard.resolve.annotation.BasicTemplate;
import com.goldcard.resolve.annotation.Convert;
import com.goldcard.resolve.annotation.Identity;
import com.goldcard.resolve.operation.method.convert.BcdConvertMethod;
import com.goldcard.resolve.operation.method.convert.HexConvertMethod;
import com.goldcard.resolve.util.ByteUtil;
import org.apache.commons.lang3.StringUtils;

@Identity(value="1A19", description="\u5199\u7528\u6237\u8d44\u6599")
@BasicTemplate(length="225")
public class JK16_1A19
extends AbstractJK16Command
implements OutwardCommand {
    @Convert(start="0", end="5", operation=BcdConvertMethod.class)
    private String start = "7A72DD1A19";
    @JsonProperty(value="\u9875\u6570")
    @Convert(start="19", end="20", operation=HexConvertMethod.class)
    public int size;
    @JsonProperty(value="\u6709\u6548\u6570\u636e\u957f\u5ea6")
    @Convert(start="20", end="21", operation=HexConvertMethod.class)
    public int length;
    @JsonProperty(value="\u6570\u636e(BCD\u7801,\u957f\u5ea6\u8bf7\u51d1\u591f400,\u5426\u5219\u7cfb\u7edf\u4e0d\u77e5\u9053\u5982\u4f55\u586b\u5145)")
    @Convert(start="21", end="221", operation=BcdConvertMethod.class)
    public String data;

    public JK16_1A19(int size, byte[] data) {
        if (size <= 0 || size >= 6) {
            throw new RuntimeException("size\u5927\u5c0f\u57281\u548c5\u4e4b\u95f4");
        }
        this.size = size;
        this.length = data.length;
        if (data.length > 200) {
            throw new RuntimeException("\u957f\u5ea6\u8fc7\u957f,\u975e\u6cd5\u6307\u4ee4");
        }
        this.data = StringUtils.rightPad(ByteUtil.bytes2HexString(data), 400, '0');
    }

    public JK16_1A19() {
    }

    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }
}

