/*
 * Decompiled with CFR 0.152.
 */
package com.goldcard.protocol;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.goldcard.ProtocolResolve;
import com.goldcard.protocol.AbstractProtocol;
import com.goldcard.resolve.model.ClazzInfo;
import com.goldcard.resolve.util.AnalysisUtil;
import com.goldcard.resolve.util.DateUtil;

public interface Command {
    public static final ObjectMapper objectMapper = new ObjectMapper();

    default public String getCommandIdentity() {
        Class<?> clazz = this.getClass();
        ClazzInfo ci = (ClazzInfo)AnalysisUtil.classInfoMaps.get(clazz);
        if (ci != null) {
            return ci.getIdentity().value();
        }
        return null;
    }

    default public boolean isStart() {
        ClazzInfo ci = (ClazzInfo)AnalysisUtil.classInfoMaps.get(this.getClass());
        if (ci != null) {
            return ci.getIdentity().isStart();
        }
        return false;
    }

    default public boolean isEnd() {
        ClazzInfo ci = (ClazzInfo)AnalysisUtil.classInfoMaps.get(this.getClass());
        if (ci != null) {
            return ci.getIdentity().isEnd();
        }
        return false;
    }

    default public String description() {
        ClazzInfo ci = (ClazzInfo)AnalysisUtil.classInfoMaps.get(this.getClass());
        if (ci != null) {
            return ci.getIdentity().description();
        }
        return null;
    }

    default public String toJsonString() {
        try {
            objectMapper.setDateFormat(DateUtil.getSimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            return objectMapper.writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    default public AbstractProtocol getProtocol() {
        ClazzInfo clazzInfo = (ClazzInfo)AnalysisUtil.classInfoMaps.get(this.getClass());
        if (clazzInfo != null) {
            return clazzInfo.getProtocol();
        }
        return null;
    }

    @JsonIgnore
    default public byte[] getBytes() {
        return ProtocolResolve.Object2bytes(this);
    }

    @JsonIgnore
    default public void init(byte[] bytes) {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c");
    }
}

