/*
 * Decompiled with CFR 0.152.
 */
package com.goldcard;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.goldcard.ProtocolResolve;
import com.goldcard.protocol.InwardCommand;
import com.goldcard.protocol.jk.jk16.JK16Protocol;
import com.goldcard.protocol.jk.jk16.outward.JK16_11FF;
import com.goldcard.protocol.jk.jk16.outward.JK16_1A01;
import com.goldcard.protocol.jk.jk16.outward.JK16_1A02;
import com.goldcard.protocol.jk.jk16.outward.JK16_1A03;
import com.goldcard.protocol.jk.jk16.outward.JK16_1A04;
import com.goldcard.protocol.jk.jk16.outward.JK16_1A05;
import com.goldcard.protocol.jk.jk16.outward.JK16_1A11;
import com.goldcard.protocol.jk.jk16.outward.JK16_1A14;
import com.goldcard.protocol.jk.jk16.outward.JK16_1A1B;
import com.goldcard.protocol.jk.jk16.outward.JK16_1A1C;
import com.goldcard.protocol.jk.jk16.outward.JK16_1A5D;
import com.goldcard.protocol.jk.jk16.outward.JK16_1A5E;
import com.goldcard.protocol.jk.jk16.outward.JK16_1A63;
import com.goldcard.protocol.jk.jk30.JK30Protocol;
import com.goldcard.protocol.jk.jk30.outward.JK30_20_System;
import com.goldcard.protocol.jk.jk30.outward.JK30_21_System;
import com.goldcard.protocol.jk.jk30.outward.JK30_22_System;
import com.goldcard.protocol.jk.jk30.outward.JK30_26_System;
import com.goldcard.protocol.jk.jk30.outward.JK30_28_System;
import com.goldcard.protocol.jk.jk30.outward.JK30_30_System;
import com.goldcard.resolve.util.AnalysisUtil;
import com.goldcard.resolve.util.ByteUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

public class ProtocolUtil {
    public static String openValve(String meterno, String isPacker) {
        JK16_1A02 obj = new JK16_1A02();
        obj.setDestination(meterno);
        try {
            return ProtocolUtil.getLastData(obj.getBytes(), "1A02", isPacker);
        }
        catch (Exception e) {
            return "0";
        }
    }

    public static String generalClose(String meterno, String isPacker) {
        JK16_1A1B obj = new JK16_1A1B();
        obj.setDestination(meterno);
        try {
            return ProtocolUtil.getLastData(obj.getBytes(), "1A1B", isPacker);
        }
        catch (Exception e) {
            return "0";
        }
    }

    public static String forceClose(String meterno, String isPacker) {
        JK16_1A01 obj = new JK16_1A01();
        obj.setDestination(meterno);
        try {
            return ProtocolUtil.getLastData(obj.getBytes(), "1A01", isPacker);
        }
        catch (Exception e) {
            return "0";
        }
    }

    public static String closeByDate(String meterno, Integer day, String isPacker) {
        JK16_1A04 obj = new JK16_1A04();
        obj.setDestination(meterno);
        obj.setDay(day);
        try {
            return ProtocolUtil.getLastData(obj.getBytes(), "1A04", isPacker);
        }
        catch (Exception e) {
            return "0";
        }
    }

    public static String closeByGas(String meterno, Integer day, String isPacker) {
        JK16_1A11 obj = new JK16_1A11();
        obj.setDestination(meterno);
        obj.setDay(day);
        try {
            return ProtocolUtil.getLastData(obj.getBytes(), "1A11", isPacker);
        }
        catch (Exception e) {
            return "0";
        }
    }

    public static String setGasBasicParam(String meterno, String signal, String show, String alarm, String power, Integer overflow, String tamper, Integer unilateralInterference, Integer time, String isPacker) {
        JK16_1A14 obj = new JK16_1A14();
        obj.setDestination(meterno);
        obj.setSignal(signal);
        obj.setShow(Integer.parseInt(show));
        obj.setAlarm(Integer.parseInt(alarm));
        obj.setPower(Integer.parseInt(power));
        obj.setOverflow(overflow);
        obj.setTamper(Integer.parseInt(tamper));
        obj.setUnilateralInterference(unilateralInterference);
        obj.setTime(time);
        try {
            return ProtocolUtil.getLastData(obj.getBytes(), "1A14", isPacker);
        }
        catch (Exception e) {
            return "0";
        }
    }

    public static String setBackCycle(String meterno, Integer dateType, Integer day, Integer hour, Integer minute, String isPacker) {
        JK16_1A05 obj = new JK16_1A05();
        obj.setDestination(meterno);
        obj.setDayOrMonth(dateType);
        obj.setDay(day);
        obj.setHour(hour);
        obj.setMinute(minute);
        try {
            return ProtocolUtil.getLastData(obj.getBytes(), "1A05", isPacker);
        }
        catch (Exception e) {
            return "0";
        }
    }

    public static String getGasToMonth(String meterno, Integer month, String isPacker) {
        JK16_1A03 obj = new JK16_1A03();
        obj.setDestination(meterno);
        obj.setSearchMonth(month);
        try {
            return ProtocolUtil.getLastData(obj.getBytes(), "1A03", isPacker);
        }
        catch (Exception e) {
            return "0";
        }
    }

    public static String getSimInfo(String meterno, String isPacker) {
        JK16_1A1C obj = new JK16_1A1C();
        obj.setDestination(meterno);
        try {
            return ProtocolUtil.getLastData(obj.getBytes(), "1A1C", isPacker);
        }
        catch (Exception e) {
            return "0";
        }
    }

    public static String getEndData(String meterno, String price, String money, String message, Integer clearType, String isPacker) {
        JK16_11FF obj = new JK16_11FF();
        obj.setDestination(meterno);
        obj.setCurrentPrice(new BigDecimal(price));
        obj.setCurrentMoney(new BigDecimal(money));
        obj.setServerInfoMsg(StringUtils.leftPad(message, 2, '0'));
        obj.setSumBuy(new BigDecimal(0));
        obj.setType(clearType);
        try {
            return ProtocolUtil.getLastData(obj.getBytes(), "11FF", isPacker);
        }
        catch (Exception e) {
            return "0";
        }
    }

    public static String setOpenTableToExce(String meterno, String isPacker) {
        JK16_1A5D obj = new JK16_1A5D();
        obj.setDestination(meterno);
        try {
            return ProtocolUtil.getLastData(obj.getBytes(), "1A5D", isPacker);
        }
        catch (Exception e) {
            return "0";
        }
    }

    public static String setPreventOpenParam(String meterno, String controlBit, String isPacker) {
        JK16_1A5E obj = new JK16_1A5E();
        obj.setDestination(meterno);
        obj.setController(StringUtils.leftPad(controlBit, 2, '0'));
        try {
            return ProtocolUtil.getLastData(obj.getBytes(), "1A5E", isPacker);
        }
        catch (Exception e) {
            return "0";
        }
    }

    public static String setRemoveAlarm(String meterno, String removeAlarm, String isPacker) {
        JK16_1A63 obj = new JK16_1A63();
        obj.setDestination(meterno);
        obj.setRemoveAlarm(StringUtils.leftPad(removeAlarm, 8, '0'));
        try {
            return ProtocolUtil.getLastData(obj.getBytes(), "1A63", isPacker);
        }
        catch (Exception e) {
            return "0";
        }
    }

    public static String openAccountTo40(String meterno, String cardno, String isPacker) {
        try {
            JK30_30_System obj = JK30_30_System.jk30_cardNo(meterno, cardno);
            return ProtocolUtil.getLastData(obj.getBytes(), "0130", isPacker);
        }
        catch (Exception e) {
            return "0";
        }
    }

    public static String switchOperatorTo40(String meterno, Integer type, String isPacker) {
        try {
            JK30_22_System obj = new JK30_22_System(meterno, type);
            return ProtocolUtil.getLastData(obj.getBytes(), "0122", isPacker);
        }
        catch (Exception e) {
            return "0";
        }
    }

    public static String readGasRecordByDateTo40(String meterno, String date, String isPacker) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd");
            Date dd = sdf.parse(date);
            JK30_28_System obj = new JK30_28_System(meterno, dd);
            return ProtocolUtil.getLastData(obj.getBytes(), "0128", isPacker);
        }
        catch (Exception e) {
            return "0";
        }
    }

    public static String adjustPriceTo40(String meterno, Integer priceVersion, Integer period, String effectiveDate, String startDate, Integer price1, Integer price2, Integer price3, Integer price4, Integer price5, Integer gasLadder1, Integer gasLadder2, Integer gasLadder3, Integer gasLadder4, String isPacker) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHH");
            JK30_21_System obj = new JK30_21_System();
            obj.setDeviceNo(meterno);
            obj.setPriceVersion(priceVersion);
            obj.setPriceCycle(period);
            obj.setExecuteTime(sdf.parse(effectiveDate));
            obj.setCycleStartTime(sdf.parse(startDate));
            obj.setPrice0(new BigDecimal(price1).divide(new BigDecimal(100)));
            obj.setPrice1(new BigDecimal(price2).divide(new BigDecimal(100)));
            obj.setPrice2(new BigDecimal(price3).divide(new BigDecimal(100)));
            obj.setPrice3(new BigDecimal(price4).divide(new BigDecimal(100)));
            obj.setPrice4(new BigDecimal(price5).divide(new BigDecimal(100)));
            obj.setLadder0(gasLadder1);
            obj.setLadder1(gasLadder2);
            obj.setLadder2(gasLadder3);
            obj.setLadder3(gasLadder4);
            return ProtocolUtil.getLastData(obj.getBytes(), "0121", isPacker);
        }
        catch (Exception e) {
            return "0";
        }
    }

    public static String rechargeTo40(String meterno, Integer money, Integer buyNum, String date, String isPacker) {
        try {
            JK30_20_System obj = new JK30_20_System(meterno, new BigDecimal(money).divide(new BigDecimal(100)), buyNum);
            SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
            obj.setTime(sdf.parse(date));
            return ProtocolUtil.getLastData(obj.getBytes(), "0120", isPacker);
        }
        catch (Exception e) {
            return "0";
        }
    }

    public static String updateGprsTo40(String meterno, String ip, Integer port, String isPacker) {
        try {
            JK30_30_System obj = JK30_30_System.jk30_ipAndPort(meterno, ip, port);
            return ProtocolUtil.getLastData(obj.getBytes(), "0130", isPacker);
        }
        catch (Exception e) {
            return "0";
        }
    }

    public static String commEndFrameTo40(String meterno, String date, String isPacker) {
        try {
            JK30_26_System obj = new JK30_26_System();
            SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
            obj.setDeviceNo(meterno);
            obj.setTime(sdf.parse(date));
            return ProtocolUtil.getLastData(obj.getBytes(), "0126", isPacker);
        }
        catch (Exception e) {
            return "0";
        }
    }

    public static String analysisCommand(String command) {
        try {
            if (StringUtils.isNotEmpty(command) && "80".equals(command.substring(0, 2))) {
                command = command.substring(2);
            }
            ObjectMapper mapper = new ObjectMapper();
            HashMap<String, Object> map = new HashMap<String, Object>();
            InwardCommand cmd = null;
            switch (command.substring(0, 2)) {
                case "7A": {
                    cmd = (InwardCommand)ProtocolResolve.bytes2Object(ByteUtil.hexString2Bytes(command), new JK16Protocol());
                    break;
                }
                case "01": {
                    cmd = (InwardCommand)ProtocolResolve.bytes2Object(ByteUtil.hexString2Bytes(command), new JK30Protocol());
                    break;
                }
                default: {
                    return "0";
                }
            }
            map.put("type", ProtocolUtil.getDateType(cmd.getCommandIdentity()));
            map.put("data", cmd);
            return mapper.writeValueAsString(map);
        }
        catch (Exception e) {
            return "0";
        }
    }

    private static String getLastData(byte[] bytes, String mark, String isPacker) {
        if ("0".equals(isPacker)) {
            return ByteUtil.bytes2HexString(bytes);
        }
        if ("1".equals(isPacker)) {
            return ByteUtil.bytes2HexString(ProtocolUtil.packHead(bytes, ByteUtil.hexString2Bytes(mark), ByteUtil.hexString2Byte("01"), ByteUtil.hexString2Byte("01"), bytes.length));
        }
        return "0";
    }

    private static String getDateType(String param) {
        String dataType = "";
        switch (param) {
            case "1F00": {
                dataType = "1";
                break;
            }
            case "151B": {
                dataType = "2";
                break;
            }
            case "1501": {
                dataType = "3";
                break;
            }
            case "1502": {
                dataType = "4";
                break;
            }
            case "1503": {
                dataType = "5";
                break;
            }
            case "1504": {
                dataType = "6";
                break;
            }
            case "1511": {
                dataType = "7";
                break;
            }
            case "1505": {
                dataType = "8";
                break;
            }
            case "1514": {
                dataType = "9";
                break;
            }
            case "155D": {
                dataType = "10";
                break;
            }
            case "155E": {
                dataType = "11";
                break;
            }
            case "1563": {
                dataType = "12";
                break;
            }
            case "30_Meter": {
                dataType = "101";
                break;
            }
            case "24_Meter": {
                dataType = "102";
                break;
            }
            case "22_Meter": {
                dataType = "103";
                break;
            }
            case "28_Meter": {
                dataType = "104";
                break;
            }
            case "21_Meter": {
                dataType = "105";
                break;
            }
            case "20_Meter": {
                dataType = "106";
            }
        }
        return dataType;
    }

    private static byte[] packHead(byte[] data, byte[] code, byte sum, byte current, int dataCount) {
        byte cs;
        byte[] newData = new byte[data.length + 10];
        byte[] len = ProtocolUtil.int2Byt(dataCount);
        byte[] head = new byte[]{107, 98, code[0], code[1], 1, sum, current, len[0], len[1]};
        System.arraycopy(head, 0, newData, 0, 9);
        System.arraycopy(data, 0, newData, 9, data.length);
        byte[] need_cs = Arrays.copyOfRange(newData, 4, newData.length - 1);
        newData[newData.length - 1] = cs = ProtocolUtil.getCS(need_cs);
        return newData;
    }

    private static byte[] int2Byt(int x) {
        byte[] bb = new byte[]{(byte)(x >> 8), (byte)(x >> 0)};
        return bb;
    }

    private static byte getCS(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        String tmp = null;
        int sum = 0;
        for (byte b : bytes) {
            tmp = Integer.toHexString(0xFF & b);
            if (tmp.length() == 1) {
                tmp = "0" + tmp;
            }
            sum += Integer.parseInt(tmp.toString(), 16);
            sb.append(tmp);
        }
        String result = Integer.toHexString(sum %= 256);
        if (result.length() == 1) {
            result = "0" + result;
        }
        return ByteUtil.hexString2Byte(result);
    }

    static {
        AnalysisUtil.initClassInfo();
    }
}

