/*
 * Decompiled with CFR 0.152.
 */
package com.goldcard;

import com.goldcard.protocol.AbstractProtocol;
import com.goldcard.protocol.Command;
import com.goldcard.protocol.jk.jk16.JK16Protocol;
import com.goldcard.resolve.annotation.BasicTemplate;
import com.goldcard.resolve.model.ClazzInfo;
import com.goldcard.resolve.operation.Operation;
import com.goldcard.resolve.operation.ValidationOperation;
import com.goldcard.resolve.util.AnalysisUtil;
import com.goldcard.resolve.util.ByteUtil;
import com.goldcard.resolve.util.ThreadContextUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class ProtocolResolve {
    public static Command bytes2Object(byte[] bytes, AbstractProtocol protocol) {
        try {
            Method method = protocol.getClass().getDeclaredMethod("init", byte[].class);
            try {
                byte[] tmp_bytes = Arrays.copyOfRange(bytes, 0, bytes.length);
                return (Command)method.invoke((Object)protocol, new Object[]{tmp_bytes});
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        catch (NoSuchMethodException | SecurityException method) {
            String key;
            Class clazz;
            byte[] tmp_bytes = Arrays.copyOfRange(bytes, 0, bytes.length);
            if ("80".equals(ByteUtil.byte2HexString(bytes[0]))) {
                tmp_bytes = Arrays.copyOfRange(tmp_bytes, 1, tmp_bytes.length);
            }
            if ((clazz = (Class)AnalysisUtil.classMap.get(key = String.valueOf(protocol.getProtocolName()) + protocol.getCommandIdentity(tmp_bytes))) == null) {
                throw new RuntimeException("\u65e0\u6cd5\u627e\u5230\u5408\u9002\u7684\u89e3\u6790Class\u7c7b");
            }
            return (Command)ProtocolResolve.bytes2Object(tmp_bytes, clazz);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static <T> T bytes2Object(byte[] bytes, Class<T> clazz) {
        try {
            instance = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e.getCause() + e.getMessage());
        }
        tmp_bytes = Arrays.copyOfRange(bytes, 0, bytes.length);
        try {
            method = clazz.getDeclaredMethod("init", new Class[]{byte[].class});
            try {
                method.invoke(instance, new Object[]{tmp_bytes});
                return instance;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(String.valueOf(e.getMessage()) + e.getCause());
            }
        }
        catch (NoSuchMethodException | SecurityException method) {
            AnalysisUtil.classInfoMaps.putIfAbsent(clazz, new ClazzInfo(clazz));
            ctx = ThreadContextUtil.currentInstance.get();
            ctx.setRootObject(instance);
            operations = ((ClazzInfo)AnalysisUtil.classInfoMaps.get(clazz)).getOperations();
            failureOperation = new ArrayList<Operation>();
            ** for (entry : operations.entrySet())
        }
lbl-1000:
        // 3 sources

        {
            for (Operation oper : entry.getValue()) {
                ThreadContextUtil.currentInstance.set(ctx);
                try {
                    tmp_bytes = oper.handle(tmp_bytes, instance, Operation.Direction.INWARD);
                }
                catch (Exception e) {
                    if (oper instanceof ValidationOperation) {
                        validation = (ValidationOperation)oper;
                        if (validation.isCanDelay()) {
                            failureOperation.add(oper);
                            continue;
                        }
                        throw new RuntimeException(oper.toString(), e);
                    }
                    throw new RuntimeException(oper.toString(), e);
                }
            }
            continue;
        }
lbl38:
        // 2 sources

        for (Operation oper : failureOperation) {
            oper.handle(tmp_bytes, instance, Operation.Direction.INWARD);
        }
        return instance;
    }

    public static <T> byte[] Object2bytes(T instance) {
        Class<?> clazz = instance.getClass();
        StandardEvaluationContext ctx = ThreadContextUtil.currentInstance.get();
        ctx.setRootObject(instance);
        BasicTemplate basicTemplate = ((ClazzInfo)AnalysisUtil.classInfoMaps.get(clazz)).getBasicTemplate();
        if (basicTemplate == null) {
            throw new RuntimeException("basicTemplate\u4e3a\u7a7a,\u4e0d\u80fd\u6253\u5305");
        }
        char c = basicTemplate.padding();
        int length = (Integer)new SpelExpressionParser().parseExpression(basicTemplate.length()).getValue(ctx);
        byte[] bytes = ByteUtil.hexString2Bytes(StringUtils.leftPad("", length * 2, c));
        TreeMap<Integer, List<Operation>> operations = ((ClazzInfo)AnalysisUtil.classInfoMaps.get(clazz)).getOperations();
        Iterator<Integer> iterator = operations.descendingKeySet().iterator();
        while (iterator.hasNext()) {
            List<Operation> list = operations.get(iterator.next());
            int i = list.size() - 1;
            while (i >= 0) {
                ThreadContextUtil.currentInstance.set(ctx);
                bytes = list.get(i).handle(bytes, instance, Operation.Direction.OUTWARD);
                --i;
            }
        }
        return bytes;
    }

    public static void main(String[] args) {
        byte[] bytes = ByteUtil.hexString2Bytes("807A72B91F000000000000001818262067180101D1C84EE9EF42872A0000000233333335333333353333333533333335333333353333333533333335333333353333333533333335333333353333333533333335333333353333333533333335333333353333333533333335333333353333333533333335333333333333333333333333333333333333333333333333333333333333333333333333000000000000000000000000000000020400001A058116190122140000008B817BAA");
        AnalysisUtil.initClassInfo();
        System.out.println(ProtocolResolve.bytes2Object(bytes, new JK16Protocol()).toJsonString());
    }
}

