/*
 * Decompiled with CFR 0.152.
 */
package com.cqct.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import java.util.regex.Pattern;

public class Parser {
    protected String str;
    protected int index;
    public static char[] WSP = new char[]{' ', '\t'};
    public static char[] SPACE = WSP;
    public static char[] CRLF = new char[]{'\r', '\n'};
    public static char[] WSPCRLF = new char[]{' ', '\t', '\r', '\n'};

    public Parser(String s) {
        if (s == null) {
            throw new RuntimeException("Tried to costruct a new Parser with a null String");
        }
        this.str = s;
        this.index = 0;
    }

    public Parser(String s, int i) {
        if (s == null) {
            throw new RuntimeException("Tried to costruct a new Parser with a null String");
        }
        this.str = s;
        this.index = i;
    }

    public Parser(StringBuffer sb) {
        if (sb == null) {
            throw new RuntimeException("Tried to costruct a new Parser with a null StringBuffer");
        }
        this.str = sb.toString();
        this.index = 0;
    }

    public Parser(StringBuffer sb, int i) {
        if (sb == null) {
            throw new RuntimeException("Tried to costruct a new Parser with a null StringBuffer");
        }
        this.str = sb.toString();
        this.index = i;
    }

    public int getPos() {
        return this.index;
    }

    public String getWholeString() {
        return this.str;
    }

    public String getRemainingString() {
        return this.str.substring(this.index);
    }

    public Parser subParser(int len) {
        return new Parser(this.str.substring(this.index, this.index + len));
    }

    public int length() {
        return this.str.length() - this.index;
    }

    public boolean hasMore() {
        return this.length() > 0;
    }

    public char getChar() {
        return this.str.charAt(this.index++);
    }

    public char charAt(int n) {
        return this.str.charAt(this.index + n);
    }

    public char nextChar() {
        return this.charAt(0);
    }

    public Parser setPos(int i) {
        this.index = i;
        return this;
    }

    public Parser goTo(char c) {
        this.index = this.str.indexOf(c, this.index);
        if (this.index < 0) {
            this.index = this.str.length();
        }
        return this;
    }

    public Parser goTo(char[] cc) {
        this.index = this.indexOf(cc);
        if (this.index < 0) {
            this.index = this.str.length();
        }
        return this;
    }

    public Parser goTo(String s) {
        this.index = this.str.indexOf(s, this.index);
        if (this.index < 0) {
            this.index = this.str.length();
        }
        return this;
    }

    public Parser goTo(String[] ss) {
        this.index = this.indexOf(ss);
        if (this.index < 0) {
            this.index = this.str.length();
        }
        return this;
    }

    public Parser goToIgnoreCase(String s) {
        this.index = this.indexOfIgnoreCase(s);
        if (this.index < 0) {
            this.index = this.str.length();
        }
        return this;
    }

    public Parser goToIgnoreCase(String[] ss) {
        this.index = this.indexOfIgnoreCase(ss);
        if (this.index < 0) {
            this.index = this.str.length();
        }
        return this;
    }

    public Parser goToNextLine() {
        while (this.index < this.str.length() && !Parser.isCRLF(this.str.charAt(this.index))) {
            ++this.index;
        }
        if (this.index < this.str.length()) {
            this.index = this.str.startsWith("\r\n", this.index) ? (this.index += 2) : ++this.index;
        }
        return this;
    }

    public static boolean isAnyOf(char[] ca, char ch) {
        boolean found = false;
        int i = 0;
        while (i < ca.length) {
            if (ca[i] == ch) {
                found = true;
                break;
            }
            ++i;
        }
        return found;
    }

    public static boolean isUpAlpha(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static boolean isLowAlpha(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static boolean isAlpha(char c) {
        return Parser.isUpAlpha(c) || Parser.isLowAlpha(c);
    }

    public static boolean isAlphanum(char c) {
        return Parser.isAlpha(c) || Parser.isDigit(c);
    }

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isDecimal(char c) {
        return c >= '0' && c <= '9' || c == '.';
    }

    public static boolean isChar(char c) {
        return c > ' ' && c <= '~';
    }

    public static boolean isCR(char c) {
        return c == '\r';
    }

    public static boolean isLF(char c) {
        return c == '\n';
    }

    public static boolean isCRLF(char c) {
        return Parser.isAnyOf(CRLF, c);
    }

    public static boolean isHT(char c) {
        return c == '\t';
    }

    public static boolean isSP(char c) {
        return c == ' ';
    }

    public static boolean isWSP(char c) {
        return Parser.isAnyOf(WSP, c);
    }

    public static boolean isWSPCRLF(char c) {
        return Parser.isAnyOf(WSPCRLF, c);
    }

    public static int compareIgnoreCase(char c1, char c2) {
        if (Parser.isUpAlpha(c1)) {
            c1 = (char)(c1 + 32);
        }
        if (Parser.isUpAlpha(c2)) {
            c2 = (char)(c2 + 32);
        }
        return c1 - c2;
    }

    public int indexOf(char c) {
        return this.str.indexOf(c, this.index);
    }

    public int indexOf(char[] cc) {
        boolean found = false;
        int begin = this.index;
        while (begin < this.str.length() && !found) {
            int i = 0;
            while (i < cc.length) {
                if (this.str.charAt(begin) == cc[i]) {
                    found = true;
                    break;
                }
                ++i;
            }
            ++begin;
        }
        return found ? begin - 1 : -1;
    }

    public int indexOf(String s) {
        return this.str.indexOf(s, this.index);
    }

    public int indexOf(String[] ss) {
        boolean found = false;
        int begin = this.index;
        while (begin < this.str.length() && !found) {
            int i = 0;
            while (i < ss.length) {
                if (this.str.startsWith(ss[i], begin)) {
                    found = true;
                    break;
                }
                ++i;
            }
            ++begin;
        }
        return found ? begin - 1 : -1;
    }

    public int indexOfIgnoreCase(String s) {
        Parser par = new Parser(this.str, this.index);
        while (par.hasMore()) {
            if (par.startsWithIgnoreCase(s)) {
                return par.getPos();
            }
            par.skipChar();
        }
        return -1;
    }

    public int indexOfIgnoreCase(String[] ss) {
        Parser par = new Parser(this.str, this.index);
        while (par.hasMore()) {
            if (par.startsWithIgnoreCase(ss)) {
                return par.getPos();
            }
            par.skipChar();
        }
        return -1;
    }

    public int indexOfNextLine() {
        Parser par = new Parser(this.str, this.index);
        par.goToNextLine();
        int i = par.getPos();
        return i < this.str.length() ? i : -1;
    }

    public boolean startsWith(String s) {
        return this.str.startsWith(s, this.index);
    }

    public boolean startsWith(String[] ss) {
        int i = 0;
        while (i < ss.length) {
            if (this.str.startsWith(ss[i], this.index)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean startsWithIgnoreCase(String s) {
        int k = 0;
        while (k < s.length() && this.index + k < this.str.length()) {
            if (Parser.compareIgnoreCase(s.charAt(k), this.str.charAt(this.index + k)) != 0) {
                return false;
            }
            ++k;
        }
        return true;
    }

    public boolean startsWithIgnoreCase(String[] ss) {
        int i = 0;
        while (i < ss.length) {
            boolean equal = true;
            int k = 0;
            while (k < ss[i].length() && this.index + k < this.str.length()) {
                equal = Parser.compareIgnoreCase(ss[i].charAt(k), this.str.charAt(this.index + k)) == 0;
                if (!equal) break;
                ++k;
            }
            if (equal) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Parser skipChar() {
        if (this.index < this.str.length()) {
            ++this.index;
        }
        return this;
    }

    public Parser skipN(int n) {
        this.index += n;
        if (this.index > this.str.length()) {
            this.index = this.str.length();
        }
        return this;
    }

    public Parser skipWSP() {
        while (this.index < this.str.length() && Parser.isSP(this.str.charAt(this.index))) {
            ++this.index;
        }
        return this;
    }

    public Parser skipCRLF() {
        while (this.index < this.str.length() && Parser.isCRLF(this.str.charAt(this.index))) {
            ++this.index;
        }
        return this;
    }

    public Parser skipWSPCRLF() {
        while (this.index < this.str.length() && Parser.isWSPCRLF(this.str.charAt(this.index))) {
            ++this.index;
        }
        return this;
    }

    public Parser skipChars(char[] cc) {
        while (this.index < this.str.length() && Parser.isAnyOf(cc, this.nextChar())) {
            ++this.index;
        }
        return this;
    }

    public Parser skipString() {
        this.getString();
        return this;
    }

    public String getString() {
        int begin = this.index;
        while (begin < this.str.length() && !Parser.isChar(this.str.charAt(begin))) {
            ++begin;
        }
        int end = begin;
        while (end < this.str.length() && Parser.isChar(this.str.charAt(end))) {
            ++end;
        }
        this.index = end;
        return this.str.substring(begin, end);
    }

    public String getString(int len) {
        int start = this.index;
        this.index = start + len;
        return this.str.substring(start, this.index);
    }

    public String getWord(char[] separators) {
        int begin = this.index;
        while (begin < this.str.length() && Parser.isAnyOf(separators, this.str.charAt(begin))) {
            ++begin;
        }
        int end = begin;
        while (end < this.str.length() && !Parser.isAnyOf(separators, this.str.charAt(end))) {
            ++end;
        }
        this.index = end;
        return this.str.substring(begin, end);
    }

    public Integer getInteger(boolean fsFlag) {
        String value = this.getNumberStr(fsFlag);
        return value != null && value.length() > 0 ? Integer.valueOf(Integer.parseInt(value)) : null;
    }

    public Integer getInteger() {
        return this.getInteger(false);
    }

    public Integer getNumberIndex() {
        int begin = this.index;
        while (begin < this.str.length() && !Parser.isDigit(this.str.charAt(begin))) {
            ++begin;
        }
        return this.str.length() > begin ? begin : -1;
    }

    public String getDecimalStr(boolean fsFlag) {
        int begin = this.index;
        while (begin < this.str.length() && !Parser.isDecimal(this.str.charAt(begin))) {
            ++begin;
        }
        int end = begin;
        while (end < this.str.length() && Parser.isDecimal(this.str.charAt(end))) {
            ++end;
        }
        this.index = end;
        String first = fsFlag && begin > 0 && "-".equals(String.valueOf(this.str.charAt(begin - 1))) ? "-" : "";
        return String.valueOf(first) + this.str.substring(begin, end);
    }

    public String getDecimalStr() {
        return this.getDecimalStr(false);
    }

    public String getNumberStr(boolean fsFlag) {
        int begin = this.index;
        while (begin < this.str.length() && !Parser.isDigit(this.str.charAt(begin))) {
            ++begin;
        }
        int end = begin;
        while (end < this.str.length() && Parser.isDigit(this.str.charAt(end))) {
            ++end;
        }
        this.index = end;
        String first = fsFlag && begin > 0 && "-".equals(String.valueOf(this.str.charAt(begin - 1))) ? "-" : "";
        return String.valueOf(first) + this.str.substring(begin, end);
    }

    public String getNumberStr() {
        return this.getNumberStr(false);
    }

    public int getInt() {
        return Integer.parseInt(this.getString());
    }

    public double getDouble() {
        return Double.parseDouble(this.getString());
    }

    public String getLine() {
        int end = this.index;
        while (end < this.str.length() && !Parser.isCRLF(this.str.charAt(end))) {
            ++end;
        }
        String line = this.str.substring(this.index, end);
        this.index = end;
        if (this.index < this.str.length()) {
            this.index = this.str.startsWith("\r\n", this.index) ? (this.index += 2) : ++this.index;
        }
        return line;
    }

    public Vector getWordVector(char[] separators) {
        Vector<String> list = new Vector<String>();
        do {
            list.addElement(this.getWord(separators));
        } while (this.hasMore());
        return list;
    }

    public String[] getWordArray(char[] separators) {
        Vector list = this.getWordVector(separators);
        String[] array = new String[list.size()];
        int i = 0;
        while (i < list.size()) {
            array[i] = (String)list.elementAt(i);
            ++i;
        }
        return array;
    }

    public Vector getStringVector() {
        Vector<String> list = new Vector<String>();
        do {
            list.addElement(this.getString());
        } while (this.hasMore());
        return list;
    }

    public String[] getStringArray() {
        Vector list = this.getStringVector();
        String[] array = new String[list.size()];
        int i = 0;
        while (i < list.size()) {
            array[i] = (String)list.elementAt(i);
            ++i;
        }
        return array;
    }

    public String getWordSkippingQuoted(char[] separators) {
        int begin = this.index;
        while (begin < this.str.length() && Parser.isAnyOf(separators, this.str.charAt(begin))) {
            ++begin;
        }
        boolean inside_quoted_string = false;
        int end = begin;
        while (end < this.str.length() && (!Parser.isAnyOf(separators, this.str.charAt(end)) || inside_quoted_string)) {
            if (this.str.charAt(end) == '\"') {
                inside_quoted_string = !inside_quoted_string;
            }
            ++end;
        }
        this.index = end;
        return this.str.substring(begin, end);
    }

    public String getStringUnquoted() {
        int next_qmark;
        while (this.index < this.str.length() && !Parser.isChar(this.str.charAt(this.index))) {
            ++this.index;
        }
        if (this.index == this.str.length()) {
            return this.str.substring(this.index, this.index);
        }
        if (this.str.charAt(this.index) == '\"' && (next_qmark = this.str.indexOf("\"", this.index + 1)) > 0) {
            String qtext = this.str.substring(this.index + 1, next_qmark);
            this.index = next_qmark + 1;
            return qtext;
        }
        return this.getString();
    }

    public Parser goToSkippingQuoted(char c) {
        boolean inside_quotes = false;
        try {
            while (this.index < this.str.length() && (this.nextChar() != c || inside_quotes)) {
                if (this.nextChar() == '\"') {
                    inside_quotes = !inside_quotes;
                }
                ++this.index;
            }
        }
        catch (RuntimeException e) {
            System.out.println("len= " + this.str.length());
            System.out.println("index= " + this.index);
            throw e;
        }
        return this;
    }

    public String toString() {
        return this.getRemainingString();
    }

    private static void setAttr() throws Exception {
        File file = new File("D:\\temp\\dbtable.ini");
        FileInputStream fis = new FileInputStream(file);
        InputStreamReader inReader = new InputStreamReader((InputStream)fis, "gbk");
        BufferedReader buffReader = new BufferedReader(inReader);
        String inStr = null;
        StringBuffer sb = new StringBuffer("");
        while ((inStr = buffReader.readLine()) != null) {
            Parser parser = new Parser(inStr);
            String s = parser.getString();
            String type = "String";
            if (inStr.toLowerCase().contains("int") || inStr.toLowerCase().contains("numeric") || inStr.toLowerCase().contains("decimal")) {
                Pattern pattern = Pattern.compile(".*[numeric,decimal]\\(\\d,[1-9]\\).*");
                String string = type = pattern.matcher(inStr).find() ? "Float" : "Integer";
            }
            if (inStr.toLowerCase().contains("datetime") || inStr.toLowerCase().contains("timestamp")) {
                type = "Timestamp";
            }
            if (s == null || "".equals(s.trim())) continue;
            String[] ss = s.toLowerCase().split("_");
            String str = "";
            if (ss == null || ss.length <= 0) continue;
            String common = inStr.substring(inStr.indexOf("'") + 1, inStr.lastIndexOf("'"));
            int i = 0;
            while (i < ss.length) {
                if (i == 0) {
                    str = String.valueOf(str) + ss[i];
                } else if (ss[i] != null && !"".equals(ss[i].trim())) {
                    str = String.valueOf(str) + ss[i].substring(0, 1).toUpperCase() + ss[i].substring(1);
                }
                ++i;
            }
            sb.append("\t/**\n");
            sb.append("\t * " + common + "\n");
            sb.append("\t */\n");
            sb.append("\tprivate " + type + " " + str + ";\r\n\n");
        }
        System.out.println(sb.toString());
        fis.close();
    }

    private static void getSql() throws Exception {
        File file = new File("D:\\temp\\dbtable.ini");
        FileInputStream fis = new FileInputStream(file);
        InputStreamReader inReader = new InputStreamReader(fis);
        BufferedReader buffReader = new BufferedReader(inReader);
        String inStr = null;
        StringBuffer sb = new StringBuffer("\tStringBuffer sb = new StringBuffer(\"select \");\n");
        while ((inStr = buffReader.readLine()) != null) {
            Parser parser = new Parser(inStr);
            String s = parser.getString();
            if (s == null || "".equals(s.trim())) continue;
            String[] ss = s.toLowerCase().split("_");
            String str = "";
            if (ss == null || ss.length <= 0) continue;
            int i = 0;
            while (i < ss.length) {
                if (i == 0) {
                    str = String.valueOf(str) + ss[i];
                } else if (ss[i] != null && !"".equals(ss[i].trim())) {
                    str = String.valueOf(str) + ss[i].substring(0, 1).toUpperCase() + ss[i].substring(1);
                }
                ++i;
            }
            sb.append("\tsb.append(\"a." + s + " as " + str + ",\");\r\n");
        }
        System.out.println(sb.toString());
        fis.close();
    }

    private static void getIbatisSql() throws Exception {
        File file = new File("D:\\temp\\dbtable.ini");
        FileInputStream fis = new FileInputStream(file);
        InputStreamReader inReader = new InputStreamReader(fis);
        BufferedReader buffReader = new BufferedReader(inReader);
        String inStr = null;
        StringBuffer sb = new StringBuffer("\tselect\n");
        while ((inStr = buffReader.readLine()) != null) {
            Parser parser = new Parser(inStr);
            String s = parser.getString();
            if (s == null || "".equals(s.trim())) continue;
            String[] ss = s.toLowerCase().split("_");
            String str = "";
            if (ss == null || ss.length <= 0) continue;
            int i = 0;
            while (i < ss.length) {
                if (i == 0) {
                    str = String.valueOf(str) + ss[i];
                } else if (ss[i] != null && !"".equals(ss[i].trim())) {
                    str = String.valueOf(str) + ss[i].substring(0, 1).toUpperCase() + ss[i].substring(1);
                }
                ++i;
            }
            sb.append("\tt." + s + " as \"" + str + "\",\r\n");
        }
        System.out.println(sb.toString());
        fis.close();
    }

    private static void getInsert(String keyword) throws Exception {
        File file = new File("D:\\temp\\dbtable.ini");
        FileInputStream fis = new FileInputStream(file);
        InputStreamReader inReader = new InputStreamReader(fis);
        BufferedReader buffReader = new BufferedReader(inReader);
        String inStr = null;
        StringBuffer sb = new StringBuffer("insert into  (\n");
        String s1 = "";
        String s2 = "";
        int len = 0;
        int count = 0;
        while ((inStr = buffReader.readLine()) != null) {
            Parser parser = new Parser(inStr);
            String s = parser.getString();
            if (s == null || "".equals(s.trim())) continue;
            String[] ss = s.toLowerCase().split("_");
            String str = "";
            if (ss == null || ss.length <= 0) continue;
            int i = 0;
            while (i < ss.length) {
                if (i == 0) {
                    str = String.valueOf(str) + ss[i];
                } else if (ss[i] != null && !"".equals(ss[i].trim())) {
                    str = String.valueOf(str) + ss[i].substring(0, 1).toUpperCase() + ss[i].substring(1);
                }
                ++i;
            }
            String m = "";
            if ((len += s.length()) > 80) {
                if (count > 0) {
                    m = "\n\t";
                }
                len = 0;
            }
            if (count == 0) {
                m = "\t";
                ++count;
            }
            s1 = String.valueOf(s1) + m + s + ", ";
            s2 = String.valueOf(s2) + m + keyword.replace("key", str) + ", ";
        }
        sb.append(String.valueOf(s1.substring(0, s1.length() - 2).toUpperCase()) + "\n");
        sb.append(") values (\n");
        sb.append(String.valueOf(s2.substring(0, s2.length() - 2)) + "\n");
        sb.append(")");
        System.out.println(sb.toString());
        fis.close();
    }

    private static void getIbatisInsert() throws Exception {
        File file = new File("D:\\temp\\dbtable.ini");
        FileInputStream fis = new FileInputStream(file);
        InputStreamReader inReader = new InputStreamReader(fis);
        BufferedReader buffReader = new BufferedReader(inReader);
        String inStr = null;
        StringBuffer sb = new StringBuffer("insert into  (\n");
        String s1 = "";
        String s2 = "";
        int len = 0;
        int count = 0;
        while ((inStr = buffReader.readLine()) != null) {
            Parser parser = new Parser(inStr);
            String s = parser.getString();
            if (s == null || "".equals(s.trim())) continue;
            String[] ss = s.toLowerCase().split("_");
            String str = "";
            if (ss == null || ss.length <= 0) continue;
            int i = 0;
            while (i < ss.length) {
                if (i == 0) {
                    str = String.valueOf(str) + ss[i];
                } else if (ss[i] != null && !"".equals(ss[i].trim())) {
                    str = String.valueOf(str) + ss[i].substring(0, 1).toUpperCase() + ss[i].substring(1);
                }
                ++i;
            }
            String m = "";
            if ((len += s.length()) > 80) {
                if (count > 0) {
                    m = "\n\t";
                }
                len = 0;
            }
            if (count == 0) {
                m = "\t";
                ++count;
            }
            s1 = String.valueOf(s1) + m + s + ", ";
            s2 = String.valueOf(s2) + m + "#" + str + "#, ";
        }
        sb.append(String.valueOf(s1.substring(0, s1.length() - 2).toUpperCase()) + "\n");
        sb.append(") values (\n");
        sb.append(String.valueOf(s2.substring(0, s2.length() - 2)) + "\n");
        sb.append(")");
        System.out.println(sb.toString());
        fis.close();
    }

    private static void getUpdate(String key) throws Exception {
        File file = new File("D:\\temp\\dbtable.ini");
        FileInputStream fis = new FileInputStream(file);
        InputStreamReader inReader = new InputStreamReader(fis);
        BufferedReader buffReader = new BufferedReader(inReader);
        String inStr = null;
        StringBuffer sb = new StringBuffer("update \nset");
        while ((inStr = buffReader.readLine()) != null) {
            Parser parser = new Parser(inStr);
            String s = parser.getString();
            if (s == null || "".equals(s.trim())) continue;
            String[] ss = s.toLowerCase().split("_");
            String str = "";
            if (ss == null || ss.length <= 0) continue;
            int i = 0;
            while (i < ss.length) {
                if (i == 0) {
                    str = String.valueOf(str) + ss[i];
                } else if (ss[i] != null && !"".equals(ss[i].trim())) {
                    str = String.valueOf(str) + ss[i].substring(0, 1).toUpperCase() + ss[i].substring(1);
                }
                ++i;
            }
            sb.append("\t" + s.toUpperCase() + " = " + key.replace("key", str) + ",\r\n");
        }
        System.out.println(sb.toString());
        fis.close();
    }

    private static void convertNew() throws Exception {
        File file = new File("D:\\temp\\dbtable.ini");
        FileInputStream fis = new FileInputStream(file);
        InputStreamReader inReader = new InputStreamReader(fis);
        BufferedReader buffReader = new BufferedReader(inReader);
        String inStr = null;
        StringBuffer sb = new StringBuffer("");
        while ((inStr = buffReader.readLine()) != null) {
            Parser parser = new Parser(inStr);
            String s = parser.getString();
            if (s == null || "".equals(s.trim())) continue;
            String[] ss = s.toLowerCase().split("_");
            String str = "";
            if (ss == null || ss.length <= 0) continue;
            int i = 0;
            while (i < ss.length) {
                if (ss[i] != null && !"".equals(ss[i].trim())) {
                    str = String.valueOf(str) + ss[i].substring(0, 1).toUpperCase() + ss[i].substring(1);
                }
                ++i;
            }
            sb.append("\tnewPo.set" + str + "(formPo.get" + str + "());\r\n");
        }
        System.out.println(sb.toString());
        fis.close();
    }

    private static void getTable() throws Exception {
        File file = new File("D:\\temp\\dbtable.ini");
        FileInputStream fis = new FileInputStream(file);
        InputStreamReader inReader = new InputStreamReader(fis);
        BufferedReader buffReader = new BufferedReader(inReader);
        String inStr = null;
        StringBuffer sb = new StringBuffer("<table class='btbForm' style='border: 0px;'>\n");
        int len = 0;
        while ((inStr = buffReader.readLine()) != null) {
            Parser parser = new Parser(inStr);
            String s = parser.getString();
            String common = inStr.substring(inStr.indexOf("'") + 1, inStr.lastIndexOf("'"));
            if (len % 2 == 0) {
                sb.append("\t<tr>\n");
            }
            if (s == null || "".equals(s.trim())) continue;
            String[] ss = s.toLowerCase().split("_");
            String str = "";
            if (ss == null || ss.length <= 0) continue;
            String style1 = null;
            String style2 = "";
            if (len == 0 || len == 1) {
                style1 = "style='width:17%;";
                style2 = "style='width:33%;'";
            }
            style1 = style1 == null ? "style='text-align:right;'" : String.valueOf(style1) + "text-align:right;'";
            int i = 0;
            while (i < ss.length) {
                if (i == 0) {
                    str = String.valueOf(str) + ss[i];
                } else if (ss[i] != null && !"".equals(ss[i].trim())) {
                    str = String.valueOf(str) + ss[i].substring(0, 1).toUpperCase() + ss[i].substring(1);
                }
                ++i;
            }
            sb.append("\t\t<td " + style1 + ">\n\t\t\t" + common + "\n\t\t</td>\n\t\t<td " + style2 + ">\n\t\t\t" + " ${bo.po." + str + "}\n\t\t</td>\r\n");
            if (len % 2 == 1) {
                sb.append("\t</tr>\n");
            }
            ++len;
        }
        if (len % 2 != 0) {
            int size = (2 - len % 2) * 2;
            sb.append("\t\t<td colspan='" + size + "'></td>\n\t</tr>\n");
        }
        sb.append("</table>");
        System.out.println(sb.toString());
        fis.close();
    }

    public static void main(String[] args) throws Exception {
        String str = "-33331.6ff";
        Parser parser = new Parser(str);
        System.out.println(parser.getNumberStr());
    }
}

