/*
 * Decompiled with CFR 0.152.
 */
package com.cqct.utils;

import com.cqct.utils.NumberHelper;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectHelper {
    public static String parseValueForScope(String value) {
        if (ObjectHelper.isEmptyValue(value)) {
            return null;
        }
        Object[] values = value.replace("'", "").replace("\uff0c", ",").replace("/", ",").replace("\u3001", ",").replace("\\", ",").split(",");
        return ObjectHelper.parseForScope(values);
    }

    public static String parseValueIntForScope(String value) {
        if (ObjectHelper.isEmptyValue(value)) {
            return null;
        }
        Object[] values = value.replace("'", "").replace("\uff0c", ",").replace("/", ",").replace("\u3001", ",").replace("\\", ",").split(",");
        return ObjectHelper.parseIntForScope(values);
    }

    public static String parseValueForScope(Object[] objects, String separator) {
        return ObjectHelper.parseValueForScope(objects, separator, null);
    }

    public static <T> String parseValueForScope(List<T> objects, String separator) {
        return ObjectHelper.parseValueForScope(objects, separator, null);
    }

    public static String parseValueForScope(Object[] objects, String separator, String attrName) {
        String scope = null;
        if (objects != null && objects.length > 0) {
            if (ObjectHelper.isEmptyValue(separator)) {
                separator = ",";
            }
            scope = "";
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                String value = ObjectHelper.getSeparatorValue(object, null, attrName);
                if (ObjectHelper.isNotEmptyValue(value)) {
                    scope = String.valueOf(scope) + separator + value;
                }
                ++n2;
            }
            if (!"".equals(scope)) {
                scope = scope.substring(separator.length());
            }
        }
        return scope;
    }

    public static <T> String parseValueForScope(List<T> objects, String separator, String attrName) {
        String scope = null;
        if (objects != null && objects.size() > 0) {
            if (ObjectHelper.isEmptyValue(separator)) {
                separator = ",";
            }
            scope = "";
            for (T object : objects) {
                String value = ObjectHelper.getSeparatorValue(object, null, attrName);
                if (!ObjectHelper.isNotEmptyValue(value)) continue;
                scope = String.valueOf(scope) + separator + value;
            }
            if (!"".equals(scope)) {
                scope = scope.substring(separator.length());
            }
        }
        return scope;
    }

    public static String parseForScope(Object[] objects) {
        return ObjectHelper.parseForScope(objects, null);
    }

    public static String parseForScope(Object[] objects, String attrName) {
        return ObjectHelper.parseForScope(objects, null, attrName);
    }

    public static String parseForScope(Object[] objects, String separator, String ... attrName) {
        String scope = null;
        if (objects != null && objects.length > 0) {
            scope = "";
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                String value = ObjectHelper.getSeparatorValue(object, separator, attrName);
                if (ObjectHelper.isNotEmptyValue(value)) {
                    scope = String.valueOf(scope) + ",'" + value + "'";
                }
                ++n2;
            }
            if (!"".equals(scope)) {
                scope = scope.substring(1);
            }
        }
        return scope;
    }

    public static String parseIntForScope(Object[] objects) {
        return ObjectHelper.parseIntForScope(objects, null);
    }

    public static String parseIntForScope(Object[] objects, String attrName) {
        return ObjectHelper.parseIntForScope(objects, null, attrName);
    }

    public static String parseIntForScope(Object[] objects, String separator, String ... attrName) {
        String scope = null;
        if (objects != null && objects.length > 0) {
            scope = "";
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                String value = ObjectHelper.getSeparatorValue(object, separator, attrName);
                if (ObjectHelper.isNotEmptyValue(value)) {
                    scope = String.valueOf(scope) + "," + value;
                }
                ++n2;
            }
            if (!"".equals(scope)) {
                scope = scope.substring(1);
            }
        }
        return scope;
    }

    public static <T> String parseForScope(List<T> list) {
        return ObjectHelper.parseForScope(list, null);
    }

    public static <T> String parseForScope(List<T> list, String attrName) {
        return ObjectHelper.parseForScope(list, null, attrName);
    }

    public static <T> String parseForScope(List<T> list, String separator, String ... attrName) {
        String scope = null;
        if (list != null && list.size() > 0) {
            scope = "";
            for (T object : list) {
                String value = ObjectHelper.getSeparatorValue(object, separator, attrName);
                if (!ObjectHelper.isNotEmptyValue(value)) continue;
                scope = String.valueOf(scope) + ",'" + value + "'";
            }
            if (!"".equals(scope)) {
                scope = scope.substring(1);
            }
        }
        return scope;
    }

    public static <T> String parseIntForScope(List<T> list) {
        return ObjectHelper.parseIntForScope(list, null);
    }

    public static <T> String parseIntForScope(List<T> list, String attrName) {
        return ObjectHelper.parseIntForScope(list, null, attrName);
    }

    public static <T> String parseIntForScope(List<T> list, String separator, String ... attrName) {
        String scope = null;
        if (list != null && list.size() > 0) {
            scope = "";
            for (T object : list) {
                String value = ObjectHelper.getSeparatorValue(object, separator, attrName);
                if (!ObjectHelper.isNotEmptyValue(value)) continue;
                scope = String.valueOf(scope) + "," + value;
            }
            if (!"".equals(scope)) {
                scope = scope.substring(1);
            }
        }
        return scope;
    }

    public static <T, M> String parseIntForScope(Map<T, M> map) {
        return ObjectHelper.parseIntForScope(map, null);
    }

    public static <T, M> String parseIntForScope(Map<T, M> map, String attrName) {
        return ObjectHelper.parseIntForScope(map, null, attrName);
    }

    public static <T, M> String parseIntForScope(Map<T, M> map, String separator, String ... attrName) {
        String scope = null;
        if (map != null && map.size() > 0) {
            scope = "";
            for (T object : map.keySet()) {
                String value = ObjectHelper.getSeparatorValue(object, separator, attrName);
                if (!ObjectHelper.isNotEmptyValue(value)) continue;
                scope = String.valueOf(scope) + "," + value;
            }
            if (!"".equals(scope)) {
                scope = scope.substring(1);
            }
        }
        return scope;
    }

    public static <T, M> String parseForScope(Map<T, M> map) {
        return ObjectHelper.parseForScope(map, null);
    }

    public static <T, M> String parseForScope(Map<T, M> map, String attrName) {
        return ObjectHelper.parseForScope(map, null, attrName);
    }

    public static <T, M> String parseForScope(Map<T, M> map, String separator, String ... attrName) {
        String scope = null;
        if (map != null && map.size() > 0) {
            scope = "";
            for (T object : map.keySet()) {
                String value = ObjectHelper.getSeparatorValue(object, separator, attrName);
                if (!ObjectHelper.isNotEmptyValue(value)) continue;
                scope = String.valueOf(scope) + ",'" + value + "'";
            }
            if (!"".equals(scope)) {
                scope = scope.substring(1);
            }
        }
        return scope;
    }

    public static Map<String, String> parseForMap(Object[] objects) {
        return ObjectHelper.parseForMap(objects, null);
    }

    public static Map<String, String> parseForMapValue(Object[] objects, String keyAttr, String valueAttr) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (objects != null && objects.length > 0) {
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                String key = ObjectHelper.getPropertyValue(object, keyAttr);
                if (ObjectHelper.isNotEmptyValue(key)) {
                    map.put(key, ObjectHelper.getPropertyValue(object, valueAttr));
                }
                ++n2;
            }
        }
        return map;
    }

    public static Map<String, String> parseForMapUnionValue(Object[] objects, String valueAttr, String separator, String ... keyAttr) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (objects != null && objects.length > 0) {
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                String key = ObjectHelper.getSeparatorValue(object, separator, keyAttr);
                if (ObjectHelper.isNotEmptyValue(key)) {
                    map.put(key, ObjectHelper.getPropertyValue(object, valueAttr));
                }
                ++n2;
            }
        }
        return map;
    }

    public static <T> Map<String, String> parseForMapValue(List<T> objects, String keyAttr, String valueAttr) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (objects != null && objects.size() > 0) {
            for (T object : objects) {
                String key = ObjectHelper.getPropertyValue(object, keyAttr);
                if (!ObjectHelper.isNotEmptyValue(key)) continue;
                map.put(key, ObjectHelper.getPropertyValue(object, valueAttr));
            }
        }
        return map;
    }

    public static <T> Map<String, String> parseForMapUnionValue(List<T> objects, String valueAttr, String separator, String ... keyAttr) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (objects != null && objects.size() > 0) {
            for (T object : objects) {
                String key = ObjectHelper.getSeparatorValue(object, separator, keyAttr);
                if (!ObjectHelper.isNotEmptyValue(key)) continue;
                map.put(key, ObjectHelper.getPropertyValue(object, valueAttr));
            }
        }
        return map;
    }

    public static Map<String, String> parseForMap(Object[] objects, String attrName) {
        return ObjectHelper.parseForMap(objects, null, attrName);
    }

    public static Map<String, String> parseForMap(Object[] objects, String separator, String ... attrName) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (objects != null && objects.length > 0) {
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                String value = ObjectHelper.getSeparatorValue(object, separator, attrName);
                if (ObjectHelper.isNotEmptyValue(value)) {
                    map.put(value, "1");
                }
                ++n2;
            }
        }
        return map;
    }

    public static <T> Map<T, String> parseArrayForMap(T[] objects) {
        Class<T> claName = ObjectHelper.getArrayClassName(objects);
        return claName == null ? new HashMap() : ObjectHelper.parseArrayForMap(objects, null, claName);
    }

    public static <T> Map<T, String> parseArrayForMap(Object[] objects, String attrName, Class<T> claName) {
        HashMap<T, String> map = new HashMap<T, String>();
        if (objects != null && objects.length > 0) {
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                T value = ObjectHelper.getPropertyValue(object, claName, attrName);
                if (ObjectHelper.isNotEmptyValue(value)) {
                    map.put(value, "1");
                }
                ++n2;
            }
        }
        return map;
    }

    public static <T> Map<String, T> parseForMapObject(T[] objects) {
        return ObjectHelper.parseForMapObject(objects, null);
    }

    public static <T> Map<String, T> parseForMapObject(T[] objects, String attrName) {
        return ObjectHelper.parseForMapObject(objects, null, attrName);
    }

    public static <T> Map<String, T> parseForMapObject(T[] objects, String separator, String ... attrName) {
        HashMap<String, T> map = new HashMap<String, T>();
        if (objects != null && objects.length > 0) {
            T[] TArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                T object = TArray[n2];
                String value = ObjectHelper.getSeparatorValue(object, separator, attrName);
                if (ObjectHelper.isNotEmptyValue(value)) {
                    map.put(value, object);
                }
                ++n2;
            }
        }
        return map;
    }

    public static <M, T> Map<M, T> parseArrayForMapObject(T[] objects, String attrName, Class<M> claName) {
        HashMap<M, T> map = new HashMap<M, T>();
        if (objects != null && objects.length > 0) {
            T[] TArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                T object = TArray[n2];
                M value = ObjectHelper.getPropertyValue(object, claName, attrName);
                if (ObjectHelper.isNotEmptyValue(value)) {
                    map.put(value, object);
                }
                ++n2;
            }
        }
        return map;
    }

    public static <M, T> Map<M, List<T>> parseArrayForMapList(T[] objects, String attrName, Class<M> claName) {
        HashMap map = new HashMap();
        if (objects != null && objects.length > 0) {
            T[] TArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                T object = TArray[n2];
                M value = ObjectHelper.getPropertyValue(object, claName, attrName);
                if (ObjectHelper.isNotEmptyValue(value)) {
                    if (map.get(value) == null) {
                        map.put(value, new ArrayList());
                    }
                    ((List)map.get(value)).add(object);
                }
                ++n2;
            }
        }
        return map;
    }

    public static <T> Map<String, List<T>> parseArrayForMapList(T[] objects, String separator, String ... attrName) {
        HashMap<String, List<T>> map = new HashMap<String, List<T>>();
        if (objects != null && objects.length > 0) {
            T[] TArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                T object = TArray[n2];
                String value = ObjectHelper.getSeparatorValue(object, separator, attrName);
                if (ObjectHelper.isNotEmptyValue(value)) {
                    if (map.get(value) == null) {
                        map.put(value, new ArrayList());
                    }
                    ((List)map.get(value)).add(object);
                }
                ++n2;
            }
        }
        return map;
    }

    public static <T> Map<String, String> parseForMap(List<T> list) {
        return ObjectHelper.parseForMap(list, null);
    }

    public static <T> Map<String, String> parseForMap(List<T> list, String attrName) {
        return ObjectHelper.parseForMap(list, null, attrName);
    }

    public static <T> Map<String, String> parseForMap(List<T> list, String separator, String ... attrName) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (list != null && list.size() > 0) {
            for (T object : list) {
                String value = ObjectHelper.getSeparatorValue(object, separator, attrName);
                if (!ObjectHelper.isNotEmptyValue(value)) continue;
                map.put(value, "1");
            }
        }
        return map;
    }

    public static <T> Map<T, String> parseArrayForMap(List<T> list) {
        Class<T> claName = ObjectHelper.getArrayClassName(list);
        return claName == null ? new HashMap() : ObjectHelper.parseArrayForMap(list, null, claName);
    }

    public static <T, M> Map<M, String> parseArrayForMap(List<T> list, String attrName, Class<M> claName) {
        HashMap<M, String> map = new HashMap<M, String>();
        if (list != null && list.size() > 0) {
            for (T object : list) {
                M value = ObjectHelper.getPropertyValue(object, claName, attrName);
                if (!ObjectHelper.isNotEmptyValue(value)) continue;
                map.put(value, "1");
            }
        }
        return map;
    }

    public static <T> Map<String, T> parseForMapObject(List<T> list) {
        return ObjectHelper.parseForMapObject(list, null);
    }

    public static <T> Map<String, T> parseForMapObject(List<T> list, String attrName) {
        return ObjectHelper.parseForMapObject(list, null, attrName);
    }

    public static <T> Map<String, T> parseForMapObject(List<T> list, String separator, String ... attrName) {
        HashMap<String, T> map = new HashMap<String, T>();
        if (list != null && list.size() > 0) {
            for (T object : list) {
                String value = ObjectHelper.getSeparatorValue(object, separator, attrName);
                if (!ObjectHelper.isNotEmptyValue(value)) continue;
                map.put(value, object);
            }
        }
        return map;
    }

    public static <T> List<String> parseForList(List<T> list, String attrName) {
        return ObjectHelper.parseForList(list, null, attrName);
    }

    public static <T> List<String> parseForList(T[] list, String attrName) {
        return ObjectHelper.parseForList(list, null, attrName);
    }

    public static <T> List<String> parseForList(Map<T, ?> map, String attrName) {
        return ObjectHelper.parseForList(map, null, attrName);
    }

    public static <T> List<String> parseForList(List<T> list, String separator, String ... attrName) {
        ArrayList<String> resultList = new ArrayList<String>();
        if (list != null && list.size() > 0) {
            for (T object : list) {
                String value = ObjectHelper.getSeparatorValue(object, separator, attrName);
                if (!ObjectHelper.isNotEmptyValue(value)) continue;
                resultList.add(value);
            }
        }
        return resultList;
    }

    public static <T> List<String> parseForList(T[] list, String separator, String ... attrName) {
        ArrayList<String> resultList = new ArrayList<String>();
        if (list != null && list.length > 0) {
            T[] TArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                T object = TArray[n2];
                String value = ObjectHelper.getSeparatorValue(object, separator, attrName);
                if (ObjectHelper.isNotEmptyValue(value)) {
                    resultList.add(value);
                }
                ++n2;
            }
        }
        return resultList;
    }

    public static <T> List<String> parseForList(Map<T, ?> map, String separator, String ... attrName) {
        ArrayList<String> resultList = new ArrayList<String>();
        if (map != null && map.size() > 0) {
            for (T object : map.keySet()) {
                String value = ObjectHelper.getSeparatorValue(object, separator, attrName);
                if (!ObjectHelper.isNotEmptyValue(value)) continue;
                resultList.add(value);
            }
        }
        return resultList;
    }

    public static <T, M> List<M> parseForList(T[] list, String attrName, Class<M> claName) {
        ArrayList<M> resultList = new ArrayList<M>();
        if (list != null && list.length > 0) {
            T[] TArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                T object = TArray[n2];
                M value = ObjectHelper.getPropertyValue(object, claName, attrName);
                if (ObjectHelper.isNotEmptyValue(value)) {
                    resultList.add(value);
                }
                ++n2;
            }
        }
        return resultList;
    }

    public static <T> List<T> parseForList(Map<T, ?> map) {
        ArrayList<T> resultList = new ArrayList<T>();
        if (map != null && map.size() > 0) {
            for (T object : map.keySet()) {
                if (!ObjectHelper.isNotEmptyValue(object)) continue;
                resultList.add(object);
            }
        }
        return resultList;
    }

    public static <T> List<T> parseForValueList(Map<?, T> map) {
        ArrayList<T> resultList = new ArrayList<T>();
        if (map != null && map.size() > 0) {
            for (T object : map.values()) {
                if (!ObjectHelper.isNotEmptyValue(object)) continue;
                resultList.add(object);
            }
        }
        return resultList;
    }

    public static <T, M> List<M> parseForList(Map<T, Object> map, String attrName, Class<M> claName) {
        ArrayList<M> resultList = new ArrayList<M>();
        if (map != null && map.size() > 0) {
            for (T object : map.keySet()) {
                M value = ObjectHelper.getPropertyValue(object, claName, attrName);
                if (!ObjectHelper.isNotEmptyValue(value)) continue;
                resultList.add(value);
            }
        }
        return resultList;
    }

    public static <T, M> List<M> parseForList(List<T> list, String attrName, Class<M> claName) {
        ArrayList<M> resultList = new ArrayList<M>();
        if (list != null && list.size() > 0) {
            for (T object : list) {
                M value = ObjectHelper.getPropertyValue(object, claName, attrName);
                if (!ObjectHelper.isNotEmptyValue(value)) continue;
                resultList.add(value);
            }
        }
        return resultList;
    }

    public static <M, T> Map<M, T> parseArrayForMapObject(List<T> list, String attrName, Class<M> claName) {
        HashMap<M, T> map = new HashMap<M, T>();
        if (list != null && list.size() > 0) {
            for (T object : list) {
                M value = ObjectHelper.getPropertyValue(object, claName, attrName);
                if (!ObjectHelper.isNotEmptyValue(value)) continue;
                map.put(value, object);
            }
        }
        return map;
    }

    public static <M, T> Map<M, List<T>> parseArrayForMapList(List<T> list, String attrName, Class<M> claName) {
        HashMap map = new HashMap();
        if (list != null && list.size() > 0) {
            for (T object : list) {
                M value = ObjectHelper.getPropertyValue(object, claName, attrName);
                if (!ObjectHelper.isNotEmptyValue(value)) continue;
                if (map.get(value) == null) {
                    map.put(value, new ArrayList());
                }
                ((List)map.get(value)).add(object);
            }
        }
        return map;
    }

    public static <T> Map<String, List<T>> parseArrayForMapList(List<T> list, String separator, String ... attrName) {
        HashMap<String, List<T>> map = new HashMap<String, List<T>>();
        if (list != null && list.size() > 0) {
            for (T object : list) {
                String value = ObjectHelper.getSeparatorValue(object, separator, attrName);
                if (!ObjectHelper.isNotEmptyValue(value)) continue;
                if (map.get(value) == null) {
                    map.put(value, new ArrayList());
                }
                ((List)map.get(value)).add(object);
            }
        }
        return map;
    }

    public static String getPropertyValue(Object obj, String attrName) {
        return ObjectHelper.getPropertyValue(obj, attrName, null);
    }

    public static String getPropertyValue(Object obj, String attrName, String defaultValue) {
        try {
            Object value = ObjectHelper.containProperty(obj, attrName) ? BeanUtils.getProperty(obj, attrName) : obj;
            return ObjectHelper.isEmptyValue(value) ? defaultValue : value.toString();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public static <T> T getPropertyValue(Object obj, Class<T> claName, String attrName) {
        return ObjectHelper.getPropertyValue(obj, attrName, claName, null);
    }

    public static <T> T getPropertyValue(Object obj, String attrName, Class<T> claName, T defaultValue) {
        try {
            if (obj == null) {
                return defaultValue;
            }
            Object value = ObjectHelper.containProperty(obj, attrName) ? ObjectHelper.getAttrValue(obj, attrName, claName) : obj;
            return (T)ObjectHelper.convertEmptyToValue(value, defaultValue);
        }
        catch (Throwable throwable) {
            return defaultValue;
        }
    }

    public static String getSeparatorValue(Object object, String separator, String ... attrNames) {
        if (ObjectHelper.isEmptyValue(object)) {
            return null;
        }
        if (attrNames == null || attrNames.length == 0) {
            return ObjectHelper.getPropertyValue(object, null);
        }
        String value = "";
        int i = 0;
        while (i < attrNames.length) {
            String str = i == 0 ? "" : ObjectHelper.convertNullToEmpty(separator);
            value = String.valueOf(value) + str + ObjectHelper.convertNullToEmpty(ObjectHelper.getPropertyValue(object, attrNames[i]));
            ++i;
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean containProperty(Object obj, String attrName) {
        if (ObjectHelper.isEmptyValue(attrName)) {
            return false;
        }
        try {
            PropertyDescriptor[] list = PropertyUtils.getPropertyDescriptors(obj);
            if (list == null) return false;
            if (list.length <= 0) return false;
            PropertyDescriptor[] propertyDescriptorArray = list;
            int n = list.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n2];
                if (propertyDescriptor != null && attrName.equals(propertyDescriptor.getName())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static <T> Class<T> getArrayClassName(T[] objects) {
        if (objects != null && objects.length > 0) {
            T[] TArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                T obj = TArray[n2];
                Class<T> claName = ObjectHelper.getClassName(obj);
                if (claName != null) {
                    return claName;
                }
                ++n2;
            }
        }
        return null;
    }

    public static <T> Class<T> getArrayClassName(List<T> objects) {
        if (objects != null && objects.size() > 0) {
            for (T obj : objects) {
                Class<T> claName = ObjectHelper.getClassName(obj);
                if (claName == null) continue;
                return claName;
            }
        }
        return null;
    }

    public static <T> Class<T> getClassName(T obj) {
        return obj != null ? obj.getClass() : null;
    }

    public static <T> T getAttrValue(Object obj, String attrName, Class<T> claName) {
        try {
            Object value = ObjectHelper.getFieldObject(obj, attrName);
            if (value != null) {
                return (T)value;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isEmptyValue(Object ... values) {
        boolean flag = true;
        if (values != null && values.length > 0) {
            Object[] objectArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object s = objectArray[n2];
                if (s != null && !"".equals(s.toString().trim())) {
                    flag = false;
                    break;
                }
                ++n2;
            }
        }
        return flag;
    }

    public static boolean isNotEmptyValue(Object ... values) {
        boolean flag;
        boolean bl = flag = values != null && values.length > 0;
        if (flag) {
            Object[] objectArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object s = objectArray[n2];
                if (s == null || "".equals(s.toString().trim())) {
                    flag = false;
                    break;
                }
                ++n2;
            }
        }
        return flag;
    }

    public static int samePhoneValue(String phoneNo, String telNo) {
        int value = 0;
        if (ObjectHelper.isNotEmptyValue(phoneNo, telNo)) {
            boolean telMobileFlag;
            telNo = telNo.replace("-", "");
            phoneNo = phoneNo.replace("-", "");
            if (ObjectHelper.isEmptyValue(telNo) || ObjectHelper.isEmptyValue(phoneNo)) {
                return 0;
            }
            boolean phoneMobileFlag = phoneNo.startsWith("01") && phoneNo.length() == 12 || phoneNo.startsWith("1") && phoneNo.length() == 11;
            boolean bl = telMobileFlag = telNo.startsWith("01") && telNo.length() == 12 || telNo.startsWith("1") && telNo.length() == 11;
            if (phoneMobileFlag && telMobileFlag) {
                if (phoneNo.startsWith("01")) {
                    phoneNo = phoneNo.substring(1);
                }
                if (telNo.startsWith("01")) {
                    telNo = telNo.substring(1);
                }
                if (telNo.equals(phoneNo)) {
                    value = 10;
                }
            } else if (!telMobileFlag && !phoneMobileFlag) {
                if (telNo.endsWith(phoneNo) || phoneNo.endsWith(telNo)) {
                    value = 6;
                }
                if (phoneNo.equals(telNo)) {
                    value = 9;
                }
            }
        }
        return value;
    }

    public static String parsePhoneNo(String telNo) {
        boolean telMobileFlag;
        if (ObjectHelper.isEmptyValue(telNo)) {
            return telNo;
        }
        boolean bl = telMobileFlag = (telNo = telNo.replace("-", "")).startsWith("01") && telNo.length() == 12 || telNo.startsWith("1") && telNo.length() == 11;
        if (telMobileFlag) {
            if (telNo.startsWith("01")) {
                telNo = telNo.substring(1);
            }
        } else if (telNo.startsWith("0") && telNo.length() > 4) {
            telNo = telNo.startsWith("010") || telNo.startsWith("026") || telNo.startsWith("020") || telNo.startsWith("021") || telNo.startsWith("022") || telNo.startsWith("023") || telNo.startsWith("024") || telNo.startsWith("025") || telNo.startsWith("027") || telNo.startsWith("028") || telNo.startsWith("029") ? telNo.substring(3) : telNo.substring(4);
        }
        return telNo;
    }

    public static String[] covertObjectArrayToStringArray(Object[] objs) {
        if (objs != null) {
            String[] values = new String[objs.length];
            int i = 0;
            while (i < objs.length) {
                if (objs[i] != null) {
                    values[i] = objs[i].toString();
                }
                ++i;
            }
            return values;
        }
        return null;
    }

    public static <T> String[] covertListToStringArray(List<T> objList) {
        if (objList != null && objList.size() > 0) {
            String[] values = new String[objList.size()];
            int i = 0;
            while (i < objList.size()) {
                if (objList.get(i) != null) {
                    values[i] = objList.get(i).toString();
                }
                ++i;
            }
            return values;
        }
        return null;
    }

    public static String getPointValue(Object num, Integer size) {
        String value = ObjectHelper.trimNullToEmpty(num);
        Integer length = value.length();
        int i = 0;
        while (i < size - length) {
            value = "0" + value;
            ++i;
        }
        return value;
    }

    public static String getBeforCodeValue(Object num, Integer size, String code) {
        return ObjectHelper.getInsertCodeValue(num, size, code, "0");
    }

    public static String getAfterCodeValue(Object num, Integer size, String code) {
        return ObjectHelper.getInsertCodeValue(num, size, code, "1");
    }

    public static String getInsertCodeValue(Object num, Integer size, String code, String fx) {
        String value = ObjectHelper.trimNullToEmpty(num);
        boolean fxFlag = "0".equals(fx);
        Integer length = value.length();
        int i = 0;
        while (i < size - length) {
            value = String.valueOf(fxFlag ? code : "") + value + (fxFlag ? "" : code);
            ++i;
        }
        return value;
    }

    public static String convertNullToEmpty(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    public static String trimNullToEmpty(Object obj) {
        return ObjectHelper.isEmptyValue(obj) ? "" : obj.toString().trim();
    }

    public static String trimEmptyToNull(Object obj) {
        return ObjectHelper.isEmptyValue(obj) ? null : obj.toString().trim();
    }

    public static <T> T convertEmptyToValue(T ... objs) {
        if (objs != null && objs.length > 0) {
            T[] TArray = objs;
            int n = objs.length;
            int n2 = 0;
            while (n2 < n) {
                T obj = TArray[n2];
                if (ObjectHelper.isNotEmptyValue(obj)) {
                    return obj;
                }
                ++n2;
            }
        }
        return null;
    }

    public static String trimEmptyToValue(Object ... objs) {
        if (objs != null && objs.length > 0) {
            Object[] objectArray = objs;
            int n = objs.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (ObjectHelper.isNotEmptyValue(obj)) {
                    return ObjectHelper.trimEmptyToNull(obj);
                }
                ++n2;
            }
        }
        return null;
    }

    public static Method getAttrGetMethod(Object parentObj, String attrName) {
        Method[] methods;
        Method[] methodArray = methods = parentObj.getClass().getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method != null && ("get" + attrName).equalsIgnoreCase(method.getName())) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    public static void setObjectValue(Object parentObj, String attrName, Object valueObj) throws Exception {
        Method[] methods = parentObj.getClass().getMethods();
        Method getMethod = null;
        Method setMethod = null;
        String varName = attrName.substring(0, attrName.indexOf("["));
        String varKey = attrName.substring(attrName.indexOf("[") + 1, attrName.indexOf("]"));
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method != null) {
                if (("get" + varName).equalsIgnoreCase(method.getName())) {
                    getMethod = method;
                }
                if (("set" + varName).equalsIgnoreCase(method.getName())) {
                    setMethod = method;
                }
                if (getMethod != null && setMethod != null) break;
            }
            ++n2;
        }
        HashMap obj = getMethod.invoke(parentObj, new Object[0]);
        if (obj == null) {
            Class<Map> classType = getMethod.getReturnType();
            obj = classType.isAssignableFrom(Map.class) ? new HashMap() : classType.newInstance();
            setMethod.invoke(parentObj, obj);
        }
        if (obj instanceof Map) {
            Class<?> class1 = parentObj.getClass();
            Map map = obj;
            Field mapField = class1.getDeclaredField(varName);
            Type mapType = mapField.getGenericType();
            if (mapType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)mapType;
                Type[] types = parameterizedType.getActualTypeArguments();
                String keyPath = types[0].toString().substring(6).trim();
                String valuePath = types[1].toString().substring(6).trim();
                if (keyPath.equals("java.lang.Integer")) {
                    map.put(Integer.parseInt(varKey), valueObj);
                } else {
                    map.put(varKey, valueObj);
                }
            }
        }
    }

    public static Object newObject(Object parentObj, String attrName) throws Exception {
        Integer index;
        Method[] methods = parentObj.getClass().getMethods();
        Method getMethod = null;
        Method setMethod = null;
        String varName = attrName;
        String varKey = "";
        if (attrName.matches(".*\\[.*\\]$")) {
            varName = attrName.substring(0, attrName.indexOf("["));
            varKey = attrName.substring(attrName.indexOf("[") + 1, attrName.indexOf("]"));
        }
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method != null) {
                if (("get" + varName).equalsIgnoreCase(method.getName())) {
                    getMethod = method;
                }
                if (("set" + varName).equalsIgnoreCase(method.getName())) {
                    setMethod = method;
                }
                if (getMethod != null && setMethod != null) break;
            }
            ++n2;
        }
        Cloneable obj = getMethod.invoke(parentObj, new Object[0]);
        if (obj == null) {
            Class<Object> classType = getMethod.getReturnType();
            obj = classType.isAssignableFrom(Map.class) ? new HashMap() : (classType.isAssignableFrom(List.class) ? new ArrayList() : classType.newInstance());
            setMethod.invoke(parentObj, obj);
        }
        if (obj instanceof Map) {
            Class<?> class1 = parentObj.getClass();
            Field mapField = class1.getDeclaredField(varName);
            Type mapType = mapField.getGenericType();
            if (mapType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)mapType;
                Type[] types = parameterizedType.getActualTypeArguments();
                String keyPath = types[0].toString().substring(6).trim();
                String valuePath = types[1].toString().substring(6).trim();
                if (keyPath.equals("java.lang.Integer")) {
                    Map map = (Map)((Object)obj);
                    if (map.get(Integer.parseInt(varKey)) != null) {
                        obj = map.get(Integer.parseInt(varKey));
                    } else {
                        obj = ObjectHelper.newObjectByPath(valuePath);
                        map.put(Integer.parseInt(varKey), obj);
                    }
                } else {
                    Map map = (Map)((Object)obj);
                    if (map.get(varKey) != null) {
                        obj = map.get(varKey);
                    } else {
                        obj = ObjectHelper.newObjectByPath(valuePath);
                        map.put(varKey, obj);
                    }
                }
            }
        } else if (obj instanceof List && (index = NumberHelper.parseInt(varKey)) != null) {
            Class<?> class1 = parentObj.getClass();
            List objList = obj;
            Field mapField = class1.getDeclaredField(varName);
            Type mapType = mapField.getGenericType();
            if (mapType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)mapType;
                Type[] types = parameterizedType.getActualTypeArguments();
                String valuePath = types[0].toString().substring(6).trim();
                Integer objSize = objList.size();
                if (objSize < index + 1) {
                    int i = objSize;
                    while (i < index + 1) {
                        objList.add(ObjectHelper.newObjectByPath(valuePath));
                        ++i;
                    }
                }
                obj = objList.get(index);
            }
        }
        return obj;
    }

    public static Object getFieldObject(Object parentObj, String attrName) throws Exception {
        Method[] methods = parentObj.getClass().getMethods();
        Method getMethod = null;
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method != null && ("get" + attrName).equalsIgnoreCase(method.getName())) {
                getMethod = method;
                break;
            }
            ++n2;
        }
        return getMethod.invoke(parentObj, new Object[0]);
    }

    public static Object newObjectByPath(String classPath) {
        try {
            Class<?> classType = Class.forName(classPath);
            return classType.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String formatJsonValue(String value) {
        value = ObjectHelper.trimNullToEmpty(value);
        return value.replace("\n", " ").replace("\r", " ").replace("\"", " ");
    }

    public static <T> T[] convertArray(List<T> objList) {
        if (objList != null && objList.size() > 0) {
            int len = objList.size();
            Object[] values = (Object[])Array.newInstance(objList.get(0).getClass(), len);
            int i = 0;
            while (i < len) {
                values[i] = objList.get(i);
                ++i;
            }
            return values;
        }
        return null;
    }

    public static <T> List<T> convertArray(T[] objs) {
        if (objs != null && objs.length > 0) {
            ArrayList<T> valueList = new ArrayList<T>();
            T[] TArray = objs;
            int n = objs.length;
            int n2 = 0;
            while (n2 < n) {
                T obj = TArray[n2];
                valueList.add(obj);
                ++n2;
            }
            return valueList;
        }
        return null;
    }

    public static <T> List<T> splitArrayList(List<T> srcList, int srcPos) {
        return ObjectHelper.splitArrayList(srcList, srcPos, -1);
    }

    public static <T> List<T> splitArrayList(List<T> srcList, int srcPos, int length) {
        ArrayList<T> resultList = new ArrayList<T>();
        if (srcList != null && srcList.size() > srcPos) {
            if (length == -1) {
                length = srcList.size();
            }
            int srcLen = srcList.size();
            int i = srcPos;
            while (i < srcPos + length) {
                if (srcLen <= i) break;
                resultList.add(srcList.get(i));
                ++i;
            }
        }
        return resultList;
    }

    public static <T> String[] parseArray(List<T> objList, String attrName) {
        if (objList != null && objList.size() > 0) {
            List<String> valueList = ObjectHelper.parseForList(objList, attrName);
            return ObjectHelper.convertArray(valueList);
        }
        return null;
    }

    public static <T> String[] parseArray(List<T> objList, String separator, String ... attrName) {
        if (objList != null && objList.size() > 0) {
            List<String> valueList = ObjectHelper.parseForList(objList, separator, attrName);
            return ObjectHelper.convertArray(valueList);
        }
        return null;
    }

    public static <T> String[] parseArray(T[] objs, String attrName) {
        if (objs != null && objs.length > 0) {
            List<String> valueList = ObjectHelper.parseForList(objs, attrName);
            return ObjectHelper.convertArray(valueList);
        }
        return null;
    }

    public static <T> String[] parseArray(T[] objs, String separator, String ... attrName) {
        if (objs != null && objs.length > 0) {
            List<String> valueList = ObjectHelper.parseForList(objs, separator, attrName);
            return ObjectHelper.convertArray(valueList);
        }
        return null;
    }

    public static <T, M> M[] parseArray(List<T> objList, String attrName, Class<M> claName) {
        if (objList != null && objList.size() > 0) {
            List<M> valueList = ObjectHelper.parseForList(objList, attrName, claName);
            return ObjectHelper.convertArray(valueList);
        }
        return null;
    }

    public static int getCharLen(String src, String ch) {
        int maxLen = 0;
        int index = -1;
        while ((index = src.indexOf(ch, index)) > -1) {
            ++index;
            ++maxLen;
        }
        return maxLen;
    }

    public static boolean equalsIn(Object src, Object ... dsts) {
        if (ObjectHelper.isNotEmptyValue(src) && dsts != null && dsts.length > 0) {
            Object[] objectArray = dsts;
            int n = dsts.length;
            int n2 = 0;
            while (n2 < n) {
                String dstValue;
                Object dst = objectArray[n2];
                String srcValue = ObjectHelper.trimNullToEmpty(src);
                if (srcValue.equals(dstValue = ObjectHelper.trimNullToEmpty(dst))) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static <T, M> Map<M, List<T>> parseArrayForMapTree(List<T> treeList, String attrName, String pAttrName, Class<M> claName) {
        HashMap childMap = new HashMap();
        if (treeList == null || treeList.size() == 0) {
            return childMap;
        }
        Map<M, List<T>> pMap = ObjectHelper.parseArrayForMapList(treeList, pAttrName, claName);
        Map<Object, T> map = ObjectHelper.parseArrayForMapObject(treeList, attrName, claName);
        M rootId = null;
        for (T obj : treeList) {
            rootId = ObjectHelper.getAttrValue(obj, pAttrName, claName);
            if (map.get(rootId) == null) break;
        }
        ObjectHelper.parseArrayForMapTreeChild(pMap, rootId, childMap, attrName, claName);
        return childMap;
    }

    private static <M, T> void parseArrayForMapTreeChild(Map<M, List<T>> pMap, M pId, Map<M, List<T>> childMap, String attrName, Class<M> claName) {
        List<T> childList = pMap.get(pId);
        if (childList == null || childList.size() == 0) {
            return;
        }
        for (T obj : childList) {
            M key = ObjectHelper.getAttrValue(obj, attrName, claName);
            List<T> valueList = childMap.get(pId);
            ArrayList<T> myList = new ArrayList<T>();
            if (valueList != null && valueList.size() > 0) {
                for (T value : valueList) {
                    myList.add(value);
                }
            }
            myList.add(obj);
            childMap.put(key, myList);
            ObjectHelper.parseArrayForMapTreeChild(pMap, key, childMap, attrName, claName);
        }
    }

    public static String decodeStr(Object src, Object ... objs) {
        return ObjectHelper.trimEmptyToNull(ObjectHelper.decode(src, objs));
    }

    public static Object decode(Object src, Object ... objs) {
        if (objs != null && objs.length > 0) {
            if (ObjectHelper.isEmptyValue(src) || objs.length == 1) {
                if (objs.length % 2 == 1) {
                    return objs[objs.length - 1];
                }
            } else {
                int index = 0;
                while (index < objs.length - 1) {
                    if (ObjectHelper.equalsIn(src, objs[index])) {
                        return objs[index + 1];
                    }
                    index += 2;
                }
                if (index == objs.length - 1) {
                    return objs[index];
                }
            }
        }
        return null;
    }

    public static String interceptWord(String value, Integer wordLen) {
        String reg = "[\u0000-\u00ff]";
        String str = value = ObjectHelper.trimNullToEmpty(value);
        if (value.length() > wordLen) {
            str = "";
            wordLen = wordLen * 2;
            Integer totalIndex = 0;
            int i = 0;
            while (i < value.length()) {
                String word = value.substring(i, i + 1);
                if ((totalIndex = Integer.valueOf(totalIndex + (word.matches(reg) ? 1 : 2))) > wordLen) break;
                str = String.valueOf(str) + word;
                ++i;
            }
        }
        return str;
    }

    public static <T> T clone(T obj) {
        try {
            return (T)BeanUtils.cloneBean(obj);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void sleep(long sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

