/*
 * Decompiled with CFR 0.152.
 */
package com.cqct.utils;

import com.cqct.utils.ObjectHelper;
import java.math.BigDecimal;
import java.text.DecimalFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberHelper {
    private static int MIN_PONIT_SIZE = 4;

    public static String parseFormatStr(Number value, String format) {
        return NumberHelper.parseFormatValue(value, format, "");
    }

    public static String parseFormatValue(Number value, String format, String defaultValue) {
        String str = null;
        try {
            if (value != null) {
                DecimalFormat df = new DecimalFormat(format);
                str = df.format(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str == null ? defaultValue : str;
    }

    public static String parseFormatStr(Number value, Integer pointSize) {
        return NumberHelper.parseFormatValue(value, pointSize, "");
    }

    public static String parseFormatValue(Number value, Integer pointSize, String defaultValue) {
        String str = null;
        try {
            if (value != null) {
                String format = "#";
                if (pointSize != null) {
                    int i = 1;
                    while (i < pointSize) {
                        format = String.valueOf(format) + "#";
                        ++i;
                    }
                }
                str = NumberHelper.parseFormatStr(value, "0." + format);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str == null ? defaultValue : str;
    }

    public static String parseFormatStr(Object value, Integer pointSize) {
        return NumberHelper.parseFormatStr(NumberHelper.parseNumber(value), pointSize);
    }

    public static String parseFormatValue(Object value, Integer pointSize, String defaultValue) {
        return NumberHelper.parseFormatValue(NumberHelper.parseNumber(value), pointSize, defaultValue);
    }

    public static String parseFormatStr(Object value, String format) {
        return NumberHelper.parseFormatStr(NumberHelper.parseNumber(value), format);
    }

    public static String parseFormatValue(Object value, String format, String defaultValue) {
        return NumberHelper.parseFormatValue(NumberHelper.parseNumber(value), format, defaultValue);
    }

    public static String parseFormatStr(Number value) {
        return NumberHelper.parseFormatValue(value, "");
    }

    public static String parseFormatValue(Number value, String defaltValue) {
        String resultStr = null;
        try {
            if (value != null) {
                DecimalFormat df = new DecimalFormat("#.000000");
                String str = df.format(value);
                String format = "0";
                if (str.contains(".") && str.length() - 1 > str.lastIndexOf(".")) {
                    String suffix = str.substring(str.lastIndexOf(".") + 1);
                    Integer total = suffix.length();
                    String expand = NumberHelper.expandValue("", "0", total);
                    Integer num = 0;
                    while (total >= num + 1 && "0".equals(suffix.substring(total - num - 1, total - num))) {
                        num = num + 1;
                    }
                    if (total > num) {
                        format = String.valueOf(format) + "." + expand.substring(num);
                    }
                }
                resultStr = NumberHelper.parseFormatStr(value, format);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultStr == null ? defaltValue : resultStr;
    }

    public static String parseFormatStr(Object value) {
        return NumberHelper.parseFormatStr(NumberHelper.parseNumber(value));
    }

    public static String parseFormatValue(Object value, String defaultValue) {
        return NumberHelper.parseFormatStr(NumberHelper.parseNumber(value), defaultValue);
    }

    public static Integer parseInt(Number value) {
        return NumberHelper.parseInt(value, null);
    }

    public static Integer parseInt(Number value, Integer defaultValue) {
        Integer i = null;
        try {
            if (value != null) {
                i = Integer.parseInt(NumberHelper.parseFormatStr(value, "#"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return i == null ? defaultValue : i;
    }

    public static Integer parseInt(Object value) {
        return NumberHelper.parseInt(value, null);
    }

    public static Integer parseInt(Object value, Integer defaultValue) {
        return NumberHelper.parseInt(NumberHelper.parseNumber(value), defaultValue);
    }

    public static Long parseLong(Number value) {
        return NumberHelper.parseLong(value, null);
    }

    public static Long parseLong(Number value, Long defaultValue) {
        Long i = null;
        try {
            if (value != null) {
                i = Long.parseLong(NumberHelper.parseFormatStr(value, "#"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return i == null ? defaultValue : i;
    }

    public static Long parseLong(Object value) {
        return NumberHelper.parseLong(NumberHelper.parseNumber(value));
    }

    public static Long parseLong(Object value, Long defaultValue) {
        return NumberHelper.parseLong(NumberHelper.parseNumber(value), defaultValue);
    }

    public static Double parseDouble(Number value, Integer pointSize) {
        return NumberHelper.parseDouble(value, pointSize, null);
    }

    public static Double parseDouble(Number value, Integer pointSize, Double defaultValue) {
        Double d = null;
        try {
            String str = NumberHelper.parseFormatStr(value, pointSize);
            if (str != null && !"".equals(str.trim())) {
                d = Double.valueOf(str);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return d == null ? defaultValue : d;
    }

    public static Double parseDouble(Object value, Integer pointSize) {
        return NumberHelper.parseDouble(NumberHelper.parseNumber(value), pointSize);
    }

    public static Double parseDouble(Object value, Integer pointSize, Double defaultValue) {
        return NumberHelper.parseDouble(NumberHelper.parseNumber(value), pointSize, defaultValue);
    }

    public static Double parseDouble(Number value) {
        return NumberHelper.parseDouble(value, (Integer)MIN_PONIT_SIZE);
    }

    public static Double parseDouble(Number value, Double defaultValue) {
        return NumberHelper.parseDouble(value, (Integer)MIN_PONIT_SIZE, defaultValue);
    }

    public static Double parseDouble(Object value) {
        return NumberHelper.parseDouble(value, (Integer)MIN_PONIT_SIZE);
    }

    public static Double parseDouble(Object value, Double defaultValue) {
        return NumberHelper.parseDouble(value, (Integer)MIN_PONIT_SIZE, defaultValue);
    }

    public static Float parseFloat(Number value, Integer pointSize) {
        return NumberHelper.parseFloat(value, pointSize, null);
    }

    public static Float parseFloat(Number value, Integer pointSize, Float defaultValue) {
        Float f = null;
        try {
            String str = NumberHelper.parseFormatStr(value, pointSize);
            if (str != null && !"".equals(str.trim())) {
                f = Float.valueOf(str);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return f == null ? defaultValue : f;
    }

    public static Float parseFloat(Object value, Integer pointSize) {
        return NumberHelper.parseFloat(NumberHelper.parseNumber(value), pointSize);
    }

    public static Float parseFloat(Object value, Integer pointSize, Float defaultValue) {
        return NumberHelper.parseFloat(NumberHelper.parseNumber(value), pointSize, defaultValue);
    }

    public static Float parseFloat(Number value) {
        return NumberHelper.parseFloat(value, (Integer)MIN_PONIT_SIZE);
    }

    public static Float parseFloat(Number value, Float defaultValue) {
        return NumberHelper.parseFloat(value, (Integer)MIN_PONIT_SIZE, defaultValue);
    }

    public static Float parseFloat(Object value) {
        return NumberHelper.parseFloat(value, (Integer)MIN_PONIT_SIZE);
    }

    public static Float parseFloat(Object value, Float defaultValue) {
        return NumberHelper.parseFloat(value, (Integer)MIN_PONIT_SIZE, defaultValue);
    }

    public static Integer expandValue(Integer src, Integer base, Integer size) {
        if (src == null || base == null || size == null) {
            return null;
        }
        if (size == 0) {
            return src;
        }
        int i = 0;
        while (i < size) {
            src = src * base;
            ++i;
        }
        return src;
    }

    public static String expandValue(String src, String base, Integer size) {
        if (base == null || "".equals(base.trim()) || size == null || size == 0) {
            return src;
        }
        if (src == null) {
            src = "";
        }
        int i = 0;
        while (i < size) {
            src = String.valueOf(base) + src;
            ++i;
        }
        return src;
    }

    public static String parseCurrency(Object value) {
        String str = NumberHelper.parseFormatStr(value, (Integer)2);
        return str == null ? "0.00" : str;
    }

    public static String parseCurrency(Number value) {
        String str = NumberHelper.parseFormatStr(value, (Integer)2);
        return str == null ? "0.00" : str;
    }

    public static Number parseNumber(Object value) {
        Number num = null;
        try {
            if (value != null) {
                "".endsWith(value.toString().trim());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return num;
    }

    public static String parseToSimple(Number value) {
        return NumberHelper.parseFormatStr(value, "#.##");
    }

    public static String parseToSimple(Object value) {
        return NumberHelper.parseFormatStr(value, "#.##");
    }

    public static boolean compSameValue(Number num1, Number num2) {
        String str1 = NumberHelper.parseFormatStr(num1 == null ? (Number)0 : (Number)num1);
        String str2 = NumberHelper.parseFormatStr(num2 == null ? (Number)0 : (Number)num2);
        return str1.equals(str2);
    }

    public static boolean compSameValue(String num1, String num2) {
        String str1 = NumberHelper.parseFormatStr(num1 == null ? "0" : num1);
        String str2 = NumberHelper.parseFormatStr(num2 == null ? "0" : num2);
        return str1.equals(str2);
    }

    public static boolean compSameValue(Number num1, String num2) {
        String str1 = NumberHelper.parseFormatStr(num1 == null ? (Number)0 : (Number)num1);
        String str2 = NumberHelper.parseFormatStr(num2 == null ? "0" : num2);
        return str1.equals(str2);
    }

    public static int getBase10(int value) {
        int base = 1;
        int i = 0;
        while (i < value) {
            base *= 10;
            ++i;
        }
        return base;
    }

    public static Float ceilValue(Float value, int point, int ceilPoint) {
        if (value == null) {
            return value;
        }
        Float fxFlag = Float.valueOf(value.floatValue() < 0.0f ? -1.0f : 1.0f);
        value = Float.valueOf(Math.abs(value.floatValue()));
        Float pointValue = Float.valueOf((float)NumberHelper.getBase10(point) * 1.0f);
        Float cellValue = NumberHelper.mul(value, pointValue);
        Integer base = NumberHelper.getBase10(ceilPoint);
        Long outValue = (cellValue = Float.valueOf(cellValue.floatValue() * (float)base.intValue())).longValue();
        Long lastValue = outValue % (long)base.intValue();
        if (lastValue > 0L) {
            outValue = outValue + (long)base.intValue();
        }
        lastValue = outValue / (long)base.intValue();
        return NumberHelper.dev(Float.valueOf((float)lastValue.longValue() * fxFlag.floatValue()), pointValue);
    }

    public static Float ceilValue(String value, int point, int ceilPoint) {
        if (value == null || "".equals(value.trim())) {
            return null;
        }
        return NumberHelper.ceilValue(NumberHelper.parseFloat(value), point, ceilPoint);
    }

    public static <T> T add(T v1, T v2, T ... v3) {
        T value = NumberHelper.add(v1, v2);
        if (v3.length > 0) {
            T[] TArray = v3;
            int n = v3.length;
            int n2 = 0;
            while (n2 < n) {
                T v = TArray[n2];
                value = NumberHelper.add(value, v);
                ++n2;
            }
        }
        return value;
    }

    public static <T> T add(T v1, T v2) {
        Number value = null;
        if (v1 instanceof Integer) {
            value = (Integer)v1 + (Integer)v2;
        } else if (v1 instanceof Long) {
            value = (Long)v1 + (Long)v2;
        } else if (v1 instanceof Double) {
            BigDecimal b1 = new BigDecimal(Double.toString((Double)v1));
            BigDecimal b2 = new BigDecimal(Double.toString((Double)v2));
            value = b1.add(b2).doubleValue();
        } else if (v1 instanceof Float) {
            BigDecimal b1 = new BigDecimal(Float.toString(((Float)v1).floatValue()));
            BigDecimal b2 = new BigDecimal(Float.toString(((Float)v2).floatValue()));
            value = Float.valueOf(b1.add(b2).floatValue());
        }
        return (T)value;
    }

    public static Integer addInt(Integer v1, Integer v2, Integer ... v3) {
        Integer value = NumberHelper.add(ObjectHelper.convertEmptyToValue(v1, 0), ObjectHelper.convertEmptyToValue(v2, 0));
        if (v3 != null && v3.length > 0) {
            Integer[] integerArray = v3;
            int n = v3.length;
            int n2 = 0;
            while (n2 < n) {
                Integer v = integerArray[n2];
                value = NumberHelper.add(value, ObjectHelper.convertEmptyToValue(v, 0));
                ++n2;
            }
        }
        return value;
    }

    public static Long addLong(Long v1, Long v2, Long ... v3) {
        Long value = NumberHelper.add(ObjectHelper.convertEmptyToValue(v1, 0L), ObjectHelper.convertEmptyToValue(v2, 0L));
        if (v3 != null && v3.length > 0) {
            Long[] longArray = v3;
            int n = v3.length;
            int n2 = 0;
            while (n2 < n) {
                Long v = longArray[n2];
                value = NumberHelper.add(value, ObjectHelper.convertEmptyToValue(v, 0L));
                ++n2;
            }
        }
        return value;
    }

    public static Float addFloat(Float v1, Float v2, Float ... v3) {
        Float value = NumberHelper.add(ObjectHelper.convertEmptyToValue(v1, Float.valueOf(0.0f)), ObjectHelper.convertEmptyToValue(v2, Float.valueOf(0.0f)));
        if (v3 != null && v3.length > 0) {
            Float[] floatArray = v3;
            int n = v3.length;
            int n2 = 0;
            while (n2 < n) {
                Float v = floatArray[n2];
                value = NumberHelper.add(value, ObjectHelper.convertEmptyToValue(v, Float.valueOf(0.0f)));
                ++n2;
            }
        }
        return value;
    }

    public static Double addDouble(Double v1, Double v2, Double ... v3) {
        Double value = NumberHelper.add(ObjectHelper.convertEmptyToValue(v1, 0.0), ObjectHelper.convertEmptyToValue(v2, 0.0));
        if (v3 != null && v3.length > 0) {
            Double[] doubleArray = v3;
            int n = v3.length;
            int n2 = 0;
            while (n2 < n) {
                Double v = doubleArray[n2];
                value = NumberHelper.add(value, ObjectHelper.convertEmptyToValue(v, 0.0));
                ++n2;
            }
        }
        return value;
    }

    public static <T> T mul(T v1, T v2, T ... v3) {
        T value = NumberHelper.mul(v1, v2);
        if (v3.length > 0) {
            T[] TArray = v3;
            int n = v3.length;
            int n2 = 0;
            while (n2 < n) {
                T v = TArray[n2];
                value = NumberHelper.mul(value, v);
                ++n2;
            }
        }
        return value;
    }

    public static <T> T mul(T v1, T v2) {
        Number value = null;
        if (v1 instanceof Integer) {
            value = (Integer)v1 * (Integer)v2;
        } else if (v1 instanceof Long) {
            value = (Long)v1 * (Long)v2;
        } else if (v1 instanceof Double) {
            BigDecimal b1 = new BigDecimal(Double.toString((Double)v1));
            BigDecimal b2 = new BigDecimal(Double.toString((Double)v2));
            value = b1.multiply(b2).doubleValue();
        } else if (v1 instanceof Float) {
            BigDecimal b1 = new BigDecimal(Float.toString(((Float)v1).floatValue()));
            BigDecimal b2 = new BigDecimal(Float.toString(((Float)v2).floatValue()));
            value = Float.valueOf(b1.multiply(b2).floatValue());
        }
        return (T)value;
    }

    public static Integer mulInt(Integer v1, Integer v2, Integer ... v3) {
        Integer value = NumberHelper.mul(ObjectHelper.convertEmptyToValue(v1, 0), ObjectHelper.convertEmptyToValue(v2, 0));
        if (v3 != null && v3.length > 0) {
            Integer[] integerArray = v3;
            int n = v3.length;
            int n2 = 0;
            while (n2 < n) {
                Integer v = integerArray[n2];
                value = NumberHelper.mul(value, ObjectHelper.convertEmptyToValue(v, 0));
                ++n2;
            }
        }
        return value;
    }

    public static Long mulLong(Long v1, Long v2, Long ... v3) {
        Long value = NumberHelper.mul(ObjectHelper.convertEmptyToValue(v1, 0L), ObjectHelper.convertEmptyToValue(v2, 0L));
        if (v3 != null && v3.length > 0) {
            Long[] longArray = v3;
            int n = v3.length;
            int n2 = 0;
            while (n2 < n) {
                Long v = longArray[n2];
                value = NumberHelper.mul(value, ObjectHelper.convertEmptyToValue(v, 0L));
                ++n2;
            }
        }
        return value;
    }

    public static Float mulFloat(Float v1, Float v2, Float ... v3) {
        Float value = NumberHelper.mul(ObjectHelper.convertEmptyToValue(v1, Float.valueOf(0.0f)), ObjectHelper.convertEmptyToValue(v2, Float.valueOf(0.0f)));
        if (v3 != null && v3.length > 0) {
            Float[] floatArray = v3;
            int n = v3.length;
            int n2 = 0;
            while (n2 < n) {
                Float v = floatArray[n2];
                value = NumberHelper.mul(value, ObjectHelper.convertEmptyToValue(v, Float.valueOf(0.0f)));
                ++n2;
            }
        }
        return value;
    }

    public static Double mulDouble(Double v1, Double v2, Double ... v3) {
        Double value = NumberHelper.mul(ObjectHelper.convertEmptyToValue(v1, 0.0), ObjectHelper.convertEmptyToValue(v2, 0.0));
        if (v3 != null && v3.length > 0) {
            Double[] doubleArray = v3;
            int n = v3.length;
            int n2 = 0;
            while (n2 < n) {
                Double v = doubleArray[n2];
                value = NumberHelper.mul(value, ObjectHelper.convertEmptyToValue(v, 0.0));
                ++n2;
            }
        }
        return value;
    }

    public static <T> T sub(T v1, T v2, T ... v3) {
        T value = NumberHelper.sub(v1, v2);
        if (v3.length > 0) {
            T[] TArray = v3;
            int n = v3.length;
            int n2 = 0;
            while (n2 < n) {
                T v = TArray[n2];
                value = NumberHelper.sub(value, v);
                ++n2;
            }
        }
        return value;
    }

    public static <T> T sub(T v1, T v2) {
        Number value = null;
        if (v1 instanceof Integer) {
            value = (Integer)v1 - (Integer)v2;
        } else if (v1 instanceof Long) {
            value = (Long)v1 - (Long)v2;
        } else if (v1 instanceof Double) {
            BigDecimal b1 = new BigDecimal(Double.toString((Double)v1));
            BigDecimal b2 = new BigDecimal(Double.toString((Double)v2));
            value = b1.subtract(b2).doubleValue();
        } else if (v1 instanceof Float) {
            BigDecimal b1 = new BigDecimal(Float.toString(((Float)v1).floatValue()));
            BigDecimal b2 = new BigDecimal(Float.toString(((Float)v2).floatValue()));
            value = Float.valueOf(b1.subtract(b2).floatValue());
        }
        return (T)value;
    }

    public static Integer subInt(Integer v1, Integer v2, Integer ... v3) {
        Integer value = NumberHelper.sub(ObjectHelper.convertEmptyToValue(v1, 0), ObjectHelper.convertEmptyToValue(v2, 0));
        if (v3 != null && v3.length > 0) {
            Integer[] integerArray = v3;
            int n = v3.length;
            int n2 = 0;
            while (n2 < n) {
                Integer v = integerArray[n2];
                value = NumberHelper.sub(value, ObjectHelper.convertEmptyToValue(v, 0));
                ++n2;
            }
        }
        return value;
    }

    public static Long subLong(Long v1, Long v2, Long ... v3) {
        Long value = NumberHelper.sub(ObjectHelper.convertEmptyToValue(v1, 0L), ObjectHelper.convertEmptyToValue(v2, 0L));
        if (v3 != null && v3.length > 0) {
            Long[] longArray = v3;
            int n = v3.length;
            int n2 = 0;
            while (n2 < n) {
                Long v = longArray[n2];
                value = NumberHelper.sub(value, ObjectHelper.convertEmptyToValue(v, 0L));
                ++n2;
            }
        }
        return value;
    }

    public static Float subFloat(Float v1, Float v2, Float ... v3) {
        Float value = NumberHelper.sub(ObjectHelper.convertEmptyToValue(v1, Float.valueOf(0.0f)), ObjectHelper.convertEmptyToValue(v2, Float.valueOf(0.0f)));
        if (v3 != null && v3.length > 0) {
            Float[] floatArray = v3;
            int n = v3.length;
            int n2 = 0;
            while (n2 < n) {
                Float v = floatArray[n2];
                value = NumberHelper.sub(value, ObjectHelper.convertEmptyToValue(v, Float.valueOf(0.0f)));
                ++n2;
            }
        }
        return value;
    }

    public static Double subDouble(Double v1, Double v2, Double ... v3) {
        Double value = NumberHelper.sub(ObjectHelper.convertEmptyToValue(v1, 0.0), ObjectHelper.convertEmptyToValue(v2, 0.0));
        if (v3 != null && v3.length > 0) {
            Double[] doubleArray = v3;
            int n = v3.length;
            int n2 = 0;
            while (n2 < n) {
                Double v = doubleArray[n2];
                value = NumberHelper.sub(value, ObjectHelper.convertEmptyToValue(v, 0.0));
                ++n2;
            }
        }
        return value;
    }

    public static <T> T dev(T v1, T v2) {
        Number value = null;
        if (v1 instanceof Integer) {
            value = (Integer)v1 / (Integer)v2;
        } else if (v1 instanceof Long) {
            value = (Long)v1 / (Long)v2;
        } else if (v1 instanceof Double) {
            BigDecimal b1 = new BigDecimal(Double.toString((Double)v1));
            BigDecimal b2 = new BigDecimal(Double.toString((Double)v2));
            value = b1.divide(b2, MIN_PONIT_SIZE, 4).doubleValue();
        } else if (v1 instanceof Float) {
            BigDecimal b1 = new BigDecimal(Float.toString(((Float)v1).floatValue()));
            BigDecimal b2 = new BigDecimal(Float.toString(((Float)v2).floatValue()));
            value = Float.valueOf(b1.divide(b2, MIN_PONIT_SIZE, 4).floatValue());
        }
        return (T)value;
    }

    public static Integer devInt(Integer v1, Integer v2, Integer ... v3) {
        Integer value = NumberHelper.dev(ObjectHelper.convertEmptyToValue(v1, 0), ObjectHelper.convertEmptyToValue(v2, 1));
        if (v3 != null && v3.length > 0) {
            Integer[] integerArray = v3;
            int n = v3.length;
            int n2 = 0;
            while (n2 < n) {
                Integer v = integerArray[n2];
                value = NumberHelper.dev(value, ObjectHelper.convertEmptyToValue(v, 1));
                ++n2;
            }
        }
        return value;
    }

    public static Long devLong(Long v1, Long v2, Long ... v3) {
        Long value = NumberHelper.dev(ObjectHelper.convertEmptyToValue(v1, 0L), ObjectHelper.convertEmptyToValue(v2, 1L));
        if (v3 != null && v3.length > 0) {
            Long[] longArray = v3;
            int n = v3.length;
            int n2 = 0;
            while (n2 < n) {
                Long v = longArray[n2];
                value = NumberHelper.dev(value, ObjectHelper.convertEmptyToValue(v, 1L));
                ++n2;
            }
        }
        return value;
    }

    public static Float devFloat(Float v1, Float v2, Float ... v3) {
        Float value = NumberHelper.dev(ObjectHelper.convertEmptyToValue(v1, Float.valueOf(0.0f)), ObjectHelper.convertEmptyToValue(v2, Float.valueOf(1.0f)));
        if (v3 != null && v3.length > 0) {
            Float[] floatArray = v3;
            int n = v3.length;
            int n2 = 0;
            while (n2 < n) {
                Float v = floatArray[n2];
                value = NumberHelper.dev(value, ObjectHelper.convertEmptyToValue(v, Float.valueOf(1.0f)));
                ++n2;
            }
        }
        return value;
    }

    public static Double devDouble(Double v1, Double v2, Double ... v3) {
        Double value = NumberHelper.dev(ObjectHelper.convertEmptyToValue(v1, 0.0), ObjectHelper.convertEmptyToValue(v2, 1.0));
        if (v3 != null && v3.length > 0) {
            Double[] doubleArray = v3;
            int n = v3.length;
            int n2 = 0;
            while (n2 < n) {
                Double v = doubleArray[n2];
                value = NumberHelper.dev(value, ObjectHelper.convertEmptyToValue(v, 1.0));
                ++n2;
            }
        }
        return value;
    }
}

