/*
 * Decompiled with CFR 0.152.
 */
package com.cqct.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;

public class FileHelper {
    public static boolean delete(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            return false;
        }
        if (file.isFile()) {
            return FileHelper.deleteFile(fileName);
        }
        return FileHelper.deleteDirectory(fileName);
    }

    public static boolean deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.isFile() && file.exists()) {
            file.delete();
            return true;
        }
        return false;
    }

    public static boolean deleteDirectory(String dir) {
        File dirFile;
        if (!dir.endsWith(File.separator)) {
            dir = String.valueOf(dir) + File.separator;
        }
        if (!(dirFile = new File(dir)).exists() || !dirFile.isDirectory()) {
            return false;
        }
        boolean flag = true;
        File[] files = dirFile.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile() ? !(flag = FileHelper.deleteFile(files[i].getAbsolutePath())) : !(flag = FileHelper.deleteDirectory(files[i].getAbsolutePath()))) break;
            ++i;
        }
        if (!flag) {
            return false;
        }
        return dirFile.delete();
    }

    public static void resetFile(String filePath) throws IOException {
        FileHelper.resetFile(new File(filePath));
    }

    public static void resetDir(String filePath) throws IOException {
        FileHelper.resetDir(new File(filePath));
    }

    public static void resetDir(File file) throws IOException {
        if (file.exists()) {
            FileHelper.delete(file.getAbsolutePath());
        }
        FileHelper.createDir(file);
    }

    public static void resetFile(File file) throws IOException {
        if (file.exists()) {
            FileHelper.delete(file.getAbsolutePath());
        }
        FileHelper.createFile(file);
    }

    public static void createDir(String filePath) throws IOException {
        FileHelper.createDir(new File(filePath));
    }

    public static void createDir(File file) throws IOException {
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static void moveFile(String srcPath, String tarPath) throws IOException {
        FileHelper.moveFile(new File(srcPath), tarPath);
    }

    public static void moveFile(File srcFile, String tarPath) throws IOException {
        if (srcFile != null && srcFile.exists()) {
            if (srcFile.isDirectory()) {
                FileHelper.resetDir(tarPath);
                File[] files = srcFile.listFiles();
                if (files != null && files.length > 0) {
                    File[] fileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        FileHelper.moveFile(file, String.valueOf(tarPath) + File.separator + file.getName());
                        ++n2;
                    }
                }
            } else {
                FileHelper.convertToFile((InputStream)new FileInputStream(srcFile), new File(tarPath));
            }
        } else {
            throw new IOException("\u6587\u4ef6\u627e\u4e0d\u5230");
        }
    }

    public static void moveFile(File srcFile, File tarFile) throws IOException {
        FileHelper.moveFile(srcFile, tarFile.getAbsolutePath());
    }

    public static Integer getFileLen(File file) {
        int k;
        block15: {
            k = 0;
            InputStream inStream = null;
            try {
                try {
                    if (file != null && file.exists()) {
                        inStream = new FileInputStream(file);
                        k = inStream.available();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (inStream != null) {
                            inStream.close();
                            inStream = null;
                        }
                        break block15;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (inStream != null) {
                        inStream.close();
                        inStream = null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (inStream != null) {
                    inStream.close();
                    inStream = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return k;
    }

    public static File convertToFile(byte[] srcByte, File tarFile) throws IOException {
        return FileHelper.convertToFile((InputStream)new ByteArrayInputStream(srcByte), tarFile);
    }

    public static void convertToFile(File srcFile, OutputStream outStream) throws IOException {
        FileHelper.convertToFile((InputStream)new FileInputStream(srcFile), outStream);
    }

    public static void convertToFile(byte[] srcByte, OutputStream outStream) throws IOException {
        FileHelper.convertToFile((InputStream)new ByteArrayInputStream(srcByte), outStream);
    }

    public static void convertToFile(InputStream inStream, OutputStream outStream) throws IOException {
        if (inStream == null || outStream == null) {
            return;
        }
        try {
            try {
                byte[] buff = new byte[1024];
                int readed = -1;
                while ((readed = inStream.read(buff)) > 0) {
                    outStream.write(buff, 0, readed);
                }
                outStream.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException(e);
            }
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                    inStream = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (outStream != null) {
                    outStream.close();
                    outStream = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static File convertToFile(InputStream inStream, File tarFile) throws IOException {
        if (inStream == null) {
            return null;
        }
        if (!tarFile.getParentFile().exists()) {
            tarFile.getParentFile().mkdirs();
        }
        FileHelper.convertToFile(inStream, (OutputStream)new FileOutputStream(tarFile));
        return tarFile;
    }

    public static byte[] convertToByte(String srcPath) throws IOException {
        return FileHelper.convertToByte(new File(srcPath));
    }

    public static byte[] convertToByte(File srcFile) throws IOException {
        if (srcFile == null || !srcFile.exists() || srcFile.isDirectory()) {
            return null;
        }
        return FileHelper.convertToByte(new FileInputStream(srcFile));
    }

    public static byte[] convertToByte(InputStream inStream) throws IOException {
        if (inStream == null) {
            return null;
        }
        byte[] content = null;
        ByteArrayOutputStream outStream = null;
        try {
            try {
                outStream = new ByteArrayOutputStream();
                byte[] buff = new byte[1024];
                int readed = -1;
                while ((readed = inStream.read(buff)) > 0) {
                    outStream.write(buff, 0, readed);
                }
                outStream.flush();
                content = outStream.toByteArray();
                inStream.close();
                outStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException(e);
            }
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                    inStream = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (outStream != null) {
                    outStream.close();
                    outStream = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return content;
    }

    public static byte[] netDownload(String netUrl) throws IOException {
        if (netUrl == null || "".equals(netUrl.trim())) {
            return null;
        }
        return FileHelper.convertToByte(new URL(netUrl).openStream());
    }

    public static String covertToString(String filePath) throws IOException {
        if (filePath == null || "".equals(filePath.trim())) {
            return null;
        }
        return FileHelper.covertToString(new File(filePath));
    }

    public static String covertToString(String filePath, String encode) throws IOException {
        if (filePath == null || "".equals(filePath.trim())) {
            return null;
        }
        return FileHelper.covertToString(new File(filePath), encode);
    }

    public static String covertToString(File srcFile) throws IOException {
        if (srcFile == null || !srcFile.exists() || srcFile.isDirectory()) {
            return null;
        }
        return FileHelper.covertToString(new FileInputStream(srcFile));
    }

    public static String covertToString(File srcFile, String encode) throws IOException {
        if (srcFile == null || !srcFile.exists() || srcFile.isDirectory()) {
            return null;
        }
        return FileHelper.covertToString(new FileInputStream(srcFile), encode);
    }

    public static String covertToString(byte[] srcByte) throws IOException {
        if (srcByte == null || srcByte.length == 0) {
            return null;
        }
        return FileHelper.covertToString(new ByteArrayInputStream(srcByte));
    }

    public static String covertToString(byte[] srcByte, String encode) throws IOException {
        if (srcByte == null || srcByte.length == 0) {
            return null;
        }
        return FileHelper.covertToString(new ByteArrayInputStream(srcByte), encode);
    }

    public static String covertToString(InputStream inStream) throws IOException {
        return FileHelper.covertToString(inStream, "UTF-8");
    }

    public static String covertToString(InputStream inStream, String encode) throws IOException {
        if (inStream == null) {
            return null;
        }
        String content = "";
        BufferedReader buffReader = null;
        InputStreamReader inReader = null;
        try {
            try {
                inReader = new InputStreamReader(inStream, encode);
                String inStr = null;
                StringBuffer sb = new StringBuffer("");
                buffReader = new BufferedReader(inReader);
                while ((inStr = buffReader.readLine()) != null) {
                    sb.append(String.valueOf(inStr) + "\r\n");
                }
                content = sb.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException(e);
            }
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                    inStream = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (inReader != null) {
                    inReader.close();
                    inReader = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (buffReader != null) {
                    buffReader.close();
                    buffReader = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return content.toString();
    }

    public static void appendStringToFile(String content, String filePath) throws IOException {
        FileHelper.appendStringToFile(content, new File(filePath));
    }

    public static void appendStringToFile(String content, File file) throws IOException {
        FileOutputStream outStream = null;
        OutputStreamWriter writer = null;
        try {
            try {
                if (!file.exists()) {
                    FileHelper.createFile(file);
                }
                outStream = new FileOutputStream(file, true);
                writer = new OutputStreamWriter((OutputStream)outStream, "utf-8");
                writer.write(String.valueOf(content) + "\r\n");
                writer.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException(e);
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                    writer = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (outStream != null) {
                    outStream.close();
                    outStream = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static File covertStringToFile(String content, String filePath) throws IOException {
        return FileHelper.covertStringToFile(content, new File(filePath));
    }

    public static File covertStringToFile(String content, File file) throws IOException {
        FileOutputStream outStream = null;
        OutputStreamWriter writer = null;
        try {
            try {
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                outStream = new FileOutputStream(file);
                writer = new OutputStreamWriter((OutputStream)outStream, "utf-8");
                writer.write(content);
                writer.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException(e);
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                outStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    public static File createFile(String filePath) {
        return FileHelper.createFile(new File(filePath));
    }

    public static File createFile(File file) {
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            file.createNewFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return file;
    }

    public static Object clone(Object obj) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
            return ois.readObject();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }
}

