/*
 * Decompiled with CFR 0.152.
 */
package com.cqct.utils;

import com.cqct.utils.ObjectHelper;
import com.cqct.utils.Parser;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateHelper {
    private static final String DEFAULT_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final long DAY_LEN = 86400000L;

    public static Timestamp getformatTimestamp(String source) {
        return DateHelper.formatToTimestamp(source, "yyyy-MM-dd HH:mm");
    }

    public static String getFormatDayCodeStr(String source, String timeType, int forwordLen) {
        return DateHelper.getFormatStr(source, timeType, forwordLen, "yyyyMMdd");
    }

    public static String getFormatStr(String source, String timeType, int forwordLen, String format) {
        return DateHelper.getFormatStr(DateHelper.formatToDate(source), timeType, forwordLen, format);
    }

    public static String getFormatStr(Date source, String timeType, int forwordLen, String format) {
        Timestamp dst = DateHelper.forwordTimestamp(source, timeType, forwordLen);
        return DateHelper.parseDate(dst, format);
    }

    public static Timestamp getCurrentTime() {
        Date date = new Date();
        return new Timestamp(date.getTime());
    }

    public static int daysBetween(Date src, Date dst) {
        if (!ObjectHelper.isNotEmptyValue(src, dst)) {
            return 0;
        }
        Timestamp dst1 = DateHelper.changeTimestamp(dst, "day", 0);
        Timestamp src1 = DateHelper.changeTimestamp(src, "day", 0);
        Long value = src1.getTime() / 86400000L - dst1.getTime() / 86400000L;
        return Math.abs(value.intValue());
    }

    public static int daysBetween(String src, String dst) {
        return DateHelper.daysBetween(DateHelper.formatToDate(src), DateHelper.formatToDate(dst));
    }

    public static long secondBetween(Date src, Date dst) {
        long diff = dst.getTime() - src.getTime();
        long diffSeconds = diff / 1000L % 60L;
        long diffMinutes = diff / 60000L % 60L;
        long diffHours = diff / 3600000L % 24L;
        long diffDays = diff / 86400000L;
        return diffDays * 24L * 60L * 60L + diffHours * 60L * 60L + diffMinutes * 60L + diffSeconds;
    }

    public static Timestamp formatToTimestamp(String source, String format) {
        Timestamp target = null;
        try {
            if (source != null && !"".equals(source.trim())) {
                SimpleDateFormat dateFormat = new SimpleDateFormat(format);
                target = new Timestamp(dateFormat.parse(source).getTime());
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return target;
    }

    public static Timestamp formatToTimestamp(String source, String format, String timeType, int forwordLen) {
        Timestamp target = DateHelper.formatToTimestamp(source, format);
        return DateHelper.forwordTimestamp(target, timeType, forwordLen);
    }

    public static Timestamp getLastTimestamp(String source, String timeType) {
        return DateHelper.getLastTimestamp(source, timeType, 0);
    }

    public static Timestamp getLastTimestamp(String source, String timeType, int forwordLen) {
        Timestamp target = DateHelper.formatToDate(source);
        target = DateHelper.changeTimestamp(target, timeType, forwordLen - 1);
        return DateHelper.changeTimestamp(target, "second", 1);
    }

    public static Timestamp getLastTimestamp(Timestamp source, String timeType) {
        return DateHelper.getLastTimestamp(source, timeType, 0);
    }

    public static Timestamp getLastTimestamp(Timestamp source, String timeType, int forwordLen) {
        source = DateHelper.changeTimestamp(source, timeType, forwordLen - 1);
        return DateHelper.changeTimestamp(source, "second", 1);
    }

    public static Timestamp changeTimestamp(Date source, String timeType, int forwordLen) {
        if (source != null) {
            Calendar targetCal = Calendar.getInstance();
            targetCal.setTime(source);
            return DateHelper.convertTimestamp(targetCal, timeType, forwordLen);
        }
        return null;
    }

    public static Timestamp forwordTimestamp(Date source, String timeType, int forwordLen) {
        if (source != null) {
            Calendar targetCal = Calendar.getInstance();
            targetCal.setTime(source);
            return DateHelper.forwordTimestamp(targetCal, timeType, forwordLen);
        }
        return null;
    }

    public static Timestamp forwordTimestamp(String timeType, int forwordLen) {
        Calendar targetCal = Calendar.getInstance();
        return DateHelper.forwordTimestamp(targetCal, timeType, forwordLen);
    }

    public static String parseDate(Date source, String format) {
        String target = null;
        try {
            if (source != null) {
                SimpleDateFormat dateFormat = new SimpleDateFormat(format);
                target = dateFormat.format(source);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return target;
    }

    public static String getParseDate(Date source) {
        return DateHelper.parseDate(source, "yyyy-MM-dd HH:mm");
    }

    public static Timestamp getBeginTime(String timeType, int forwordLen) {
        Calendar beginCal = Calendar.getInstance();
        return DateHelper.convertTimestamp(beginCal, timeType, forwordLen);
    }

    public static Timestamp getBeginTime(String timeType) {
        return DateHelper.getBeginTime(timeType, 0);
    }

    public static String getBeginStr(String timeType) {
        return DateHelper.getBeginStr(timeType, 0);
    }

    public static String getBeginStr(String timeType, int forwordLen) {
        return DateHelper.getBeginStr(timeType, forwordLen, "yyyy-MM-dd HH:mm");
    }

    public static String getBeginStr(String timeType, int forwordLen, String format) {
        return DateHelper.parseDate(DateHelper.getBeginTime(timeType, forwordLen), format);
    }

    public static Timestamp forwordTimestamp(Calendar calendar, String timeType, int forwordLen) {
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        if ("year".equalsIgnoreCase(timeType)) {
            year -= forwordLen;
        } else if ("week".equalsIgnoreCase(timeType)) {
            day -= forwordLen * 7;
        } else if ("month".equalsIgnoreCase(timeType)) {
            month -= forwordLen;
        } else if ("day".equalsIgnoreCase(timeType)) {
            day -= forwordLen;
        } else if ("hour".equalsIgnoreCase(timeType)) {
            hour -= forwordLen;
        } else if ("minute".equalsIgnoreCase(timeType)) {
            minute -= forwordLen;
        } else if ("second".equalsIgnoreCase(timeType)) {
            second -= forwordLen;
        }
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        return new Timestamp(calendar.getTime().getTime());
    }

    private static Timestamp convertTimestamp(Calendar calendar, String timeType, int forwordLen) {
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        if ("year".equalsIgnoreCase(timeType)) {
            year -= forwordLen;
            month = 0;
            day = 1;
            hour = 0;
            minute = 0;
            second = 0;
        } else if ("week".equalsIgnoreCase(timeType)) {
            day = calendar.get(7) == 1 ? (day -= 6 + forwordLen * 7) : (day -= calendar.get(7) - 2 + forwordLen * 7);
            hour = 0;
            minute = 0;
            second = 0;
        } else if ("month".equalsIgnoreCase(timeType)) {
            month -= forwordLen;
            day = 1;
            hour = 0;
            minute = 0;
            second = 0;
        } else if ("day".equalsIgnoreCase(timeType)) {
            day -= forwordLen;
            hour = 0;
            minute = 0;
            second = 0;
        } else if ("hour".equalsIgnoreCase(timeType)) {
            hour -= forwordLen;
            minute = 0;
            second = 0;
        } else if ("minute".equalsIgnoreCase(timeType)) {
            minute -= forwordLen;
            second = 0;
        } else if ("second".equalsIgnoreCase(timeType)) {
            second -= forwordLen;
        }
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, 0);
        return new Timestamp(calendar.getTime().getTime());
    }

    public static Timestamp getMonthAgoToTimstamp(Date source) {
        return DateHelper.changeTimestamp(source, "day", 30);
    }

    public static Timestamp getForwordDayTime(Date source, int forwordLen) {
        return DateHelper.changeTimestamp(source, "day", forwordLen);
    }

    public static String getMonthAgoToDayString(Date source) {
        return DateHelper.getMonthAgoToString(source, "yyyy-MM-dd");
    }

    public static String getMonthAgoToString(Date source, String farmat) {
        Timestamp targetTime = DateHelper.changeTimestamp(source, "day", 30);
        String timeStr = DateHelper.parseDate(targetTime, farmat);
        return timeStr;
    }

    public static String getMonthAgoToDayCode2(Date source) {
        String timeStr = DateHelper.parseDate(source, "yyyy-MM");
        if (timeStr != null) {
            return timeStr.replace("-", "");
        }
        return null;
    }

    public static String getMonthAgoToDayCode(Date source) {
        String timeStr = DateHelper.getMonthAgoToString(source, "yyyy-MM-dd");
        if (timeStr != null) {
            return timeStr.replace("-", "");
        }
        return null;
    }

    public static String parseToDayCode(String source) {
        return DateHelper.formatToString(source, "yyyyMMdd");
    }

    public static String parseToDayCode(Date source) {
        return DateHelper.parseDate(source, "yyyyMMdd");
    }

    public static String getNowToDayCode() {
        String timeStr = DateHelper.getNowToDayString();
        if (timeStr != null) {
            return timeStr.replace("-", "");
        }
        return null;
    }

    public static String getNowToString(String format) {
        return DateHelper.parseDate(DateHelper.getCurrentTime(), format);
    }

    public static String getNowToDayString() {
        return DateHelper.getNowToString("yyyy-MM-dd");
    }

    public static Timestamp getNowDayTime() {
        return DateHelper.getBeginTime("day", 0);
    }

    public static String getNowDayStr() {
        return DateHelper.getNowDayStr("yyyy-MM-dd HH:mm");
    }

    public static String getNowDayStr(String formart) {
        return DateHelper.parseDate(DateHelper.getNowDayTime(), formart);
    }

    public static String getNowStr() {
        return DateHelper.getNowStr("yyyy-MM-dd HH:mm");
    }

    public static String getNowStr(String format) {
        Date date = new Date();
        return DateHelper.parseDate(date, format);
    }

    public static Timestamp getNowWeekTime() {
        return DateHelper.getBeginTime("week", 0);
    }

    public static String getNowWeekStr() {
        return DateHelper.getNowWeekStr("yyyy-MM-dd HH:mm");
    }

    public static String getNowWeekStr(String formart) {
        return DateHelper.parseDate(DateHelper.getNowWeekTime(), formart);
    }

    public static Timestamp getNowMonthTime() {
        return DateHelper.getBeginTime("month", 0);
    }

    public static String getNowMonthStr() {
        return DateHelper.getNowMonthStr("yyyy-MM-dd HH:mm");
    }

    public static String getNowMonthStr(String formart) {
        return DateHelper.parseDate(DateHelper.getNowMonthTime(), formart);
    }

    public static Timestamp getForwordDayTime(int forwordLen) {
        return DateHelper.getBeginTime("day", forwordLen);
    }

    public static Timestamp getForwordWeekTime(int forwordLen) {
        return DateHelper.getBeginTime("week", forwordLen);
    }

    public static Timestamp getForwordMonthTime(int forwordLen) {
        return DateHelper.getBeginTime("month", forwordLen);
    }

    public static String getDateCodeToDesc(String dateCode, String formart) {
        return DateHelper.getDateCodeToDesc(dateCode, formart, false);
    }

    public static String getDateCodeToDesc(String dateCode, String formart, boolean delPreZorn) {
        if (dateCode == null || dateCode.length() < 8) {
            return null;
        }
        String dateStr = formart;
        try {
            if (formart.contains("yyyy")) {
                String year = dateCode.substring(0, 4);
                dateStr = dateStr.replace("yyyy", year);
            }
            if (formart.contains("MM")) {
                String month = dateCode.substring(4, 6);
                if (delPreZorn) {
                    Integer mInt = Integer.parseInt(month);
                    month = "" + mInt;
                }
                dateStr = dateStr.replace("MM", month);
            }
            if (formart.contains("dd")) {
                String day = dateCode.substring(6, 8);
                if (delPreZorn) {
                    Integer dInt = Integer.parseInt(day);
                    day = "" + dInt;
                }
                dateStr = dateStr.replace("dd", day);
            }
        }
        catch (NumberFormatException e) {
            dateStr = null;
            e.printStackTrace();
        }
        return dateStr;
    }

    public static String getDateDescToCode(String dateDesc, String formart) {
        if (dateDesc == null || "".equals(dateDesc.trim())) {
            return null;
        }
        String value = "";
        try {
            if (formart.contains("yyyy")) {
                value = String.valueOf(value) + dateDesc.substring(0, 4);
                dateDesc = dateDesc.substring(4);
                formart = formart.substring(4);
            }
            int monthIndex = formart.indexOf("MM");
            if (formart.contains("MM")) {
                dateDesc = dateDesc.substring(monthIndex);
                formart = formart.substring(monthIndex);
                if (dateDesc.length() == 1) {
                    value = String.valueOf(value) + "0" + dateDesc;
                    dateDesc = dateDesc.substring(1);
                } else {
                    String str = dateDesc.substring(0, 2);
                    Pattern pattern = Pattern.compile("[0-9]");
                    Matcher matcher = pattern.matcher(str.substring(1));
                    if (matcher.find()) {
                        value = String.valueOf(value) + str;
                        dateDesc = dateDesc.substring(2);
                    } else {
                        value = String.valueOf(value) + "0" + str.substring(0, 1);
                        dateDesc = dateDesc.substring(1);
                    }
                }
                formart = formart.substring(2);
            }
            int dayIndex = formart.indexOf("dd");
            if (formart.contains("dd")) {
                dateDesc = dateDesc.substring(dayIndex);
                formart = formart.substring(dayIndex);
                if (dateDesc.length() == 1) {
                    value = String.valueOf(value) + "0" + dateDesc;
                } else {
                    String str = dateDesc.substring(0, 2);
                    Pattern pattern = Pattern.compile("[0-9]");
                    Matcher matcher = pattern.matcher(str.substring(1));
                    value = matcher.find() ? String.valueOf(value) + str : String.valueOf(value) + "0" + str.substring(0, 1);
                }
            }
        }
        catch (Throwable e) {
            value = null;
            e.printStackTrace();
        }
        return value;
    }

    public static String getMonthDesc(String dateCode) {
        return DateHelper.getDateCodeToDesc(dateCode, "yyyy\u5e74MM\u6708", false);
    }

    public static String getDayDesc(String dateCode) {
        return DateHelper.getDateCodeToDesc(dateCode, "yyyy\u5e74MM\u6708dd\u65e5", false);
    }

    public static String getYearDesc(String dateCode) {
        return DateHelper.getDateCodeToDesc(dateCode, "yyyy\u5e74", false);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public static Timestamp formatToDate(String value) {
        String srcFormat;
        block4: {
            String outValue;
            block6: {
                Object[] objectArray;
                String numValue;
                Parser parser;
                block5: {
                    if (value == null || "".equals(value.trim())) {
                        return null;
                    }
                    outValue = "";
                    if (value.matches("^\\d*$")) break block4;
                    parser = new Parser(value.toString());
                    numValue = null;
                    if (!true) break block5;
                    objectArray = new Object[1];
                    numValue = parser.getNumberStr();
                    objectArray[0] = numValue;
                    if (!ObjectHelper.isNotEmptyValue(objectArray)) break block6;
                }
                do {
                    outValue = String.valueOf(outValue) + (numValue.length() == 1 ? "0" : "") + numValue;
                    objectArray = new Object[1];
                    numValue = parser.getNumberStr();
                    objectArray[0] = numValue;
                } while (ObjectHelper.isNotEmptyValue(objectArray));
            }
            value = outValue;
        }
        if ((srcFormat = "yyyyMMddHHmmss").length() > value.length()) {
            value = String.valueOf(value) + ObjectHelper.getPointValue("", srcFormat.length() - value.length());
            String dateValue = value.substring(0, 4);
            dateValue = String.valueOf(dateValue) + ("00".equals(value.substring(4, 6)) ? "01" : value.substring(4, 6));
            dateValue = String.valueOf(dateValue) + ("00".equals(value.substring(6, 8)) ? "01" : value.substring(6, 8));
            value = dateValue = String.valueOf(dateValue) + value.substring(8);
        }
        return DateHelper.formatToTimestamp(value, srcFormat);
    }

    public static String formatToString(Object obj) {
        return DateHelper.formatToString(obj, null);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public static String formatToString(Object obj, String format) {
        String[] formats;
        String value;
        boolean dateFlag;
        block15: {
            String outValue;
            block17: {
                Object[] objectArray;
                String numValue;
                Parser parser;
                block16: {
                    dateFlag = ObjectHelper.isEmptyValue(format);
                    format = ObjectHelper.trimEmptyToValue(format, "yyyy-MM-dd");
                    if (ObjectHelper.isEmptyValue(obj)) {
                        return "";
                    }
                    if (obj instanceof Date) {
                        return DateHelper.parseDate((Date)obj, format);
                    }
                    value = obj.toString();
                    outValue = "";
                    if (value.matches("^\\d*$")) break block15;
                    parser = new Parser(value.toString());
                    numValue = null;
                    if (!true) break block16;
                    objectArray = new Object[1];
                    numValue = parser.getNumberStr();
                    objectArray[0] = numValue;
                    if (!ObjectHelper.isNotEmptyValue(objectArray)) break block17;
                }
                do {
                    outValue = String.valueOf(outValue) + (numValue.length() == 1 ? "0" : "") + numValue;
                    objectArray = new Object[1];
                    numValue = parser.getNumberStr();
                    objectArray[0] = numValue;
                } while (ObjectHelper.isNotEmptyValue(objectArray));
            }
            value = outValue;
        }
        if (ObjectHelper.isEmptyValue(value)) {
            return null;
        }
        String pointValue = ObjectHelper.getPointValue("", value.length());
        if (pointValue.equals(value)) {
            return null;
        }
        if (dateFlag) {
            if (value.length() == 4) {
                format = "yyyy";
            }
            if (value.length() == 6) {
                format = "yyyy-MM";
            }
        }
        String srcFormat = "";
        String[] stringArray = formats = new String[]{"yyyy", "MM", "dd", "HH", "mm", "ss"};
        int n = formats.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (format.contains(str)) {
                srcFormat = String.valueOf(srcFormat) + str;
            }
            ++n2;
        }
        if (value.length() <= 6 && !srcFormat.startsWith("yyyy")) {
            if (srcFormat.length() > value.length()) {
                value = String.valueOf(value) + ObjectHelper.getPointValue("", srcFormat.length() - value.length());
            } else if (value.length() > srcFormat.length()) {
                value = value.substring(0, srcFormat.length());
            }
            Timestamp srcTime = DateHelper.formatToTimestamp(value, srcFormat);
            return DateHelper.parseDate(srcTime, format);
        }
        value = String.valueOf(value) + ObjectHelper.getPointValue("", 14 - value.length());
        String dateValue = value.substring(0, 4);
        dateValue = String.valueOf(dateValue) + ("00".equals(value.substring(4, 6)) ? "01" : value.substring(4, 6));
        dateValue = String.valueOf(dateValue) + ("00".equals(value.substring(6, 8)) ? "01" : value.substring(6, 8));
        dateValue = String.valueOf(dateValue) + value.substring(8);
        Timestamp srcTime = DateHelper.formatToTimestamp(dateValue, "yyyyMMddHHmmss");
        return DateHelper.parseDate(srcTime, format);
    }

    public static String getDayCode(String dayDesc) {
        return DateHelper.formatToString(dayDesc, "yyyyMMdd");
    }

    public static String date2Str(Date date, String format) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static Date str2Date(String str, String format) {
        if (str == null || "".equals(str)) {
            return null;
        }
        if (format == null || "".equals(format)) {
            format = DEFAULT_FORMAT;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date date = null;
        try {
            date = sdf.parse(str);
            return date;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String timestamp2Str(Timestamp time) {
        Date date = null;
        if (time != null) {
            date = new Date(time.getTime());
        }
        return DateHelper.date2Str(date, DEFAULT_FORMAT);
    }

    public static Timestamp str2Timestamp(String str) {
        Date date = DateHelper.str2Date(str, DEFAULT_FORMAT);
        return new Timestamp(date.getTime());
    }
}

