/*
 * Decompiled with CFR 0.152.
 */
package com.cqct.jzq;

import com.cqct.utils.Crc;
import com.cqct.utils.Crc16;
import com.cqct.utils.Hex;
import com.cqct.utils.StringHelper;
import java.util.Date;

public class JzqPacket {
    private String cmdDetail = "";
    private String FAddrCode;
    private String FCCode;
    private String FSer;
    private String FSEQ;
    private String FDataLen;
    private String FCRC;
    private String FData;
    private String FAFN;
    private Integer FData_count;
    private Integer FData_per_len;
    private String FPacket;
    private String FTransWay;
    private Integer FAddrCodeLen;
    private String FProtocolCode;
    private String FCompanyCode;
    private String FKeyVer;
    private Integer FAddrCodeLen_Size;
    private Integer FAddrCode_Size;
    private Integer FPacketHEAD_Size;
    private Integer FPacketLen_Size;
    private Integer FProtocolVer_Size;
    private Integer FCompanyCode_Size;
    private Integer FCCode_Size;
    private Integer FSer_Size;
    private Integer FSEQ_Size;
    private Integer FKeyVer_Size;
    private Integer FAFN_Size;
    private Integer PNum_Size;
    private Integer FCRC_size;
    private Integer FOOT_size;
    private String FTx_Type;
    private String FVer;
    private String status_power;
    private String status_attack;
    private String packetID;
    private String packetFX;
    private String factoryCode;
    private String meter_packet_key;
    private Integer sf_iot = 1;
    private String thirdDeviceId;
    private String sCommandTitle;

    public String getFactoryCode() {
        return this.factoryCode;
    }

    public void setFactoryCode(String factoryCode) {
        this.factoryCode = factoryCode;
    }

    public String getMeter_packet_key() {
        return this.meter_packet_key;
    }

    public void setMeter_packet_key(String meter_packet_key) {
        this.meter_packet_key = meter_packet_key;
    }

    public String getFVer() {
        return this.FVer;
    }

    public void setFVer(String fVer) {
        this.FVer = fVer;
    }

    private String XANW_MeterCS(String SrcStr) {
        String st = "";
        Integer slen = SrcStr.length();
        Integer j = 0;
        Integer i = 0;
        while (i < slen / 2) {
            Integer v = Integer.parseInt(StringHelper.copy(SrcStr, 2 * i, 2), 16);
            j = v + j;
            i = i + 1;
        }
        st = Integer.toHexString(j);
        st = st.toUpperCase();
        st = StringHelper.rightStr("00" + st, 2);
        return st;
    }

    public String Encrypt_CQCT2(String Src, String Key2, Integer KeyPos) {
        Integer slen = 0;
        Integer i = 0;
        Integer k = 0;
        String dest = "";
        if (Src.length() == 0) {
            return "00";
        }
        Src = Src.toUpperCase();
        int[] b_key = new int[9];
        b_key[1] = Integer.parseInt(StringHelper.copy(Key2, 0, 2), 16);
        b_key[2] = Integer.parseInt(StringHelper.copy(Key2, 2, 2), 16);
        b_key[3] = Integer.parseInt(StringHelper.copy(Key2, 4, 2), 16);
        b_key[4] = Integer.parseInt(StringHelper.copy(Key2, 6, 2), 16);
        b_key[5] = 255 - b_key[1];
        b_key[6] = 255 - b_key[2];
        b_key[7] = 255 - b_key[3];
        b_key[8] = 255 - b_key[4];
        Integer KeyLen = 8;
        slen = Src.length();
        i = 0;
        k = 0;
        dest = "";
        while (i < slen / 2) {
            k = Integer.parseInt(StringHelper.copy(Src, 2 * i, 2), 16);
            KeyPos = KeyPos < KeyLen ? Integer.valueOf(KeyPos + 1) : Integer.valueOf(1);
            k = k ^ b_key[KeyPos];
            dest = String.valueOf(dest) + StringHelper.LeftPadCh(Integer.toHexString(k), "0", 2);
            i = i + 1;
        }
        return dest;
    }

    public void BuildPacket() {
        String sPacket = "";
        String sTmp = "";
        int i = 0;
        int PacketLEN = 0;
        if ("CQCT1.0".equals(this.FProtocolCode)) {
            if (this.FTransWay.equals("PC_SEND_GPRS")) {
                this.FCCode = "A1";
            } else if (this.FTransWay.equals("PC_ANSWER_GPRS")) {
                this.FCCode = "A2";
            } else if (this.FTransWay.equals("GPRS_SEND_PC")) {
                this.FCCode = "B1";
            } else if (this.FTransWay.equals("GPRS_ANSWER_PC")) {
                this.FCCode = "B2";
            }
            sPacket = "2424" + this.FAddrCode + this.FCCode + this.FSer + this.FSEQ;
            sTmp = this.FData;
            this.FData = String.valueOf(this.FAFN) + StringHelper.LeftPadCh(Integer.toHexString(this.FData_per_len), "0", 2) + StringHelper.LeftPadCh(Integer.toHexString(this.FData_count), "0", 2) + sTmp;
            i = this.FData.length() / 2;
            sTmp = StringHelper.LeftPadCh(Integer.toHexString(i), "0", 4);
            sPacket = String.valueOf(sPacket) + StringHelper.copy(sTmp, 2, 2) + StringHelper.copy(sTmp, 0, 2) + this.FData;
            sPacket = String.valueOf(sPacket) + "FFFF" + "23";
            PacketLEN = sPacket.length() / 2;
            sTmp = Crc.CalcCRC(sPacket, 3);
            sPacket = sPacket.substring(0, sPacket.length() - 6);
            this.FPacket = String.valueOf(sPacket) + sTmp + "23";
            this.FPacket = this.FPacket.toUpperCase();
        } else if ("CQCT2.0".equals(this.FProtocolCode) || "CQCT2.0_LLJ".equals(this.FProtocolCode)) {
            if (this.FTransWay.equals("PC_SEND_GPRS")) {
                this.FCCode = "A1";
            } else if (this.FTransWay.equals("PC_ANSWER_GPRS")) {
                this.FCCode = "A2";
            } else if (this.FTransWay.equals("GPRS_SEND_PC")) {
                this.FCCode = "B1";
            } else if (this.FTransWay.equals("GPRS_ANSWER_PC")) {
                this.FCCode = "B2";
            }
            sPacket = "2525FFFF10" + StringHelper.LeftPadCh(Integer.toHexString(this.FAddrCode.length() / 2), "0", 2) + this.FAddrCode + this.FCompanyCode + this.FCCode + this.FSer + this.FSEQ + this.FKeyVer + this.FAFN + StringHelper.LeftPadCh(Integer.toHexString(this.FData_count), "0", 2) + this.FData + "FFFF" + "23";
            i = sPacket.length() / 2;
            sTmp = StringHelper.LeftPadCh(Integer.toHexString(i), "0", 4);
            sPacket = "2525" + StringHelper.copy(sTmp, 2, 2) + StringHelper.copy(sTmp, 0, 2) + "10" + StringHelper.LeftPadCh(Integer.toHexString(this.FAddrCode.length() / 2), "0", 2) + this.FAddrCode + this.FCompanyCode + this.FCCode + this.FSer + this.FSEQ + this.FKeyVer + this.FAFN + StringHelper.LeftPadCh(Integer.toHexString(this.FData_count), "0", 2) + this.FData + "FFFF" + "23";
            PacketLEN = sPacket.length() / 2;
            sTmp = Crc.CalcCRC(sPacket, 3);
            sPacket = sPacket.substring(0, sPacket.length() - 6);
            this.FPacket = String.valueOf(sPacket) + sTmp + "23";
            this.FPacket = this.FPacket.toUpperCase();
        } else if ("CQRQ1.0".equals(this.FProtocolCode)) {
            String host_client = "01";
            if ("30FF".equals(this.FAFN) || "3029".equals(this.FAFN)) {
                host_client = "00";
            }
            sPacket = "68FFFF" + this.FAFN;
            sPacket = String.valueOf(sPacket) + this.packetFX;
            sPacket = String.valueOf(sPacket) + host_client;
            sPacket = String.valueOf(sPacket) + this.FAddrCode;
            sPacket = String.valueOf(sPacket) + this.packetID;
            i = this.FData.length() / 2;
            sTmp = StringHelper.rightStr("0000" + Integer.toHexString(i), 4);
            sPacket = String.valueOf(sPacket) + StringHelper.copy(sTmp, 2, 2) + StringHelper.copy(sTmp, 0, 2);
            sPacket = String.valueOf(sPacket) + this.FData;
            sPacket = String.valueOf(sPacket) + "FFFF";
            sPacket = String.valueOf(sPacket) + "16";
            PacketLEN = sPacket.length() / 2;
            sTmp = StringHelper.rightStr("0000" + Integer.toHexString(PacketLEN), 4);
            sPacket = "68" + StringHelper.copy(sTmp, 2, 2) + StringHelper.copy(sTmp, 0, 2) + StringHelper.rightStr(sPacket, sPacket.length() - 6);
            sPacket = StringHelper.left(sPacket, sPacket.length() - 6);
            byte[] sbuf2 = Crc16.getSendBuf(sPacket);
            String outs = Hex.bytesToHex(sbuf2);
            sPacket = String.valueOf(outs) + "16";
            this.FPacket = sPacket.toUpperCase();
        } else if ("XANW1.0".equals(this.FProtocolCode)) {
            Integer iLen;
            this.FAddrCode = this.FAddrCode.trim();
            sTmp = this.FAddrCode = StringHelper.rightStr("0000000000" + this.FAddrCode, 10);
            String tmpAddr = StringHelper.copy(sTmp, 8, 2);
            tmpAddr = String.valueOf(tmpAddr) + StringHelper.copy(sTmp, 6, 2);
            tmpAddr = String.valueOf(tmpAddr) + StringHelper.copy(sTmp, 4, 2);
            tmpAddr = String.valueOf(tmpAddr) + StringHelper.copy(sTmp, 2, 2);
            tmpAddr = String.valueOf(tmpAddr) + StringHelper.copy(sTmp, 0, 2);
            String FHead = "A5";
            String FFlag = "5A";
            String FEnd = "AA";
            String FBoardXh = "17";
            this.FCompanyCode = "W22".equals(this.FCompanyCode) ? "0161" : "0261";
            if ("0000000000".equals(this.FAddrCode)) {
                FBoardXh = "00";
                this.FCompanyCode = "0000";
            }
            if ("R_METER1".equals(this.FTx_Type)) {
                this.FCCode = "8100";
                this.FData = "0001";
            } else if ("R_METER2".equals(this.FTx_Type)) {
                this.FCCode = "8100";
                this.FData = "0002";
            } else if ("R_METER3".equals(this.FTx_Type)) {
                this.FCCode = "8100";
                this.FData = "0003";
            } else if ("R_METER4".equals(this.FTx_Type)) {
                this.FCCode = "8100";
                this.FData = "0004";
            } else if ("R_METER5".equals(this.FTx_Type)) {
                this.FCCode = "8100";
                this.FData = "0006";
            } else if ("R_METER6".equals(this.FTx_Type)) {
                this.FCCode = "8100";
                this.FData = "0101";
            } else if ("R_METER7".equals(this.FTx_Type)) {
                this.FCCode = "8100";
                this.FData = "0102";
            } else if ("R_METER8".equals(this.FTx_Type)) {
                this.FCCode = "8100";
                this.FData = "0103";
            } else if ("R_METER9".equals(this.FTx_Type)) {
                this.FCCode = "8100";
                this.FData = "0107";
            } else if ("R_METER10".equals(this.FTx_Type)) {
                this.FCCode = "8100";
                this.FData = "0108";
            } else if ("R_METER11".equals(this.FTx_Type)) {
                this.FCCode = "8100";
                this.FData = "010E";
            } else if ("R_METER12".equals(this.FTx_Type)) {
                this.FCCode = "9202";
                this.FData = "01";
            } else if ("R_METER13".equals(this.FTx_Type)) {
                this.FCCode = "9202";
                this.FData = "02";
            } else if ("R_METER14".equals(this.FTx_Type)) {
                this.FCCode = "9202";
                sTmp = "03";
                this.FData = StringHelper.rightStr("0000000000000000" + this.FData, 16);
                this.FData = String.valueOf(sTmp) + this.FData;
            } else if ("R_METER15".equals(this.FTx_Type)) {
                this.FCCode = "8200";
                this.FData = "";
            } else if ("W_METER1".equals(this.FTx_Type)) {
                this.FCCode = "8101";
                String FData_PID = "0001";
                String FData_PLEN = "06";
                sTmp = this.FData;
                sTmp = sTmp.replace('.', ',');
                sTmp = sTmp.replace(':', ',');
                String[] strIpPort = sTmp.split(",");
                String FData_PV = "";
                Integer v = 0;
                while (v < 5) {
                    i = strIpPort.length < v + 1 ? 0 : Integer.parseInt(strIpPort[v]);
                    FData_PV = v < 4 ? String.valueOf(FData_PV) + StringHelper.rightStr("00" + Integer.toHexString(i), 2) : String.valueOf(FData_PV) + StringHelper.rightStr("0000" + Integer.toHexString(i), 4);
                    v = v + 1;
                }
                this.FData = String.valueOf(FData_PID) + FData_PLEN + FData_PV;
            } else if ("W_METER2".equals(this.FTx_Type)) {
                this.FCCode = "8101";
                String FData_PID = "0003";
                String FData_PLEN = "07";
                String FData_PV = StringHelper.left(String.valueOf(this.FData) + "00000000000000", 14);
                this.FData = String.valueOf(FData_PID) + FData_PLEN + FData_PV;
            } else if ("W_METER3".equals(this.FTx_Type)) {
                this.FCCode = "8101";
                String FData_PID = "0004";
                String FData_PLEN = "05";
                sTmp = StringHelper.left(String.valueOf(this.FData) + "00000000000000", 14);
                sTmp = StringHelper.rightStr(sTmp, 12);
                sTmp = StringHelper.left(sTmp, 10);
                String sTmp1 = StringHelper.left(sTmp, 2);
                i = Integer.parseInt(sTmp1);
                String FData_PV = StringHelper.rightStr("00" + Integer.toHexString(i), 2);
                sTmp = StringHelper.rightStr(sTmp, 8);
                sTmp1 = StringHelper.left(sTmp, 2);
                i = Integer.parseInt(sTmp1);
                FData_PV = String.valueOf(FData_PV) + StringHelper.rightStr("00" + Integer.toHexString(i), 2);
                sTmp = StringHelper.rightStr(sTmp, 6);
                sTmp1 = StringHelper.left(sTmp, 2);
                i = Integer.parseInt(sTmp1);
                FData_PV = String.valueOf(FData_PV) + StringHelper.rightStr("00" + Integer.toHexString(i), 2);
                sTmp = StringHelper.rightStr(sTmp, 4);
                sTmp1 = StringHelper.left(sTmp, 2);
                i = Integer.parseInt(sTmp1);
                FData_PV = String.valueOf(FData_PV) + StringHelper.rightStr("00" + Integer.toHexString(i), 2);
                sTmp1 = sTmp = StringHelper.rightStr(sTmp, 2);
                i = Integer.parseInt(sTmp1);
                FData_PV = String.valueOf(FData_PV) + StringHelper.rightStr("00" + Integer.toHexString(i), 2);
                this.FData = String.valueOf(FData_PID) + FData_PLEN + FData_PV;
            } else if ("W_METER4".equals(this.FTx_Type)) {
                this.FCCode = "8101";
                String FData_PID = "0006";
                String FData_PLEN = "07";
                String FData_PV = StringHelper.left(String.valueOf(this.FData) + "00000000000000", 14);
                this.FData = String.valueOf(FData_PID) + FData_PLEN + FData_PV;
            } else if ("W_METER5".equals(this.FTx_Type)) {
                this.FCCode = "8101";
                String FData_PID = "0101";
                String FData_PLEN = "05";
                i = (int)Math.ceil(Double.parseDouble(this.FData) * 10.0);
                String FData_PV = "01";
                FData_PV = String.valueOf(FData_PV) + StringHelper.rightStr("00000000" + Integer.toHexString(i), 8);
                this.FData = String.valueOf(FData_PID) + FData_PLEN + FData_PV;
            } else if ("W_METER6".equals(this.FTx_Type)) {
                this.FCCode = "8101";
                String FData_PID = "0102";
                String FData_PLEN = "01";
                i = Integer.parseInt(this.FData);
                String FData_PV = StringHelper.rightStr("00" + Integer.toHexString(i), 2);
                this.FData = String.valueOf(FData_PID) + FData_PLEN + FData_PV;
            } else if ("W_METER7".equals(this.FTx_Type)) {
                this.FCCode = "8101";
                String FData_PID = "0103";
                String FData_PLEN = "01";
                i = Integer.parseInt(this.FData);
                i = (i /= 10) < 0 ? 10 : (i *= 10);
                String FData_PV = StringHelper.rightStr("00" + Integer.toHexString(i), 2);
                this.FData = String.valueOf(FData_PID) + FData_PLEN + FData_PV;
            } else if ("W_METER8".equals(this.FTx_Type)) {
                this.FCCode = "8101";
                String FData_PID = "010E";
                String FData_PLEN = "01";
                i = Integer.parseInt(this.FData);
                String FData_PV = StringHelper.rightStr("00" + Integer.toHexString(i), 2);
                this.FData = String.valueOf(FData_PID) + FData_PLEN + FData_PV;
            } else if ("W_METER9".equals(this.FTx_Type)) {
                this.FCCode = "8101";
                String FData_PID = "0206";
                String FData_PLEN = "04";
                String FData_PV = StringHelper.left(String.valueOf(this.FData) + "00000000000000000000000000000000", 32);
                i = Integer.parseInt(FData_PV, 2);
                FData_PV = StringHelper.rightStr("00000000" + Integer.toHexString(i), 8);
                this.FData = String.valueOf(FData_PID) + FData_PLEN + FData_PV;
            } else if ("W_METER10".equals(this.FTx_Type)) {
                this.FCCode = "9201";
                this.FData = "55";
            } else if ("W_METER11".equals(this.FTx_Type)) {
                this.FCCode = "9201";
                this.FData = "AA";
            } else if ("W_METER12".equals(this.FTx_Type)) {
                String FData_PLEN;
                String FData_PID;
                this.FCCode = "8201";
                String FData_PV = this.FData.trim();
                sTmp = StringHelper.rightStr("0000000000" + FData_PV, 10);
                if ("0000000000".equals(sTmp)) {
                    FData_PID = "00";
                    FData_PLEN = "0000";
                } else {
                    FData_PID = "10";
                    FData_PLEN = "0261";
                }
                FData_PV = StringHelper.copy(sTmp, 8, 2);
                FData_PV = String.valueOf(FData_PV) + StringHelper.copy(sTmp, 6, 2);
                FData_PV = String.valueOf(FData_PV) + StringHelper.copy(sTmp, 4, 2);
                FData_PV = String.valueOf(FData_PV) + StringHelper.copy(sTmp, 2, 2);
                FData_PV = String.valueOf(FData_PV) + StringHelper.copy(sTmp, 0, 2);
                this.FData = String.valueOf(FData_PID) + FData_PV + FData_PLEN;
                FData_PV = StringHelper.date2Str(new Date(), "yyyyMMddHHmmss");
                this.FData = String.valueOf(this.FData) + FData_PV;
            } else if ("W_METER13".equals(this.FTx_Type)) {
                this.FCCode = "F900";
                i = Integer.parseInt(this.FData);
                this.FData = StringHelper.rightStr("00" + Integer.toHexString(i), 2);
            } else if ("EXTD_W_METER1".equals(this.FTx_Type)) {
                this.FCCode = "FF00";
                this.FData = "09" + this.Encrypt_CQCT2("030712000080000000", "C5B5CEC4", 0);
            } else if ("EXTD_W_METER2".equals(this.FTx_Type)) {
                this.FCCode = "FF00";
                this.FData = "09" + this.Encrypt_CQCT2("030713000080000000", "C5B5CEC4", 0);
            } else if ("EXTD_W_METER3".equals(this.FTx_Type)) {
                this.FCCode = "FF01";
                this.FData = "2C01";
            } else if ("EXTD_W_METERMORE".equals(this.FTx_Type)) {
                this.FCCode = "FF00";
                this.FData = this.FData.trim();
                iLen = this.FData.length() / 2;
                iLen = iLen % 256;
                sTmp = StringHelper.rightStr("00" + Integer.toHexString(iLen), 2);
                this.FData = StringHelper.LeftPadCh(this.FData, "0", iLen * 2);
                this.FData = String.valueOf(sTmp) + StringHelper.rightStr(this.FData, iLen * 2);
            } else if ("RE_METER1".equals(this.FTx_Type)) {
                this.FCCode = "9000";
                this.FData = StringHelper.date2Str(new Date(), "yyyyMMddHHmmss");
            } else if ("RE_METER2".equals(this.FTx_Type)) {
                this.FCCode = "9002";
                this.FData = String.valueOf(StringHelper.date2Str(new Date(), "yyyyMMddHHmmss")) + "00";
            } else {
                this.FCCode = "0000";
                this.FData = "";
            }
            iLen = 10 + this.FData.length() / 2;
            String FLen = StringHelper.rightStr("0000" + Integer.toHexString(iLen), 4);
            this.FCRC = this.XANW_MeterCS(String.valueOf(this.FCCode) + FBoardXh + tmpAddr + this.FCompanyCode + this.FData);
            this.FPacket = String.valueOf(FHead) + FLen + FFlag + this.FCCode + FBoardXh + tmpAddr + this.FCompanyCode + this.FData + this.FCRC + FEnd;
            this.FPacket = this.FPacket.toUpperCase();
        } else {
            this.FPacket = "";
        }
    }

    /*
     * Exception decompiling
     */
    public String splitPacket() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Integer CheckPacketRight() {
        int iLen = 0;
        int i = -1;
        String s = "";
        String sTmp = "";
        String L1 = "";
        String L2 = "";
        String sReadBuff = "";
        sReadBuff = this.FPacket = this.FPacket.toUpperCase().trim();
        if (this.FPacket.length() == 0) {
            return -1;
        }
        sTmp = StringHelper.left(sReadBuff, 4);
        if ("2424".equals(sTmp)) {
            this.FProtocolCode = "CQCT1.0";
            iLen = 30;
            i = this.FPacket.indexOf("2424");
            s = this.FPacket.substring(i, this.FPacket.length() - i);
            if (this.FPacket.length() < 30) {
                return -1;
            }
            L1 = s.substring(28, 30);
            L2 = s.substring(26, 28);
            sTmp = String.valueOf(L1) + L2;
            iLen = 30 + Integer.parseInt(sTmp, 16) * 2 + 6;
            if (s.length() >= iLen) {
                this.FPacket = s = s.substring(0, iLen);
                L1 = this.FPacket.substring(0, 4);
                L2 = this.FPacket.substring(this.FPacket.length() - 2, this.FPacket.length());
                if (L1.equals("2424") && L2.equals("23")) {
                    this.FCRC = this.FPacket.substring(this.FPacket.length() - 6, this.FPacket.length() - 2);
                    String crc = Crc.CalcCRC(this.FPacket, 3);
                    this.FAddrCode = StringHelper.copy(this.FPacket, 4, 10);
                    this.FCCode = StringHelper.copy(this.FPacket, 14, 2);
                    if (this.FCCode.equals("A1")) {
                        this.setFTransWay("PC_SEND_GPRS");
                    } else if (this.FCCode.equals("A2")) {
                        this.setFTransWay("PC_ANSWER_GPRS");
                    } else if (this.FCCode.equals("B1")) {
                        this.setFTransWay("GPRS_SEND_PC");
                    } else if (this.FCCode.equals("B2")) {
                        this.setFTransWay("GPRS_ANSWER_PC");
                    }
                    this.FSer = StringHelper.copy(this.FPacket, 16, 8);
                    this.FSEQ = StringHelper.copy(this.FPacket, 24, 2);
                    sTmp = String.valueOf(StringHelper.copy(this.FPacket, 28, 2)) + StringHelper.copy(this.FPacket, 26, 2);
                    iLen = Integer.parseInt(sTmp, 16) * 2;
                    this.FAFN = StringHelper.copy(this.FPacket, 30, 4);
                    this.FData_per_len = Integer.parseInt(StringHelper.copy(this.FPacket, 34, 2), 16);
                    this.FData_count = Integer.parseInt(StringHelper.copy(this.FPacket, 36, 2), 16);
                    this.FData = StringHelper.copy(this.FPacket, 38, this.FData_count * this.FData_per_len * 2);
                    if ("32".equals(StringHelper.copy(this.FAddrCode, 2, 2))) {
                        this.FProtocolCode = "";
                        return -6;
                    }
                    return 0;
                }
                return -4;
            }
            return -2;
        }
        if ("2525".equals(sTmp)) {
            this.FProtocolCode = "CQCT2.0";
            i = this.FPacket.indexOf("2525");
            s = this.FPacket.substring(i, this.FPacket.length() - i);
            sTmp = String.valueOf(StringHelper.copy(s, 6, 2)) + StringHelper.copy(s, 4, 2);
            iLen = Integer.parseInt(sTmp, 16) * 2;
            if (s.length() < iLen) {
                return -2;
            }
            sReadBuff = s = StringHelper.left(s, iLen);
            this.FPacket = s;
            this.FCRC = this.FPacket.substring(this.FPacket.length() - 6, this.FPacket.length() - 2);
            String crc = Crc.CalcCRC(this.FPacket, 3);
            this.FCRC.equals(crc);
            this.FVer = StringHelper.copy(sReadBuff, 8, 2);
            if ("10".equals(StringHelper.copy(sReadBuff, 8, 2))) {
                this.FAddrCodeLen_Size = 1;
                this.FAddrCode_Size = 1;
                this.FPacketHEAD_Size = 2;
                this.FPacketLen_Size = 2;
                this.FProtocolVer_Size = 1;
                this.FCompanyCode_Size = 3;
                this.FCCode_Size = 1;
                this.FSer_Size = 4;
                this.FSEQ_Size = 1;
                this.FKeyVer_Size = 1;
                this.FAFN_Size = 2;
                this.PNum_Size = 1;
                this.FCRC_size = 2;
                this.FOOT_size = 1;
                this.FAddrCodeLen = Integer.parseInt(StringHelper.copy(sReadBuff, (this.FPacketHEAD_Size + this.FPacketLen_Size + this.FProtocolVer_Size) * 2, 2), 16);
                this.FAddrCode = StringHelper.copy(sReadBuff, (this.FPacketHEAD_Size + this.FPacketLen_Size + this.FProtocolVer_Size + this.FAddrCode_Size) * 2, this.FAddrCodeLen * 2);
                this.FCompanyCode = StringHelper.copy(sReadBuff, (this.FPacketHEAD_Size + this.FPacketLen_Size + this.FProtocolVer_Size + this.FAddrCode_Size + this.FAddrCodeLen) * 2, 6);
                String Key2 = "";
                Integer i1 = Integer.parseInt(StringHelper.left(this.FCompanyCode, 2), 16);
                this.factoryCode = "";
                if (i1 < 96) {
                    this.factoryCode = "A" + StringHelper.rightStr("00" + Integer.toHexString(i1), 2);
                } else {
                    i1 = i1 - 96;
                    this.factoryCode = "W" + StringHelper.rightStr("00" + Integer.toHexString(i1), 2);
                }
                this.factoryCode = this.factoryCode.toUpperCase();
                this.meter_packet_key = Key2 = JzqPacket.calcMeterKeyByFactoryCode(this.factoryCode);
                this.FCCode = StringHelper.copy(sReadBuff, (this.FPacketHEAD_Size + this.FPacketLen_Size + this.FProtocolVer_Size + this.FAddrCode_Size + this.FAddrCodeLen + this.FCompanyCode_Size) * 2, 2);
                if (this.FCCode.equals("A1")) {
                    this.setFTransWay("PC_SEND_GPRS");
                } else if (this.FCCode.equals("A2")) {
                    this.setFTransWay("PC_ANSWER_GPRS");
                } else if (this.FCCode.equals("B1")) {
                    this.setFTransWay("GPRS_SEND_PC");
                } else if (this.FCCode.equals("B2")) {
                    this.setFTransWay("GPRS_ANSWER_PC");
                }
                this.FSer = StringHelper.copy(sReadBuff, (this.FPacketHEAD_Size + this.FPacketLen_Size + this.FProtocolVer_Size + this.FAddrCode_Size + this.FAddrCodeLen + this.FCompanyCode_Size + this.FCCode_Size) * 2, 8);
                this.FSEQ = StringHelper.copy(sReadBuff, (this.FPacketHEAD_Size + this.FPacketLen_Size + this.FProtocolVer_Size + this.FAddrCode_Size + this.FAddrCodeLen + this.FCompanyCode_Size + this.FCCode_Size + this.FSer_Size) * 2, 2);
                this.FKeyVer = StringHelper.copy(sReadBuff, (this.FPacketHEAD_Size + this.FPacketLen_Size + this.FProtocolVer_Size + this.FAddrCode_Size + this.FAddrCodeLen + this.FCompanyCode_Size + this.FCCode_Size + this.FSer_Size + this.FSEQ_Size) * 2, 2);
                this.FAFN = StringHelper.copy(sReadBuff, (this.FPacketHEAD_Size + this.FPacketLen_Size + this.FProtocolVer_Size + this.FAddrCode_Size + this.FAddrCodeLen + this.FCompanyCode_Size + this.FCCode_Size + this.FSer_Size + this.FSEQ_Size + this.FKeyVer_Size) * 2, 4);
                this.FData_count = Integer.parseInt(StringHelper.copy(sReadBuff, (this.FPacketHEAD_Size + this.FPacketLen_Size + this.FProtocolVer_Size + this.FAddrCode_Size + this.FAddrCodeLen + this.FCompanyCode_Size + this.FCCode_Size + this.FSer_Size + this.FSEQ_Size + this.FKeyVer_Size + this.FAFN_Size) * 2, 2), 16);
                if (this.FData_count == 0) {
                    this.FData = "";
                } else if ("00".equals(this.FKeyVer)) {
                    this.FData = StringHelper.copy(sReadBuff, (this.FPacketHEAD_Size + this.FPacketLen_Size + this.FProtocolVer_Size + this.FAddrCode_Size + this.FAddrCodeLen + this.FCompanyCode_Size + this.FCCode_Size + this.FSer_Size + this.FSEQ_Size + this.FKeyVer_Size + this.FAFN_Size + this.PNum_Size) * 2, sReadBuff.length() - (this.FPacketHEAD_Size + this.FPacketLen_Size + this.FProtocolVer_Size + this.FAddrCode_Size + this.FAddrCodeLen + this.FCompanyCode_Size + this.FCCode_Size + this.FSer_Size + this.FSEQ_Size + this.FKeyVer_Size + this.FAFN_Size + this.PNum_Size) * 2 - 6);
                }
            } else {
                return -98;
            }
            sTmp = StringHelper.copy(this.FAddrCode, 2, 2);
            if (sTmp.equals("33")) {
                this.FProtocolCode = "CQCT2.0_LLJ";
            }
            if ("32".equals(sTmp) || "33".equals(sTmp)) {
                this.sf_iot = 0;
            }
            if ("CQCT2.0".equals(this.FProtocolCode) || "CQCT2.0_LLJ".equals(this.FProtocolCode)) {
                if ("0000".equals(this.FAFN)) {
                    this.cmdDetail = "\u5fc3\u8df3\u5305";
                } else if ("0021".equals(this.FAFN)) {
                    this.cmdDetail = "\u4eea\u8868\u4e3b\u52a8\u4e0a\u62a5";
                } else if ("4021".equals(this.FAFN)) {
                    this.cmdDetail = "\u76f4\u63a5\u4eea\u8868\u901a\u8baf-\u96c6\u4e2d\u5668\u56de\u590d";
                } else if ("4023".equals(this.FAFN)) {
                    this.cmdDetail = "(\u8bbe\u7f6e|\u53d6\u6d88)\u81ea\u52a8\u6284\u8868-\u96c6\u4e2d\u5668\u56de\u590d";
                } else if ("F010".equals(this.FAFN)) {
                    this.cmdDetail = "\u5347\u7ea7\u5fc3\u8df3\u5305";
                } else if ("F011".equals(this.FAFN) || "F012".equals(this.FAFN) || "F013".equals(this.FAFN)) {
                    this.cmdDetail = "\u5347\u7ea7ROM-\u96c6\u4e2d\u5668\u56de\u590d";
                } else if ("F014".equals(this.FAFN)) {
                    this.cmdDetail = "\u5347\u7ea7ROM-\u5b8c\u6210";
                }
            }
            return 0;
        }
        if ("68".equals(StringHelper.left(sReadBuff, 2)) && "16".equals(StringHelper.rightStr(sReadBuff, 2))) {
            this.FProtocolCode = "CQRQ1.0";
            i = Integer.parseInt(String.valueOf(StringHelper.copy(sReadBuff, 44, 2)) + StringHelper.copy(sReadBuff, 42, 2), 16);
            this.packetID = StringHelper.copy(sReadBuff, 28, 14);
            this.FData = StringHelper.copy(sReadBuff, 46, i * 2);
            this.packetFX = StringHelper.copy(sReadBuff, 10, 2);
            this.FAFN = StringHelper.copy(sReadBuff, 6, 4);
            this.FAddrCode = "2004".equals(this.FAFN) || "2003".equals(this.FAFN) ? StringHelper.copy(sReadBuff, 18, 10) : StringHelper.copy(sReadBuff, 14, 14);
            return 0;
        }
        if (this.FPacket.length() > 4 && "16".equals(StringHelper.rightStr(this.FPacket, 2)) && "68".equals(StringHelper.copy(this.FPacket, 2, 2))) {
            String backup_FPacket = this.FPacket;
            iLen = Integer.parseInt(StringHelper.copy(this.FPacket, 0, 2), 16);
            if (this.FPacket.length() != (iLen + 7 + 20 + 1) * 2 + 2) {
                return -2;
            }
            String sData = this.FPacket = StringHelper.rightStr(this.FPacket, this.FPacket.length() - 2);
            this.FProtocolCode = "HTDLNB1.0";
            sTmp = StringHelper.left(sData, 2);
            sData = StringHelper.rightStr(sData, sData.length() - 2);
            sTmp = StringHelper.left(sData, 4);
            sData = StringHelper.rightStr(sData, sData.length() - 4);
            this.FAddrCode = StringHelper.left(sData, 10);
            sData = StringHelper.rightStr(sData, sData.length() - 10);
            this.FData = backup_FPacket;
            return 0;
        }
        if ("A5".equals(StringHelper.copy(sReadBuff, 0, 2)) && "5A".equals(StringHelper.copy(sReadBuff, 6, 2)) && "AA".equals(StringHelper.rightStr(sReadBuff, 2))) {
            this.FProtocolCode = "XANW1.0";
            sTmp = StringHelper.copy(sReadBuff, 2, 4);
            iLen = Integer.parseInt(sTmp, 16);
            if (iLen != sReadBuff.length() / 2 - 6) {
                return -4;
            }
            sReadBuff = StringHelper.rightStr(sReadBuff, sReadBuff.length() - 2);
            this.FDataLen = StringHelper.left(sReadBuff, 4);
            sReadBuff = StringHelper.rightStr(sReadBuff, sReadBuff.length() - 4);
            sReadBuff = StringHelper.rightStr(sReadBuff, sReadBuff.length() - 2);
            this.FCCode = StringHelper.left(sReadBuff, 4);
            sReadBuff = StringHelper.rightStr(sReadBuff, sReadBuff.length() - 4);
            this.factoryCode = StringHelper.left(sReadBuff, 2);
            sReadBuff = StringHelper.rightStr(sReadBuff, sReadBuff.length() - 2);
            String tmpAddr = this.FAddrCode = StringHelper.left(sReadBuff, 10);
            this.FAddrCode = String.valueOf(StringHelper.copy(this.FAddrCode, 8, 2)) + StringHelper.copy(this.FAddrCode, 6, 2) + StringHelper.copy(this.FAddrCode, 4, 2) + StringHelper.copy(this.FAddrCode, 2, 2) + StringHelper.copy(this.FAddrCode, 0, 2);
            sReadBuff = StringHelper.rightStr(sReadBuff, sReadBuff.length() - 10);
            this.FCompanyCode = StringHelper.left(sReadBuff, 4);
            sReadBuff = StringHelper.rightStr(sReadBuff, sReadBuff.length() - 4);
            iLen = (Integer.parseInt(this.FDataLen, 16) - 10) * 2;
            this.FData = StringHelper.left(sReadBuff, iLen);
            sReadBuff = StringHelper.rightStr(sReadBuff, sReadBuff.length() - iLen);
            this.FCRC = StringHelper.left(sReadBuff, 2);
            sTmp = this.XANW_MeterCS(String.valueOf(this.FCCode) + this.factoryCode + tmpAddr + this.FCompanyCode + this.FData);
            if (!sTmp.equals(this.FCRC)) {
                return -5;
            }
            this.factoryCode = "0161".equals(this.FCompanyCode) ? "W22" : "W18";
            if ("1002".equals(this.FCCode)) {
                this.cmdDetail = "\u4eea\u8868\u4e3b\u52a8\u4e0a\u62a5";
            } else if ("7F00".equals(this.FCCode)) {
                this.cmdDetail = "0346B4DD".equals(this.FData) ? "\u5173\u95edGPRS\u529f\u80fd-\u96c6\u4e2d\u5668\u56de\u590d" : ("1041B7C8C4BE48371B41B7C8EDBE483772".equals(this.FData) ? "\u8bbe\u7f6eIP1\u53ca\u7aef\u53e3-\u57df\u540d1\u53ca\u7aef\u53e3-\u96c6\u4e2d\u5668\u56de\u590d" : "\u8bbe\u7f6eIP1\u53ca\u7aef\u53e3-\u57df\u540d1\u53ca\u7aef\u53e3-\u96c6\u4e2d\u5668\u56de\u590d");
            } else if ("0101".equals(this.FCCode)) {
                this.cmdDetail = "01".equals(this.FData) ? "\u8bbe\u7f6eGPRS\u4e0a\u7ebf\u53c2\u6570-\u96c6\u4e2d\u5668\u56de\u590d" : "\u8bbe\u7f6eIP1-\u96c6\u4e2d\u5668\u56de\u590d";
            } else if ("7F01".equals(this.FCCode)) {
                this.cmdDetail = "\u8bbe\u7f6e\u7981\u6b62\u4e0b\u7535-\u96c6\u4e2d\u5668\u56de\u590d";
            }
            return 0;
        }
        return -999;
    }

    public String getFAddrCode() {
        return this.FAddrCode;
    }

    public void setFAddrCode(String fAddrCode) {
        this.FAddrCode = fAddrCode;
        String stmp = StringHelper.copy(fAddrCode, 2, 2);
        this.FVer = stmp.equals("00") ? "V1" : "V2";
    }

    public String getFCCode() {
        return this.FCCode;
    }

    public void setFCCode(String fCCode) {
        this.FCCode = fCCode;
    }

    public String getFSer() {
        return this.FSer;
    }

    public void setFSer(String fSer) {
        this.FSer = fSer;
    }

    public String getFSEQ() {
        return this.FSEQ;
    }

    public void setFSEQ(String fSEQ) {
        this.FSEQ = fSEQ;
    }

    public String getFDataLen() {
        return this.FDataLen;
    }

    public void setFDataLen(String fDataLen) {
        this.FDataLen = fDataLen;
    }

    public String getFCRC() {
        return this.FCRC;
    }

    public void setFCRC(String fCRC) {
        this.FCRC = fCRC;
    }

    public String getFData() {
        return this.FData;
    }

    public void setFData(String fData) {
        this.FData = fData;
    }

    public String getFAFN() {
        return this.FAFN;
    }

    public void setFAFN(String fAFN) {
        this.FAFN = fAFN;
    }

    public Integer getFData_count() {
        return this.FData_count;
    }

    public void setFData_count(Integer fData_count) {
        this.FData_count = fData_count;
    }

    public Integer getFData_per_len() {
        return this.FData_per_len;
    }

    public void setFData_per_len(Integer fData_per_len) {
        this.FData_per_len = fData_per_len;
    }

    public String getFPacket() {
        return this.FPacket;
    }

    public void setFPacket(String fPacket) {
        this.FPacket = fPacket;
    }

    public String getFTransWay() {
        return this.FTransWay;
    }

    public void setFTransWay(String fTransWay) {
        this.FTransWay = fTransWay;
    }

    public Integer getFAddrCodeLen() {
        return this.FAddrCodeLen;
    }

    public void setFAddrCodeLen(Integer fAddrCodeLen) {
        this.FAddrCodeLen = fAddrCodeLen;
    }

    public String getFProtocolCode() {
        return this.FProtocolCode;
    }

    public void setFProtocolCode(String fProtocolCode) {
        this.FProtocolCode = fProtocolCode;
    }

    public String getFCompanyCode() {
        return this.FCompanyCode;
    }

    public void setFCompanyCode(String fCompanyCode) {
        this.FCompanyCode = fCompanyCode;
    }

    public String getFKeyVer() {
        return this.FKeyVer;
    }

    public void setFKeyVer(String fKeyVer) {
        this.FKeyVer = fKeyVer;
    }

    public Integer getFAddrCodeLen_Size() {
        return this.FAddrCodeLen_Size;
    }

    public void setFAddrCodeLen_Size(Integer fAddrCodeLen_Size) {
        this.FAddrCodeLen_Size = fAddrCodeLen_Size;
    }

    public Integer getFAddrCode_Size() {
        return this.FAddrCode_Size;
    }

    public void setFAddrCode_Size(Integer fAddrCode_Size) {
        this.FAddrCode_Size = fAddrCode_Size;
    }

    public Integer getFPacketHEAD_Size() {
        return this.FPacketHEAD_Size;
    }

    public void setFPacketHEAD_Size(Integer fPacketHEAD_Size) {
        this.FPacketHEAD_Size = fPacketHEAD_Size;
    }

    public Integer getFPacketLen_Size() {
        return this.FPacketLen_Size;
    }

    public void setFPacketLen_Size(Integer fPacketLen_Size) {
        this.FPacketLen_Size = fPacketLen_Size;
    }

    public Integer getFProtocolVer_Size() {
        return this.FProtocolVer_Size;
    }

    public void setFProtocolVer_Size(Integer fProtocolVer_Size) {
        this.FProtocolVer_Size = fProtocolVer_Size;
    }

    public Integer getFCompanyCode_Size() {
        return this.FCompanyCode_Size;
    }

    public void setFCompanyCode_Size(Integer fCompanyCode_Size) {
        this.FCompanyCode_Size = fCompanyCode_Size;
    }

    public Integer getFCCode_Size() {
        return this.FCCode_Size;
    }

    public void setFCCode_Size(Integer fCCode_Size) {
        this.FCCode_Size = fCCode_Size;
    }

    public Integer getFSer_Size() {
        return this.FSer_Size;
    }

    public void setFSer_Size(Integer fSer_Size) {
        this.FSer_Size = fSer_Size;
    }

    public Integer getFSEQ_Size() {
        return this.FSEQ_Size;
    }

    public void setFSEQ_Size(Integer fSEQ_Size) {
        this.FSEQ_Size = fSEQ_Size;
    }

    public Integer getFKeyVer_Size() {
        return this.FKeyVer_Size;
    }

    public void setFKeyVer_Size(Integer fKeyVer_Size) {
        this.FKeyVer_Size = fKeyVer_Size;
    }

    public Integer getFAFN_Size() {
        return this.FAFN_Size;
    }

    public void setFAFN_Size(Integer fAFN_Size) {
        this.FAFN_Size = fAFN_Size;
    }

    public Integer getPNum_Size() {
        return this.PNum_Size;
    }

    public void setPNum_Size(Integer pNum_Size) {
        this.PNum_Size = pNum_Size;
    }

    public Integer getFCRC_size() {
        return this.FCRC_size;
    }

    public void setFCRC_size(Integer fCRC_size) {
        this.FCRC_size = fCRC_size;
    }

    public Integer getFOOT_size() {
        return this.FOOT_size;
    }

    public void setFOOT_size(Integer fOOT_size) {
        this.FOOT_size = fOOT_size;
    }

    public String getsCommandTitle() {
        return this.sCommandTitle;
    }

    public void setsCommandTitle(String sCommandTitle) {
        this.sCommandTitle = sCommandTitle;
    }

    public String getStatus_power() {
        return this.status_power;
    }

    public void setStatus_power(String status_power) {
        this.status_power = status_power;
    }

    public String getStatus_attack() {
        return this.status_attack;
    }

    public void setStatus_attack(String status_attack) {
        this.status_attack = status_attack;
    }

    public String getPacketID() {
        return this.packetID;
    }

    public void setPacketID(String packetID) {
        this.packetID = packetID;
    }

    public String getPacketFX() {
        return this.packetFX;
    }

    public void setPacketFX(String packetFX) {
        this.packetFX = packetFX;
    }

    public static String calcMeterKeyByFactoryCode(String factoryCode) {
        String Key2 = "";
        if ((factoryCode = factoryCode.toUpperCase()).equals("A00")) {
            Key2 = "00000000";
        } else if (factoryCode.equals("A01")) {
            Key2 = "44556677";
        } else if (factoryCode.equals("A02")) {
            Key2 = "44556677";
        } else if (factoryCode.equals("A03")) {
            Key2 = "54504753";
        } else if (factoryCode.equals("A04")) {
            Key2 = "FFFFFFFF";
        } else if (factoryCode.equals("A05")) {
            Key2 = "584A4753";
        } else if (factoryCode.equals("A06")) {
            Key2 = "85B44536";
        } else if (factoryCode.equals("A07")) {
            Key2 = "83888167";
        } else if (factoryCode.equals("A08")) {
            Key2 = "584A4753";
        } else if (factoryCode.equals("A09")) {
            Key2 = "90749084";
        } else if (factoryCode.equals("A10")) {
            Key2 = "FFFFFFFF";
        } else if (factoryCode.equals("A11")) {
            Key2 = "70767549";
        } else if (factoryCode.equals("A12")) {
            Key2 = "73797966";
        } else if (factoryCode.equals("A13")) {
            Key2 = "FFFFFFFF";
        } else if (factoryCode.equals("A14")) {
            Key2 = "7A6A9068";
        } else if (factoryCode.equals("A15")) {
            Key2 = "7A879867";
        } else if (factoryCode.equals("A16")) {
            Key2 = "27A64BF6";
        } else if (factoryCode.equals("A17")) {
            Key2 = "3645B485";
        } else if (factoryCode.equals("A18")) {
            Key2 = "4F32C88A";
        } else if (factoryCode.equals("A19")) {
            Key2 = "379FCD2D";
        } else if (factoryCode.equals("A20")) {
            Key2 = "43514A53";
        } else if (factoryCode.equals("A21")) {
            Key2 = "626A646C";
        } else if (factoryCode.equals("A22")) {
            Key2 = "546A596D";
        } else if (factoryCode.equals("A23")) {
            Key2 = "7A6A9068";
        } else if (factoryCode.equals("A24")) {
            Key2 = "FFFFFFFF";
        } else if (factoryCode.equals("A25")) {
            Key2 = "524C4261";
        } else if (factoryCode.equals("A26")) {
            Key2 = "4351524C";
        } else if (factoryCode.equals("A27")) {
            Key2 = "43514D59";
        } else if (factoryCode.equals("A28")) {
            Key2 = "645A5078";
        } else if (factoryCode.equals("A29")) {
            Key2 = "524C4261";
        } else if (factoryCode.equals("A30")) {
            Key2 = "4A745474";
        } else if (factoryCode.equals("A31")) {
            Key2 = "54726C54";
        } else if (factoryCode.equals("A32")) {
            Key2 = "535A4358";
        } else if (factoryCode.equals("A33")) {
            Key2 = "63715248";
        } else if (factoryCode.equals("A34")) {
            Key2 = "43446C78";
        } else if (factoryCode.equals("A35")) {
            Key2 = "5266734D";
        } else if (factoryCode.equals("A36")) {
            Key2 = "D1C5BCD3";
        } else if (factoryCode.equals("A37")) {
            Key2 = "4C507478";
        } else if (factoryCode.equals("A38")) {
            Key2 = "5A4A747A";
        } else if (factoryCode.equals("A39")) {
            Key2 = "7363585A";
        } else if (factoryCode.equals("A40")) {
            Key2 = "48597962";
        } else if (factoryCode.equals("A41")) {
            Key2 = "6A715951";
        } else if (factoryCode.equals("A42")) {
            Key2 = "6B574C63";
        } else if (factoryCode.equals("A43")) {
            Key2 = "7A6C4253";
        } else if (factoryCode.equals("A44")) {
            Key2 = "6A4A6A4B";
        } else if (factoryCode.equals("A45")) {
            Key2 = "51534E59";
        } else if (factoryCode.equals("A46")) {
            Key2 = "CAA2CCC6";
        } else if (factoryCode.equals("A47")) {
            Key2 = "B4D3D4BD";
        } else if (factoryCode.equals("A48")) {
            Key2 = "BABDCCEC";
        } else if (factoryCode.equals("A49")) {
            Key2 = "B0D8CCD8";
        } else if (factoryCode.equals("A50")) {
            Key2 = "B4B4D4AA";
        } else if (factoryCode.equals("A51")) {
            Key2 = "D3C0B0B2";
        } else if (factoryCode.equals("A52")) {
            Key2 = "CDBCD4B4";
        } else if (factoryCode.equals("A53")) {
            Key2 = "B3DBB7E5";
        } else if (factoryCode.equals("A54")) {
            Key2 = "BDF0B7EF";
        } else if (factoryCode.equals("A55")) {
            Key2 = "F9C4FEB9";
        } else if (factoryCode.equals("A56")) {
            Key2 = "BFAACCAB";
        } else if (factoryCode.equals("A57")) {
            Key2 = "B0A2C1B5";
        } else if (factoryCode.equals("A58")) {
            Key2 = "F6CECCD8";
        } else if (factoryCode.equals("A59")) {
            Key2 = "F3CEACCB";
        } else if (factoryCode.equals("A0A")) {
            Key2 = "C5D6C7D4";
        } else if (factoryCode.equals("A0B")) {
            Key2 = "584E4A51";
        } else if (factoryCode.equals("A0C")) {
            Key2 = "B4D5B9CD";
        } else if (factoryCode.equals("A0D")) {
            Key2 = "CDB3D2BB";
        } else if (factoryCode.equals("A0E")) {
            Key2 = "D5E6C0BC";
        } else if (factoryCode.equals("A0F")) {
            Key2 = "C5B0ACCC";
        } else if (factoryCode.equals("A1A")) {
            Key2 = "BBAACCDA";
        } else if (factoryCode.equals("W00")) {
            Key2 = "FFFFFFFF";
        } else if (factoryCode.equals("W01")) {
            Key2 = "48535853";
        } else if (factoryCode.equals("W02")) {
            Key2 = "63715248";
        } else if (factoryCode.equals("W03")) {
            Key2 = "A553E61C";
        } else if (factoryCode.equals("W04")) {
            Key2 = "6C524C43";
        } else if (factoryCode.equals("W05")) {
            Key2 = "4C426C73";
        } else if (factoryCode.equals("W06")) {
            Key2 = "4C625967";
        } else if (factoryCode.equals("W07")) {
            Key2 = "1C4229A7";
        } else if (factoryCode.equals("W08")) {
            Key2 = "535A4358";
        } else if (factoryCode.equals("W09")) {
            Key2 = "53446871";
        } else if (factoryCode.equals("W10")) {
            Key2 = "73797966";
        } else if (factoryCode.equals("W11")) {
            Key2 = "6C794758";
        } else if (factoryCode.equals("W12")) {
            Key2 = "4C796858";
        } else if (factoryCode.equals("W13")) {
            Key2 = "6C59686C";
        } else if (factoryCode.equals("W14")) {
            Key2 = "7364596C";
        } else if (factoryCode.equals("W15")) {
            Key2 = "43447A79";
        } else if (factoryCode.equals("W16")) {
            Key2 = "6E625344";
        } else if (factoryCode.equals("W17")) {
            Key2 = "73634A5A";
        } else if (factoryCode.equals("W18")) {
            Key2 = "C5B5CEC4";
        } else if (factoryCode.equals("W19")) {
            Key2 = "C8F0C9AD";
        } else if (factoryCode.equals("W20")) {
            Key2 = "6E426C48";
        } else if (factoryCode.equals("W21")) {
            Key2 = "6B574C63";
        } else if (factoryCode.equals("W22")) {
            Key2 = "584E4A51";
        } else if (factoryCode.equals("W23")) {
            Key2 = "78614264";
        } else if (factoryCode.equals("W24")) {
            Key2 = "B6BCD4C8";
        } else if (factoryCode.equals("W25")) {
            Key2 = "B8AED0C7";
        } else if (factoryCode.equals("W26")) {
            Key2 = "C2B3D5FD";
        } else if (factoryCode.equals("W27")) {
            Key2 = "D6C7C4DC";
        } else if (factoryCode.equals("W28")) {
            Key2 = "CCECD6AE";
        } else if (factoryCode.equals("W29")) {
            Key2 = "BCAFCDF2";
        } else if (factoryCode.equals("W30")) {
            Key2 = "C9EEBFC6";
        } else if (factoryCode.equals("W31")) {
            Key2 = "BAA3CDA8";
        } else if (factoryCode.equals("W32")) {
            Key2 = "CDF2BDA1";
        } else if (factoryCode.equals("W33")) {
            Key2 = "C3D7CCD8";
        } else if (factoryCode.equals("W34")) {
            Key2 = "D1C7CFE8";
        } else if (factoryCode.equals("W35")) {
            Key2 = "D4A6CFE8";
        } else if (factoryCode.equals("W36")) {
            Key2 = "B6ABD3EE";
        } else if (factoryCode.equals("W37")) {
            Key2 = "B9DACFE8";
        } else if (factoryCode.equals("W38")) {
            Key2 = "BBE3C8AA";
        } else if (factoryCode.equals("W39")) {
            Key2 = "C5C9C2E5";
        } else if (factoryCode.equals("W40")) {
            Key2 = "B2A8CBAE";
        } else if (factoryCode.equals("W41")) {
            Key2 = "CDBCD4B4";
        } else if (factoryCode.equals("W42")) {
            Key2 = "B4B4CAC0";
        } else if (factoryCode.equals("W43")) {
            Key2 = "BFADD2B5";
        } else if (factoryCode.equals("W44")) {
            Key2 = "B4C8D4B6";
        } else if (factoryCode.equals("W45")) {
            Key2 = "DACDA8B4";
        } else if (factoryCode.equals("W46")) {
            Key2 = "B3DBB7E5";
        } else if (factoryCode.equals("W47")) {
            Key2 = "F9C4FEB9";
        } else if (factoryCode.equals("W48")) {
            Key2 = "CDB3D2BB";
        } else if (factoryCode.equals("W49")) {
            Key2 = "CCECBBE3";
        } else if (factoryCode.equals("W50")) {
            Key2 = "CDA8C7F2";
        } else if (factoryCode.equals("W51")) {
            Key2 = "BDF0B7EF";
        } else if (factoryCode.equals("W52")) {
            Key2 = "C2B9BDDD";
        } else if (factoryCode.equals("W53")) {
            Key2 = "D2E6B6BC";
        } else if (factoryCode.equals("W54")) {
            Key2 = "D3B5E7C1";
        } else if (factoryCode.equals("W55")) {
            Key2 = "B0A3C3C0";
        } else if (factoryCode.equals("W56")) {
            Key2 = "BEABBAE3";
        } else if (factoryCode.equals("W57")) {
            Key2 = "D2CAB4A8";
        } else if (factoryCode.equals("W58")) {
            Key2 = "BAA3CDA8";
        } else if (factoryCode.equals("W59")) {
            Key2 = "BBDDD2C7";
        } else if (factoryCode.equals("W60")) {
            Key2 = "CED2C7BB";
        } else if (factoryCode.equals("W61")) {
            Key2 = "CFE8D4B4";
        } else if (factoryCode.equals("W62")) {
            Key2 = "44556677";
        } else if (factoryCode.equals("W63")) {
            Key2 = "ADB8DBC0";
        } else if (factoryCode.equals("W64")) {
            Key2 = "C5D6C7D4";
        } else if (factoryCode.equals("W65")) {
            Key2 = "BBB7D3EE";
        } else if (factoryCode.equals("W66")) {
            Key2 = "BEABD6C7";
        } else if (factoryCode.equals("W67")) {
            Key2 = "C2C8F0C9";
        } else if (factoryCode.equals("W68")) {
            Key2 = "B1FEBBAA";
        } else if (factoryCode.equals("W69")) {
            Key2 = "C5B0ACCC";
        } else if (factoryCode.equals("W70")) {
            Key2 = "B1B4C8AA";
        } else if (factoryCode.equals("W71")) {
            Key2 = "BEA9BBAA";
        } else if (factoryCode.equals("W72")) {
            Key2 = "D4AAC5B5";
        } else if (factoryCode.equals("W73")) {
            Key2 = "C3FAD0C5";
        } else if (factoryCode.equals("W74")) {
            Key2 = "D4BECFE8";
        } else if (factoryCode.equals("W75")) {
            Key2 = "BDADCCCE";
        } else if (factoryCode.equals("W76")) {
            Key2 = "B9E3C8AA";
        } else if (factoryCode.equals("W77")) {
            Key2 = "D2C0CBAA";
        } else if (factoryCode.equals("W78")) {
            Key2 = "D2EDC2F5";
        } else if (factoryCode.equals("W79")) {
            Key2 = "B4D3D4BD";
        } else if (factoryCode.equals("W80")) {
            Key2 = "B4FAB0C1";
        } else if (factoryCode.equals("F03")) {
            Key2 = "54504753";
        }
        return Key2;
    }

    public Integer getSf_iot() {
        return this.sf_iot;
    }

    public void setSf_iot(Integer sf_iot) {
        this.sf_iot = sf_iot;
    }

    public String getCmdDetail() {
        return this.cmdDetail;
    }

    public void setCmdDetail(String cmdDetail) {
        this.cmdDetail = cmdDetail;
    }

    public String getThirdDeviceId() {
        return this.thirdDeviceId;
    }

    public void setThirdDeviceId(String thirdDeviceId) {
        this.thirdDeviceId = thirdDeviceId;
    }

    public static void main(String[] args) {
        JzqPacket jzq = new JzqPacket();
        jzq.setFPacket("252546011014303132333435363738393230313830373236303230FFFFFFB10017001400007003011B011807221039090002110101030C00035B6000035B6000035B600005CC600005CC600005CC60000C3500000C3500000C3500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003B9000003B9000003B9000003B90000C350000075300000753000000000000003E8000003E8000000000000000F42400000C35000007530000003E800007530000003E800007530000003E800007530000003E801560156015601560156015601560156015601560156015601560156015601560156015600007530000003E800007530000003E800007530000003E800007530000003E800007530000003E800007530000003E800007530000003E800007530000003E8FCA755AA23");
        Integer i = jzq.CheckPacketRight();
        System.out.println(jzq.getFactoryCode());
        System.out.println(jzq.getMeter_packet_key());
    }

    public String getFTx_Type() {
        return this.FTx_Type;
    }

    public void setFTx_Type(String fTx_Type) {
        this.FTx_Type = fTx_Type;
    }
}

