
package com.aote.workflow.plugin;

import com.aote.rs.Server;
import com.aote.sql.SqlServer;
import com.aote.transaction.SessionPool;
import org.hibernate.Session;
import org.json.JSONArray;
import org.json.JSONObject;

public class WorkFlowLogicServer {
	public void setService(Session session) {
		Server server = new Server();
		server.setAssignedSession(session);
	}

	public void setServiceBySqlServer(SqlServer sql) {
		Server server = new Server();
		Session session = SessionPool.getInstance().getSession();
		server.setAssignedSession(session);
	}

	public String startWorkFlow(String name, String username, String userid, JSONObject personExpression) {
		JSONArray arr = new JSONArray();
		String personExpressionArr = arr.put(personExpression).toString();
		Server server = new Server();
		Session session = SessionPool.getInstance().getSession();
		server.setAssignedSession(session);
		String process = server.txstartProcess(name, username, userid, personExpressionArr);
		return process;
	}

	public String startWorkflow(String name) {
		Server server = new Server();
		Session session = SessionPool.getInstance().getSession();
		server.setAssignedSession(session);
		String result = server.txstartProcess(name);
		return result;
	}

	public String startActivity(String processid, String name) {
		Server server = new Server();
		Session session = SessionPool.getInstance().getSession();
		server.setAssignedSession(session);
		String result = server.txstartActivity(processid, name);
		return result;
	}

	public int startActivity(String processid, String name, String username, String userid) {
		Server server = new Server();
		Session session = SessionPool.getInstance().getSession();
		server.setAssignedSession(session);
		int result = server.txstartActivity(processid, name, username, userid);
		return result;
	}

	public int startActivity(String processid, String name, String username, String userid,String orgpathnames) {
		Server server = new Server();
		Session session = SessionPool.getInstance().getSession();
		server.setAssignedSession(session);
		int result = server.txstartActivity(processid, name, orgpathnames, userid);
		return result;
	}

	public void setVars(String processid, String vars) {
		Server server = new Server();
		Session session = SessionPool.getInstance().getSession();
		server.setAssignedSession(session);
		server.txsetVars(processid, vars, "", "");
	}

	public void setVars(String processid, String vars, String username, String userid) {
		Server server = new Server();
		Session session = SessionPool.getInstance().getSession();
		server.setAssignedSession(session);
		server.txsetVars(processid, vars, username, userid);
	}

	public void setVars(String processid, JSONObject json) {
		Server server = new Server();
		Session session = SessionPool.getInstance().getSession();
		server.setAssignedSession(session);
		server.txsetVars(processid, json.toString(), "", "");
	}

	public JSONObject setVars(String processid, JSONObject json, String username, String userid) {
		Server server = new Server();
		Session session = SessionPool.getInstance().getSession();
		server.setAssignedSession(session);
		return server.ttxsetVars(processid, json.toString(), username, userid);
	}

	public JSONObject setVars(String defid, String processid, JSONObject json, String username, String userid) {
		Server server = new Server();
		Session session = SessionPool.getInstance().getSession();
		server.setAssignedSession(session);
		return server.ttxsetVars(defid, processid, json.toString(), username, userid);
	}

	public JSONObject setVars(int actid, String processid, JSONObject json, String username, String userid) {
		Server server = new Server();
		Session session = SessionPool.getInstance().getSession();
		server.setAssignedSession(session);
		return server.ttxsetVars(actid, processid, json.toString(), username, userid);
	}

	public String getAction(String activityId) {
		Server server = new Server();
		Session session = SessionPool.getInstance().getSession();
		server.setAssignedSession(session);
		return server.txgetAction(activityId);
	}

	public String getWait(String processid) {
		Server server = new Server();
		Session session = SessionPool.getInstance().getSession();
		server.setAssignedSession(session);
		return server.txgetWait(processid);
	}

	public String getWFGraph(String processid) {
		Server server = new Server();
		Session session = SessionPool.getInstance().getSession();
		server.setAssignedSession(session);
		return server.txgetWFGraph(processid);
	}

	public JSONObject getWFGraph(String processid, int width) {
		Server server = new Server();
		Session session = SessionPool.getInstance().getSession();
		server.setAssignedSession(session);
		return server.txgetWFGraph(processid, width);
	}

	public String excuteWorkFlow(String acitityid, String username, String userid, JSONObject personExpression) {
		JSONArray arr = new JSONArray();
		String personExpressionArr = arr.put(personExpression).toString();
		Server server = new Server();
		Session session = SessionPool.getInstance().getSession();
		server.setAssignedSession(session);
		String process = server.txperformActivity(acitityid.toString(), username, userid, personExpressionArr);
		return process;
	}

	public String stopWorkFlow(String acitityid) {
		Server server = new Server();
		Session session = SessionPool.getInstance().getSession();
		server.setAssignedSession(session);
		String process = server.txStopProcess(acitityid);
		return process;
	}

	public String getOperator(String actorexpression) {
		if (actorexpression.indexOf("userid") != -1) {
			String sub = actorexpression.substring(actorexpression.indexOf("userid"));
			return sub.substring(sub.indexOf("'") + 1, sub.lastIndexOf("'"));
		} else {
			return actorexpression.indexOf("(") != -1 && actorexpression.length() > 3 ? actorexpression.substring(actorexpression.indexOf("(") + 1, actorexpression.indexOf(")")) : "";
		}
	}
}
