/*
 * Decompiled with CFR 0.152.
 */
package com.aote.workflow.perform;

import com.aote.workflow.perform.Diagram;
import com.aote.workflow.perform.DiagramManager;
import com.aote.workflow.perform.ProcessDef;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

public class ProcessDefManager {
    private static final long serialVersionUID = 7046680794343910842L;
    private static ProcessDefManager instance;
    private Hashtable nameAndProcesses = new Hashtable();

    public static ProcessDefManager getInstance() {
        return instance;
    }

    public ProcessDefManager() {
        instance = this;
    }

    public void load() {
        Enumeration v;
        DiagramManager manager = DiagramManager.getInstance();
        try {
            v = manager.getDiagrams();
        }
        catch (Exception e) {
            throw new RuntimeException("ProcessDefManager.load()\u51fa\u9519\uff0c\u88c5\u8f7d\u6d41\u7a0b\u56fe\u5b9a\u4e49\u51fa\u9519");
        }
        while (v.hasMoreElements()) {
            Diagram diagram = (Diagram)v.nextElement();
            try {
                this.nameAndProcesses.put(diagram.getName(), new ProcessDef(diagram));
            }
            catch (Exception e) {
                throw new RuntimeException("ProcessDefManager.load()\u51fa\u9519\uff0c\u4ea7\u751f\u6d41\u7a0b\u5b9a\u4e49\u51fa\u9519");
            }
        }
    }

    public void reLoadProcessDefByName(Diagram d) throws Exception {
        ProcessDef def = this.getProcessDef(d.getName());
        if (def != null) {
            def.setDiagram(d);
        } else {
            def = new ProcessDef(d);
        }
        this.nameAndProcesses.put(d.getName(), def);
    }

    public ProcessDef getProcessDef(String name) {
        ProcessDef result = ProcessDefManager.getProcessesByUser(name);
        if (result != null) {
            return result;
        }
        return (ProcessDef)this.nameAndProcesses.get(name);
    }

    private static ProcessDef getProcessesByUser(String name) {
        try {
            Diagram diagram = DiagramManager.getInstance().getUserDiagramByName(name);
            if (diagram == null) {
                return null;
            }
            ProcessDef def = new ProcessDef(diagram);
            return def;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public Enumeration getProcesses() {
        return this.nameAndProcesses.elements();
    }

    public Iterator getProcessesIterator() {
        return this.nameAndProcesses.values().iterator();
    }
}

