/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.transaction.SessionPool;
import com.aote.workflow.perform.ActivityDef;
import com.aote.workflow.perform.ActivityInstance;
import com.aote.workflow.perform.ProcessDef;
import com.aote.workflow.perform.ProcessDefManager;
import com.aote.workflow.perform.ProcessInstance;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.hibernate.Session;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.Element;

@Path(value="workflow")
@Singleton
@Component
@Transactional
public class Server {
    @Autowired
    private SessionPool sessionPool;
    public Session assignedSession;

    public void setAssignedSession(Session session) {
        this.assignedSession = session;
    }

    @GET
    @Path(value="startprocess/{name}")
    public String txstartProcess(@PathParam(value="name") String name) {
        try {
            ProcessDef process = ProcessDefManager.getInstance().getProcessDef(name);
            if (process == null) {
                throw new RuntimeException("\u6d41\u7a0b\u4e0d\u5b58\u5728\uff1a\u540d\u5b57=" + name);
            }
            Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
            String processId = UUID.randomUUID().toString();
            ProcessInstance procIns = process.createInstance(session, processId);
            return procIns.getId();
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @GET
    @Path(value="startactivity/{processid}/{name}")
    public String txstartActivity(@PathParam(value="processid") String processid, @PathParam(value="name") String name) {
        try {
            Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
            ProcessInstance procIns = (ProcessInstance)session.get(ProcessInstance.class, (Serializable)((Object)processid));
            ProcessDef process = procIns.getDefine();
            ActivityDef activity = process.getActivityByName(name);
            ActivityInstance actIns = new ActivityInstance(activity, procIns, "", null, null, null);
            session.save((Object)actIns);
            return actIns.getId() + "";
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @POST
    @Path(value="setvars/{processid}/{username}/{userid}/{orgid}")
    public String txsetVars(@PathParam(value="processid") String processid, String vars, @PathParam(value="username") String username, @PathParam(value="userid") String userid, @PathParam(value="orgid") String orgid) {
        this.ttxsetVars(processid, vars, username, userid, orgid);
        return "ok";
    }

    public JSONObject ttxsetVars(String processid, String vars, String username, String userid, String orgid) {
        try {
            JSONObject jsob = new JSONObject();
            JSONObject json = new JSONObject(vars);
            Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
            ProcessInstance procIns = (ProcessInstance)session.get(ProcessInstance.class, (Serializable)((Object)processid));
            procIns.putVar(json);
            for (Object obj : procIns.getActivitiesByState("\u5f00\u59cb\u6d3b\u52a8")) {
                ActivityInstance actIns = (ActivityInstance)obj;
                jsob = actIns.finish(session, username, userid, orgid);
            }
            return jsob;
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @GET
    @Path(value="getwait/{processid}")
    public String txgetWait(@PathParam(value="processid") String processid) {
        JSONArray result = new JSONArray();
        Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
        ProcessInstance procIns = (ProcessInstance)session.get(ProcessInstance.class, (Serializable)((Object)processid));
        for (Object obj : procIns.getActivitiesByState("\u5f00\u59cb\u6d3b\u52a8")) {
            JSONObject json = new JSONObject();
            ActivityInstance actIns = (ActivityInstance)obj;
            json.put("defid", (Object)actIns.getDefid());
            json.put("defname", (Object)actIns.getDefname());
            result.put((Object)json);
        }
        return result.toString();
    }

    @POST
    @Path(value="startprocess/{name}/{username}/{userid}")
    public String txstartProcess(@PathParam(value="name") String name, @PathParam(value="username") String username, @PathParam(value="userid") String userid, String personExpression) {
        try {
            JSONArray array = new JSONArray(personExpression);
            JSONObject firstObj = array.getJSONObject(0);
            String data = firstObj.getString("data");
            JSONObject dataObj = new JSONObject(data);
            String processId = dataObj.getString("id");
            Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
            ProcessDef process = ProcessDefManager.getInstance().getProcessDef(name);
            if (process == null) {
                throw new RuntimeException("\u6d41\u7a0b\u4e0d\u5b58\u5728\uff1a\u540d\u5b57=" + name);
            }
            ActivityDef activity = process.getStartActivity();
            if (activity == null) {
                throw new RuntimeException("\u6d41\u7a0b\u6ca1\u6709\u5f00\u59cb\u6d3b\u52a8\uff1a\u540d\u5b57=" + name);
            }
            ProcessInstance procIns = process.createInstance(session, processId);
            ActivityInstance actIns = new ActivityInstance(activity, procIns, "", username, userid, null);
            session.save((Object)actIns);
            actIns.finish(session, personExpression, username, userid);
            JSONObject okObject = new JSONObject();
            okObject.put("ok", (Object)"ok");
            return okObject.toString();
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @POST
    @Path(value="startWork/{name}/{username}/{userid}")
    public String txstartWork(@PathParam(value="name") String name, @PathParam(value="username") String username, @PathParam(value="userid") String userid, String personExpression) {
        try {
            JSONObject dataObj = new JSONObject(personExpression);
            String processId = dataObj.getString("id");
            Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
            ProcessDef process = ProcessDefManager.getInstance().getProcessDef(name);
            if (process == null) {
                throw new RuntimeException("\u6d41\u7a0b\u4e0d\u5b58\u5728\uff1a\u540d\u5b57=" + name);
            }
            ActivityDef activity = process.getStartActivity();
            if (activity == null) {
                throw new RuntimeException("\u6d41\u7a0b\u6ca1\u6709\u5f00\u59cb\u6d3b\u52a8\uff1a\u540d\u5b57=" + name);
            }
            ProcessInstance procIns = process.createInstance(session, processId);
            ActivityInstance actIns = new ActivityInstance(activity, procIns, "", username, userid, null);
            session.save((Object)actIns);
            JSONObject result = new JSONObject();
            result.put("procIns", (Object)procIns.getId());
            result.put("actIns", actIns.getId());
            result.put("actName", (Object)actIns.getName());
            return result.toString();
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @POST
    @Path(value="perfomactivity/{acitityid}/{username}/{userid}")
    public String txperformActivity(@PathParam(value="acitityid") String acitityid, @PathParam(value="username") String username, @PathParam(value="userid") String userid, String personExpression) {
        try {
            Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
            ActivityInstance actIns = (ActivityInstance)session.load(ActivityInstance.class, (Serializable)((Object)acitityid));
            actIns.finish(session, personExpression, username, userid);
            if (actIns.getState().equals("\u7ed3\u675f")) {
                JSONObject error = new JSONObject();
                error.put("error", (Object)"\u5df2\u7ed3\u675f");
                return error.toString();
            }
            JSONObject okObject = new JSONObject();
            okObject.put("ok", (Object)"ok");
            return okObject.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @GET
    @Path(value="action/{acitityid}")
    public String txgetAction(@PathParam(value="acitityid") String acitityid) {
        Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
        ActivityInstance actIns = (ActivityInstance)session.load(ActivityInstance.class, (Serializable)Integer.valueOf(Integer.parseInt(acitityid)));
        Element e = actIns.getDefine().getElement();
        if (e.hasAttribute("action")) {
            return e.getAttribute("action");
        }
        return "";
    }

    @POST
    @Path(value="stop/{acitityid}")
    public String txStopProcess(@PathParam(value="acitityid") String acitityid) {
        try {
            Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
            ActivityInstance actIns = (ActivityInstance)session.load(ActivityInstance.class, (Serializable)((Object)acitityid));
            ProcessInstance pi = actIns.getProcess();
            List list = pi.getActivitiesByState("\u5f00\u59cb\u6d3b\u52a8");
            for (ActivityInstance act : list) {
                act.setState("\u7ec8\u6b62\u05b9");
                session.update((Object)act);
            }
            pi.stop();
            session.update((Object)pi);
            JSONObject result = new JSONObject();
            result.put("procIns", (Object)(pi == null ? null : pi.getName()));
            result.put("actIns", (Object)(actIns == null ? null : actIns.getName()));
            return result.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

