package com.aote.workflow.perform;

import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import com.af.plugins.HttpPost;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hibernate.*;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

import com.af.plugins.RestTools;

//临时产生人员映射关系
public class PersonService {
	public static void Run(String personExpression, Session session) {

		if("".equals(personExpression)){
			return;
		}

		// 获得实际人员表达式，personExpression有可能是给ldap表达式，与实际不同
		String realPerson = getActorid(personExpression);
		Map actor = new HashMap();
		actor.put("id", realPerson);

		Set persons = new HashSet();
		// 如果是人员
		if (personExpression.startsWith("P")) {
			String name = personExpression.substring(2,
					personExpression.length() - 1);
			Map map = new HashMap<String, String>();
			map.put("userid", name);
			map.put("userseq", name);
			persons.add(map);
		}
		// 是部门
		else if (personExpression.startsWith("D")) {
			String name = personExpression.substring(2,
					personExpression.length() - 1);
			String str = "{source: 'tool.getChildrenOfResName($" + name
					+ "$)', userid: ''}";
			String actual=RestTools.post("/rs/search", str);
			persons=getPerson(persons,str);
			sessionDel(session, personExpression);
		}
		// 是角色
		else if (personExpression.startsWith("R")) {
			String name = personExpression.substring(2,
					personExpression.length() - 1);
			String str = "{source: 'tool.getChildrenOfResName($" + name
					+ "$)', userid: ''}";
			String actual=RestTools.post("/rs/search", str);
			persons=getPerson(persons,str);
			sessionDel(session, personExpression);
		}else {//非R非P
			//对表达式字符串进行转义
			personExpression=getExpression(personExpression);
			persons=getPerson(persons,personExpression);
			//删除数据库中已存在的数据
			sessionDel(session,realPerson);
		}
		actor.put("f_person", persons);
		//保存数据到数据库
		session.saveOrUpdate("t_actor", actor);
	}

	public static void Run(String personExpression, Session session, String userid, String orgid) {

		if("".equals(personExpression)){
			return;
		}

		// 获得实际人员表达式，personExpression有可能是给ldap表达式，与实际不同
		String realPerson = getActorid(personExpression);
		Map actor = new HashMap();
		actor.put("id", realPerson);

		Set persons = new HashSet();
		// 如果是人员
		if (personExpression.startsWith("P")) {
			String name = personExpression.substring(2,
					personExpression.length() - 1);
			Map map = new HashMap<String, String>();
			map.put("userid", name);
			map.put("userseq", name);
			persons.add(map);
		}
		// 是部门
		else if (personExpression.startsWith("D")) {
			String name = personExpression.substring(2,
					personExpression.length() - 1);
			String str = "{source: 'this.getParentByType($organization$).getChildByName($" + name
					+ "$).getUsers()', userid: '" + userid + "'}";
			String actual=RestTools.post("/rs/search", str);
			persons=getPerson(persons,str);
			sessionDel(session, personExpression);
		}
		// 是角色
		else if (personExpression.startsWith("R")) {
			String name = personExpression.substring(2,
					personExpression.length() - 1);
			String str = "{source: 'this.getParentByType($organization$).getChildByName($" + name
					+ "$).getUsers()', userid: '" + userid + "'}";
			String actual=RestTools.post("/rs/search", str);
			persons=getPerson(persons,str);
			sessionDel(session, personExpression);
		}else {//非R非P
			//对表达式字符串进行转义
			personExpression=getExpression(personExpression);
			persons=getPerson(persons,personExpression);
			//删除数据库中已存在的数据
			sessionDel(session,realPerson);
		}
		String name = personExpression.substring(2,
				personExpression.length() - 1);
		if (name.contains("子公司")) {
			persons = getAllUser(persons,orgid,name);
		}else {
			persons = getTotalUser(persons,orgid,name);
		}
		actor.put("f_person", persons);
		//保存数据到数据库
		session.saveOrUpdate("t_actor", actor);
	}

	//session执行插入前删除
	public static void sessionDel(Session session,String str){
		str = str.replaceAll("'", "''");
		String hql="DELETE t_actorperson WHERE  actorid='"+str+"'";
		Query query = session.createQuery(hql);
		query.executeUpdate();
	}

	//获取人员
	public static  Set getPerson(Set persons,String str){
        String actual=RestTools.post("/rs/search", str);
		if(actual.indexOf("status: ") == -1 ){
			Object json = new JSONTokener(actual).nextValue();
			if(json instanceof JSONObject){
				JSONObject obj = (JSONObject)json;
				Map map = new HashMap<String, String>();
				//获取人选的id以及name
				map.put("userseq", obj.getString("id"));
				map.put("userid", obj.getString("name"));
				persons.add(map);
			}else if (json instanceof JSONArray){
				JSONArray arr = new JSONArray(actual);
				for (int i = 0; i < arr.length(); i++) {
					JSONObject obj = arr.getJSONObject(i);
					Map map = new HashMap<String, String>();
					//获取人选的id以及name
					map.put("userseq", obj.getString("id"));
					map.put("userid", obj.getString("name"));
					persons.add(map);
				}
			}
		}
		return  persons;
	}

	//转义表达式
	public static  String  getExpression(String personExpression){
		// 转义 {: @lt;   } : @gt;  $ : @amp;
		String str = new String();
		if(personExpression != null){
			str = personExpression.replace("@lt;", "{");
			str = str.replace("@gt;", "}");
			str = str.replace("@amp;", "$");
		}
		//获取userid
	    return getUserid(str,1);

	}
    //替换this
    public static  String  getFixEXpression(String personExpression) {
        String str=getUserid(personExpression,1);
		// String userid=getUserid(personExpression,0);
        // 替换表达式source中的this为userid
		// 之前替换this出现bug 现在改为不替换 直接存储
        return  str;
    }
	//获取userid
    public static  String  getUserid(String str,int i) {
		JSONObject json = new JSONObject(str);
		String userid = json.getString("userid");
		int index=0;
        String olduserid=userid;
        //截取userid中正确的userid，对userid中的“.”进行判断截取最后一个字段
        if(userid.lastIndexOf(".")==userid.length()-1){//userid最后
            userid=userid.substring(0,userid.length()-1);
            index=	userid.lastIndexOf(".");
            userid=userid.substring(index+1,userid.length());
            //返回表达式i=0，返回userid，i=1，返回表达式
            if(i==0){return userid;}else {
                return str.replace(olduserid, userid);
            }
        }else{
            index=	userid.lastIndexOf(".");
            if(index==-1){
                if(i==0){return userid;}else {
                    return str.replace(olduserid, userid);
                }
            }
            else {
                userid = userid.substring(index + 1, userid.length());
                if(i==0){return userid;}else {
                    return str.replace(olduserid, userid);
                }
            }
        }
    }
    //获取actorid
    public static  String  getActorid(String str) {
		if (str.equals("") || str.startsWith("R") || str.startsWith("P")|| str.startsWith("D")) {
			return str;
		}
		//对非R非P角色的actorid进行转义
		str = str.replace("@lt;", "{");
		str = str.replace("@gt;", "}");
		str = str.replace("@amp;", "$");
		str=getFixEXpression(str);
		//		JSONObject json = new JSONObject(str);
		//		String actorid = json.getString("source");
        return str;
    }

	public static String getPath() {
		String path = "";
		Map<String, String> map = new HashMap<String, String>();
		SAXReader read = new SAXReader();
		InputStream input = PersonService.class.getClassLoader()
				.getResourceAsStream("workflow.xml");
		try {
			Document document = read.read(input);
			Element root = document.getRootElement();
			for (Iterator it = root.elementIterator("url"); it.hasNext();) {
				Element elm = (Element) it.next();
				path = elm.attribute("path").getValue();
			}
			return path;
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	public static Set getAllUser(Set a,String orgid,String name){
		JSONObject res= new JSONObject();
		JSONObject resData = new JSONObject();
		res.put("orgid",orgid);
		res.put("name",name);
		resData.put("data",res);
		String actual = RestTools.post("/rs/sql/searchUser",resData.toString());
		System.out.println("resData:" + resData.toString());
		JSONArray allUser = new JSONArray(actual);
		for (int i = 0; i < allUser.length(); i++) {
			JSONObject obj = allUser.getJSONObject(i);
			Map map = new HashMap<String, String>();
			//获取人选的id以及name
			map.put("userseq", obj.getString("id"));
			map.put("userid", obj.getString("name"));
			a.add(map);
		}
		return a;
	}
	public static Set getTotalUser(Set a,String orgid,String name){
		JSONObject org = new JSONObject();
		JSONObject orgData = new JSONObject();
		org.put("tablename","t_organization");
		org.put("condition","name = '湖南燎原燃气有限公司'");
		orgData.put("data",org);
		String Total = RestTools.post("/rs/sql/applysingleTable",orgData.toString());
		System.out.println("Total:" + Total);
		JSONArray jsonOrg = new JSONArray(Total);
		orgid = jsonOrg.getJSONObject(0).get("id").toString();
		JSONObject res= new JSONObject();
		JSONObject resData = new JSONObject();
		res.put("orgid",orgid);
		res.put("name",name);
		resData.put("data",res);
		String actual = RestTools.post("/rs/sql/searchUser",resData.toString());
		System.out.println("resData:" + resData.toString());
		JSONArray allUser = new JSONArray(actual);
		for (int i = 0; i < allUser.length(); i++) {
			JSONObject obj = allUser.getJSONObject(i);
			Map map = new HashMap<String, String>();
			//获取人选的id以及name
			map.put("userseq", obj.getString("id"));
			map.put("userid", obj.getString("name"));
			a.add(map);
		}
		return a;
	}
}
