package com.aote.workflow.perform;

import java.util.*;

import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate3.HibernateTemplate;

/**
 * 活动实例
 */
public class ActivityInstance {
	static Logger log = Logger.getLogger(ActivityInstance.class);
	@Autowired
	private HibernateTemplate hibernateTemplate;
	/**
	 * 活动ID号
	 */
	private int id;

	/**
	 * 活动定义
	 */
	private ActivityDef define = null;

	private String defid;

	/**
	 * 活动定义名称
	 */
	private String defname;

	/**process
	 * 执行者表达式
	 */
	private String actorexpression = null;

	/**
	 * 流程实例
	 */
	private ProcessInstance process = null;

	/**
	 * 流程名称
	 */
	private String processName = null;

	/**
	 * 父流程
	 */
	private String parentprocess = null;

	/**
	 * 活动状态
	 */
	private String state = "";

	private Date sendTime;


	/**
	 * 发送人id
	 */
	private String senderId = null;

	/**
	 * 发送人名称
	 */
	private String sender = null;

	private Date finishTime;

	/**
	 * 超时设置
	 */
	private String timeout = null;
	/**
	 * 节点类型
	 */
	private String nodetype = null;

	private Date deadLine;

	/**
	 * 活动执行人id
	 */
	private String userid;

	/**
	 * 活动执行人名称
	 */
	private String person;

	/**
	 * 上一个活动实例
	 */
	private ActivityInstance foreActivityInstance = null;

	/**
	 * 后面的活动实例列表
	 */
	private Set backActivities = new HashSet();

	/**
	 * 默认构造，Hibernate必须
	 *
	 * @return
	 */
	public ActivityInstance() {

	}

	public String getSender() {
		return sender;
	}

	/**
	 * 采用活动定义、流程实例以及活动参与者ID号构造
	 *
	 * @param define
	 *            活动定义
	 * @param process
	 *            流程实例
	 * @param person
	 *            活动参与者
	 */
	public ActivityInstance(ActivityDef define, ProcessInstance process,
							String actorExpression, String sender, String sendid,
							ActivityInstance foreActivityIns) throws Exception {
		this.define = define;
		this.defid = define.getID();
		this.process = process;
		this.actorexpression = actorExpression;

		this.processName = this.process.getName();
		this.defname = this.define.getName();
		//处理超时相关
		this.DealTimeout();
		// 活动发送人，发送时间
		this.setSender(sender);
		this.setSenderId(sendid);
		this.setSendTime(new Date());

		this.foreActivityInstance = foreActivityIns;
		// 设置活动状态
		state = "开始活动";
		// 添加到流程中
		process.add(this);
	}

	/**
	 * 处理超时相关
	 */

	public boolean DealTimeout() {
		try {
			//得到超时时间标志位
			String timeflag=this.define.getTimeout();
			if(timeflag!=null&&timeflag.length()>0){
				Date date = new Date();
				log.debug("取得超时标志---"+this.define.getName()+"["+timeflag+"]");
				if(timeflag.startsWith("ss")){
					Integer sec=Integer.parseInt( timeflag.substring(timeflag.indexOf("(")+1,timeflag.indexOf(")")));
					Long time=(long)sec*1000;
					this.setDeadLine(new Date(date.getTime() +time));
					this.setTimeout(sec+"秒");
				}else if(timeflag.startsWith("mm")){
					Integer min=Integer.parseInt( timeflag.substring(timeflag.indexOf("(")+1,timeflag.indexOf(")")));
					Long time=(long)min*1000*60;
					this.setDeadLine(new Date(date.getTime() +time));
					this.setTimeout(min+"分钟");
				}else if(timeflag.startsWith("HH")){
					Integer hour=Integer.parseInt( timeflag.substring(timeflag.indexOf("(")+1,timeflag.indexOf(")")));
					Long time=(long)hour*1000*60*60;
					this.setDeadLine(new Date(date.getTime() +time));
					this.setTimeout(hour+"小时");

				}else if(timeflag.startsWith("dd")){
					Integer day=Integer.parseInt( timeflag.substring(timeflag.indexOf("(")+1,timeflag.indexOf(")")));
					Long time=(long)day*1000*60*60*24;
					this.setDeadLine(new Date(date.getTime() +time));
					this.setTimeout(day+"天");
				}else {
					log.debug("无法识别超时标志---"+this.define.getName()+"["+timeflag+"]");
				}
			}else {
				log.debug("无超时标志位---"+this.define.getName());
				return false;
			}
			return true;
		}catch (Exception e){
			log.debug("处理超时相关函数DealTimeout出现异常---"+e.getMessage());
			return false;
		}
	}

	/**
	 * 设置时间
	 *
	 * @param date
	 *            时间
	 */
	public void setTime(java.util.Date date) {
		// gc.setTime(date);
	}

	/**
	 * 得到后继活动
	 *
	 * @return 后继活动列表
	 */
	public Set getActivities() {
		return backActivities;
	}

	/**
	 * 添加后继活动
	 *
	 * @param activity
	 *            后继活动
	 */
	public void add(ActivityInstance activity) {
		if (!this.backActivities.contains(activity)) {
			this.backActivities.add(activity);
		}
	}

	/**
	 * 设置状态
	 *
	 * @param state
	 */
	public void setState(String state) {
		this.state = state;
	}

	/**
	 * 得到流程实例
	 */
	public ProcessInstance getProcess() {
		return process;
	}

	/**
	 * 得到活动定义
	 *
	 * @return 活动定义
	 */
	public ActivityDef getDefine() {
		if (this.define != null) {
			return this.define;
		}
		// 如果为空重新装在，根据流程定义ｉｄ得到流程定义
		ProcessDef pDef = this.getProcess().getDefine();
		if (pDef == null) {
			throw new RuntimeException("活动实例找不到流程定义");
		}
		return pDef.getActivity(this.defid);
	}

	/**
	 * 尝试结束活动，只要有一个转移线满足条件，活动就进行转移
	 * @param session
	 */
	public synchronized JSONObject finish(Session session, String username, String userid) throws Exception {
		// 根据每个转移创建任务和活动
		ProcessDef procDef = ProcessDefManager.getInstance().getProcessDef(
				processName);
		ActivityDef actDef = procDef.getActivity(defid);

		// 是否往后转移了
		boolean transe = false;
		//创建返回的活动JSON对象
		JSONObject json = new JSONObject();
		for (DiversionDef divDef : actDef.getSplits()) {
			ActivityDef tailDef = divDef.getTail();
			// 如果不满足表达式条件，继续下一个
			String expression = divDef.getExpression();
			if (expression != null && !expression.equals("")
					&& this.process.getExpressionValue(expression).equals(Boolean.FALSE)) {
				continue;
			}
			//如果要扭转的活动强制合并
			if(tailDef.getNodetype()!=null&&tailDef.getJoins().size()>1&&tailDef.getNodetype().equals("合并")){
				List list = this.process.getActivitiesByState("开始活动");
				if(list.size()>1){
					//如果还有没有完成的活动，不能转移，将转移交于后面活动
					//向返回的JSON对象中添加活动编号属性
					json.put("f_service_acitivity_id", this.getId());
					state = "结束";
					// 设置完成人，完成时间
					this.setPerson(username);
					this.setUserid(userid);
					this.setFinishTime(new Date());
					session.update(this);
					continue;
				}
			}
			//如果要扭转的活动强制合并
			if(tailDef.getNodetype()!=null&&tailDef.getJoins().size()>1&&tailDef.getNodetype().equals("执行")){
				List list = this.process.getActivitiesByState("开始活动");
				if(list.size()>1){
					//如果还有没有完成的活动，不能转移，将转移交于后面活动
					Iterator iter = list.iterator();
					while (iter.hasNext()) {
						ActivityInstance act = (ActivityInstance) iter.next();
						act.setState("结束");
						act.setPerson(username);
						act.setUserid(userid);
						act.setFinishTime(new Date());
						session.update(act);
					}
					continue;
				}
			}
			// 根据人员表达式，产生人员对照表
			String exp = tailDef.getPersonExpression();
			exp = (String)this.process.getExpressionValue("$" + exp);
			PersonService.Run(exp, session, userid);
			// 用于计算的表达式与实际保存的不同，当从ldap取人员时，实际保存的简化了
			String actorExp = PersonService.getActorid(exp);
			ActivityInstance actIns = new ActivityInstance(
					tailDef, process, actorExp, username, userid, this);

			session.save(actIns);
			transe = true;
		}
		// 如果转移了，让当前活动结束
		if (transe) {
			//向返回的JSON对象中添加活动编号属性
			json.put("f_service_acitivity_id", this.getId());
			state = "结束";
			// 设置完成人，完成时间
			this.setPerson(username);
			this.setUserid(userid);
			this.setFinishTime(new Date());
			session.update(this);
			return json;
		}
		return json;
	}

	/**
	 * 结束活动
	 */
	public synchronized void finish(Session session, String personExpression,
									String username, String userid) throws Exception {
		// 解析传递过来的对象属性
		JSONArray array = new JSONArray(personExpression);
		JSONObject firstObj = array.getJSONObject(0);
		final String data = firstObj.getString("data");
		JSONObject dataObj = new JSONObject(data);

		// 把前台传过来的，活动对应的人员，转换成json串
		state = "结束";
		// 设置完成人，完成时间
		this.setPerson(username);
		this.setUserid(userid);
		this.setFinishTime(new Date());
		// 根据每个转移创建任务和活动
		ProcessDef procDef = ProcessDefManager.getInstance().getProcessDef(
				processName);
		ActivityDef actDef = procDef.getActivity(defid);
		for (DiversionDef divDef : actDef.getSplits()) {
			ActivityDef tailDef = divDef.getTail();

			// 给流程中的变量赋值
			this.process.putVar(dataObj);

			// 如果不满足表达式条件，继续下一个
			String expression = divDef.getExpression();
			if (expression != null && !expression.equals("")
					&& this.process.getExpressionValue(expression).equals(Boolean.FALSE)) {
				continue;
			}
			// 拿到当前流程的processid 和 下一步的流程名称
			String dename = tailDef.getName();
			String processid = dataObj.get("id").toString();
			int ct = getstate(dename, session, processid);
			if (ct >= 1) {
				System.out.println("流程已存在");
				return;
			} else {
				System.out.println("添加下一步流程");
				// 根据人员表达式，产生人员对照表
				String exp = tailDef.getPersonExpression();
				if (dataObj.has(tailDef.getName())) {
					String pExp = dataObj.getString(tailDef.getName());
					exp = pExp;
				}
				PersonService.Run(exp, session);

				ActivityInstance actIns = new ActivityInstance(tailDef,
						process, PersonService.getActorid(exp), username, userid, this);

				session.save(actIns);
			}

		}
		session.update(this);
	}

	public int getstate(String dename, Session session, String acitityid) {
		//
		final String Sql = "select id,defname,state count from activityins "
				+ "where defname='" + dename + "' and processid='" + acitityid
				+ "' and state = '开始活动'";
		int num = session.createSQLQuery(Sql).list().size();
		return num;
	}

	/**
	 * 得到活动名称
	 */
	public String getName() {
		return this.getDefine().getName();
	}

	/**
	 * 得到活动所属流程名称
	 */
	public String getProcessName() {
		return this.getDefine().getProcess().getName();
	}

	public String getState() {
		return state;
	}

	/**
	 * 得到标准的时间格式，即每年是4位的，月， 日，时，分，秒都是2位的
	 *
	 * @param time
	 * @return
	 */
	public String getFormatTime(String time) {
		String result = "";
		if (time.length() < 2) {
			result = "0" + time;
		} else {
			result = time;
		}
		return result;
	}

	/**
	 * 挂起活动
	 */
	public void suspend() throws Exception {
		if (this.getState().equals("开始活动")) {
			this.setState("挂起");
		}
	}

	/**
	 * 重启活动
	 */
	public void resume() throws Exception {
		if (this.getState().equals("挂起")) {
			this.setState("开始活动");
		}
	}

	public void setStateForSynchron(String state) {
		this.state = state;
	}

	public ActivityInstance getForeActivityInstance() {
		return this.foreActivityInstance;
	}

	public void setForeActivityInstance(ActivityInstance foreActivityInstance) {
		this.foreActivityInstance = foreActivityInstance;
	}
	public void setDeadLine(Date deadLine) {
		this.deadLine = deadLine;
	}

	public Date getDeadLine() {
		return deadLine;
	}

	public String getTimeout() {
		return timeout;
	}

	public void setNodetype(String nodetype) {
		this.nodetype = nodetype;
	}
	public String getNodetype() {
		return nodetype;
	}

	public void setTimeout(String timeout) {
		this.timeout = timeout;
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public Set getBackActivities() {
		return backActivities;
	}

	public void setBackActivities(Set backActivities) {
		this.backActivities = backActivities;
	}

	public String getDefid() {
		return defid;
	}

	public String getDefname() {
		return defname;
	}

	public void setParentprocess(String parentprocess) {
		this.parentprocess = parentprocess;
	}

	public String getParentprocess() {
		return parentprocess;
	}

	public void setDefname(String defname) {
		this.defname = defname;
	}

	public String getActorexpression() {
		return actorexpression;
	}

	public void setActorexpression(String actorexpression) {
		this.actorexpression = actorexpression;
	}

	public Date getSendTime() {
		return sendTime;
	}



	public void setSendTime(Date sendTime) {
		this.sendTime = sendTime;
	}

	public Date getFinishTime() {
		return finishTime;
	}

	public void setFinishTime(Date finishTime) {
		this.finishTime = finishTime;
	}

	public String getPerson() {
		return person;
	}

	public void setPerson(String person) {
		this.person = person;
	}

	public void setDefine(ActivityDef define) {
		this.define = define;
	}

	public void setProcessName(String processName) {
		this.processName = processName;
	}

	public void setSender(String sender) {
		this.sender = sender;
	}

	public void setDefid(String defid) {
		this.defid = defid;
	}

	public String getUserid() {
		return userid;
	}

	public void setUserid(String userid) {
		this.userid = userid;
	}

	public void setProcess(ProcessInstance process) {
		this.process = process;
	}

	public String getSenderId() {
		return senderId;
	}

	public void setSenderId(String sendId) {
		this.senderId = sendId;
	}

	public JSONObject getJson() {
		JSONObject json = new JSONObject();
		json.put("id", this.id);
		json.put("processid", this.process.getId());
		json.put("defid", this.defid);
		json.put("defname", this.defname);
		json.put("sendTime", this.sendTime);
		json.put("senderId", this.senderId);
		json.put("sender", this.sender);
		json.put("deadLine", this.deadLine);
		json.put("nodetype", this.nodetype);
		json.put("timeout", this.timeout);
		json.put("finishTime", this.finishTime);
		json.put("userid", this.userid);
		json.put("state", this.state);
		//上一个流程id
		String previd="";
		if(this.foreActivityInstance!=null){
			previd=this.foreActivityInstance.getDefid();
		}
		json.put("previd", previd);
		return json;
	}


}
